/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.PosLog;
import com.floreantpos.model.NumberBound;
import com.floreantpos.model.Store;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.CurrencyUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class NumberUtil {
    private static final NumberFormat a = NumberFormat.getNumberInstance();
    private static final NumberFormat b = NumberFormat.getNumberInstance();
    private static final DecimalFormat c = new DecimalFormat("#.##");
    private static final NumberFormat d = new DecimalFormat("0");
    private static final NumberFormat e = new DecimalFormat("0.00##");
    private static final NumberFormat f = new DecimalFormat("0.######");
    private static Map<NumberBound, Pattern> g = new HashMap<NumberBound, Pattern>();
    private static Map<Integer, Pattern> h = new HashMap<Integer, Pattern>();
    private static final char i;
    private static final char j;
    private static int k;

    public static double round(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(k, 4);
        return bigDecimal.doubleValue();
    }

    public static BigDecimal round(BigDecimal bigDecimal) {
        return bigDecimal.setScale(k, 4);
    }

    public static double round(double d, int n) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(n, 4);
        return bigDecimal.doubleValue();
    }

    public static double roundToOneDigit(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(1, 4);
        return bigDecimal.doubleValue();
    }

    public static double roundToTwoDigit(double d) {
        return NumberUtil.round(d);
    }

    public static double roundToThreeDigit(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(3, 4);
        return bigDecimal.doubleValue();
    }

    public static String format3DigitNumber(Double d) {
        return NumberUtil.format3DigitNumber((Number)d);
    }

    public static String format3DigitNumber(Number number) {
        if (number == null) {
            return b.format(0L);
        }
        String string = b.format(number);
        return string;
    }

    public static String format6DigitNumber(Double d) {
        if (d == null) {
            return f.format(0L);
        }
        String string = f.format(d);
        return string;
    }

    public static String format6DigitNumber(Number number) {
        if (number == null) {
            return f.format(0L);
        }
        String string = f.format(number);
        return string;
    }

    public static String formatNumber(Double d, boolean bl) {
        return NumberUtil.formatNumberAcceptNegative(d);
    }

    public static String format(Number number) {
        return NumberUtil.formatNumber(number, true);
    }

    public static String formatNumber(Number number, boolean bl) {
        if (number == null) {
            return a.format(0L);
        }
        String string = a.format(number);
        if (!bl && string.startsWith("-")) {
            return a.format(0L);
        }
        return string;
    }

    public static String formatNumber(Double d) {
        return NumberUtil.formatNumber(d, false);
    }

    public static String formatNumber(Number number) {
        return NumberUtil.formatNumber(number, false);
    }

    public static String trimDecilamIfNotNeeded(Double d) {
        return NumberUtil.trimDecilamIfNotNeeded(d, false);
    }

    public static String trimDecilamIfNotNeeded(Number number) {
        return NumberUtil.trimDecilamIfNotNeeded(number, false);
    }

    public static String trimDecilamIfNotNeeded(Number number, boolean bl) {
        if (number == null) {
            return c.format(0L);
        }
        String string = c.format(number);
        if (bl) {
            return string;
        }
        if (string.startsWith("-")) {
            return c.format(0L);
        }
        return string;
    }

    public static String formatNumberAcceptNegative(Double d) {
        return NumberUtil.formatNumberAcceptNegative((Number)d);
    }

    public static String formatNumberAcceptNegative(Number number) {
        if (number == null) {
            return a.format(0L);
        }
        return a.format(number);
    }

    public static Number parse(String string) throws ParseException {
        if (StringUtils.isBlank((String)string)) {
            return 0;
        }
        return a.parse(string);
    }

    public static double parseDouble(String string) {
        try {
            if (StringUtils.isBlank((String)string)) {
                return 0.0;
            }
            return a.parse(string).doubleValue();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Number parseOrGetZero(String string) {
        try {
            if (StringUtils.isBlank((String)string)) {
                return 0;
            }
            return a.parse(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static String getCurrencyFormat(Object object) {
        String string = e.format(object);
        if (string.startsWith("-")) {
            return "-" + CurrencyUtil.getCurrencySymbol() + string.replaceFirst("-", "");
        }
        return CurrencyUtil.getCurrencySymbol() + string;
    }

    public static String getCurrencyFormatWithoutCurrencySymbol(Object object) {
        return e.format(object);
    }

    public static double getCurrencyFormatWithoutSymbol(Object object) {
        try {
            return e.parse(e.format(object)).doubleValue();
        }
        catch (ParseException parseException) {
            return 0.0;
        }
    }

    public static int getIntegerFormat(Object object) {
        try {
            return d.parse(d.format(object)).intValue();
        }
        catch (ParseException parseException) {
            return 0;
        }
    }

    public static BigDecimal convertToBigDecimal(double d) {
        return new BigDecimal(Double.toString(d));
    }

    public static BigDecimal convertToBigDecimal(String string) {
        return new BigDecimal(string);
    }

    public static boolean isZero(Double d) {
        return NumberUtil.isZero((Number)d);
    }

    public static boolean isZero(Number number) {
        String string = a.format(number);
        try {
            return Math.abs(a.parse(string).doubleValue()) == 0.0;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static Boolean isFractional(String string) {
        try {
            return NumberUtil.isFractional(NumberUtil.parseDouble(string));
        }
        catch (Exception exception) {
            PosLog.error(NumberUtil.class, exception);
            return null;
        }
    }

    public static Boolean isFractional(Double d) {
        int n;
        if (d == null || d.isNaN()) {
            return null;
        }
        double d2 = d;
        return d2 > (d = new Double(n = (int)d2));
    }

    public static String formatNumberIfNeeded(Double d) {
        Boolean bl = NumberUtil.isFractional(d);
        String string = bl != false ? NumberUtil.formatNumber(d) : String.valueOf((int)d.doubleValue());
        return string;
    }

    public static String formatAmount(Double d) {
        return NumberUtil.formatAmount((Number)d);
    }

    public static String formatAmount(Number number) {
        return e.format(number);
    }

    public static boolean isValidDouble(String string) {
        return NumberUtil.a(string, new NumberBound(8, 6));
    }

    public static boolean isValidDouble(String string, int n, int n2) {
        return NumberUtil.a(string, new NumberBound(n, n2));
    }

    private static boolean a(String string, NumberBound numberBound) {
        if (string == null) {
            return false;
        }
        Pattern pattern = NumberUtil.getPattern(numberBound);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault());
        String string2 = "" + decimalFormatSymbols.getGroupingSeparator();
        string = string.replace(string2, "");
        return pattern.matcher(string).matches();
    }

    public static Pattern getPattern(NumberBound numberBound) {
        if (!g.containsKey(numberBound)) {
            NumberUtil.a(numberBound, true);
        }
        Pattern pattern = g.get(numberBound);
        return pattern;
    }

    public static Pattern getPatternForPositiveNumber(NumberBound numberBound) {
        numberBound.setPositiveNumberOnly(true);
        if (!g.containsKey(numberBound)) {
            NumberUtil.a(numberBound, false);
        }
        Pattern pattern = g.get(numberBound);
        return pattern;
    }

    private static void a(NumberBound numberBound, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("[-]?");
        }
        stringBuilder.append("[0-9]{0,");
        stringBuilder.append(numberBound.getBeforeDecimal());
        stringBuilder.append("}(\\");
        stringBuilder.append(i);
        stringBuilder.append("[0-9]{0,");
        stringBuilder.append(numberBound.getAfterDecimal());
        stringBuilder.append("})?");
        String string = stringBuilder.toString();
        g.put(numberBound, Pattern.compile(string));
    }

    public static Pattern getIntegerPattern(int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("[-]?");
        }
        stringBuilder.append("[0-9]{0,");
        stringBuilder.append(n);
        stringBuilder.append("}?");
        String string = stringBuilder.toString();
        h.put(n, Pattern.compile(string));
        return h.get(n);
    }

    public static char getDecimalSeparator() {
        return i;
    }

    public static char getGroupingSeparator() {
        return j;
    }

    public static void initializeNumberFormats() {
        Store store = DataProvider.get().getStore();
        k = store.getDecimalPlace();
        a.setMinimumFractionDigits(k);
        a.setMaximumFractionDigits(k);
        e.setMinimumFractionDigits(k);
    }

    public static String toString(double d) {
        return f.format(d);
    }

    static {
        k = 2;
        a.setMinimumFractionDigits(k);
        a.setMaximumFractionDigits(k);
        a.setRoundingMode(RoundingMode.HALF_UP);
        b.setMinimumFractionDigits(3);
        b.setMaximumFractionDigits(3);
        b.setRoundingMode(RoundingMode.HALF_UP);
        a.setGroupingUsed(false);
        b.setGroupingUsed(false);
        e.setGroupingUsed(true);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault(Locale.Category.FORMAT));
        i = decimalFormatSymbols.getDecimalSeparator();
        j = decimalFormatSymbols.getGroupingSeparator();
    }
}

