/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.PosLog;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.util.KitchenTicketUtill;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.common.util.TerminalUtil;
import com.orocube.common.util.TicketStatus;
import com.orocube.rest.service.mqtt.MqttSender;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.orocube.rest.service.mqtt.OroMqttDataListener;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;

public abstract class OroMqttMessageReceiver
implements IMqttMessageListener {
    private final Set<OroMqttDataListener> dataListeners = new HashSet<OroMqttDataListener>();

    public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
        AsyncAction.execute(() -> {
            try {
                this.handleMessage(string, mqttMessage);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        });
    }

    private void handleMessage(String string, MqttMessage mqttMessage) throws Exception {
        block33: {
            block32: {
                String string2;
                if (!string.endsWith("MQTT-COMMAND")) break block32;
                switch (string2 = new String(mqttMessage.getPayload())) {
                    case "2": {
                        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                            oroMqttDataListener.refreshBookingRequestReceived(string, mqttMessage);
                        }
                        break block33;
                    }
                    case "3": {
                        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                            oroMqttDataListener.refreshKDSRequestReceived(string, mqttMessage);
                        }
                        break block33;
                    }
                    case "1": {
                        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                            oroMqttDataListener.refreshTablesRequestReceived(string, mqttMessage);
                        }
                        break block33;
                    }
                    case "4": {
                        String string3 = Application.getInstance().getCurrentTerminalOutletId();
                        String[] stringArray = string.split("/");
                        String string4 = stringArray[1];
                        if (StringUtils.isBlank((String)string4)) break;
                        if (!string4.equals("MQTT-COMMAND") && !string4.equals(string3)) break block33;
                        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                            oroMqttDataListener.cloudDataUpdateRequestReceived();
                        }
                        break block33;
                    }
                    default: {
                        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                            oroMqttDataListener.mqttCommandReceived(string, mqttMessage);
                        }
                        break block33;
                    }
                }
                break block33;
            }
            if (string.endsWith("auto-update-service")) {
                for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                    oroMqttDataListener.autoUpdateRequestReceived(string, mqttMessage);
                }
            } else if (string.endsWith("MQTT-COMMAND-KIT-DIS-UPDATE")) {
                for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                    oroMqttDataListener.refreshKDSRequestReceived(string, mqttMessage);
                }
            } else if (string.endsWith("public") || string.endsWith("data")) {
                String string5 = POSUtil.decompress(mqttMessage.getPayload());
                if (StringUtils.isEmpty((String)string5)) {
                    return;
                }
                this.debug("Notification received: ");
                JSONObject jSONObject = new JSONObject(string5);
                if (!this.isValidMessage(jSONObject)) {
                    return;
                }
                this.messageReceived(jSONObject);
            } else if (string.endsWith("MQTT-COMMAND-REFRESH-CACHE")) {
                for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                    oroMqttDataListener.cacheRefreshRequestReceived(string, mqttMessage);
                }
            } else if (string.endsWith("MQTT-COMMAND-STORE-CLOSED")) {
                for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                    oroMqttDataListener.storeCloseRequestReceived(string, mqttMessage);
                }
            }
        }
    }

    private void messageReceived(JSONObject jSONObject) throws Exception {
        String string;
        if (this.isPosLogFileRequest(jSONObject)) {
            MailService.doSendEmailPosLogFile(jSONObject.toString());
            return;
        }
        if (!this.isValidMqttSender(jSONObject)) {
            return;
        }
        BaseDataServiceDao baseDataServiceDao = BaseDataServiceDao.getInstance();
        String string2 = jSONObject.toString();
        switch (string = jSONObject.getString("request")) {
            case "Ticket Notification": {
                List<Ticket> list = baseDataServiceDao.saveOrUpdateTickets(string2, false);
                ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                if (list != null && list.size() > 0) {
                    for (Ticket ticket : list) {
                        Store store;
                        Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                        arrayList.add(ticket2);
                        if (ticket2.getTicketStatus() == TicketStatus.Confirmed) {
                            store = DataProvider.get().getStore();
                            if (store.isAutoSendOrdersToKitchen() && store.getSendOrderBeforeTime() == 0) {
                                SendToKitchenAction.doSendNewItemsToKitchen(ticket2, false);
                            }
                        } else if (ticket2.getTicketStatus() == TicketStatus.Preparing) {
                            SendToKitchenAction.doSendNewItemsToKitchen(ticket2, false);
                        } else if (ticket2.getTicketStatus() == TicketStatus.Ready) {
                            this.doBumpTicketFromKitchen(ticket2);
                        } else if (ticket2.getTicketStatus() == TicketStatus.Pending && (store = DataProvider.get().getStore()) != null && store.isAutomaticConfirmOrder()) {
                            ticket2.setTicketStatus(TicketStatus.Confirmed);
                            ticket2.setShouldUpdateStock(true);
                            ticket2.setShowNewOrderNotification(true);
                            TicketDAO.getInstance().saveOrUpdate(ticket2);
                            if (store.isAutoSendOrdersToKitchen() && store.getSendOrderBeforeTime() == 0) {
                                SendToKitchenAction.doSendNewItemsToKitchen(ticket2, false);
                            }
                        }
                        ActionHistoryDAO.saveHistory(ticket2, "Mqtt ticket save", "Ticket found via mqtt. Id: " + ticket2.getId());
                    }
                }
                this.fireTicketReceived(arrayList);
            }
        }
    }

    private void doBumpTicketFromKitchen(Ticket ticket) throws Exception {
        List<KitchenTicket> list = KitchenTicketDAO.getInstance().findByParentId(ticket.getId());
        if (list != null) {
            for (KitchenTicket kitchenTicket : list) {
                KitchenTicketUtill.bumpOrUnbumpKitchenTicket(kitchenTicket);
                OroMqttMessageReceiver.sendUpdateNotificationToKitchen();
            }
        }
    }

    private static void sendUpdateNotificationToKitchen() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
            jSONObject.put("command", (Object)"3");
            jSONObject.put("isKds", (Object)Boolean.FALSE);
            OroMqttClient.getInstance().publishData("MQTT-COMMAND-KIT-DIS-UPDATE", jSONObject.toString());
        }
        catch (Exception exception) {
            PosLog.error(OroMqttMessageReceiver.class, exception);
        }
    }

    private boolean isValidMqttSender(JSONObject jSONObject) {
        String string = OrgJsonUtil.getString(jSONObject, "source");
        return StringUtils.isNotBlank((String)string) && MqttSender.valueOf(string) == MqttSender.ONLINE_ORDER;
    }

    private boolean isPosLogFileRequest(JSONObject jSONObject) {
        return jSONObject.getString("request").equals("Log File Request");
    }

    private boolean isValidMessage(JSONObject jSONObject) {
        String string;
        String string2 = jSONObject.getString("deviceId");
        if (string2 != null && string2.equals(Application.getInstance().getMqttDeviceId())) {
            return false;
        }
        if (!jSONObject.has("request")) {
            this.debug("Empty request");
            return false;
        }
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal == null) {
            return false;
        }
        boolean bl = terminal.isMasterTerminal();
        if (!bl) {
            this.debug("Notification skipped. This is not master terminal.");
        }
        if (StringUtils.isEmpty((String)(string = Application.getInstance().getCurrentTerminalOutletId()))) {
            this.debug("Notification skipped. No outlet is defined for this terminal.");
            return false;
        }
        if (bl) {
            Integer n;
            Integer n2 = n = jSONObject.has("blockTerminalId") ? Integer.valueOf(jSONObject.getInt("blockTerminalId")) : null;
            if (n != null && n > 0 && terminal.getId() == n) {
                return false;
            }
        }
        return bl;
    }

    private void debug(String string) {
        PosLog.debug(OroMqttClient.class, string);
    }

    public void addDataListener(OroMqttDataListener oroMqttDataListener) {
        this.dataListeners.add(oroMqttDataListener);
    }

    public void removeDataListener(OroMqttDataListener oroMqttDataListener) {
        this.dataListeners.remove(oroMqttDataListener);
    }

    private void fireTicketReceived(List<Ticket> list) {
        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
            oroMqttDataListener.ticketReceived(list);
        }
    }
}

