/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.DefaultOrderServiceExtension;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import javax.swing.JOptionPane;

public class AssignDriverAction
extends PosAction {
    public AssignDriverAction() {
        super(POSConstants.ASSIGN_DRIVER_BUTTON_TEXT);
    }

    public AssignDriverAction(DataChangeListener dataChangeListener) {
        super(POSConstants.ASSIGN_DRIVER_BUTTON_TEXT, dataChangeListener);
    }

    @Override
    public void execute() {
        try {
            int n;
            Object object = this.getSelectedObject();
            if (object == null) {
                return;
            }
            Ticket ticket = null;
            ticket = object instanceof Ticket ? (Ticket)object : TicketService.getTicket((String)object);
            if (ticket == null) {
                return;
            }
            if (!ticket.getOrderType().isDelivery().booleanValue()) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SwitchboardView.8"));
                return;
            }
            User user = ticket.getAssignedDriver();
            if (user != null && (n = JOptionPane.showOptionDialog(Application.getPosWindow(), Messages.getString("SwitchboardView.9"), POSConstants.CONFIRM, 0, 3, null, null, null)) != 0) {
                return;
            }
            OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
            if (orderServiceExtension == null) {
                orderServiceExtension = new DefaultOrderServiceExtension();
            }
            orderServiceExtension.assignDriver(ticket.getId());
            if (this.listener != null) {
                this.listener.dataChanged(ticket);
            }
            TicketDAO.getInstance().refresh(ticket);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }
}

