/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.base.BaseCustomer;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseMenuItemModifierSpec;
import com.floreantpos.model.base.BaseMenuItemSize;
import com.floreantpos.model.base.BaseSalesArea;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.base.BaseTicketItemDiscount;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.ReorderType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.TableSelectionView;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderTypeSelectionDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import com.orocube.common.util.TicketStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TicketReorderAction
extends PosAction {
    private Ticket a;
    private boolean b;

    public TicketReorderAction() {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT);
        this.setRequiredPermission(UserPermission.CREATE_TICKET);
    }

    public TicketReorderAction(Ticket ticket, UserPermission userPermission) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, userPermission);
        this.a = ticket;
    }

    public TicketReorderAction(DataChangeListener dataChangeListener) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, dataChangeListener);
        this.setRequiredPermission(UserPermission.CREATE_TICKET);
    }

    public void setTicket(Ticket ticket) {
        this.a = ticket;
    }

    public Ticket getTicket() {
        return this.a;
    }

    @Override
    public void execute() {
        try {
            Object object;
            if (!this.getCurrentUser().hasPermission(this.requiredPermission)) {
                POSMessageDialog.showError(Messages.getString("OrderTypeButton.1"));
                return;
            }
            if (this.listener != null) {
                object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            if (this.a == null) {
                return;
            }
            if (this.a.getTicketStatus() == TicketStatus.Canceled) {
                POSMessageDialog.showError(Messages.getString("TicketReorderAction.4"));
                return;
            }
            object = DataProvider.get().getTicketToBeCreated();
            if (object != null) {
                ((Ticket)object).setCustomer(this.a.getCustomer());
                this.a(this.a, ((Ticket)object).getOrderType(), (Ticket)object);
            } else {
                OrderType orderType = DataProvider.get().getSelectedOrderType();
                if (orderType == null) {
                    OrderTypeSelectionDialog orderTypeSelectionDialog = new OrderTypeSelectionDialog();
                    orderTypeSelectionDialog.open();
                    if (orderTypeSelectionDialog.isCanceled()) {
                        return;
                    }
                    orderType = orderTypeSelectionDialog.getSelectedOrderType();
                }
                this.a = TicketDAO.getInstance().loadFullTicket(this.a.getId());
                this.a(this.a, orderType, null);
            }
            this.b = true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(Ticket ticket, OrderType orderType, Ticket ticket2) {
        Object object;
        PropertyContainer propertyContainer;
        Object object2;
        Serializable serializable;
        Object object3;
        if (ticket == null) {
            throw new PosException(Messages.getString("TicketReorderAction.2"));
        }
        if (ticket2 == null) {
            ticket2 = new Ticket(true);
            ticket2.setOrderType(orderType);
        }
        if (orderType.isShowTableSelection().booleanValue()) {
            object3 = TableSelectorFactory.createTableSelectorDialog(orderType);
            serializable = ((TableSelectorDialog)object3).getTableSelector();
            ((TableSelectionView)serializable).setHomeViewMode(Boolean.FALSE);
            ((TableSelectionView)serializable).setShouldReorder(Boolean.TRUE);
            ((TableSelectionView)serializable).setReorderType(ReorderType.TICKET_REORDER);
            ((TableSelectorDialog)object3).setCreateNewTicket(false);
            ((TableSelectorDialog)object3).updateView(true);
            ((POSDialog)object3).openUndecoratedFullScreen();
            ((TableSelectionView)serializable).setReorderType(null);
            ((TableSelectionView)serializable).setShouldReorder(Boolean.FALSE);
            if (((POSDialog)object3).isCanceled()) {
                return;
            }
            object2 = ((TableSelectorDialog)object3).getSelectedTables();
            ArrayList arrayList = new ArrayList();
            Iterator object4 = object2.iterator();
            while (object4.hasNext()) {
                propertyContainer = (ShopTable)object4.next();
                object = ((ShopTable)propertyContainer).getSalesArea();
                if (object != null) {
                    ticket2.setSalesArea((SalesArea)object);
                    ticket2.setSalesAreaId(((BaseSalesArea)object).getId());
                }
                arrayList.add(((BaseShopTable)((Object)propertyContainer)).getId());
            }
            ticket2.setTableNumbers(arrayList);
        }
        if (StringUtils.isNotEmpty((String)(object3 = this.a(ticket.getTicketItems(), orderType)))) {
            if (((String)object3).length() > 2) {
                object3 = ((String)object3).substring(0, ((String)object3).length() - 2);
            }
            object3 = (String)object3 + Messages.getString("OrderController.0");
            if (POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), (String)object3, Messages.getString("CONFIRM"), Messages.getString("TicketReorderAction.3"), Messages.getString("OrderController.1")) != 0) {
                return;
            }
        }
        serializable = new ArrayList();
        object2 = ticket.getCustomer();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            List<TicketItemModifier> list;
            Object object4;
            if (ticketItem.isVoided().booleanValue() || ticketItem.isItemReturned().booleanValue() || ticketItem.isGiftCard() || ticketItem.isTreatAsSeat().booleanValue()) continue;
            propertyContainer = ticketItem.cloneAsNew();
            ((BaseTicketItem)((Object)propertyContainer)).setTicket(ticket2);
            object = ((TicketItem)propertyContainer).getDiscounts();
            if (object != null) {
                object4 = object.iterator();
                while (object4.hasNext()) {
                    list = (TicketItemDiscount)object4.next();
                    Discount discount = DiscountDAO.getInstance().get(((BaseTicketItemDiscount)((Object)list)).getDiscountId());
                    if (discount.isEnabled().booleanValue() && !discount.isExpired()) continue;
                    object4.remove();
                }
            }
            if ((object4 = ((TicketItem)propertyContainer).getMenuItem()) != null) {
                if (((BaseMenuItem)object4).isDeleted().booleanValue()) continue;
                ((BaseTicketItem)((Object)propertyContainer)).setName(((MenuItem)object4).getDisplayName());
                ((BaseTicketItem)((Object)propertyContainer)).setShouldPrintToKitchen(((BaseMenuItem)object4).isShouldPrintToKitchen());
                list = orderType.isServiceChargeApplicable();
                if (((Boolean)((Object)list)).booleanValue()) {
                    ((BaseTicketItem)((Object)propertyContainer)).setServiceChargeApplicable((Boolean)((Object)list));
                    ((BaseTicketItem)((Object)propertyContainer)).setServiceChargeRate(ticket2.getOutletServiceChargeRate());
                } else {
                    ((BaseTicketItem)((Object)propertyContainer)).setServiceChargeRate(0.0);
                }
                if (!((BaseMenuItem)object4).isEditablePrice().booleanValue()) {
                    ((MenuItem)object4).setTicketItemUnitPriceAndCost((TicketItem)propertyContainer, (MenuItem)object4, DataProvider.get().getUnitByCode(((TicketItem)propertyContainer).getUnitName()), ticket2);
                }
                if (((BaseTicketItem)((Object)propertyContainer)).isPizzaType().booleanValue()) {
                    this.a((MenuItem)object4, (TicketItem)propertyContainer);
                }
                if (((BaseTicketItem)((Object)propertyContainer)).isComboItem().booleanValue()) {
                    ((TicketItem)propertyContainer).doCalculateComboItemPrice(true);
                }
                MenuItem.setItemTaxes((TicketItem)propertyContainer, ((MenuItem)object4).getTaxGroup((Customer)object2), ticket2.getOrderType());
            }
            serializable.add(propertyContainer);
            list = ((TicketItem)propertyContainer).getTicketItemModifiers();
            if (list == null) continue;
            list.forEach(arg_0 -> this.a((TicketItem)propertyContainer, orderType, arg_0));
        }
        this.a((List<TicketItem>)((Object)serializable));
        ticket2.getTicketItems().addAll((Collection<TicketItem>)((Object)serializable));
        if (object2 != null) {
            if (!((BaseCustomer)object2).isActive().booleanValue()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TicketReorderAction.5"));
                ticket2.setCustomer(null);
                OrderView.getInstance().setCurrentTicket(ticket2);
                RootView.getInstance().showView("ORDER_VIEW");
                return;
            }
            if (!((BaseCustomer)object2).isDeleted().booleanValue()) {
                ticket2.setCustomer(ticket.getCustomer());
                if (orderType.isDelivery().booleanValue()) {
                    this.a(ticket, ticket2);
                    boolean bl = OrderServiceFactory.getOrderService().showDeliveryInfo(ticket2, orderType, (Customer)object2);
                    if (!bl) {
                        return;
                    }
                    if (StringUtils.isBlank((String)ticket2.getDeliveryAddress())) {
                        return;
                    }
                }
            } else if (!this.a(orderType, ticket, ticket2)) {
                return;
            }
        } else if (!this.a(orderType, ticket, ticket2)) {
            return;
        }
        OrderView.getInstance().setCurrentTicket(ticket2);
        RootView.getInstance().showView("ORDER_VIEW");
    }

    private void a(Ticket ticket, Ticket ticket2) {
        String string;
        if (StringUtils.isNotBlank((String)ticket.getCustomerName())) {
            ticket2.setCustomerName(ticket.getCustomerName());
        }
        if (StringUtils.isNotBlank((String)ticket.getCustomerMobileNo())) {
            ticket2.setCustomerMobileNo(ticket.getCustomerMobileNo());
        }
        String string2 = "";
        if (StringUtils.isNotBlank((String)ticket.getDeliveryAddress())) {
            string2 = ticket.getDeliveryAddress();
        }
        if (StringUtils.isNotBlank((String)(string = ticket.getDeliveryZipCode()))) {
            string2 = string2 + ", " + string;
        }
        ticket2.setDeliveryAddress(string2);
        if (StringUtils.isNotBlank((String)ticket.getExtraDeliveryInfo())) {
            ticket2.setExtraDeliveryInfo(ticket.getExtraDeliveryInfo());
        }
        if (StringUtils.isNotBlank((String)ticket.getDeliveryFlatNo())) {
            ticket2.setDeliveryFlatNo(ticket.getDeliveryFlatNo());
        }
        if (ticket.getDeliveryCharge() != null) {
            ticket2.setDeliveryCharge(ticket.getDeliveryCharge());
        }
    }

    private String a(List<TicketItem> list, OrderType orderType) {
        OrderController orderController = OrderView.getInstance().getOrderController();
        String string = "";
        for (TicketItem ticketItem : list) {
            MenuItem menuItem = ticketItem.getMenuItem();
            if (menuItem == null || menuItem.isDeleted().booleanValue()) continue;
            if (!orderController.hasAvailableStock(menuItem, 1.0, Boolean.TRUE, orderType)) {
                string = string + menuItem.getDisplayName() + ",\n";
            }
            if (!ticketItem.isComboItem().booleanValue()) continue;
            List<TicketItem> list2 = ticketItem.getComboItems();
            if (list2 == null || list2.isEmpty()) {
                return string;
            }
            for (TicketItem ticketItem2 : list2) {
                MenuItem menuItem2 = ticketItem2.getMenuItem();
                if (menuItem2 == null || orderController.hasAvailableStock(menuItem2, 1.0, Boolean.TRUE, orderType)) continue;
                string = string + menuItem2.getDisplayName() + ",\n";
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean a(OrderType orderType, Ticket ticket, Ticket ticket2) {
        if (orderType.isRequiredCustomerData().booleanValue() && ticket2.getCustomer() == null) {
            CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(orderType);
            customerSelectorDialog.setCreateNewTicket(false);
            customerSelectorDialog.openFullScreen();
            if (customerSelectorDialog.isCanceled() || customerSelectorDialog.getSelectedCustomer() == null) return false;
            ticket2.setCustomer(customerSelectorDialog.getSelectedCustomer());
            if (!orderType.isDelivery().booleanValue()) return true;
            this.a(ticket, ticket2);
            boolean bl = OrderServiceFactory.getOrderService().showDeliveryInfo(ticket2, orderType, ticket2.getCustomer());
            if (bl) return true;
            return false;
        }
        if (!orderType.isDelivery().booleanValue()) return true;
        this.a(ticket, ticket2);
        boolean bl = OrderServiceFactory.getOrderService().showDeliveryInfo(ticket2, orderType, ticket2.getCustomer());
        if (bl) return true;
        return false;
    }

    private void a(List<TicketItem> list) {
        for (TicketItem ticketItem : list) {
            List<TicketItemModifier> list2 = ticketItem.getTicketItemModifiers();
            if (list2 == null) continue;
            Iterator<TicketItemModifier> iterator = list2.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier = iterator.next();
                if (!ticketItem.isPizzaType().booleanValue() || !ticketItemModifier.isInfoOnly().booleanValue() || iterator.hasNext()) continue;
                iterator.remove();
            }
        }
    }

    private void a(TicketItem ticketItem, TicketItemModifier ticketItemModifier, MenuModifier menuModifier) {
        Object object;
        String string = ticketItemModifier.getMultiplierName();
        List<Multiplier> list = DataProvider.get().getMultiplierList();
        Multiplier comparable2 = null;
        for (Multiplier comparable3 : list) {
            if (!comparable3.getId().equals(string)) continue;
            comparable2 = comparable3;
        }
        String string2 = ticketItemModifier.getSectionName() == null ? "" : ticketItemModifier.getSectionName();
        TicketItemModifier ticketItemModifier2 = ticketItem.getSizeModifier();
        MenuItemSize menuItemSize = null;
        if (ticketItemModifier2 != null) {
            Object object2;
            Object d2;
            object = ticketItemModifier2.getName().trim();
            String d = "";
            List<MenuItemSize> list2 = MenuItemSizeDAO.getInstance().findAll();
            if (list2 != null) {
                d2 = list2.iterator();
                while (d2.hasNext()) {
                    object2 = (MenuItemSize)d2.next();
                    if (!((String)object).contains(((BaseMenuItemSize)object2).getName()) || ((BaseMenuItemSize)object2).getName().length() <= d.length()) continue;
                    d = ((BaseMenuItemSize)object2).getName();
                }
            }
            if ((d2 = ticketItem.getMenuItem().getPizzaPriceList()) != null) {
                object2 = d2.iterator();
                while (object2.hasNext()) {
                    PizzaPrice d3 = (PizzaPrice)object2.next();
                    if (!d3.getSize().getName().equalsIgnoreCase(d)) continue;
                    menuItemSize = d3.getSize();
                    break;
                }
            }
        }
        MenuModifierDAO.getInstance().initialize(menuModifier);
        ticketItemModifier.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        object = menuModifier.getMenuItemModifierGroup();
        if (object != null) {
            ticketItemModifier.setGroupId(((BaseMenuItemModifierSpec)object).getId());
        }
        double d = menuModifier.getPriceForSizeAndMultiplier(menuItemSize, false, comparable2);
        double d2 = menuModifier.getCost() * (comparable2.getRate() / 100.0);
        ticketItemModifier.setUnitPrice(d);
        ticketItemModifier.setUnitCost(d2);
        if (!ticketItemModifier.isInfoOnly().booleanValue()) {
            double d3 = ticketItem.getMenuItem().getDefaultSellPortion().intValue();
            ticketItemModifier.setUnitPrice(ticketItemModifier.getUnitPrice() * d3 / 100.0);
        }
        ticketItemModifier.setShouldSectionWisePrice(menuModifier.isShouldSectionWisePrice());
        if (ticketItemModifier.isShouldSectionWisePrice().booleanValue()) {
            ticketItemModifier.setUnitPrice(this.a(string2, ticketItemModifier.getUnitPrice()));
        }
    }

    private Double a(String string, double d) {
        switch (string) {
            case "WHOLE": {
                return d * 1.0;
            }
            case "Quarter 1": {
                return d * 0.25;
            }
            case "Quarter 2": {
                return d * 0.25;
            }
            case "Quarter 3": {
                return d * 0.25;
            }
            case "Quarter 4": {
                return d * 0.25;
            }
            case "Half 1": {
                return d * 0.5;
            }
            case "Half 2": {
                return d * 0.5;
            }
        }
        return null;
    }

    private void a(MenuItem menuItem, TicketItem ticketItem) {
        List<MenuItemSize> list = MenuItemSizeDAO.getInstance().findAll();
        List<PizzaCrust> list2 = PizzaCrustDAO.getInstance().findAll();
        TicketItemModifier ticketItemModifier = ticketItem.getSizeModifier();
        if (ticketItemModifier != null) {
            String string = ticketItemModifier.getName().trim();
            String string2 = "";
            String string3 = "";
            for (MenuItemSize object : list) {
                if (!string.contains(object.getName()) || object.getName().length() <= string2.length()) continue;
                string2 = object.getName();
            }
            for (PizzaCrust pizzaCrust : list2) {
                if (!string.contains(pizzaCrust.getName()) || pizzaCrust.getName().length() <= string3.length()) continue;
                string3 = pizzaCrust.getName();
            }
            List<PizzaPrice> list3 = menuItem.getPizzaPriceList();
            if (list3 != null) {
                for (PizzaPrice pizzaPrice : list3) {
                    if (!pizzaPrice.getCrust().getName().equalsIgnoreCase(string3) || !pizzaPrice.getSize().getName().equalsIgnoreCase(string2)) continue;
                    ticketItem.setUnitPrice(pizzaPrice.getPrice(menuItem.getDefaultSellPortion()));
                    break;
                }
            }
        }
    }

    public boolean isReorder() {
        return this.b;
    }

    private /* synthetic */ void a(TicketItem ticketItem, OrderType orderType, TicketItemModifier ticketItemModifier) {
        MenuModifier menuModifier;
        String string = ticketItemModifier.getItemId();
        MenuModifier menuModifier2 = menuModifier = StringUtils.isBlank((String)string) ? null : MenuModifierDAO.getInstance().loadFullModifier(string);
        if (menuModifier != null) {
            Object object;
            if (ticketItem.isPizzaType().booleanValue()) {
                this.a(ticketItem, ticketItemModifier, menuModifier);
            } else {
                object = MenuItemModifierSpecDAO.getInstance().get(ticketItemModifier.getGroupId());
                if (object != null && ((MenuItemModifierSpec)object).hasPriceRules()) {
                    ticketItem.updateModifiersUnitPriceByGroup((MenuItemModifierSpec)object);
                    ticketItemModifier.setName(menuModifier.getDisplayName());
                } else if (StringUtils.isNotEmpty((String)ticketItemModifier.getMultiplierName())) {
                    List<Multiplier> list = DataProvider.get().getMultiplierList();
                    for (Multiplier multiplier : list) {
                        if (!ticketItemModifier.getMultiplierName().equals(multiplier.getTicketPrefix())) continue;
                        ticketItemModifier.setUnitPrice(menuModifier.getPriceForMultiplier(multiplier));
                        break;
                    }
                } else {
                    ticketItemModifier.setUnitPrice(menuModifier.getPrice());
                }
            }
            object = menuModifier.getTaxByOrderType(orderType, ticketItem);
            if (object != null) {
                ticketItemModifier.getTaxes().clear();
                ticketItemModifier.getTaxes().addAll((Collection<TicketItemTax>)object);
            }
        }
    }
}

