/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.CustomerAccountReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class CustomerAccountReportAction
extends AbstractAction {
    public CustomerAccountReportAction() {
        super(Messages.getString("CUSTOMER_ACCOUNT_REPORT"));
    }

    public CustomerAccountReportAction(String string) {
        super(string);
    }

    public CustomerAccountReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            CustomerAccountReportView customerAccountReportView = null;
            int n = jTabbedPane.indexOfTab(Messages.getString("CUSTOMER_ACCOUNT_REPORT"));
            if (n == -1) {
                customerAccountReportView = new CustomerAccountReportView();
                jTabbedPane.addTab(Messages.getString("CUSTOMER_ACCOUNT_REPORT"), customerAccountReportView);
            } else {
                customerAccountReportView = (CustomerAccountReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(customerAccountReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

