/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Main;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.ProgressDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.datamigrate.DbConnectionInfo;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.apache.commons.io.IOUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.dialect.Dialect;

public class DataResetAction
extends AbstractAction
implements Runnable {
    private ProgressDialog2 a;

    public DataResetAction() {
        super(Messages.getString("DataResetAction.0"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JPasswordField jPasswordField = new JPasswordField(20);
        jPasswordField.requestFocusInWindow();
        String string = Messages.getString("DataResetAction.1");
        int n = 2;
        int n2 = JOptionPane.showConfirmDialog(POSUtil.getFocusedWindow(), jPasswordField, string, n, -1);
        if (n2 != 0) {
            return;
        }
        String string2 = new String(jPasswordField.getPassword());
        String string3 = new SimpleDateFormat(Messages.getString("DataResetAction.2")).format(new Date());
        if (!string3.equals(string2)) {
            POSMessageDialog.showError(Messages.getString("DataResetAction.3"));
            return;
        }
        String string4 = Messages.getString("DataResetAction.4");
        string4 = "<html>" + string4 + "</html>";
        int n3 = JOptionPane.showConfirmDialog(POSUtil.getFocusedWindow(), string4);
        if (n3 != 0) {
            return;
        }
        this.a = new ProgressDialog2(this);
        this.a.setProgressLabelText(Messages.getString("DataResetAction.7"));
        this.a.setIndeterminate(true);
        this.a.setCancelable(false);
        this.a.pack();
        this.a.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        DbConnectionInfo dbConnectionInfo = new DbConnectionInfo();
        Database database = AppConfig.getDefaultDatabase();
        dbConnectionInfo.setSelectedDatabase(database);
        dbConnectionInfo.setDriverClass(database.getHibernateConnectionDriverClass());
        dbConnectionInfo.setConnectionString(AppConfig.getConnectString());
        dbConnectionInfo.setUserName(AppConfig.getDatabaseUser());
        dbConnectionInfo.setPassword(AppConfig.getDatabasePassword());
        try {
            Object object;
            Session session = TerminalDAO.getInstance().createNewSession();
            Transaction transaction = session.beginTransaction();
            Query query = session.createQuery(String.format("update Terminal set %s=null, %s=null", Terminal.PROP_CURRENT_CASH_DRAWER, Terminal.PROP_ASSIGNED_USER_ID));
            query.executeUpdate();
            query = session.createQuery(String.format("update User set %s=null, %s=null,%s=false", User.PROP_LAST_CLOCK_IN_TIME, User.PROP_LAST_CLOCK_OUT_TIME, User.PROP_CLOCKED_IN));
            query.executeUpdate();
            transaction.commit();
            session.close();
            InputStream inputStream = this.getClass().getResourceAsStream("/db-reset-data");
            List list = IOUtils.readLines((InputStream)inputStream);
            inputStream.close();
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                object = ((String)object2.next()).trim();
                if (((String)object).startsWith("//")) continue;
                arrayList.add(((String)object).toLowerCase());
            }
            DatabaseUtil.removeConstrainsFromDestDB(dbConnectionInfo);
            object2 = dbConnectionInfo.openConnection();
            object = object2.getMetaData();
            Dialect dialect = (Dialect)Class.forName(dbConnectionInfo.getSelectedDatabase().getHibernateDialect()).newInstance();
            String string = dialect.getSchemaNameResolver().resolveSchemaName((Connection)object2, dialect);
            ResultSet resultSet = object.getTables(null, string, null, new String[]{"TABLE"});
            while (resultSet.next()) {
                String string2 = resultSet.getString("TABLE_NAME");
                if (!arrayList.contains(string2.toLowerCase())) continue;
                String string3 = "delete from " + string2;
                Statement statement = object2.createStatement();
                statement.execute(string3);
                statement.close();
            }
            resultSet.close();
            object2.commit();
            object2.close();
            bl = true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
        finally {
            DatabaseUtil.restoreDbConstraints(dbConnectionInfo);
            this.a.dispose();
            if (bl) {
                JOptionPane.showMessageDialog(POSUtil.getFocusedWindow(), Messages.getString("DataResetAction.10"));
                Main.restart();
            }
        }
    }
}

