/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ComboGroupItemSelectionDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class ComboGroupTreeExplorer
extends JPanel {
    private JXTreeTable a;
    private MenuItem b;
    private List<ComboGroup> c;
    private ComboGroupTreeTableModel d;
    private DefaultMutableTreeTableNode e;
    private DefaultCellEditor f;

    public ComboGroupTreeExplorer() {
        this.setPreferredSize(PosUIManager.getSize(0, 300));
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0 0 0 0"));
        this.add(jPanel);
        this.a = new JXTreeTable(){

            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                if (n2 != 5) {
                    return;
                }
                TreePath treePath = ComboGroupTreeExplorer.this.a.getPathForRow(n);
                DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                if (defaultMutableTreeTableNode.getUserObject() instanceof ComboGroup) {
                    return;
                }
                ComboGroupTreeExplorer.this.a.editCellAt(n, n2);
                TableCellEditor tableCellEditor = ComboGroupTreeExplorer.this.a.getCellEditor(n, n2);
                if (!(tableCellEditor instanceof DefaultCellEditor)) {
                    return;
                }
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)tableCellEditor;
                if (defaultCellEditor.getComponent() instanceof JTextField) {
                    JTextField jTextField = (JTextField)defaultCellEditor.getComponent();
                    jTextField.requestFocus();
                    jTextField.selectAll();
                }
            }

            public TableCellRenderer getCellRenderer(int n, int n2) {
                return super.getCellRenderer(n, n2);
            }

            public TableCellEditor getCellEditor(int n, int n2) {
                TreePath treePath;
                DefaultMutableTreeTableNode defaultMutableTreeTableNode;
                if (n2 == 5 && (defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)(treePath = ComboGroupTreeExplorer.this.a.getPathForRow(n)).getLastPathComponent()).getUserObject() instanceof MenuItem) {
                    return ComboGroupTreeExplorer.this.f;
                }
                return super.getCellEditor(n, n2);
            }

            public void setValueAt(Object object, int n, int n2) {
                try {
                    if (n2 != 5) {
                        super.setValueAt(object, n, n2);
                        return;
                    }
                    TreePath treePath = ComboGroupTreeExplorer.this.a.getPathForRow(n);
                    DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                    TreeTableNode treeTableNode = defaultMutableTreeTableNode.getParent();
                    if (defaultMutableTreeTableNode.getUserObject() instanceof MenuItem && treeTableNode.getUserObject() instanceof ComboGroup) {
                        boolean bl;
                        ComboGroup comboGroup = (ComboGroup)treeTableNode.getUserObject();
                        MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
                        String string = object == null ? "0%" : object.toString();
                        Double d = this.a(string, bl = string.endsWith("%"));
                        if (NumberUtil.getCurrencyFormatWithoutCurrencySymbol(d).length() > 15) {
                            POSMessageDialog.showError(Messages.getString("EnterValidRageOfPrice"));
                            return;
                        }
                        if (bl) {
                            if (Math.abs(d) > 100.0) {
                                ComboGroupTreeExplorer.this.c();
                                return;
                            }
                        } else if (d < 0.0) {
                            POSMessageDialog.showError(Messages.getString("NegativeStaticNotAllowed"));
                            return;
                        }
                        comboGroup.addItemPrice(menuItem.getId(), this.a(d, bl));
                    }
                }
                catch (Exception exception) {
                    PosLog.error(((Object)((Object)this)).getClass(), exception);
                }
            }

            private String a(Double d, boolean bl) {
                if (bl) {
                    return NumberUtil.trimDecilamIfNotNeeded(d, true) + "%";
                }
                return NumberUtil.format6DigitNumber(d);
            }

            private Double a(String string, boolean bl) {
                if (string == null || string.isEmpty()) {
                    return 0.0;
                }
                if (bl) {
                    return POSUtil.parseDouble(string.replaceAll("%", ""));
                }
                return POSUtil.parseDouble(string);
            }
        };
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.setRootVisible(false);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.a.setSelectionMode(0);
        this.a.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        jPanel.add((Component)new JScrollPane((Component)this.a), "grow");
        this.add((Component)this.d(), "South");
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        tableColumnModel.getColumn(2).setMinWidth(40);
        tableColumnModel.getColumn(2).setMaxWidth(40);
        tableColumnModel.getColumn(3).setMinWidth(40);
        tableColumnModel.getColumn(3).setMaxWidth(40);
        tableColumnModel.getColumn(5).setMinWidth(200);
        tableColumnModel.getColumn(5).setMaxWidth(200);
    }

    private void b() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComboGroupTreeExplorer.this.a(Integer.parseInt(actionEvent.getActionCommand()));
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn((JTable)this.a, abstractAction, 5){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (n2 != 5) {
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
                TreePath treePath = ComboGroupTreeExplorer.this.a.getPathForRow(n);
                DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                if (defaultMutableTreeTableNode.getUserObject() instanceof MenuItem) {
                    JLabel jLabel = new JLabel();
                    jLabel.setHorizontalAlignment(4);
                    jLabel.setText(object == null ? "" : object.toString());
                    jLabel.setOpaque(true);
                    jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    if (bl) {
                        jLabel.setBackground(jTable.getSelectionBackground());
                        jLabel.setForeground(jTable.getSelectionForeground());
                    } else {
                        jLabel.setBackground(jTable.getBackground());
                        jLabel.setForeground(jTable.getForeground());
                    }
                    return jLabel;
                }
                return super.getTableCellRendererComponent(jTable, object, false, bl2, n, n2);
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                if (n2 != 5) {
                    return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                TreePath treePath = ComboGroupTreeExplorer.this.a.getPathForRow(n);
                DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                if (defaultMutableTreeTableNode.getUserObject() instanceof MenuItem) {
                    return ComboGroupTreeExplorer.this.f.getComponent();
                }
                Component component = super.getTableCellEditorComponent(jTable, object, false, n, n2);
                return component;
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 5, 1, 5, this.a.getBackground());
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(1, 5, 1, 5, this.a.getBackground());
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder compoundBorder = new CompoundBorder(matteBorder, BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), border));
        CompoundBorder compoundBorder2 = new CompoundBorder(matteBorder2, BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), border));
        buttonColumn.setUnselectedBorder(compoundBorder);
        buttonColumn.setFocusBorder(compoundBorder2);
    }

    private void a(int n) {
        if (n < 0) {
            return;
        }
        try {
            ComboGroup comboGroup;
            List<MenuItem> list;
            Double d = NumberSelectionDialog2.takeDoubleInput(Messages.getString("EnterPercentage"), true);
            if (d == null) {
                return;
            }
            if (Math.abs(d) > 100.0) {
                this.c();
                return;
            }
            TreePath treePath = this.a.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (defaultMutableTreeTableNode.getUserObject() instanceof ComboGroup && (list = (comboGroup = (ComboGroup)defaultMutableTreeTableNode.getUserObject()).getItems()) != null && list.size() > 0) {
                for (MenuItem menuItem : list) {
                    comboGroup.addItemPrice(menuItem.getId(), NumberUtil.trimDecilamIfNotNeeded(d, true) + "%");
                }
            }
            this.e();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE);
        }
    }

    private void c() {
        POSMessageDialog.showError(Messages.getString("PercentCannotBeGreaterHundred"));
    }

    private JPanel d() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(""));
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.setActionCommand(POSConstants.ADD);
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.setActionCommand(POSConstants.EDIT);
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.setActionCommand(POSConstants.DELETE);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (POSConstants.ADD.equals(string)) {
                    ComboGroupTreeExplorer.this.addNewComboGroup();
                } else if (POSConstants.EDIT.equals(string)) {
                    ComboGroupTreeExplorer.this.editComboGroup();
                } else if (POSConstants.DELETE.equals(string)) {
                    ComboGroupTreeExplorer.this.deleteComboGroup();
                }
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        jButton3.addActionListener(actionListener);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }

    protected void addNewComboGroup() {
        try {
            MenuItem menuItem;
            Object object;
            Object object2;
            ComboGroup comboGroup = new ComboGroup();
            ComboGroupItemSelectionDialog comboGroupItemSelectionDialog = new ComboGroupItemSelectionDialog(this.b, comboGroup);
            comboGroupItemSelectionDialog.setSize(PosUIManager.getSize(600, 600));
            comboGroupItemSelectionDialog.open();
            if (comboGroupItemSelectionDialog.isCanceled()) {
                return;
            }
            if (this.c == null) {
                this.c = new ArrayList<ComboGroup>();
            }
            if (this.c.size() > 0) {
                object2 = this.c.iterator();
                while (object2.hasNext()) {
                    object = (ComboGroup)object2.next();
                    if (!this.a((ComboGroup)object, comboGroup.getItems())) continue;
                    return;
                }
            }
            if ((object2 = comboGroup.getItems()) != null && object2.size() > 0) {
                object = object2.iterator();
                while (object.hasNext()) {
                    menuItem = (MenuItem)object.next();
                    comboGroup.addItemPrice(menuItem.getId(), "0%");
                }
            }
            this.c.add(comboGroup);
            object = (MutableTreeTableNode)this.d.getRoot();
            menuItem = new DefaultMutableTreeTableNode((Object)comboGroup);
            this.a((DefaultMutableTreeTableNode)menuItem);
            this.d.insertNodeInto((MutableTreeTableNode)menuItem, (MutableTreeTableNode)object, object.getChildCount());
            this.a.expandAll();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private boolean a(ComboGroup comboGroup, List<MenuItem> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        List<MenuItem> list2 = comboGroup.getItems();
        if (list2 == null || list2.isEmpty()) {
            return false;
        }
        for (MenuItem menuItem : list2) {
            if (menuItem == null || StringUtils.isEmpty((CharSequence)menuItem.getId())) continue;
            for (MenuItem menuItem2 : list) {
                if (menuItem2 == null || !StringUtils.isNotEmpty((CharSequence)menuItem2.getId()) || !menuItem.getId().equals(menuItem2.getId())) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ComboGroupItemSelectionDialog.18"));
                return true;
            }
        }
        return false;
    }

    protected void editComboGroup() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.a.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (defaultMutableTreeTableNode.getUserObject() instanceof ComboGroup) {
                ComboGroup comboGroup = (ComboGroup)defaultMutableTreeTableNode.getUserObject();
                ComboGroupItemSelectionDialog comboGroupItemSelectionDialog = new ComboGroupItemSelectionDialog(this.b, comboGroup, true);
                comboGroupItemSelectionDialog.setSize(PosUIManager.getSize(600, 600));
                comboGroupItemSelectionDialog.open();
                if (comboGroupItemSelectionDialog.isCanceled()) {
                    return;
                }
                if (this.c != null && this.c.size() > 0) {
                    for (ComboGroup comboGroup2 : this.c) {
                        if (comboGroup2 == comboGroup || !this.a(comboGroup2, comboGroup.getItems())) continue;
                        return;
                    }
                }
            } else if (defaultMutableTreeTableNode.getUserObject() instanceof MenuItem) {
                TreeTableNode treeTableNode = defaultMutableTreeTableNode.getParent();
                ComboGroup comboGroup = (ComboGroup)treeTableNode.getUserObject();
                ComboGroupItemSelectionDialog comboGroupItemSelectionDialog = new ComboGroupItemSelectionDialog(this.b, comboGroup, true);
                comboGroupItemSelectionDialog.setSize(PosUIManager.getSize(600, 600));
                comboGroupItemSelectionDialog.open();
                if (comboGroupItemSelectionDialog.isCanceled()) {
                    return;
                }
            }
            this.e();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE);
        }
    }

    protected void deleteComboGroup() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.a.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (ConfirmDeleteDialog.showMessage(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            if (defaultMutableTreeTableNode.getUserObject() instanceof ComboGroup) {
                ComboGroup comboGroup = (ComboGroup)defaultMutableTreeTableNode.getUserObject();
                MutableTreeTableNode mutableTreeTableNode = this.findTreeNodeForTree((MutableTreeTableNode)this.d.getRoot(), comboGroup.getId());
                if (mutableTreeTableNode.getParent() != null) {
                    this.c.remove(comboGroup);
                    this.d.removeNodeFromParent(mutableTreeTableNode);
                }
            } else if (defaultMutableTreeTableNode.getUserObject() instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
                TreeTableNode treeTableNode = defaultMutableTreeTableNode.getParent();
                ComboGroup comboGroup = (ComboGroup)treeTableNode.getUserObject();
                if (comboGroup != null) {
                    comboGroup.getItems().remove(menuItem);
                    this.e();
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE);
        }
    }

    public MutableTreeTableNode findTreeNodeForTree(MutableTreeTableNode mutableTreeTableNode, String string) {
        if (((DefaultMutableTreeTableNode)mutableTreeTableNode).getUserObject() instanceof ComboGroup) {
            ComboGroup comboGroup = (ComboGroup)mutableTreeTableNode.getUserObject();
            if (comboGroup.getId() == null || comboGroup.getId().equals(string)) {
                return mutableTreeTableNode;
            }
            Enumeration enumeration = mutableTreeTableNode.children();
            while (enumeration.hasMoreElements()) {
                MutableTreeTableNode mutableTreeTableNode2 = (MutableTreeTableNode)enumeration.nextElement();
                MutableTreeTableNode mutableTreeTableNode3 = this.findTreeNodeForTree(mutableTreeTableNode2, string);
                if (mutableTreeTableNode3 == null) continue;
                return mutableTreeTableNode3;
            }
        }
        return null;
    }

    private void e() throws Exception {
        this.a.removeAll();
        ComboGroup comboGroup = new ComboGroup();
        comboGroup.setId("0");
        comboGroup.setName("Root");
        this.e = new DefaultMutableTreeTableNode((Object)comboGroup);
        this.e.setUserObject((Object)comboGroup);
        if (this.c != null) {
            for (ComboGroup comboGroup2 : this.c) {
                DefaultMutableTreeTableNode defaultMutableTreeTableNode = new DefaultMutableTreeTableNode((Object)comboGroup2);
                this.e.add((MutableTreeTableNode)defaultMutableTreeTableNode);
                this.a(defaultMutableTreeTableNode);
            }
        }
        this.d = new ComboGroupTreeTableModel(this.e);
        this.a.setTreeTableModel((TreeTableModel)this.d);
        FixedLengthTextField fixedLengthTextField = new FixedLengthTextField();
        fixedLengthTextField.setLength(15);
        fixedLengthTextField.setHorizontalAlignment(4);
        fixedLengthTextField.setBorder(BorderFactory.createCompoundBorder(fixedLengthTextField.getBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.f = new DefaultCellEditor(fixedLengthTextField);
        this.f.setClickCountToStart(1);
        this.a.setDefaultEditor(this.a.getColumnClass(5), (TableCellEditor)this.f);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.a.expandAll();
        this.b();
        this.resizeColumnWidth((JTable)this.a);
    }

    private void a(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        ComboGroup comboGroup = (ComboGroup)defaultMutableTreeTableNode.getUserObject();
        if (comboGroup == null) {
            return;
        }
        defaultMutableTreeTableNode.setAllowsChildren(true);
        List<MenuItem> list = comboGroup.getItems();
        for (MenuItem menuItem : list) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode2 = new DefaultMutableTreeTableNode((Object)menuItem);
            defaultMutableTreeTableNode.add((MutableTreeTableNode)defaultMutableTreeTableNode2);
        }
    }

    public void setComboGroups(List<ComboGroup> list) {
        try {
            this.c = list;
            this.e();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    public void setMenuItem(MenuItem menuItem) {
        this.b = menuItem;
        this.setComboGroups(menuItem.getComboGroups());
    }

    public List<ComboGroup> getGroups() {
        return this.c;
    }

    class ComboGroupTreeTableModel
    extends DefaultTreeTableModel {
        String a;
        private final String[] c;

        public ComboGroupTreeTableModel(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
            super((TreeTableNode)defaultMutableTreeTableNode);
            this.a = " (" + CurrencyUtil.getCurrencySymbol() + ")";
            this.c = new String[]{Messages.getString("ComboGroupTreeExplorer.0"), Messages.getString("ComboGroupTreeExplorer.1"), Messages.getString("ComboGroupTreeExplorer.2"), Messages.getString("ComboGroupTreeExplorer.4"), Messages.getString("ComboGroupTreeExplorer.5") + this.a, Messages.getString("ComboGroupTreeExplorer.13") + this.a};
        }

        public void setRoot(TreeTableNode treeTableNode) {
            super.setRoot(treeTableNode);
        }

        public int getColumnCount() {
            return this.c.length;
        }

        public String getColumnName(int n) {
            return this.c[n];
        }

        public boolean isCellEditable(Object object, int n) {
            return object instanceof DefaultMutableTreeTableNode && (((DefaultMutableTreeTableNode)object).getUserObject() instanceof ComboGroup ? n == 5 : ((DefaultMutableTreeTableNode)object).getUserObject() instanceof MenuItem && n == 5);
        }

        public Object getValueAt(Object object, int n) {
            if (object instanceof DefaultMutableTreeTableNode) {
                DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)object;
                if (defaultMutableTreeTableNode.getUserObject() instanceof ComboGroup) {
                    ComboGroup comboGroup = (ComboGroup)defaultMutableTreeTableNode.getUserObject();
                    if (comboGroup == null) {
                        return "";
                    }
                    switch (n) {
                        case 0: {
                            return comboGroup.getName();
                        }
                        case 2: {
                            return comboGroup.getMinQuantity();
                        }
                        case 3: {
                            return comboGroup.getMaxQuantity();
                        }
                        case 5: {
                            return Messages.getString("ApplyModificationPercentage");
                        }
                    }
                } else if (defaultMutableTreeTableNode.getUserObject() instanceof MenuItem) {
                    MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
                    if (menuItem == null) {
                        return "";
                    }
                    switch (n) {
                        case 1: {
                            return menuItem.getDisplayName();
                        }
                        case 4: {
                            return menuItem.getVariantPrice();
                        }
                        case 5: {
                            TreeTableNode treeTableNode = defaultMutableTreeTableNode.getParent();
                            if (treeTableNode.getUserObject() instanceof ComboGroup) {
                                ComboGroup comboGroup = (ComboGroup)treeTableNode.getUserObject();
                                return comboGroup.getItemPriceDisplay(menuItem.getId());
                            }
                            return "";
                        }
                    }
                }
            }
            return null;
        }
    }
}

