/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.CustomerForm;
import com.floreantpos.ui.model.MultipleCustomerSelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class CustomerSelectionDialog
extends POSDialog
implements ActionListener {
    private MultipleCustomerSelectionView a;
    private List<Customer> b;
    private boolean c;
    private TitlePanel d;
    private static CustomerSelectionDialog e;

    public CustomerSelectionDialog(JDialog jDialog, List<Customer> list) {
        super(jDialog, "", true);
        this.b = list;
        this.a();
    }

    public CustomerSelectionDialog(List<Customer> list) {
        super(POSUtil.getFocusedWindow(), "");
        this.b = list;
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle(Messages.getString("CustomerSelectionDialog.1"));
        this.d = new TitlePanel();
        this.d.setTitle(Messages.getString("CustomerSelectionDialog.4"));
        this.add((Component)this.d, "North");
        this.a = new MultipleCustomerSelectionView(this.b);
        PosSmallButton posSmallButton = new PosSmallButton(POSConstants.SELECT);
        posSmallButton.setActionCommand(POSConstants.OK);
        posSmallButton.setBackground(Color.GREEN);
        posSmallButton.setFocusable(false);
        posSmallButton.addActionListener(this);
        PosSmallButton posSmallButton2 = new PosSmallButton(POSConstants.CANCEL);
        posSmallButton2.setFocusable(false);
        posSmallButton2.addActionListener(this);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 12 5", "", ""));
        PosSmallButton posSmallButton3 = new PosSmallButton();
        PosSmallButton posSmallButton4 = new PosSmallButton();
        posSmallButton4.setText(POSConstants.ADD);
        posSmallButton3.setText(POSConstants.EDIT);
        posSmallButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerSelectionDialog.this.d();
            }
        });
        posSmallButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    boolean bl = true;
                    CustomerForm customerForm = new CustomerForm(bl);
                    customerForm.enableCustomerFields(true);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog(customerForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    Customer customer = (Customer)customerForm.getBean();
                    CustomerSelectionDialog.this.a.getModel().addRow(customer);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        jPanel.add(posSmallButton4);
        jPanel.add(posSmallButton3);
        jPanel.add(posSmallButton);
        jPanel.add(posSmallButton2);
        this.add((Component)this.a, "Center");
        this.add((Component)jPanel, "South");
    }

    public void setSingleSelectionEnable(boolean bl) {
        this.c = bl;
        if (bl) {
            this.d.setTitle(Messages.getString("CustomerSelectionDialog.9"));
        }
        this.a.setSingleSelectionEnable(bl);
    }

    public void setSelectedGroup(CustomerGroup customerGroup) {
        this.a.setSelectedGroup(customerGroup);
    }

    private void b() {
        if (this.c) {
            Customer customer = this.getSelectedRowData();
            if (customer == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CustomerSelectionDialog.10"));
                return;
            }
        } else {
            List<Customer> list = this.a.getSelectedCustomerList();
            if (list == null || list.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CustomerSelectionDialog.11"));
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void c() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(string)) {
            this.c();
        } else if (POSConstants.OK.equalsIgnoreCase(string)) {
            this.b();
        }
    }

    private void d() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            Customer customer = this.a.getModel().getRow(n);
            CustomerForm customerForm = new CustomerForm();
            customerForm.enableCustomerFields(true);
            customerForm.setBean(customer);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog(customerForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    public List<Customer> getSelectedCustomerList() {
        return this.a.getSelectedCustomerList();
    }

    public Customer getSelectedRowData() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.a.getModel().getRow(n);
    }

    public static CustomerSelectionDialog getInstance(List<Customer> list, boolean bl) {
        if (e == null) {
            e = new CustomerSelectionDialog(list);
            e.setSingleSelectionEnable(bl);
        }
        return e;
    }
}

