/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.mailservices.MailAttachment;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.ReportFrequency;
import com.floreantpos.model.Store;
import com.floreantpos.model.WorkingHours;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.service.EndOfDayReportService;
import com.floreantpos.report.service.ItemwiseSalesReportService;
import com.floreantpos.report.service.PayoutReportService;
import com.floreantpos.report.service.SalesBalanceReportService;
import com.floreantpos.util.POSUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EmailReportJob
extends CronJob {
    public static final String PROP_EMAIL = "EMAIL";
    public static final String PROP_EMAIL_REPORTS = "EMAIL_REPORTS_LIST";

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Date date;
        PosLog.info(this.getClass(), "Initializing email to send report...");
        Date date2 = date = new Date();
        Date date3 = DateUtil.startOfDay(date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");
        try {
            CronJob cronJob = CronJobDAO.getInstance().get(jobExecutionContext.getJobDetail().getKey().getName());
            date3 = this.getInitialDate(cronJob);
            PosLog.debug(this.getClass(), String.format("Report time- , start: %s end: %s", date3, date2));
            if (date3 == null) {
                return;
            }
            Map map = (Map)new ObjectMapper().readValue(cronJob.getProperties(), (TypeReference)new TypeReference<Map<String, String>>(){});
            String string = (String)map.get(PROP_EMAIL);
            String string2 = Messages.getString("EmailReportJob.0");
            String string3 = " ";
            ArrayList<MailAttachment> arrayList = new ArrayList<MailAttachment>();
            String string4 = (String)map.get(PROP_EMAIL_REPORTS);
            List<String> list = Arrays.asList(string4.split(","));
            String[] stringArray = list.iterator();
            while (stringArray.hasNext()) {
                String[] stringArray2 = stringArray.next();
                int n = POSUtil.parseInteger((String)stringArray2);
                switch (n) {
                    case 1: {
                        String string5 = "payout_report_" + simpleDateFormat.format(date3) + "_to_" + simpleDateFormat.format(date2) + ".pdf";
                        byte[] object = JasperExportManager.exportReportToPdf((JasperPrint)new PayoutReportService().createJasperPrint(date3, date2));
                        arrayList.add(new MailAttachment(string5, object));
                        break;
                    }
                    case 2: {
                        String string5 = "itemwise_sales_report_" + simpleDateFormat.format(date3) + "_to_" + simpleDateFormat.format(date2) + ".pdf";
                        byte[] byArray = JasperExportManager.exportReportToPdf((JasperPrint)new ItemwiseSalesReportService(date3, date2, null, null, true, false, true).createJasperPrint());
                        arrayList.add(new MailAttachment(string5, byArray));
                        break;
                    }
                    case 3: {
                        String string6 = "sales_balance_report_" + simpleDateFormat.format(date3) + ".pdf";
                        byte[] byArray = JasperExportManager.exportReportToPdf((JasperPrint)SalesBalanceReportService.createSalesBalanceReport(date3, date2, null));
                        arrayList.add(new MailAttachment(string6, byArray));
                        break;
                    }
                    case 4: {
                        String string7 = "eod_report_" + simpleDateFormat.format(date3) + ".pdf";
                        byte[] byArray = JasperExportManager.exportReportToPdf((JasperPrint)EndOfDayReportService.createEndOfDayReport(date3, date2, null));
                        arrayList.add(new MailAttachment(string7, byArray));
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)string)) {
                for (String string8 : stringArray = string.split(",")) {
                    if (MailService.sendMailWithAttchments(string8, string2, string3, arrayList)) {
                        PosLog.info(this.getClass(), "Successfully send email to " + string8 + " ...");
                        continue;
                    }
                    PosLog.error(this.getClass(), "Unable to send email to " + string8 + " ...");
                }
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Runtime error occured in sending email...", exception);
        }
    }

    public Date getInitialDate(CronJob cronJob) {
        ReportFrequency reportFrequency = ReportFrequency.fromKey(cronJob.getFrequency());
        Store store = StoreDAO.getRestaurant();
        Calendar calendar = Calendar.getInstance();
        if (reportFrequency.equals((Object)ReportFrequency.DAILY)) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            return calendar.getTime();
        }
        if (reportFrequency.equals((Object)ReportFrequency.DAILY_PREVIOUS_DAY_REPORT)) {
            calendar.add(5, -1);
        } else if (reportFrequency.equals((Object)ReportFrequency.WEEKLY)) {
            calendar.add(5, -7);
        } else if (reportFrequency.equals((Object)ReportFrequency.MONTHLY)) {
            calendar.add(2, -1);
        }
        WorkingHours workingHours = store.getWorkingHours(calendar.get(7));
        Calendar calendar2 = workingHours.getOpenHour();
        calendar2.set(5, calendar.get(5));
        calendar2.set(2, calendar.get(2));
        calendar2.set(1, calendar.get(1));
        return calendar2.getTime();
    }
}

