/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.StoreAlreadyCloseException;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.ExternalPaymentGatewayPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.StoreUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class StoreCloseJob
extends CronJob {
    public static final String ID = "store-close";

    public StoreCloseJob() {
    }

    public StoreCloseJob(String string) {
        this.setId(ID);
        this.setFrequency("Daily");
        this.setExecutionTime(string);
    }

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        PosWindow posWindow = Application.getPosWindow();
        Store store = DataProvider.get().getStore();
        StoreDAO.getInstance().refresh(store);
        boolean bl = store.getBooleanProperty("do_not_allow_close_store_with.open_tickets", false);
        boolean bl2 = store.getBooleanProperty("do_not_allow_user_clock_out_with.open_tickets", false);
        if ((bl || bl2) && TicketDAO.getInstance().hasOpenTickets()) {
            posWindow.updateStatusBarFooterMessage(Messages.getString("StoreCloseJob.0"));
            return;
        }
        String string = StoreUtil.getAutoOpenCloseStoreBy(store);
        User user = DataProvider.get().getUserById(string);
        this.a(user);
        List<User> list = UserDAO.getInstance().findClockedInUsers();
        Transaction transaction = null;
        try (Session session = GenericDAO.getInstance().createNewSession();){
            transaction = session.beginTransaction();
            for (User list22 : list) {
                UserDAO.getInstance().doForceClockOutUser(session, list22, user);
            }
            StoreSession storeSession = StoreUtil.getCurrentStoreSession();
            List<CashDrawer> list2 = CashDrawerDAO.getInstance().findByStoreOperationData(storeSession, true, session);
            if (list2 != null) {
                for (CashDrawer cashDrawer : list2) {
                    TerminalDAO.getInstance().resetCashDrawer(session, cashDrawer, cashDrawer.getTerminal(), user, 0.0);
                }
            }
            StoreUtil.closeStore(session, user);
            transaction.commit();
            PosLog.info(this.getClass(), "Store is closed successfully");
            OroMqttClient.getInstance().notifyStoreClosed();
            posWindow.updateStatusBarFooterMessage("");
        }
        catch (StoreAlreadyCloseException storeAlreadyCloseException) {
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Runtime error occured in closing store...", exception);
        }
    }

    private void a(User user) {
        Integer n = DataProvider.get().getCurrentTerminal().getId();
        List<String> list = PosTransactionDAO.getInstance().getDistinctCardMmerchantGateway(null, n);
        ArrayList arrayList = new ArrayList();
        list.forEach(string -> {
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGatewayByName(string);
            if (paymentGatewayPlugin != null && paymentGatewayPlugin.getProcessor() != null && !(paymentGatewayPlugin instanceof ExternalPaymentGatewayPlugin) && paymentGatewayPlugin.supportsBatchClose()) {
                arrayList.add(paymentGatewayPlugin);
            }
        });
        if (arrayList.isEmpty()) {
            return;
        }
        for (PaymentGatewayPlugin paymentGatewayPlugin : arrayList) {
            if (paymentGatewayPlugin == null || paymentGatewayPlugin.getProcessor() == null || paymentGatewayPlugin instanceof ExternalPaymentGatewayPlugin || !paymentGatewayPlugin.supportsBatchClose()) continue;
            List<Terminal> list2 = TerminalDAO.getInstance().findAll();
            for (Terminal terminal : list2) {
                try {
                    paymentGatewayPlugin.getProcessor().closeBatch(terminal, user);
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), "Runtime error occured in closing batch...", exception);
                }
            }
        }
    }
}

