/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;

public interface PropertyContainer {
    @JsonIgnore
    public JsonObject getPropertyStore();

    default public boolean hasProperty(String string) {
        JsonObject jsonObject = this.getPropertyStore();
        if (jsonObject == null) {
            return false;
        }
        return jsonObject.has(string);
    }

    default public String getProperty(String string) {
        JsonObject jsonObject = this.getPropertyStore();
        if (jsonObject == null) {
            return null;
        }
        if (jsonObject.has(string)) {
            JsonElement jsonElement = jsonObject.get(string);
            if (jsonElement instanceof JsonNull) {
                return "";
            }
            if (jsonElement.isJsonArray()) {
                String string2 = new Gson().toJson(jsonElement);
                return string2;
            }
            return jsonElement.getAsString();
        }
        return null;
    }

    default public String getProperty(String string, String string2) {
        if (this.getPropertyStore().has(string)) {
            JsonElement jsonElement = this.getPropertyStore().get(string);
            if (jsonElement instanceof JsonNull) {
                return "";
            }
            return jsonElement.getAsString();
        }
        return string2;
    }

    default public Boolean getBooleanProperty(String string, boolean bl) {
        JsonObject jsonObject = this.getPropertyStore();
        if (jsonObject == null) {
            return false;
        }
        JsonElement jsonElement = jsonObject.get(string);
        if (jsonElement == null) {
            return bl;
        }
        return jsonElement.getAsBoolean();
    }

    default public double getDoubleProperty(String string) {
        return PropertyContainer.parseDouble(this.getProperty(string));
    }

    default public int getIntProperty(String string) {
        return (int)PropertyContainer.parseDouble(this.getProperty(string));
    }

    default public void addProperty(String string, String string2) {
        this.getPropertyStore().addProperty(string, string2);
    }

    default public void removeProperty(String string) {
        if (this.getPropertyStore() != null) {
            this.getPropertyStore().remove(string);
        }
    }

    public static double parseDouble(String string) {
        if (StringUtils.isBlank((String)string)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }
}

