/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.IdContainer;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseInventoryStockUnit;
import com.floreantpos.model.base.BasePackagingUnit;
import com.floreantpos.model.base.BaseRecepie;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.RecipeTableDAO;
import com.floreantpos.model.ext.InvMapKey;
import com.floreantpos.model.util.DataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"menuItemName"})
public class Recepie
extends BaseRecepie
implements IdContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    private Double cost;
    private Boolean visible;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private Double cookingYield;

    public Recepie() {
    }

    public Recepie(String string) {
        super(string);
    }

    public Recepie(String string, String string2) {
        super(string, string2);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public void addRecepieItem(RecepieItem recepieItem) {
        List<RecepieItem> list = this.getRecepieItems();
        if (list == null) {
            list = new ArrayList<RecepieItem>(3);
            this.setRecepieItems(list);
        }
        list.add(recepieItem);
    }

    @Override
    public String toString() {
        return super.getName();
    }

    public Double getCost() {
        return this.cost == null ? 0.0 : this.cost;
    }

    public void setCost(Double d) {
        this.cost = d;
    }

    public void calculateCost() {
        double d = 0.0;
        double d2 = 0.0;
        List<RecepieItem> list = this.getRecepieItems();
        if (list != null && list.size() > 0) {
            for (RecepieItem recepieItem : list) {
                recepieItem.calculatePercentage();
                d2 += recepieItem.getCost();
            }
        }
        d = d2 * this.getPortion() / this.getYield();
        this.setCost(d);
    }

    @Override
    public Double getPortion() {
        return super.getPortion() == 0.0 ? 1.0 : super.getPortion();
    }

    @Override
    public Double getYield() {
        return super.getYield() == 0.0 ? 1.0 : super.getYield();
    }

    public void setVisible(Boolean bl) {
        this.visible = bl;
    }

    public Boolean isVisible() {
        return this.visible == null ? false : this.visible;
    }

    public void populateRecipeItemQuantity(Double d, HashMap<InvMapKey, Double> hashMap, double d2) {
        List<RecepieItem> list = this.getRecepieItems();
        if (list == null || list.size() == 0) {
            return;
        }
        for (RecepieItem recepieItem : list) {
            Comparable<Double> comparable;
            Object object;
            Object object2;
            MenuItem menuItem = recepieItem.getInventoryItem();
            String string = recepieItem.getUnitCode();
            if (menuItem == null || !menuItem.isInventoryItem().booleanValue()) continue;
            IUnit iUnit = DataProvider.get().getUnitByCode(string);
            Double d3 = recepieItem.getQuantity();
            if (iUnit != null && iUnit instanceof PackagingUnit && ((BasePackagingUnit)(object2 = (PackagingUnit)iUnit)).isRecipeUnit().booleanValue()) {
                MenuItemDAO.getInstance().initializeUnits(menuItem);
                if (menuItem.getStockUnits() != null && menuItem.getStockUnits().size() > 0) {
                    object = menuItem.getStockUnits().iterator();
                    while (object.hasNext()) {
                        comparable = (InventoryStockUnit)object.next();
                        if (((BaseInventoryStockUnit)comparable).getUnit() == null || !((BasePackagingUnit)object2).getCode().equals(((BaseInventoryStockUnit)comparable).getPackagingUnit().getCode())) continue;
                        string = ((BaseInventoryStockUnit)comparable).getUnit().getCode();
                        d3 = ((BaseInventoryStockUnit)comparable).getUnit().getConversionRate() * ((BaseInventoryStockUnit)comparable).getBaseUnitValue() * d3;
                        break;
                    }
                }
            }
            if ((object = hashMap.get(object2 = new InvMapKey(menuItem.getId(), string))) == null) {
                object = 0.0;
            }
            comparable = (Double)object + d2 * d3 * d;
            hashMap.put((InvMapKey)object2, (Double)comparable);
        }
    }

    public Double getCookingYield() {
        return this.cookingYield == null ? 1.0 : this.cookingYield;
    }

    public void setCookingYield(Double d) {
        this.cookingYield = d;
    }

    @XmlTransient
    public String getMenuItemName() {
        return DataProvider.get().getRecipeMenuItemName(this);
    }

    public void setMenuItemName(String string) {
    }

    public void populateRecipeItems(HashMap<String, RecepieItem> hashMap, double d, Recepie recepie, boolean bl) {
        List<RecepieItem> list = this.getRecepieItems();
        if (list == null || list.size() == 0) {
            return;
        }
        for (RecepieItem recepieItem : list) {
            MenuItem menuItem = recepieItem.getInventoryItem();
            if (menuItem == null) continue;
            String string = menuItem.getId();
            if (!bl) {
                string = recepie.getId() + "-" + string;
            }
            string = string + "-" + recepieItem.getUnitCode();
            RecepieItem recepieItem2 = hashMap.get(string);
            RecipeTable recipeTable = RecipeTableDAO.getInstance().findBy(menuItem.getId());
            if (recipeTable != null) continue;
            if (recepieItem2 == null) {
                recepieItem2 = new RecepieItem();
                recepieItem2.setRecepie(recepie);
                recepieItem2.setInventoryItem(recepieItem.getInventoryItem());
                recepieItem2.setUnit(recepieItem.getUnit());
                recepieItem2.setUnitCode(recepieItem.getUnitCode());
                if (!bl) {
                    hashMap.put(recepie.getId() + "-" + string, recepieItem2);
                } else {
                    hashMap.put(string, recepieItem2);
                }
            }
            recepieItem2.setCost(menuItem.getCost(recepieItem2.getUnitCode()));
            recepieItem2.setGroupName(recepie.getName());
            recepieItem2.setGroupId(recepie.getId());
            Double d2 = recepieItem2.getQuantity() + recepieItem.getQuantity() * d;
            recepieItem2.setQuantity(d2);
        }
    }

    public void populateRecipeSummaryItems(HashMap<String, RecepieItem> hashMap, double d, Recepie recepie, boolean bl) {
        List<RecepieItem> list = this.getRecepieItems();
        if (list == null || list.size() == 0) {
            return;
        }
        for (RecepieItem recepieItem : list) {
            MenuItem menuItem = recepieItem.getInventoryItem();
            if (menuItem == null) continue;
            String string = menuItem.getId();
            RecepieItem recepieItem2 = hashMap.get(string);
            if (recepieItem2 == null) {
                recepieItem2 = new RecepieItem();
                recepieItem2.setRecepie(recepie);
                recepieItem2.setInventoryItem(recepieItem.getInventoryItem());
                recepieItem2.setUnit(menuItem.getUnit());
                recepieItem2.setUnitCode(menuItem.getUnit() == null ? null : menuItem.getUnit().getUniqueCode());
                hashMap.put(string, recepieItem2);
            }
            recepieItem2.setCost(menuItem.getCost(recepieItem2.getUnitCode()));
            recepieItem2.setGroupName(recepie.getName());
            recepieItem2.setGroupId(recepie.getId());
            Double d2 = recepieItem2.getQuantity() + menuItem.getBaseUnitQuantity(recepieItem.getUnitCode()) * recepieItem.getQuantity() * d;
            recepieItem2.setQuantity(d2);
        }
    }

    public int getCookingMin() {
        int n = this.getCookingTime();
        int n2 = n / 3600;
        int n3 = n - n2 * 3600;
        int n4 = n3 / 60;
        return n4;
    }
}

