/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.Messages;
import java.util.Calendar;
import java.util.Date;

public enum ServicePaymentType {
    ANUALLY(Messages.getString("ServicePaymentType.Annually")),
    HALF_YEARLY(Messages.getString("ServicePaymentType.HalfYearly")),
    QUARTERLY(Messages.getString("ServicePaymentType.Quarterly")),
    MONTHLY(Messages.getString("ServicePaymentType.Monthly")),
    ONE_TIME(Messages.getString("ServicePaymentType.OneTime")),
    DAILY(Messages.getString("ServicePaymentType.Daily")),
    WEEKLY(Messages.getString("ServicePaymentType.Weekly"));

    private String displayString;

    private ServicePaymentType(String string2) {
        this.displayString = string2;
    }

    public String toString() {
        return this.displayString;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public void setDisplayString(String string) {
        this.displayString = string;
    }

    public Date calculateEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        switch (this) {
            case ANUALLY: {
                calendar.add(1, 1);
                break;
            }
            case HALF_YEARLY: {
                calendar.add(2, 6);
                break;
            }
            case QUARTERLY: {
                calendar.add(2, 3);
                break;
            }
            case MONTHLY: {
                calendar.add(2, 1);
                break;
            }
            case WEEKLY: {
                calendar.add(5, 7);
                break;
            }
            case DAILY: 
            case ONE_TIME: {
                calendar.add(5, 1);
                break;
            }
        }
        calendar.add(13, -1);
        return calendar.getTime();
    }
}

