/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.Store;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.GlobalIdGenerator;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"typesAsString", "floor", "userName", "image"})
public class ShopTable
extends BaseShopTable
implements PropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_RECTANGLE = 0;
    public static final int TYPE_ROUNDED_RECTANGLE = 1;
    public static final int TYPE_ROUND = 2;
    public static final int TYPE_POLYGON = 3;
    public static final int TYPE_CUSTOM = 4;
    public static final String RESERVATION_NUMBER = "RES_NO";
    private Date ticketCreateTime;
    private boolean showStatus;
    private boolean reArrange;
    private int guestNumber;
    private String typesAsString;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;
    public static final SimpleDateFormat bookingDateFormat = new SimpleDateFormat("yyyy-MMM-dd hh:mm:ss");
    private boolean isTemporary;

    public ShopTable() {
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
    }

    public ShopTable(Integer n) {
        super(n);
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
    }

    public ShopTable(Integer n, String string) {
        super(n, string);
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
    }

    public ShopTable(Integer n, Integer n2) {
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
        this.setX(n);
        this.setY(n2);
    }

    public ShopTable(ShopFloor shopFloor, Integer n, Integer n2, Integer n3) {
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
        this.setCapacity(4);
        this.setId(n3);
        this.setFloorId(shopFloor.getId());
        this.setX(n);
        this.setY(n2);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public TableStatus getTableStatus() {
        return this.getShopTableStatus().getTableStatus();
    }

    public void setTableStatus(TableStatus tableStatus) {
        this.setTableStatusNum(tableStatus.getValue());
    }

    private void setTableStatusNum(int n) {
        ShopTableStatus shopTableStatus = this.getStatus();
        shopTableStatus.setTableStatusNum(n);
    }

    public Integer getTableNumber() {
        return this.getId();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTableNumber());
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setTemporary(boolean bl) {
        this.isTemporary = bl;
    }

    public String getTypesAsString() {
        List<ShopTableType> list = this.getTypes();
        String string = "";
        if (list == null || list.size() == 0) {
            return "";
        }
        boolean bl = false;
        for (ShopTableType shopTableType : list) {
            if (bl) {
                string = string + ", ";
            }
            string = string + shopTableType.getName();
            bl = true;
        }
        return string;
    }

    public String getTicketId() {
        ShopTableStatus shopTableStatus = this.getStatus();
        if (shopTableStatus == null) {
            return null;
        }
        List<String> list = shopTableStatus.getListOfTicketNumbers();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public String getUserId() {
        ShopTableStatus shopTableStatus = this.getStatus();
        if (shopTableStatus == null) {
            return null;
        }
        return shopTableStatus.getUserId();
    }

    public String getUserName() {
        ShopTableStatus shopTableStatus = this.getStatus();
        if (shopTableStatus == null) {
            return null;
        }
        return shopTableStatus.getUserName();
    }

    public String getTicketShortId() {
        ShopTableStatus shopTableStatus = this.getStatus();
        if (shopTableStatus == null) {
            return null;
        }
        return shopTableStatus.getTokenNo();
    }

    @Override
    public ShopTableStatus getShopTableStatus() {
        ShopTableStatus shopTableStatus = super.getShopTableStatus();
        if (shopTableStatus != null) {
            return shopTableStatus;
        }
        shopTableStatus = new ShopTableStatus();
        Integer n = this.getId();
        shopTableStatus.setId(n);
        shopTableStatus.setTableStatus(TableStatus.Available);
        return shopTableStatus;
    }

    @Deprecated
    public ShopTableStatus getStatus() {
        return this.getShopTableStatus();
    }

    public Date getTicketCreateTime() {
        return this.ticketCreateTime;
    }

    public void setTicketCreateTime(Date date) {
        this.ticketCreateTime = date;
    }

    public boolean isShowStatus() {
        return this.showStatus;
    }

    public void setShowStatus(boolean bl) {
        this.showStatus = bl;
    }

    public boolean isReArrange() {
        return this.reArrange;
    }

    public void setReArrange(boolean bl) {
        this.reArrange = bl;
    }

    public int getGuestNumber() {
        return this.guestNumber;
    }

    public void setGuestNumber(int n) {
        this.guestNumber = n;
    }

    @XmlTransient
    public ShopFloor getFloor() {
        if (StringUtils.isNotEmpty((String)this.getFloorId())) {
            return ShopFloorDAO.getInstance().get(this.getFloorId());
        }
        return null;
    }

    public void setFloor(ShopFloor shopFloor) {
        String string = null;
        if (shopFloor != null) {
            string = shopFloor.getId();
        }
        super.setFloorId(string);
    }

    @XmlTransient
    public SalesArea getSalesArea() {
        if (StringUtils.isNotEmpty((String)this.getSalesAreaId())) {
            return SalesAreaDAO.getInstance().get(this.getSalesAreaId());
        }
        return null;
    }

    public void setSalesArea(SalesArea salesArea) {
        String string = null;
        if (salesArea != null) {
            string = salesArea.getId();
        }
        super.setSalesAreaId(string);
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void setTypesAsString(String string) {
        this.typesAsString = string;
    }

    public double getAngle() {
        String string = this.getProperty("angle");
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                return Double.parseDouble(string);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
        return 0.0;
    }

    public void setAngle(double d) {
        this.addProperty("angle", String.valueOf(d));
    }

    public void setImageResource(ImageResource imageResource) {
        this.addProperty("image", imageResource.getId());
    }

    public ImageIcon getImage() {
        if (this.propertiesContainer == null) {
            return null;
        }
        String string = this.getProperty("image");
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        ImageResource imageResource = DataProvider.get().getImageResource(string);
        if (imageResource != null) {
            ImageIcon imageIcon = imageResource.getImageIcon();
            return imageIcon;
        }
        return null;
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    public void removeImage() {
        this.removeProperty("image");
    }

    @Override
    public Integer getWidth() {
        ImageIcon imageIcon = this.getImage();
        if (imageIcon == null) {
            return super.getWidth();
        }
        return imageIcon.getIconWidth();
    }

    @Override
    public Integer getHeight() {
        ImageIcon imageIcon = this.getImage();
        if (imageIcon == null) {
            return super.getHeight();
        }
        return imageIcon.getIconHeight();
    }

    public String getNameOrNumber() {
        Store store = DataProvider.get().getStore();
        String string = this.getName();
        return store.isShowTableNameOnTable() && StringUtils.isNotBlank((String)string) ? string : this.getTableNumber().toString();
    }
}

