/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseAttendenceHistory;
import com.floreantpos.model.base.BaseUser;
import com.floreantpos.model.dao.BaseAttendenceHistoryDAO;
import com.floreantpos.model.dao.DeclaredTipsDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.AttendanceReportData;
import com.floreantpos.report.PayrollReportData;
import com.floreantpos.report.WeeklyPayrollReportData;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.AggregateProjection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.PropertyProjection;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class AttendenceHistoryDAO
extends BaseAttendenceHistoryDAO {
    private static final SimpleDateFormat keyDateFormat = new SimpleDateFormat("dd_MM_yyyy");
    private Map<String, User> userMap = new HashMap<String, User>();

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Deprecated
    public List<String> getClockedInUserIds() {
        try (Session session = this.createNewSession();){
            List<String> list = this.getClockedInUserIds(session);
            return list;
        }
    }

    @Deprecated
    public List<String> getClockedInUserIds(Session session) {
        Criteria criteria = session.createCriteria(AttendenceHistory.class, "ah");
        this.addDeletedFilter(criteria);
        AggregateProjection aggregateProjection = Projections.max((String)AttendenceHistory.PROP_CLOCK_IN_TIME);
        PropertyProjection propertyProjection = Projections.groupProperty((String)AttendenceHistory.PROP_USER_ID);
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(AttendenceHistory.class, (String)"th");
        detachedCriteria.add((Criterion)Property.forName((String)("ah." + AttendenceHistory.PROP_USER_ID)).eqProperty("th." + AttendenceHistory.PROP_USER_ID));
        detachedCriteria.setProjection((Projection)aggregateProjection);
        criteria.add(Property.forName((String)("ah." + AttendenceHistory.PROP_CLOCK_IN_TIME)).eq(detachedCriteria));
        criteria.add(Restrictions.isNull((String)AttendenceHistory.PROP_CLOCK_OUT_TIME));
        criteria.setProjection((Projection)propertyProjection);
        List list = criteria.list();
        return list;
    }

    public Set<User> findNumberOfClockedInUserAtHour(Date date, Date date2, int n, Terminal terminal) {
        HashSet<User> hashSet = new HashSet<User>();
        Session session = null;
        List<Date> list = POSUtil.getDaysBetweenDates(date, date2);
        try {
            if (list != null) {
                for (Date date3 : list) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date3);
                    calendar.set(11, n);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    Date date4 = calendar.getTime();
                    calendar.add(11, 1);
                    Date date5 = calendar.getTime();
                    session = this.getSession();
                    Criteria criteria = session.createCriteria(this.getReferenceClass());
                    this.buildAttendenceCriteria(date4, date5, criteria);
                    if (terminal != null) {
                        criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_TERMINAL_ID, (Object)terminal.getId()));
                    }
                    List list2 = criteria.list();
                    for (Object e : list2) {
                        AttendenceHistory attendenceHistory = (AttendenceHistory)e;
                        hashSet.add(attendenceHistory.getUser());
                    }
                }
            }
            HashSet<User> hashSet2 = hashSet;
            return hashSet2;
        }
        catch (Exception exception) {
            throw new PosException(Messages.getString("AttendenceHistoryDAO.2"), exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    @Deprecated
    public List<User> findNumberOfClockedInUserAtShift(Date date, Date date2, Shift shift, Terminal terminal) {
        Session session = null;
        ArrayList<User> arrayList = new ArrayList<User>();
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date2));
            if (shift != null) {
                criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_SHIFT_ID, (Object)shift.getId()));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            for (Object e : list) {
                AttendenceHistory attendenceHistory = (AttendenceHistory)e;
                arrayList.add(attendenceHistory.getUser());
            }
            ArrayList<User> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            throw new PosException(Messages.getString("AttendenceHistoryDAO.5"), exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public AttendenceHistory findByLastClockInTime(User user) {
        try (Session session = this.createNewSession();){
            AttendenceHistory attendenceHistory = this.findByLastClockInTime(user, session);
            return attendenceHistory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public AttendenceHistory findHistoryByClockedInTime(User user) {
        Session session = null;
        try {
            session = this.createNewSession();
            AttendenceHistory attendenceHistory = this.findHistoryByClockedInTime(user, session);
            return attendenceHistory;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public AttendenceHistory findByLastClockInTime(User user, Session session) {
        Criteria criteria = session.createCriteria(AttendenceHistory.class);
        if (user != null) {
            criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
        }
        criteria.addOrder(Order.desc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
        criteria.setFirstResult(0);
        criteria.setMaxResults(1);
        List list = criteria.list();
        if (list.size() > 0) {
            return (AttendenceHistory)list.get(0);
        }
        return null;
    }

    @Deprecated
    public AttendenceHistory findHistoryByClockedInTime(User user, Session session) {
        Criteria criteria = session.createCriteria(AttendenceHistory.class);
        if (user != null) {
            criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
        }
        criteria.add(Restrictions.isNull((String)AttendenceHistory.PROP_CLOCK_OUT_TIME));
        criteria.addOrder(Order.desc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
        criteria.setFirstResult(0);
        criteria.setMaxResults(1);
        List list = criteria.list();
        if (list.size() > 0) {
            return (AttendenceHistory)list.get(0);
        }
        return null;
    }

    public List<PayrollReportData> findPayroll(Date date, Date date2, User user) {
        this.userMap.clear();
        ArrayList<PayrollReportData> arrayList = new ArrayList<PayrollReportData>();
        HashMap<String, List<AttendenceHistory>> hashMap = new HashMap<String, List<AttendenceHistory>>();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)date2));
            if (user != null) {
                criteria.add(Restrictions.in((String)AttendenceHistory.PROP_USER_ID, user.getRoleIds()));
            }
            this.populateReportDataListMap(hashMap, criteria.list());
            for (List list : hashMap.values()) {
                if (list == null || list.isEmpty()) continue;
                this.populateReportDataList(arrayList, list);
            }
            ArrayList<PayrollReportData> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private void populateReportDataListMap(Map<String, List<AttendenceHistory>> map, List list) {
        for (AttendenceHistory attendenceHistory : list) {
            String string = keyDateFormat.format(attendenceHistory.getClockInTime()) + "_" + attendenceHistory.getUser().getId();
            List<AttendenceHistory> list2 = map.get(string);
            if (list2 == null || list2.isEmpty()) {
                list2 = new ArrayList<AttendenceHistory>();
            }
            list2.add(attendenceHistory);
            map.put(string, list2);
        }
        this.calculateWorkHourMap(map);
    }

    private void calculateWorkHourMap(Map<String, List<AttendenceHistory>> map) {
        Object object;
        for (List<AttendenceHistory> object22 : map.values()) {
            object = Comparator.comparing(BaseAttendenceHistory::getClockInTime, Comparator.nullsLast(Comparator.naturalOrder()));
            object22.sort((Comparator<AttendenceHistory>)object);
        }
        Set<String> set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            long l = 0L;
            long l2 = 0L;
            List<AttendenceHistory> list = map.get(object);
            ListIterator<AttendenceHistory> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                boolean bl = listIterator.hasPrevious();
                int n = listIterator.previousIndex();
                AttendenceHistory attendenceHistory = listIterator.next();
                long l3 = attendenceHistory.getClockOutTime().getTime() - attendenceHistory.getClockInTime().getTime();
                if (bl) {
                    AttendenceHistory attendenceHistory2 = list.get(n);
                    long l4 = attendenceHistory2.getClockOutTime().getTime() - attendenceHistory2.getClockInTime().getTime();
                    attendenceHistory.setPreviousTotalWorkHourMs(l2 += l4);
                    l = l2 + l3;
                } else {
                    l += l3;
                }
                attendenceHistory.setDailyTotalWorkHourMs(l);
            }
        }
    }

    private void populateReportDataList(ArrayList<PayrollReportData> arrayList, List list) {
        for (AttendenceHistory attendenceHistory : list) {
            PayrollReportData payrollReportData = new PayrollReportData();
            payrollReportData.setClockIn(attendenceHistory.getClockInTime());
            payrollReportData.setClockOut(attendenceHistory.getClockOutTime());
            payrollReportData.setDate(attendenceHistory.getClockInTime());
            User user = this.getUserFromHistory(attendenceHistory);
            payrollReportData.setUser(user);
            payrollReportData.setUserIdSortKey(StringUtils.isBlank((String)user.getParentUserId()) ? user.getId() : user.getParentUserId());
            payrollReportData.setDailyTotalWorkHourMs(attendenceHistory.getDailyTotalWorkHourMs());
            payrollReportData.setPreviousTotalWorkHourMs(attendenceHistory.getPreviousTotalWorkHourMs());
            payrollReportData.calculate();
            arrayList.add(payrollReportData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WeeklyPayrollReportData> findWeeklyPayroll(Date date, Date date2, User user, int n) {
        List<Object> list;
        this.userMap.clear();
        Session session = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<Date[]> arrayList2 = new ArrayList<Date[]>();
        List<User> list2 = UserDAO.getInstance().findAll();
        if (user != null) {
            list2.clear();
            list2.add(user);
            list = user.getLinkedUser();
            for (User comparable : list) {
                if (comparable.getId().equals(user.getId())) continue;
                list2.add(comparable);
            }
        }
        list = POSUtil.getStringIds(list2, User.class);
        try {
            HashMap<String, List<AttendenceHistory>> hashMap;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            Date[] dateArray = new Date[2];
            dateArray[0] = date;
            while (!date.after(date2)) {
                int arrayList4 = calendar.get(7);
                int dateArray2 = arrayList4 - (n - 1);
                calendar.add(5, 1);
                if (dateArray2 != 0 && dateArray2 != 7 && !calendar.getTime().after(date2)) continue;
                calendar.add(5, -1);
                hashMap = calendar.getTime();
                dateArray[1] = hashMap;
                arrayList2.add(dateArray);
                dateArray = new Date[2];
                calendar.add(5, 1);
                dateArray[0] = date = calendar.getTime();
            }
            for (Date[] dateArray2 : arrayList2) {
                hashMap = new HashMap();
                criteria = session.createCriteria(AttendenceHistory.class);
                Date date3 = DateUtil.startOfDay(dateArray2[0]);
                Date date4 = DateUtil.endOfDay(dateArray2[1]);
                criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date3));
                criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date4));
                criteria.add(Restrictions.isNotNull((String)AttendenceHistory.PROP_CLOCK_OUT_TIME));
                if (!list.isEmpty()) {
                    criteria.add(Restrictions.in((String)AttendenceHistory.PROP_USER_ID, list));
                }
                List list3 = criteria.list();
                this.populateReportDataListMap(hashMap, list3);
                ArrayList arrayList3 = new ArrayList();
                for (List list4 : hashMap.values()) {
                    if (list4 == null || list4.isEmpty()) continue;
                    arrayList3.addAll(list4);
                }
                List<WeeklyPayrollReportData> list5 = this.populateWeeklyPayrollReportDataList(arrayList3, date3, date4, n, list2, list);
                arrayList.addAll(list5);
            }
            ArrayList arrayList4 = arrayList;
            return arrayList4;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private List<WeeklyPayrollReportData> populateWeeklyPayrollReportDataList(List list, Date date, Date date2, int n, List<User> list2, List<String> list3) {
        WeeklyPayrollReportData weeklyPayrollReportData2;
        Object object;
        HashMap<String, WeeklyPayrollReportData> hashMap = new HashMap<String, WeeklyPayrollReportData>();
        for (AttendenceHistory object22 : list) {
            object = this.getUserFromHistory(object22);
            if (object == null) continue;
            weeklyPayrollReportData2 = (WeeklyPayrollReportData)hashMap.get(((BaseUser)object).getId());
            if (weeklyPayrollReportData2 == null) {
                weeklyPayrollReportData2 = new WeeklyPayrollReportData();
                weeklyPayrollReportData2.setFirstDayOfWeek(n);
                hashMap.put(((BaseUser)object).getId(), weeklyPayrollReportData2);
            }
            double d = ((User)object).getCostPerHourRate();
            double d2 = ((User)object).getOvertimePerHourRate();
            long l = object22.getClockOutTime().getTime() - object22.getClockInTime().getTime();
            long l2 = (long)((double)((User)object).getRegularWorkHourWeekly() * 3600000.0);
            long l3 = weeklyPayrollReportData2.getTotalWorkHourMs() + l;
            long l4 = l3 > l2 ? l2 : l3;
            long l5 = l3 > l2 ? l3 - l2 : 0L;
            weeklyPayrollReportData2.setTotalWorkHourMs(l3);
            weeklyPayrollReportData2.setRegularWorkHourMs(l4);
            weeklyPayrollReportData2.setOvertimeMs(l5);
            double d3 = NumberUtil.round((double)weeklyPayrollReportData2.getRegularWorkHourMs() / 3600000.0 * d);
            weeklyPayrollReportData2.setRegularPayment(d3);
            double d4 = NumberUtil.round((double)weeklyPayrollReportData2.getOvertimeMs() / 3600000.0 * d2);
            weeklyPayrollReportData2.setOvertimePayment(d4);
            weeklyPayrollReportData2.setFromDateOfWeek(date);
            weeklyPayrollReportData2.setToDateOfWeek(date2);
            weeklyPayrollReportData2.setUser((User)object);
        }
        for (User user : list2) {
            object = (WeeklyPayrollReportData)hashMap.get(user.getId());
            if (object != null) continue;
            weeklyPayrollReportData2 = new WeeklyPayrollReportData();
            weeklyPayrollReportData2.setFirstDayOfWeek(n);
            weeklyPayrollReportData2.setTotalWorkHourMs(0L);
            weeklyPayrollReportData2.setFromDateOfWeek(date);
            weeklyPayrollReportData2.setToDateOfWeek(date2);
            weeklyPayrollReportData2.setUser(user);
            hashMap.put(user.getId(), weeklyPayrollReportData2);
        }
        Map<String, Double> map = this.doFindDeclaredTips(date, date2, hashMap);
        Collection collection = hashMap.values();
        for (WeeklyPayrollReportData weeklyPayrollReportData2 : collection) {
            weeklyPayrollReportData2.calculate();
            User user = weeklyPayrollReportData2.getUser();
            weeklyPayrollReportData2.setUserIdSortKey(StringUtils.isBlank((String)user.getParentUserId()) ? user.getId() : user.getParentUserId());
            Double d = (Double)map.get(user.getId());
            weeklyPayrollReportData2.setTotalDeclaredTips(d == null ? 0.0 : d);
            weeklyPayrollReportData2.setTotalNoCashTips(PosTransactionDAO.getInstance().calculateTipsByUser(date, date2, user, null));
        }
        return new ArrayList<WeeklyPayrollReportData>(collection);
    }

    private User getUserFromHistory(AttendenceHistory attendenceHistory) {
        String string = attendenceHistory.getUserId();
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        User user = this.userMap.get(string);
        if (user != null) {
            return user;
        }
        user = UserDAO.getInstance().get(string);
        this.userMap.put(string, user);
        return user;
    }

    private Map<String, Double> doFindDeclaredTips(Date date, Date date2, Map<String, WeeklyPayrollReportData> map) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        try (Session session = DeclaredTipsDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(DeclaredTips.class);
            criteria.add((Criterion)Restrictions.ge((String)DeclaredTips.PROP_DECLARED_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)DeclaredTips.PROP_DECLARED_TIME, (Object)date2));
            if (!map.keySet().isEmpty()) {
                criteria.add(Restrictions.in((String)DeclaredTips.PROP_OWNER_ID, map.keySet()));
            }
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.sum((String)DeclaredTips.PROP_AMOUNT), DeclaredTips.PROP_AMOUNT);
            projectionList.add((Projection)Projections.groupProperty((String)DeclaredTips.PROP_OWNER_ID), DeclaredTips.PROP_OWNER_ID);
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(DeclaredTips.class));
            List list = criteria.list();
            for (DeclaredTips declaredTips : list) {
                hashMap.put(declaredTips.getOwnerId(), declaredTips.getAmount());
            }
        }
        return hashMap;
    }

    public List<AttendanceReportData> findAttendance(Date date, Date date2, User user) {
        ArrayList<AttendanceReportData> arrayList = new ArrayList<AttendanceReportData>();
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add(Restrictions.between((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date, (Object)date2));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER_ID));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
            AttendenceHistoryDAO.addUserWithAllRoleCriteria(criteria, user, AttendenceHistory.PROP_USER_ID);
            List list = criteria.list();
            for (AttendenceHistory attendenceHistory : list) {
                AttendanceReportData attendanceReportData = new AttendanceReportData();
                attendanceReportData.setClockIn(attendenceHistory.getClockInTime());
                attendanceReportData.setClockOut(attendenceHistory.getClockOutTime());
                attendanceReportData.setUser(attendenceHistory.getUser());
                attendanceReportData.setName(attendenceHistory.getUser().getFirstName());
                attendanceReportData.calculate();
                arrayList.add(attendanceReportData);
            }
            ArrayList<AttendanceReportData> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public List<AttendenceHistory> findHistory(Date date, Date date2, User user) {
        try (Session session = null;){
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add(Restrictions.between((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date, (Object)date2));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER_ID));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
            AttendenceHistoryDAO.addUserWithAllRoleCriteria(criteria, user, AttendenceHistory.PROP_USER_ID);
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public List<AttendenceHistory> findAttendanceHistory(Date date, Date date2, User user) {
        try (Session session = null;){
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)date2));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_ID));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
            }
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public void saveOrUpdateAttendenceHistoryList(List<AttendenceHistory> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (AttendenceHistory attendenceHistory : list) {
                AttendenceHistory attendenceHistory2 = this.get(attendenceHistory.getId());
                if (attendenceHistory2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(attendenceHistory.getLastUpdateTime(), attendenceHistory2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), attendenceHistory.getId() + " already updated");
                        continue;
                    }
                    long l = attendenceHistory2.getVersion();
                    PropertyUtils.copyProperties((Object)attendenceHistory2, (Object)attendenceHistory);
                    attendenceHistory2.setVersion(l);
                    attendenceHistory2.setUpdateLastUpdateTime(bl);
                    attendenceHistory2.setUpdateSyncTime(bl2);
                    this.update(attendenceHistory2, session);
                    continue;
                }
                attendenceHistory.setUpdateLastUpdateTime(bl);
                attendenceHistory.setUpdateSyncTime(bl2);
                this.save(attendenceHistory, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public static AttendenceHistory createNewHistory(User user, Terminal terminal, Shift shift) {
        AttendenceHistory attendenceHistory = new AttendenceHistory();
        Date date = user.getLastClockInTime();
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        attendenceHistory.setClockInTime(date);
        attendenceHistory.setClockInHour((short)calendar.get(10));
        attendenceHistory.setUser(user);
        attendenceHistory.setTerminal(terminal);
        attendenceHistory.setShift(shift);
        attendenceHistory.setOutletId(DataProvider.get().getCurrentOutletId());
        return attendenceHistory;
    }

    public List<AttendenceHistory> findAttendenceReport(Date date, Date date2) {
        return this.findAttendenceReport(date, date2, null, false);
    }

    public List<AttendenceHistory> findAttendenceReport(Date date, Date date2, User user, boolean bl) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.buildAttendenceCriteria(date, date2, criteria);
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
            }
            if (bl) {
                criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER_ID));
            }
            List list = criteria.list();
            return list;
        }
        catch (Exception exception) {
            throw new PosException(Messages.getString("AttendenceHistoryDAO.2"), exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private void buildAttendenceCriteria(Date date, Date date2, Criteria criteria) {
        Criterion criterion = Restrictions.isNotNull((String)AttendenceHistory.PROP_CLOCK_OUT_TIME);
        LogicalExpression logicalExpression = Restrictions.and((Criterion)criterion, (Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)date));
        LogicalExpression logicalExpression2 = Restrictions.and((Criterion)criterion, (Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)date2));
        LogicalExpression logicalExpression3 = Restrictions.and((Criterion)criterion, (Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)date2));
        LogicalExpression logicalExpression4 = Restrictions.and((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date), (Criterion)logicalExpression);
        LogicalExpression logicalExpression5 = Restrictions.and((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date2), (Criterion)logicalExpression2);
        LogicalExpression logicalExpression6 = Restrictions.and((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date), (Criterion)logicalExpression3);
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{logicalExpression4, logicalExpression5, logicalExpression6}));
    }
}

