/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Course;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.BaseCourseDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public class CourseDAO
extends BaseCourseDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        Course course = (Course)object;
        if (course == null) {
            throw new PosException(Messages.getString("CourseDAO.0"));
        }
        this.checkForeignRelation(course);
        course.setDeleted(Boolean.TRUE);
        this.update(course, session);
    }

    private void checkForeignRelation(Course course) throws PosException {
        try (Session session = this.createNewSession();){
            List<String> list = GenericDAO.getInstance().getForeignDataListNames(session, MenuItem.class, MenuItem.PROP_COURSE_ID, course.getId());
            if (list != null && list.size() > 0) {
                String string = Messages.getString("CourseDAO.1") + (list.size() > 1 ? Messages.getString("CourseDAO.2") : ":");
                int n = 1;
                for (String string2 : list) {
                    string = string + "\n" + n + ". " + string2;
                    ++n;
                }
                throw new PosException(Messages.getString("CourseDAO.6"), string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Course> findAll() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)Course.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateCourseList(List<Course> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Course course : list) {
                Course course2 = this.get(course.getId());
                if (course2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(course.getLastUpdateTime(), course2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), course.getName() + " already updated");
                        continue;
                    }
                    PropertyUtils.copyProperties((Object)course2, (Object)course);
                    course2.setUpdateLastUpdateTime(bl);
                    course2.setUpdateSyncTime(bl2);
                    this.update(course2, session);
                    continue;
                }
                course.setUpdateLastUpdateTime(bl);
                course.setUpdateSyncTime(bl2);
                this.save(course, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

