/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.DataSyncInfo;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.webservice.SyncService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;

public class GenericDAO
extends _RootDAO {
    private static final GenericDAO instance = new GenericDAO();

    public static GenericDAO getInstance() {
        return instance;
    }

    @Override
    protected Class getReferenceClass() {
        return null;
    }

    @Override
    public Serializable save(Object object) {
        return super.save(object);
    }

    @Override
    public void saveOrUpdate(Object object) {
        super.saveOrUpdate(object);
    }

    @Override
    public Serializable save(Object object, Session session) {
        return super.save(object, session);
    }

    @Override
    public void saveOrUpdate(Object object, Session session) {
        super.saveOrUpdate(object, session);
    }

    @Override
    public Session getSession(String string, boolean bl) {
        return super.getSession(string, bl);
    }

    public List findAll(Class clazz, Session session) {
        Criteria criteria = session.createCriteria(clazz);
        return criteria.list();
    }

    public void saveAll(List list, Session session) {
        Transaction transaction = session.beginTransaction();
        for (Object e : list) {
            session.saveOrUpdate(e);
        }
        transaction.commit();
    }

    @Override
    public void closeSession(Session session) {
        try {
            super.closeSession(session);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List findAllUnSyncItem(Class clazz) {
        return this.findAllUnSyncItem(clazz, false, null);
    }

    public List findAllUnSyncItem(Class<?> clazz, boolean bl, Date date) {
        return this.getAllUnSyncItems(clazz, bl, date, 0);
    }

    public List findAllUnSyncItem(Class<?> clazz, boolean bl, Date date, int n) {
        return this.getAllUnSyncItems(clazz, bl, date, n);
    }

    public List getUnSyncMenuItems(boolean bl, Date date) {
        return this.getUnSyncMenuItems(bl, date, 0);
    }

    public List getUnSyncMenuItems(boolean bl, Date date, int n) {
        try (Session session = this.createNewSession();){
            List list = this.getAllUnSyncItems(MenuItem.class, bl, date, session, n);
            HashSet<MenuItem> hashSet = new HashSet<MenuItem>();
            for (MenuItem menuItem : list) {
                MenuItemDAO.getInstance().initialize(menuItem, session);
                hashSet.add(menuItem);
                if (menuItem.getVariants() == null || menuItem.getVariants().isEmpty()) continue;
                for (MenuItem menuItem2 : menuItem.getVariants()) {
                    MenuItemDAO.getInstance().initialize(menuItem2);
                    hashSet.add(menuItem2);
                }
            }
            ArrayList arrayList = new ArrayList(hashSet);
            return arrayList;
        }
    }

    private List getAllUnSyncItems(Class<?> clazz, boolean bl, Date date, int n) {
        try (Session session = this.createNewSession();){
            List list = this.getAllUnSyncItems(clazz, bl, date, session, n);
            return list;
        }
    }

    private List getAllUnSyncItems(Class<?> clazz, boolean bl, Date date, Session session, int n) {
        Criteria criteria = session.createCriteria(clazz);
        this.createCriteriaToSearchUnSyncedItems(bl, date, criteria);
        if (n > 0) {
            criteria.setMaxResults(n);
        }
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    private void createCriteriaToSearchUnSyncedItems(boolean bl, Date date, Criteria criteria) {
        Criterion criterion;
        Criterion criterion2;
        if (!bl) {
            criterion2 = Restrictions.isNull((String)InventoryStock.PROP_LAST_UPDATE_TIME);
            criterion = Restrictions.isNull((String)InventoryStock.PROP_LAST_SYNC_TIME);
            PropertyExpression propertyExpression = Restrictions.gtProperty((String)InventoryStock.PROP_LAST_UPDATE_TIME, (String)InventoryStock.PROP_LAST_SYNC_TIME);
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{criterion2, criterion, propertyExpression}));
        }
        if (bl && date != null) {
            criterion2 = Restrictions.isNull((String)InventoryStock.PROP_LAST_SYNC_TIME);
            criterion = Restrictions.lt((String)InventoryStock.PROP_LAST_SYNC_TIME, (Object)date);
            criteria.add((Criterion)Restrictions.or((Criterion)criterion2, (Criterion)criterion));
        }
    }

    public int getUnSyncItemCount(Class<?> clazz, boolean bl, Date date) {
        try (Session session = this.createNewSession();){
            int n = this.getUnSyncItemCount(clazz, bl, date, session);
            return n;
        }
    }

    private int getUnSyncItemCount(Class<?> clazz, boolean bl, Date date, Session session) {
        Criteria criteria = session.createCriteria(clazz);
        this.createCriteriaToSearchUnSyncedItems(bl, date, criteria);
        int n = this.rowCount(criteria);
        return n;
    }

    public int getUnSyncPosTransactionItemCount(boolean bl, Date date) {
        try (Session session = this.createNewSession();){
            int n;
            Criteria criteria = session.createCriteria(PosTransaction.class);
            this.createCriteriaToSearchUnSyncedItems(bl, date, criteria);
            criteria.add(Restrictions.isNull((String)PosTransaction.PROP_TICKET));
            int n2 = n = this.rowCount(criteria);
            return n2;
        }
    }

    public List findAllUnSyncPosTransactions(boolean bl, Date date, int n) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(PosTransaction.class);
            this.createCriteriaToSearchUnSyncedItems(bl, date, criteria);
            criteria.add(Restrictions.isNull((String)PosTransaction.PROP_TICKET));
            if (n > 0) {
                criteria.setMaxResults(n);
            }
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list = criteria.list();
            return list;
        }
    }

    public void updateItemsLastSyncTime(List<String> list, String string) {
        this.updateItemsLastSyncTime(null, list, string);
    }

    public void updateItemsLastSyncTime(Date date, List<String> list, String string) {
        Object object;
        if (list == null || list.isEmpty()) {
            return;
        }
        if (date == null) {
            date = new Date();
        }
        String string2 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            object = transaction.next();
            string2 = string2 + "'" + (String)object + "'";
            if (!transaction.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        transaction = null;
        try {
            object = this.createNewSession();
            Throwable throwable = null;
            try {
                transaction = object.beginTransaction();
                String string3 = "update " + string + " set %s=:lastSyncTime where %s in %s";
                string3 = String.format(string3, InventoryStock.PROP_LAST_SYNC_TIME, InventoryStock.PROP_ID, string2);
                Query query = object.createQuery(string3);
                query.setParameter("lastSyncTime", (Object)date);
                query.executeUpdate();
                transaction.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        object = Calendar.getInstance();
        ((Calendar)object).setTime(date);
        ((Calendar)object).add(13, -1);
        this.updateLastUpdateTimeIfNull(string, ((Calendar)object).getTime());
    }

    public void updateTicketsLastSyncTime(Date date, List<String> list) {
        Object object;
        if (list == null || list.isEmpty()) {
            return;
        }
        if (date == null) {
            date = new Date();
        }
        String string = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            object = transaction.next();
            string = string + "'" + (String)object + "'";
            if (!transaction.hasNext()) continue;
            string = string + ",";
        }
        string = string + ")";
        transaction = null;
        try {
            object = this.createNewSession();
            Throwable throwable = null;
            try {
                transaction = object.beginTransaction();
                String string2 = "update " + Ticket.REF + " set %s=:lastSyncTime,%s=:cloudSynced where %s in %s";
                string2 = String.format(string2, Ticket.PROP_LAST_SYNC_TIME, Ticket.PROP_CLOUD_SYNCED, InventoryStock.PROP_ID, string);
                Query query = object.createQuery(string2);
                query.setParameter("lastSyncTime", (Object)date);
                query.setParameter("cloudSynced", (Object)Boolean.TRUE);
                query.executeUpdate();
                transaction.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        object = Calendar.getInstance();
        ((Calendar)object).setTime(date);
        ((Calendar)object).add(13, -1);
        this.updateLastUpdateTimeIfNull(Ticket.REF, ((Calendar)object).getTime());
    }

    public void updateItemsLastSyncTimeByInt(Date date, List<Integer> list, String string) {
        Object object;
        if (list == null || list.isEmpty()) {
            return;
        }
        if (date == null) {
            date = new Date();
        }
        String string2 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            int n = transaction.next();
            string2 = string2 + n;
            if (!transaction.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        transaction = null;
        try {
            object = this.createNewSession();
            Throwable throwable = null;
            try {
                transaction = object.beginTransaction();
                String string3 = "update " + string + " set %s=:lastSyncTime where %s in" + string2;
                string3 = String.format(string3, InventoryStock.PROP_LAST_SYNC_TIME, InventoryStock.PROP_ID);
                Query query = object.createQuery(string3);
                query.setParameter("lastSyncTime", (Object)date);
                query.executeUpdate();
                transaction.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        object = Calendar.getInstance();
        ((Calendar)object).setTime(date);
        ((Calendar)object).add(13, -1);
        this.updateLastUpdateTimeIfNull(string, ((Calendar)object).getTime());
    }

    public void updateLastUpdateTimeIfNull(String string) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, calendar.get(14));
        this.updateLastUpdateTimeIfNull(string, calendar.getTime());
    }

    public void updateLastUpdateTimeIfNull(String string, Date date) {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            String string2 = "update " + string + " set %s=:lastUpdateTime where %s is null";
            string2 = String.format(string2, Terminal.PROP_LAST_UPDATE_TIME, Terminal.PROP_LAST_UPDATE_TIME);
            Query query = session.createQuery(string2);
            query.setParameter("lastUpdateTime", (Object)date);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            PosLog.error(this.getClass(), Messages.getString("GenericDAO.19"));
        }
    }

    public void changeCurrentOutletAndRelatedModels(List<String> list, Outlet outlet) throws Exception {
        if (outlet == null) {
            return;
        }
        String string = outlet.getId();
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            OutletDAO.getInstance().saveOrUpdateOutlet(outlet, string, true, false, true, session);
            Outlet outlet2 = OutletDAO.getInstance().get(DataProvider.get().getCurrentOutletId());
            outlet2.setDeleted(true);
            OutletDAO.getInstance().update(outlet2, session);
            String string2 = "update " + Store.REF + " set %s=:outletId";
            string2 = String.format(string2, Store.PROP_DEFAULT_OUTLET_ID);
            Query query = session.createQuery(string2);
            query.setParameter("outletId", (Object)string);
            query.executeUpdate();
            for (String string3 : list) {
                String string4 = "update " + string3 + " set %s=:outletId";
                string4 = String.format(string4, "outletId");
                Query query2 = session.createQuery(string4);
                query2.setParameter("outletId", (Object)string);
                query2.executeUpdate();
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateOutletRelatedModelsIfNullExists(List<String> list) throws Exception {
        String string = DataProvider.get().getCurrentOutletId();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (String string2 : list) {
                String string3 = "update " + string2 + " set %s=:outletId where %s is null";
                string3 = String.format(string3, "outletId", "outletId");
                Query query = session.createQuery(string3);
                query.setParameter("outletId", (Object)string);
                query.executeUpdate();
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    public void checkIdOrNameExists(String string, String string2, Class clazz) {
        try (Session session = this.createNewSession();){
            this.checkIdOrNameExists(string, string2, clazz, session);
        }
    }

    public void checkIdOrNameExists(String string, String string2, Class clazz, Session session) {
        if (StringUtils.isBlank((String)string2)) {
            throw new PosException(POSConstants.NAME_IS_EMPTY);
        }
        this.checkDifferentObjectExists(string, string2, clazz, "name", session);
    }

    public void checkDifferentObjectExists(String string, String string2, Class clazz, String string3) {
        try (Session session = this.createNewSession();){
            this.checkDifferentObjectExists(string, string2, clazz, string3, session);
        }
    }

    public void checkDifferentObjectExists(String string, String string2, Class clazz, String string3, Session session) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.setProjection(Projections.rowCount());
        criteria.add((Criterion)Restrictions.eq((String)string3, (Object)string2).ignoreCase());
        if (StringUtils.isNotEmpty((String)string)) {
            criteria.add((Criterion)Restrictions.ne((String)"id", (Object)string));
        }
        this.addDeletedFilter(criteria);
        Number number = (Number)criteria.uniqueResult();
        if (number != null && number.intValue() > 0) {
            throw new DuplicateDataException(String.format("%s %s " + Messages.getString("GenericDAO.22"), WordUtils.capitalizeFully((String)string3), string2));
        }
    }

    public Object findObjectByFieldValue(String string, Class clazz, String string2, String ... stringArray) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(clazz);
            Disjunction disjunction = Restrictions.disjunction();
            for (String string3 : stringArray) {
                disjunction.add((Criterion)Restrictions.eq((String)string3, (Object)string).ignoreCase());
            }
            criteria.add((Criterion)disjunction);
            if (StringUtils.isNotEmpty((String)string2)) {
                criteria.add((Criterion)Restrictions.ne((String)"id", (Object)string2));
            }
            criteria.setMaxResults(1);
            this.addDeletedFilter(criteria);
            Object object = criteria.uniqueResult();
            return object;
        }
    }

    public void updateLastUpdateTimeProperty(Class clazz, Date date) {
        Store store = StoreDAO.getRestaurant();
        this.updateLastUpdateTimeProperty(store, clazz, date);
        GenericDAO.getInstance().saveOrUpdate(store);
    }

    public void updateLastUpdateTimeProperty(Store store, Class clazz, Date date) {
        this.updateLastUpdateTimeProperty(store, clazz.getSimpleName(), date);
    }

    public void updateLastUpdateTimeProperty(Store store, String string, Date date) {
        store.addProperty(string + "." + Store.PROP_LAST_UPDATE_TIME, DateUtil.formatSyncTime(date));
    }

    public List<String> getForeignDataListNames(Session session, Class<?> clazz, String string, String string2) {
        return this.getForeignDataList(session, clazz, string, string2, "name");
    }

    public List getForeignDataList(Session session, Class<?> clazz, String string, String string2, String string3) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.setProjection((Projection)Projections.property((String)string3));
        criteria.add((Criterion)Restrictions.eq((String)string, (Object)string2));
        this.addDeletedFilter(criteria, clazz);
        return criteria.list();
    }

    public List<String> getForeignDataListNames(Session session, Class<?> clazz, String string, String string2, String string3) {
        return this.getForeignDataList(session, clazz, string, string2, string3, "name");
    }

    public List getForeignDataList(Session session, Class<?> clazz, String string, String string2, String string3, String string4) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.createAlias(string, "c");
        criteria.setProjection((Projection)Projections.property((String)string4));
        criteria.add((Criterion)Restrictions.eq((String)("c." + string2), (Object)string3));
        this.addDeletedFilter(criteria, clazz);
        return criteria.list();
    }

    public List<String> findAllByImageResource(Session session, Class<?> clazz, String string, ImageResource imageResource, String string2) {
        Criteria criteria = session.createCriteria(clazz);
        if (imageResource != null) {
            criteria.add((Criterion)Restrictions.eq((String)string, (Object)imageResource.getId()));
        }
        this.addDeletedFilter(criteria);
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)string2)));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public Date getMaxLastUpdateTime() {
        List<DataSyncInfo> list = SyncService.getSyncModelClasses();
        try (Session session = this.createNewSession();){
            Date date = null;
            for (DataSyncInfo dataSyncInfo : list) {
                Date date2 = this.getLastUpdateTime(dataSyncInfo.getBeanClass(), InventoryStock.PROP_LAST_UPDATE_TIME, session);
                if (date == null) {
                    date = date2;
                    continue;
                }
                if (date2 == null || date2.compareTo(date) <= 0) continue;
                date = date2;
            }
            Iterator<DataSyncInfo> iterator = date;
            return iterator;
        }
    }

    public Date getLastUpdateTime(Class<?> clazz, String string, Session session) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.setProjection((Projection)Projections.max((String)string));
        criteria.setMaxResults(1);
        return (Date)criteria.uniqueResult();
    }
}

