/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseImageResourceDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.NullPrecedence;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ImageResourceDAO
extends BaseImageResourceDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rowCount() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImages(PaginationSupport paginationSupport, ImageResource.IMAGE_CATEGORY iMAGE_CATEGORY, String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            if (iMAGE_CATEGORY != null) {
                criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)iMAGE_CATEGORY.getType()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)ImageResource.PROP_DESCRIPTION, (String)string, (MatchMode)MatchMode.START));
            }
            if (iMAGE_CATEGORY != ImageResource.IMAGE_CATEGORY.DELETED) {
                criteria.add((Criterion)Restrictions.ne((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)ImageResource.IMAGE_CATEGORY.DELETED.getType()));
            }
            paginationSupport.setNumRows(this.rowCount(criteria));
            criteria.addOrder(Order.desc((String)ImageResource.PROP_LAST_UPDATE_TIME).nulls(NullPrecedence.LAST));
            int n = paginationSupport.getCurrentRowIndex();
            criteria.setFirstResult(n);
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
        catch (Exception exception) {
            paginationSupport.setRows(new ArrayList());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource getDefaultFloorImage(InputStream inputStream) throws Exception {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.addOrder(Order.asc((String)ImageResource.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType()));
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_DESCRIPTION, (Object)"default_floor_image"));
            List list = criteria.list();
            if (list.size() > 0) {
                ImageResource imageResource = (ImageResource)list.get(0);
                return imageResource;
            }
            if (inputStream != null) {
                ImageResource imageResource = new ImageResource();
                byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
                imageResource.setImageBytes(byArray);
                imageResource.setDescription("default_floor_image");
                imageResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                this.save(imageResource);
                ImageResource imageResource2 = imageResource;
                return imageResource2;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource findById(String string) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_ID, (Object)string));
            criteria.add((Criterion)Restrictions.ne((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)ImageResource.IMAGE_CATEGORY.DELETED.getType()));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                ImageResource imageResource = null;
                return imageResource;
            }
            ImageResource imageResource = (ImageResource)list.get(0);
            return imageResource;
        }
    }

    public void saveOrUpdate(List<ImageResource> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ImageResource imageResource : list) {
                this.saveOrUpdate(imageResource, session);
            }
            transaction.commit();
        }
    }

    public void saveOrUpdateImageResourceList(List<ImageResource> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (ImageResource imageResource : list) {
                this.saveOrUpdateImageResource(session, imageResource, bl, bl2);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    public void saveOrUpdateImageResource(Session session, ImageResource imageResource, boolean bl, boolean bl2) throws Exception {
        ImageResource imageResource2;
        if (imageResource.getImageBytes() == null) {
            imageResource.setImageBytes(new byte[0]);
        }
        if ((imageResource2 = this.get(imageResource.getId())) != null) {
            if (!BaseDataServiceDao.get().shouldSave(imageResource.getLastUpdateTime(), imageResource2.getLastUpdateTime())) {
                PosLog.info(this.getClass(), imageResource.getId() + " already updated");
                return;
            }
            long l = imageResource2.getVersion();
            PropertyUtils.copyProperties((Object)imageResource2, (Object)imageResource);
            imageResource2.setVersion(l);
            imageResource2.setUpdateLastUpdateTime(bl);
            imageResource2.setUpdateSyncTime(bl2);
            if (session == null) {
                this.update(imageResource2);
            } else {
                this.update(imageResource2, session);
            }
        } else {
            imageResource.setUpdateLastUpdateTime(bl);
            imageResource.setUpdateSyncTime(bl2);
            if (session == null) {
                this.save(imageResource);
            } else {
                this.save(imageResource, session);
            }
        }
    }

    public void checkRelationOndelete(ImageResource imageResource) {
        Throwable throwable = null;
        try (Session session = this.createNewSession();){
            String string = "";
            string = string + this.checkIfImageResourceSetOnStore(imageResource);
            string = string + this.checkIfImageResourceSetOnShopFloor(session, imageResource);
            string = string + this.checkIfImageResourceSetOnCustomer(session, imageResource);
            string = string + this.checkIfImageResourceSetOnUser(session, imageResource);
            string = string + this.checkIfImageResourceSetOnPizzaItem(session, imageResource);
            string = string + this.checkIfImageResourceSetOnMenuItem(session, imageResource);
            string = string + this.checkIfImageResourceSetOnVarient(session, imageResource);
            string = string + this.checkIfImageResourceSetOnSlideShowImage(session, imageResource);
            if (POSUtil.isBlankOrNull(string)) {
                return;
            }
            try {
                throw new PosException("This image is being used by other items, are you sure to delete it?", string);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private String checkIfImageResourceSetOnStore(ImageResource imageResource) {
        String string = "";
        String string2 = StoreDAO.getRestaurant().getImageId();
        if (imageResource.getId().equals(string2)) {
            string = Messages.getString("ImageResourceDAO.0") + "\n";
        }
        return string;
    }

    private String checkIfImageResourceSetOnShopFloor(Session session, ImageResource imageResource) {
        List<String> list = GenericDAO.getInstance().findAllByImageResource(session, ShopFloor.class, ShopFloor.PROP_IMAGE_ID, imageResource, ShopFloor.PROP_NAME);
        return this.populateItemList(list, Messages.getString("ImageResourceDAO.1"));
    }

    private String checkIfImageResourceSetOnCustomer(Session session, ImageResource imageResource) {
        List<String> list = GenericDAO.getInstance().findAllByImageResource(session, Customer.class, Customer.PROP_IMAGE_ID, imageResource, Customer.PROP_NAME);
        return this.populateItemList(list, POSConstants.CUSTOMER.toLowerCase());
    }

    private String checkIfImageResourceSetOnUser(Session session, ImageResource imageResource) {
        List<String> list = GenericDAO.getInstance().findAllByImageResource(session, User.class, User.PROP_IMAGE_ID, imageResource, User.PROP_FIRST_NAME);
        return this.populateItemList(list, POSConstants.USER.toLowerCase());
    }

    private String checkIfImageResourceSetOnPizzaItem(Session session, ImageResource imageResource) {
        List<String> list = MenuItemDAO.getInstance().findAllByImageResource(session, imageResource, Boolean.TRUE, null);
        return this.populateItemList(list, Messages.getString("ImageResourceDAO.2"));
    }

    private String checkIfImageResourceSetOnMenuItem(Session session, ImageResource imageResource) {
        List<String> list = MenuItemDAO.getInstance().findAllByImageResource(session, imageResource, null, Boolean.FALSE);
        return this.populateItemList(list, Messages.getString("ImageResourceDAO.3"));
    }

    private String checkIfImageResourceSetOnVarient(Session session, ImageResource imageResource) {
        List<String> list = MenuItemDAO.getInstance().findAllByImageResource(session, imageResource, null, Boolean.TRUE);
        return this.populateItemList(list, Messages.getString("ImageResourceDAO.4"));
    }

    private String checkIfImageResourceSetOnSlideShowImage(Session session, ImageResource imageResource) {
        List<String> list = GenericDAO.getInstance().findAllByImageResource(session, SlideShowImage.class, SlideShowImage.PROP_IMAGE_ID, imageResource, SlideShowImage.PROP_ID);
        return this.populateItemList(list, Messages.getString("ImageResourceDAO.5"));
    }

    private String populateItemList(List<String> list, String string) {
        String string2 = "";
        if (list != null && !list.isEmpty()) {
            string2 = Messages.getString("ImageResourceDAO.6") + string + (list.size() > 1 ? Messages.getString("MenuItemDAO.4") : ":");
            int n = 1;
            for (String string3 : list) {
                string2 = string2 + "\n" + n + ". " + string3;
                ++n;
            }
            string2 = string2 + "\n";
        }
        return string2;
    }
}

