/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.dao.BaseInventoryUnitGroupDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class InventoryUnitGroupDAO
extends BaseInventoryUnitGroupDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)object;
        List<InventoryUnit> list = inventoryUnitGroup.getUnits();
        if (list != null && list.size() > 0) {
            int n = 0;
            for (InventoryUnit inventoryUnit : list) {
                if (inventoryUnit.isDeleted().booleanValue()) continue;
                ++n;
            }
            if (n > 0) {
                throw new PosException(Messages.getString("InventoryUnitGroupDAO.0"));
            }
        }
        super.delete(object, session);
    }

    @Override
    public List<InventoryUnitGroup> findAll() {
        List<InventoryUnitGroup> list = super.findAll();
        if (list != null) {
            for (InventoryUnitGroup inventoryUnitGroup : list) {
                List<InventoryUnit> list2 = inventoryUnitGroup.getUnits();
                if (list2 == null) continue;
                Iterator<InventoryUnit> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    InventoryUnit inventoryUnit = iterator.next();
                    if (!inventoryUnit.isDeleted().booleanValue()) continue;
                    iterator.remove();
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryUnitGroup findByName(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            InventoryUnitGroup inventoryUnitGroup = this.findByName(string, session);
            return inventoryUnitGroup;
        }
        finally {
            this.closeSession(session);
        }
    }

    public InventoryUnitGroup findByName(String string, Session session) {
        if (session == null) {
            session = this.getSession();
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)InventoryUnitGroup.PROP_NAME, (Object)string));
        return (InventoryUnitGroup)criteria.uniqueResult();
    }

    public void saveOrUpdateInventoryUnitGroups(List<InventoryUnitGroup> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryUnitGroup inventoryUnitGroup : list) {
                if (arrayList.contains(inventoryUnitGroup.getName())) {
                    inventoryUnitGroup.setName(inventoryUnitGroup.getName() + "_");
                }
                arrayList.add(inventoryUnitGroup.getName());
                InventoryUnitGroup inventoryUnitGroup2 = this.get(inventoryUnitGroup.getId());
                if (inventoryUnitGroup2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(inventoryUnitGroup.getLastUpdateTime(), inventoryUnitGroup2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), inventoryUnitGroup.getName() + " already updated");
                        continue;
                    }
                    long l = inventoryUnitGroup2.getVersion();
                    PropertyUtils.copyProperties((Object)inventoryUnitGroup2, (Object)inventoryUnitGroup);
                    inventoryUnitGroup2.setVersion(l);
                    inventoryUnitGroup2.setUpdateLastUpdateTime(bl);
                    inventoryUnitGroup2.setUpdateSyncTime(bl2);
                    this.update(inventoryUnitGroup2, session);
                    continue;
                }
                inventoryUnitGroup.setUpdateLastUpdateTime(bl);
                inventoryUnitGroup.setUpdateSyncTime(bl2);
                this.save(inventoryUnitGroup, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

