/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.BaseKitchenTicketDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.VirtualPrinterDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.webservice.CloudDataUploader;
import com.orocube.common.util.TicketStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class KitchenTicketDAO
extends BaseKitchenTicketDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastUpdateDate() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)KitchenTicket.PROP_LAST_UPDATE_TIME));
            criteria.setMaxResults(1);
            Date date = (Date)criteria.uniqueResult();
            return date;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(Terminal terminal, boolean bl, PaginatedListModel paginatedListModel, boolean bl2) {
        Session session = null;
        Criteria criteria = null;
        try {
            List<String> list;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_VOIDED, (Object)Boolean.FALSE));
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.BUMP.name()));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.WAITING.name()));
            }
            List<Object> list2 = new ArrayList();
            String string = terminal.getProperty("KDS.ORDER.TYPE.ID");
            if (StringUtils.isNotBlank((String)string)) {
                list2 = Arrays.asList(string.split(","));
            }
            if (list2 != null && !list2.isEmpty()) {
                criteria.add(Restrictions.in((String)KitchenTicket.PROP_ORDER_TYPE_ID, list2));
            }
            List<Object> list3 = new ArrayList();
            String string2 = terminal.getProperty("KDS.PRINTER_ID");
            if (StringUtils.isNotBlank((String)string2)) {
                list3 = Arrays.asList(string2.split(","));
            }
            if (list3 != null && !list3.isEmpty()) {
                list = new ArrayList<String>();
                for (int i = 0; i < list3.size(); ++i) {
                    VirtualPrinter virtualPrinter = VirtualPrinterDAO.getInstance().get((String)list3.get(i), session);
                    list.add(virtualPrinter.getName());
                }
                criteria.add(Restrictions.in((String)KitchenTicket.PROP_PRINTER_NAME, list));
            }
            criteria.add(Restrictions.isNotEmpty((String)"ticketItems"));
            paginatedListModel.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            if (bl2) {
                criteria.addOrder(Order.asc((String)KitchenTicket.PROP_CREATE_DATE));
            } else {
                criteria.addOrder(Order.desc((String)KitchenTicket.PROP_CREATE_DATE));
            }
            list = criteria.list();
            if (list == null) {
                list = new ArrayList();
            }
            paginatedListModel.setData(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<KitchenTicket> findPreparingTickets() {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.WAITING.name()));
            criteria.addOrder(Order.desc((String)KitchenTicket.PROP_LAST_UPDATE_TIME));
            criteria.setMaxResults(100);
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public List<KitchenTicket> findDispatchedTickets() {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(KitchenTicket.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.BUMP.name()));
            criteria.addOrder(Order.desc((String)KitchenTicket.PROP_LAST_UPDATE_TIME));
            criteria.setMaxResults(100);
            List list2 = list = criteria.list();
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KitchenTicket> findAllOpen(Date date) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.WAITING.name()));
            if (date != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"lastUpdateTime"), (Criterion)Restrictions.gt((String)"lastUpdateTime", (Object)date)));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void dispatchAll() {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.getSession();
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.BUMP.name()));
            List list = criteria.list();
            if (list.isEmpty()) {
                transaction.rollback();
                throw new PosException("No data to dispatch");
            }
            for (KitchenTicket kitchenTicket : list) {
                this.delete(kitchenTicket, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KitchenTicket> findByParentId(String string) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_TICKET_ID, (Object)string));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KitchenTicket findByLastOrderParentId(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_TICKET_ID, (Object)string));
            criteria.addOrder(Order.desc((String)KitchenTicket.PROP_CREATE_DATE));
            List list = criteria.list();
            if (list.size() > 0) {
                KitchenTicket kitchenTicket = (KitchenTicket)list.get(0);
                return kitchenTicket;
            }
            KitchenTicket kitchenTicket = null;
            return kitchenTicket;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findNextKitchenTickets(PaginatedTableModel paginatedTableModel) {
        List list;
        Session session = null;
        Criteria criteria = null;
        try {
            int n = paginatedTableModel.getNextRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(n);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            List list2 = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginatedTableModel.setNumRows(number.intValue());
            }
            paginatedTableModel.setCurrentRowIndex(n);
            list = list2;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findPreviousKitchenTickets(PaginatedTableModel paginatedTableModel) {
        List list;
        Session session = null;
        Criteria criteria = null;
        try {
            int n = paginatedTableModel.getPreviousRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(n);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            List list2 = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginatedTableModel.setNumRows(number.intValue());
            }
            paginatedTableModel.setCurrentRowIndex(n);
            list = list2;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(List<KitchenTicket> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (KitchenTicket kitchenTicket : list) {
                session.saveOrUpdate((Object)kitchenTicket);
            }
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date isDataUpdated(Date date) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)KitchenTicket.PROP_CREATE_DATE));
            if (date != null) {
                criteria.add((Criterion)Restrictions.gt((String)KitchenTicket.PROP_CREATE_DATE, (Object)date));
            }
            if ((object = criteria.uniqueResult()) == null) {
                Date date2 = null;
                return date2;
            }
            Date date3 = (Date)object;
            return date3;
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        Date date = StoreDAO.getServerTimestamp();
        KitchenTicket kitchenTicket = (KitchenTicket)object;
        kitchenTicket.setLastUpdateTime(date);
        session.saveOrUpdate((Object)kitchenTicket);
    }

    public void bumpOrUnbump(KitchenTicket kitchenTicket, KitchenStatus kitchenStatus, KitchenStatus kitchenStatus2, boolean bl) {
        this.bumpOrUnbump(kitchenTicket, null, kitchenStatus, kitchenStatus2, bl);
    }

    public void bumpOrUnbump(KitchenTicket kitchenTicket, Ticket ticket, KitchenStatus kitchenStatus, KitchenStatus kitchenStatus2, boolean bl) {
        if (ticket == null) {
            ticket = TicketDAO.getInstance().loadFullTicket(kitchenTicket.getTicketId());
        }
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            block5: for (KitchenTicketItem kitchenTicketItem : kitchenTicket.getTicketItems()) {
                if (kitchenTicketItem.isVoided().booleanValue()) continue;
                kitchenTicketItem.setStatus(kitchenStatus.name());
                double d = kitchenTicketItem.getQuantity();
                if (ticket == null) continue;
                for (TicketItem ticketItem : ticket.getTicketItems()) {
                    if (!StringUtils.isNotEmpty((String)kitchenTicketItem.getTicketItemId()) || !kitchenTicketItem.getTicketItemId().equals(ticketItem.getId()) || ticketItem.getKitchenStatusValue() == kitchenStatus2) continue;
                    if (d == 0.0) continue block5;
                    ticketItem.setKitchenStatusValueWithChildren(kitchenStatus2);
                    d -= ticketItem.getQuantity().doubleValue();
                }
            }
            kitchenTicket.setStatus(kitchenStatus.name());
            Date date = StoreDAO.getServerTimestamp();
            if (bl) {
                kitchenTicket.setClosingDate(date);
            } else {
                kitchenTicket.setClosingDate(null);
            }
            this.saveOrUpdate(kitchenTicket, session);
            if (ticket != null) {
                KitchenTicketItem kitchenTicketItem;
                kitchenTicketItem = ticket.getTicketStatus();
                if (bl && kitchenTicketItem == TicketStatus.Preparing) {
                    ticket.setTicketStatus(TicketStatus.Ready);
                } else if (!bl && kitchenTicketItem == TicketStatus.Ready) {
                    ticket.setTicketStatus(TicketStatus.Preparing);
                }
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
            }
            transaction.commit();
            CloudDataUploader.get().uploadTicketIfOnlineOrder(ticket);
        }
    }

    public void deleteByTicketId(String string, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_TICKET_ID, (Object)string));
        List list = criteria.list();
        for (KitchenTicket kitchenTicket : list) {
            this.delete(kitchenTicket, session);
        }
    }
}

