/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.BaseOutletDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.SyncService;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;

public class OutletDAO
extends BaseOutletDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime((Outlet)object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime((Outlet)object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime((Outlet)object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public List<Outlet> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outlet initialize(Outlet outlet) {
        if (outlet == null || outlet.getId() == null) {
            return outlet;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)outlet);
            Hibernate.initialize(outlet.getDepartments());
            Outlet outlet2 = outlet;
            return outlet2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateOutlets(List<Outlet> list, String string, boolean bl, boolean bl2, boolean bl3) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Outlet outlet : list) {
                this.saveOrUpdateOutlet(outlet, string, bl, bl2, bl3, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateOutlet(Outlet outlet, String string, boolean bl, boolean bl2, boolean bl3, Session session) throws Exception {
        Outlet outlet2 = this.get(outlet.getId());
        if (outlet2 != null) {
            if (!bl && !BaseDataServiceDao.get().shouldSave(outlet.getLastUpdateTime(), outlet2.getLastUpdateTime())) {
                PosLog.debug(this.getClass(), outlet.getName() + " already updated");
                return;
            }
            long l = outlet2.getVersion();
            PropertyUtils.copyProperties((Object)outlet2, (Object)outlet);
            outlet2.setVersion(l);
            outlet2.setUpdateLastUpdateTime(bl2);
            outlet2.setUpdateSyncTime(bl3);
            this.copyOutletToLocalStoreIfNeeeded(outlet2, string, session);
            this.update(outlet2, session);
        } else {
            outlet.setVersion(0L);
            outlet.setUpdateLastUpdateTime(bl2);
            outlet.setUpdateSyncTime(bl3);
            this.copyOutletToLocalStoreIfNeeeded(outlet, string, session);
            this.save(outlet, session);
        }
    }

    private void copyOutletToLocalStoreIfNeeeded(Outlet outlet, String string, Session session) {
        Outlet outlet2 = outlet;
        if (!string.equals(outlet2.getId())) {
            return;
        }
        Store store = DataProvider.get().getStore();
        if (store != null) {
            Set set;
            StoreDAO.getInstance().refresh(store, session);
            store.setDefaultGratuityPercentage(outlet2.getDefaultGratuityPercentage());
            store.setServiceChargePercentage(outlet2.getServiceChargePercentage());
            store.setOutletName(outlet2.getName());
            store.setUseDetailedReconciliation(outlet2.isUseDetailedReconciliation());
            store.setItemPriceIncludesTax(outlet2.isItemPriceIncludesTax());
            List<String> list = SyncService.getNotReplaceableStoreKeys();
            Map<String, String> map = store.getProperties();
            if (map == null) {
                map = new HashMap<String, String>();
            }
            if ((set = outlet2.getPropertyStore().keySet()) != null) {
                for (String string2 : set) {
                    if (list.contains(string2) || string2.endsWith(".lastUpdateTime")) continue;
                    try {
                        String string3 = outlet2.getProperty(string2);
                        if (StringUtils.isBlank((String)string3)) continue;
                        if (string3.length() > 255) {
                            POSUtil.storeLongProperty(map, string2, string3, 255);
                            continue;
                        }
                        map.put(string2, string3);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                }
            }
            store.setProperties(map);
            GenericDAO.getInstance().saveOrUpdate(store, session);
        }
    }

    private void removeBlankOutletProperties(Outlet outlet) {
        Set set = outlet.getPropertyStore().keySet();
        if (set == null || set.size() == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : set) {
            try {
                String string2 = outlet.getProperty(string);
                if (string2 != null) continue;
                arrayList.add(string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                arrayList.add(string);
            }
        }
        for (String string : arrayList) {
            outlet.removeProperty(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutletSyncable(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (string != null) {
                criteria.add((Criterion)Restrictions.eq((String)Outlet.PROP_ID, (Object)string));
            }
            Criterion criterion = Restrictions.isNull((String)Outlet.PROP_LAST_UPDATE_TIME);
            Criterion criterion2 = Restrictions.isNull((String)Outlet.PROP_LAST_SYNC_TIME);
            PropertyExpression propertyExpression = Restrictions.gtProperty((String)Outlet.PROP_LAST_UPDATE_TIME, (String)Outlet.PROP_LAST_SYNC_TIME);
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{criterion, criterion2, propertyExpression}));
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list = criteria.list();
            if (list.size() == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }
}

