/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.dao.BasePriceRuleDAO;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class PriceRuleDAO
extends BasePriceRuleDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.validateData((PriceRule)object, session);
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.validateData((PriceRule)object, session);
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.validateData((PriceRule)object, session);
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    private void validateData(PriceRule priceRule, Session session) {
        if (priceRule.isDeleted().booleanValue()) {
            return;
        }
        if (this.priceRuleExists(priceRule, session)) {
            throw new DuplicateDataException(Messages.getString("PriceRuleDAO.1"));
        }
    }

    private boolean priceRuleExists(PriceRule priceRule, Session session) {
        Object object;
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        String string = priceRule.getId();
        if (StringUtils.isNotEmpty((String)string)) {
            object = Restrictions.ne((String)"id", (Object)string);
            criteria.add((Criterion)object);
        }
        this.addDeletedFilter(criteria);
        object = priceRule.getOutletId();
        Criterion criterion = object != null ? Restrictions.eq((String)PriceRule.PROP_OUTLET_ID, (Object)object) : Restrictions.isNull((String)PriceRule.PROP_OUTLET_ID);
        String string2 = priceRule.getDepartmentId();
        Criterion criterion2 = string2 != null ? Restrictions.eq((String)PriceRule.PROP_DEPARTMENT_ID, (Object)string2) : Restrictions.isNull((String)PriceRule.PROP_DEPARTMENT_ID);
        String string3 = priceRule.getSalesAreaId();
        Criterion criterion3 = string3 != null ? Restrictions.eq((String)PriceRule.PROP_SALES_AREA_ID, (Object)string3) : Restrictions.isNull((String)PriceRule.PROP_SALES_AREA_ID);
        String string4 = priceRule.getOrderTypeId();
        Criterion criterion4 = string4 != null ? Restrictions.eq((String)PriceRule.PROP_ORDER_TYPE_ID, (Object)string4) : Restrictions.isNull((String)PriceRule.PROP_ORDER_TYPE_ID);
        String string5 = priceRule.getCustomerGroupId();
        Criterion criterion5 = string5 != null ? Restrictions.eq((String)PriceRule.PROP_CUSTOMER_GROUP_ID, (Object)string5) : Restrictions.isNull((String)PriceRule.PROP_CUSTOMER_GROUP_ID);
        String string6 = priceRule.getPriceShiftId();
        Criterion criterion6 = string6 != null ? Restrictions.eq((String)PriceRule.PROP_PRICE_SHIFT_ID, (Object)string6) : Restrictions.isNull((String)PriceRule.PROP_PRICE_SHIFT_ID);
        Boolean bl = priceRule.getCustomerIsMember();
        Criterion criterion7 = bl != null ? Restrictions.eq((String)PriceRule.PROP_CUSTOMER_IS_MEMBER, (Object)bl) : Restrictions.isNull((String)PriceRule.PROP_CUSTOMER_IS_MEMBER);
        Conjunction conjunction = Restrictions.and((Criterion[])new Criterion[]{criterion, criterion2, criterion3, criterion4, criterion5, criterion6, criterion7});
        criteria.add((Criterion)conjunction);
        List list = criteria.list();
        return list != null && list.size() > 0;
    }

    @Override
    public List<PriceRule> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void delete(Object object, Session session) {
        if (!(object instanceof PriceRule)) {
            throw new PosException(Messages.getString("PriceRuleDAO.0"));
        }
        PriceRule priceRule = (PriceRule)object;
        priceRule.setDeleted(Boolean.TRUE);
        super.update(priceRule, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getPrice(MenuItem menuItem, PriceShift priceShift, OrderType orderType, Department department, SalesArea salesArea, Customer customer) {
        Session session = null;
        try {
            session = this.createNewSession();
            Double d = this.getPrice(menuItem, priceShift, orderType, department, salesArea, customer, session);
            return d;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public List<PriceRule> getPriceRule(MenuItem menuItem, OrderType orderType, Department department, SalesArea salesArea, Customer customer, List<PriceShift> list, Session session) {
        String string = null;
        if (list != null && !list.isEmpty()) {
            string = POSUtil.createStringByField(list, Shift.class, "getId", true);
        }
        String string2 = "SELECT * FROM PRICE_RULE as pr";
        string2 = string2 + " LEFT JOIN CUSTOMER_CUST_GROUP ccg ON";
        string2 = string2 + " pr.CUSTOMER_GROUP_ID = ccg.CUST_GROUP_ID";
        string2 = string2 + " LEFT JOIN PRICE_TABLE pt ON";
        string2 = string2 + " pt.ID = pr.PRICE_TABLE_ID";
        string2 = string2 + " WHERE";
        string2 = string2 + " (pr.DELETED IS NULL OR pr.DELETED = FALSE)";
        string2 = string2 + " AND (pt.DELETED IS NULL OR pt.DELETED = FALSE)";
        string2 = string2 + " AND";
        string2 = string2 + " pr.ACTIVE = true";
        boolean bl = orderType != null;
        string2 = string2 + " AND";
        if (bl) {
            string2 = string2 + " (";
        }
        string2 = string2 + " pr.ORDER_TYPE_ID IS NULL";
        if (bl) {
            string2 = string2 + " OR";
            string2 = string2 + " pr.ORDER_TYPE_ID = '" + orderType.getId() + "')";
        }
        boolean bl2 = department != null;
        string2 = string2 + " AND";
        if (bl2) {
            string2 = string2 + " (";
        }
        string2 = string2 + " pr.DEPARTMENT_ID IS NULL";
        if (bl2) {
            string2 = string2 + " OR";
            string2 = string2 + " pr.DEPARTMENT_ID = '" + department.getId() + "')";
        }
        boolean bl3 = salesArea != null;
        string2 = string2 + " AND";
        if (bl3) {
            string2 = string2 + " (";
        }
        string2 = string2 + " pr.SALES_AREA_ID IS NULL";
        if (bl3) {
            string2 = string2 + " OR";
            string2 = string2 + " pr.SALES_AREA_ID = '" + salesArea.getId() + "')";
        }
        if (StringUtils.isNotBlank((String)string)) {
            string2 = string2 + " AND (";
            string2 = string2 + " pr.PRICE_SHIFT_ID in (" + string + ")";
            string2 = string2 + " OR";
            string2 = string2 + " pr.PRICE_SHIFT_ID IS NULL )";
        } else {
            string2 = string2 + " AND (";
            string2 = string2 + " pr.PRICE_SHIFT_ID IS NULL )";
        }
        boolean bl4 = customer != null;
        string2 = string2 + " AND ";
        if (bl4) {
            string2 = string2 + " (";
        }
        string2 = string2 + " pr.CUSTOMER_GROUP_ID IS NULL";
        if (bl4) {
            string2 = string2 + " OR";
            string2 = string2 + " ccg.CUSTOMER_ID = '" + customer.getId() + "')";
        }
        string2 = string2 + " AND ";
        if (bl4) {
            string2 = string2 + " (";
        }
        string2 = string2 + " pr.CUSTOMER_IS_MEMBER IS NULL";
        if (bl4) {
            string2 = string2 + " OR";
            string2 = string2 + " pr.CUSTOMER_IS_MEMBER = " + customer.isMembershipActive() + ")";
        }
        SQLQuery sQLQuery = session.createSQLQuery(string2);
        sQLQuery.addEntity(PriceRule.class);
        return sQLQuery.list();
    }

    public Double getPrice(MenuItem menuItem, PriceShift priceShift, OrderType orderType, Department department, SalesArea salesArea, Customer customer, Session session) {
        List<String> list;
        List<PriceShift> list2 = ShiftUtil.getCurrentPriceShifts();
        List<PriceRule> list3 = this.getPriceRule(menuItem, orderType, department, salesArea, customer, list2, session);
        List<String> list4 = null;
        if (list2 != null && !list2.isEmpty()) {
            list4 = POSUtil.getStringIds(list2, PriceShift.class);
        }
        if (list3 == null || list3.isEmpty()) {
            return null;
        }
        if (list4 != null && !list4.isEmpty()) {
            list = new ArrayList<String>(list4);
            list3.sort(Comparator.comparing(priceRule -> list.indexOf(priceRule.getPriceShiftId())));
        }
        list = POSUtil.getStringIds(list3, PriceRule.class, "getPriceTableId");
        Criteria criteria = session.createCriteria(PriceTableItem.class);
        criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
        this.addDeletedFilter(criteria);
        criteria.add(Restrictions.in((String)PriceTableItem.PROP_PRICE_TABLE_ID, list));
        List list5 = criteria.list();
        if (list5 != null && list5.size() > 0) {
            if (list5.size() == 1) {
                PriceTableItem priceTableItem2 = (PriceTableItem)list5.get(0);
                return priceTableItem2.getPrice();
            }
            list5.sort(Comparator.comparing(priceTableItem -> list.indexOf(priceTableItem.getPriceTableId())));
            PriceTableItem priceTableItem3 = (PriceTableItem)list5.get(0);
            return priceTableItem3.getPrice();
        }
        return null;
    }

    public List<PriceRule> findByPriceShiftId(String string, Session session) {
        return this.findByPriceShiftId(string, session, Boolean.FALSE);
    }

    public List<PriceRule> findByPriceShiftId(String string, Session session, boolean bl) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        if (bl) {
            this.addDeletedFilter(criteria);
        }
        criteria.add((Criterion)Restrictions.eq((String)PriceRule.PROP_PRICE_SHIFT_ID, (Object)string));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)PriceRule.PROP_NAME), (String)PriceRule.PROP_NAME));
        criteria.setResultTransformer(Transformers.aliasToBean(PriceRule.class));
        return criteria.list();
    }

    public List<PriceRule> getPriceRulesByPriceTable(PriceTable priceTable, Session session) {
        if (priceTable == null || priceTable.getId() == null) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)PriceRule.PROP_PRICE_TABLE_ID, (Object)priceTable.getId()));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)PriceRule.PROP_NAME), (String)PriceRule.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }

    public PriceRule getPriceRulesByPriceTable(String string) {
        try (Session session = this.createNewSession();){
            if (StringUtils.isBlank((String)string)) {
                PriceRule priceRule = null;
                return priceRule;
            }
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)PriceRule.PROP_PRICE_TABLE_ID, (Object)string));
            criteria.addOrder(Order.asc((String)PriceTable.PROP_NAME).ignoreCase());
            criteria.setMaxResults(1);
            PriceRule priceRule = (PriceRule)criteria.uniqueResult();
            return priceRule;
        }
    }

    public void saveOrUpdatePriceRuleList(List<PriceRule> list, boolean bl, boolean bl2) throws Exception {
        if (list != null && list.size() > 0) {
            for (PriceRule priceRule : list) {
                PriceRuleDAO priceRuleDAO = PriceRuleDAO.getInstance();
                PriceRule priceRule2 = priceRuleDAO.get(priceRule.getId());
                if (priceRule2 != null) {
                    String string = priceRule2.getId();
                    long l = priceRule2.getVersion();
                    PropertyUtils.copyProperties((Object)priceRule2, (Object)priceRule);
                    priceRule2.setId(string);
                    priceRule2.setVersion(l);
                    priceRule2.setUpdateLastUpdateTime(bl);
                    priceRule2.setUpdateSyncTime(bl2);
                    priceRuleDAO.update(priceRule2);
                    continue;
                }
                priceRule.setVersion(0L);
                priceRule.setUpdateLastUpdateTime(bl);
                priceRule.setUpdateSyncTime(bl2);
                priceRuleDAO.save(priceRule);
            }
        }
    }

    public void saveOrUpdate(PriceTable priceTable, PriceRule priceRule, List<PriceTableItem> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            if (StringUtils.isBlank((String)priceTable.getId()) || PriceTableDAO.getInstance().get(priceTable.getId()) == null) {
                priceTable.setId(UUID.randomUUID().toString());
                PriceTableDAO.getInstance().save(priceTable, session);
            } else {
                PriceTableDAO.getInstance().saveOrUpdate(priceTable, session);
            }
            priceRule.setPriceTableId(priceTable.getId());
            if (StringUtils.isBlank((String)priceRule.getId()) || PriceRuleDAO.getInstance().get(priceRule.getId()) == null) {
                priceRule.setId(priceTable.getId());
                PriceRuleDAO.getInstance().save(priceRule, session);
            } else {
                PriceRuleDAO.getInstance().saveOrUpdate(priceRule, session);
            }
            if (list != null) {
                for (PriceTableItem priceTableItem : list) {
                    priceTableItem.setPriceTableId(priceTable.getId());
                    PriceTableItemDAO.getInstance().saveOrUpdate(priceTableItem, session);
                }
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

