/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.BaseRecepieDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.RecepieItemDAO;
import com.floreantpos.model.ext.InvMapKey;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.BeanTableModel;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class RecepieDAO
extends BaseRecepieDAO {
    @Override
    protected void delete(Object object, Session session) {
        Recepie recepie = (Recepie)object;
        if (recepie == null) {
            throw new PosException(Messages.getString("RecepieDAO.0"));
        }
        this.checkForeignRelation(recepie);
        recepie.setDeleted(Boolean.TRUE);
        this.update(recepie, session);
    }

    private void checkForeignRelation(Recepie recepie) throws PosException {
        try (Session session = this.createNewSession();){
            List<String> list = GenericDAO.getInstance().getForeignDataListNames(session, MenuItem.class, MenuItem.PROP_DEFAULT_RECIPE_ID, recepie.getId());
            if (list != null && list.size() > 0) {
                String string = Messages.getString("RecepieDAO.1") + (list.size() > 1 ? Messages.getString("RecepieDAO.2") : ":");
                int n = 1;
                for (String string2 : list) {
                    string = string + "\n" + n + ". " + string2;
                    ++n;
                }
                throw new PosException(Messages.getString("RecepieDAO.4"), string);
            }
        }
    }

    @Override
    public List<Recepie> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(String string, boolean bl) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(Recepie.class);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)Recepie.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            this.addDeletedFilter(criteria);
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRecepies(BeanTableModel<Recepie> beanTableModel, String string, boolean bl) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(Recepie.class);
            if (StringUtils.isNotEmpty((String)string)) {
                object = Restrictions.disjunction();
                object.add(Restrictions.ilike((String)Recepie.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                criteria.createAlias(Recepie.PROP_MENU_ITEM, "item");
                object.add(Restrictions.ilike((String)"item.name", (String)string.trim(), (MatchMode)MatchMode.START));
                criteria.add((Criterion)object);
            }
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            object = (Number)criteria.uniqueResult();
            beanTableModel.setNumRows(((Number)object).intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)Recepie.PROP_NAME));
            criteria.setFirstResult(beanTableModel.getCurrentRowIndex());
            criteria.setMaxResults(beanTableModel.getPageSize());
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list = criteria.list();
            beanTableModel.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Recepie> findBy(MenuItem menuItem) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Recepie.PROP_MENU_ITEM, (Object)menuItem));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Recepie findByName(String string, String string2) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Recepie.PROP_NAME, (Object)string));
            if (StringUtils.isNotBlank((String)string2)) {
                criteria.add((Criterion)Restrictions.ne((String)Recepie.PROP_ID, (Object)string2));
            }
            criteria.setMaxResults(1);
            Recepie recepie = (Recepie)criteria.uniqueResult();
            return recepie;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<String> getForeignDataListNames(MenuItem menuItem) {
        try (Session session = this.createNewSession();){
            List<String> list = this.getForeignDataListNames(menuItem, session);
            return list;
        }
    }

    public List<String> getForeignDataListNames(MenuItem menuItem, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)Recepie.PROP_NAME)));
        criteria.createAlias("recepieItems", "items");
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Recepie.PROP_MENU_ITEM, (Object)menuItem), (Criterion)Restrictions.eq((String)("items." + RecepieItem.PROP_INVENTORY_ITEM), (Object)menuItem)));
        this.addDeletedFilter(criteria);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public void adjustInventory(Double d, List<Recepie> list) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.adjustInventory(d, list, session);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void adjustInventory(Double d, List<Recepie> list, Session session) throws Exception {
        HashMap<InvMapKey, Double> hashMap = new HashMap<InvMapKey, Double>();
        HashMap<InvMapKey, Double> hashMap2 = new HashMap<InvMapKey, Double>();
        for (Recepie idContainer2 : list) {
            Double d2 = idContainer2.getYield();
            Double d3 = idContainer2.getCookingYield();
            MenuItem menuItem = idContainer2.getMenuItem();
            MenuItemDAO.getInstance().initializeUnits(menuItem);
            InventoryUnit inventoryUnit = menuItem.getUnit();
            InvMapKey invMapKey = new InvMapKey(menuItem.getId(), inventoryUnit == null ? null : inventoryUnit.getCode());
            Double d4 = hashMap.get(invMapKey);
            if (d4 == null) {
                d4 = 0.0;
            }
            Double d5 = idContainer2.getPortion();
            if ((d5 = Double.valueOf(d5 + d4)) <= 0.0) continue;
            hashMap.put(invMapKey, d5);
            idContainer2.populateRecipeItemQuantity(d, hashMap2, d3 / d2);
        }
        InventoryLocation inventoryLocation = InventoryLocationDAO.getInstance().getDefaultOutInventoryLocation(session);
        InventoryLocation inventoryLocation2 = InventoryLocationDAO.getInstance().getDefaultInInventoryLocation(session);
        this.adjustInventory(hashMap, InventoryTransactionType.IN, "PREPARE IN", inventoryLocation2, session);
        this.adjustInventory(hashMap2, InventoryTransactionType.OUT, "PREPARE OUT", inventoryLocation, session);
    }

    public void adjustRecipeItemsFromInventory(Double d, List<Recepie> list, Session session) throws Exception {
        HashMap<InvMapKey, Double> hashMap = new HashMap<InvMapKey, Double>();
        HashMap<InvMapKey, Double> hashMap2 = new HashMap<InvMapKey, Double>();
        for (Recepie recepie : list) {
            Double d2 = recepie.getYield();
            Double d3 = recepie.getCookingYield();
            MenuItem menuItem = recepie.getMenuItem();
            InvMapKey invMapKey = new InvMapKey(menuItem.getId(), menuItem.getUnit().getCode());
            Double d4 = (Double)hashMap.get(invMapKey);
            if (d4 == null) {
                d4 = 0.0;
            }
            Double d5 = recepie.getPortion();
            if ((d5 = Double.valueOf(d5 + d4)) <= 0.0) continue;
            hashMap.put(invMapKey, d5);
            recepie.populateRecipeItemQuantity(d, hashMap2, d3 / d2);
        }
        InventoryLocation inventoryLocation = InventoryLocationDAO.getInstance().getDefaultOutInventoryLocation(session);
        this.adjustInventory(hashMap2, InventoryTransactionType.OUT, "PREPARE OUT", inventoryLocation, session);
    }

    private void adjustInventory(HashMap<InvMapKey, Double> hashMap, InventoryTransactionType inventoryTransactionType, String string, InventoryLocation inventoryLocation, Session session) throws Exception {
        Store store = DataProvider.get().getStore();
        boolean bl = store.isUpdateOnHandBlncForSale();
        boolean bl2 = store.isUpdateAvlBlncForSale();
        for (InvMapKey invMapKey : hashMap.keySet()) {
            String string2 = invMapKey.getMenuItemId();
            Double d = hashMap.get(invMapKey);
            MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemWithFields(string2, MenuItem.PROP_NAME, MenuItem.PROP_PRICE, MenuItem.PROP_SKU, MenuItem.PROP_BARCODE, MenuItem.PROP_UNIT_ID, MenuItem.PROP_COST, MenuItem.PROP_AVERAGE_UNIT_PURCHASE_PRICE, MenuItem.PROP_AVG_COST);
            if (menuItem == null || !menuItem.isInventoryItem().booleanValue()) continue;
            IUnit iUnit = DataProvider.get().getUnitByCode(invMapKey.getUnitCode());
            if (iUnit instanceof PackagingUnit) {
                MenuItemDAO.getInstance().initializeUnits(menuItem);
            }
            double d2 = menuItem.getBaseUnitQuantity(invMapKey.getUnitCode());
            menuItem.setId(string2);
            InventoryTransaction inventoryTransaction = new InventoryTransaction();
            inventoryTransaction.setReason(string);
            inventoryTransaction.setTransactionDate(new Date());
            inventoryTransaction.setMenuItem(menuItem);
            inventoryTransaction.setType(inventoryTransactionType.getType());
            inventoryTransaction.setUser(Application.getCurrentUser());
            inventoryTransaction.setUnitPrice(menuItem.getPrice() * d2);
            inventoryTransaction.setQuantity(d);
            if (invMapKey.getUnitCode() != null) {
                inventoryTransaction.setUnit(invMapKey.getUnitCode());
            } else {
                InventoryUnit inventoryUnit = menuItem.getUnit();
                if (inventoryUnit != null) {
                    inventoryTransaction.setUnit(inventoryUnit.getCode());
                }
            }
            inventoryTransaction.setUnitCost(menuItem.getCost());
            if (inventoryTransactionType == InventoryTransactionType.IN) {
                inventoryTransaction.setToInventoryLocation(inventoryLocation);
            } else {
                inventoryTransaction.setFromInventoryLocation(inventoryLocation);
            }
            inventoryTransaction.setOutletId(DataProvider.get().getCurrentOutletId());
            inventoryTransaction.calculateTotal();
            InventoryTransactionDAO.getInstance().adjustInventoryStock(inventoryTransaction, session, bl2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMenuItemName(Recepie recepie) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias("menuItem", "item");
            criteria.setProjection((Projection)Projections.property((String)"item.name"));
            criteria.add((Criterion)Restrictions.eq((String)RecipeTable.PROP_ID, (Object)recepie.getId()));
            this.addDeletedFilter(criteria);
            String string = (String)criteria.uniqueResult();
            return string;
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Serializable save(Object object, Session session) {
        Recepie recepie = (Recepie)object;
        if (this.nameExists(recepie.getId(), recepie.getName())) {
            throw new PosException(Messages.getString("RecepieDAO.6"));
        }
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        Recepie recepie = (Recepie)object;
        if (this.nameExists(recepie.getId(), recepie.getName())) {
            throw new PosException(Messages.getString("RecepieDAO.6"));
        }
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        Recepie recepie = (Recepie)object;
        if (this.nameExists(recepie.getId(), recepie.getName())) {
            throw new PosException(Messages.getString("RecepieDAO.6"));
        }
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(String string, String string2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.ne((String)Recepie.PROP_ID, (Object)string));
            }
            criteria.add((Criterion)Restrictions.eq((String)Recepie.PROP_NAME, (Object)string2).ignoreCase());
            this.addDeletedFilter(criteria);
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateRecipes(List<Recepie> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        HashMap<String, MenuItem> hashMap = new HashMap<String, MenuItem>();
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (Recepie recepie : list) {
                List<RecepieItem> list2 = recepie.getRecepieItems();
                recepie.setRecepieItems(null);
                String string = recepie.getMenuItem().getId();
                MenuItem menuItem = (MenuItem)hashMap.get(string);
                if (menuItem == null) {
                    menuItem = MenuItemDAO.getInstance().get(string);
                    if (menuItem == null) {
                        throw new Exception("No item found with id " + string);
                    }
                    hashMap.put(menuItem.getId(), menuItem);
                }
                recepie.setMenuItem(menuItem);
                recepie.setUpdateLastUpdateTime(bl);
                recepie.setUpdateSyncTime(bl2);
                RecepieDAO recepieDAO = RecepieDAO.getInstance();
                Recepie recepie2 = recepieDAO.get(recepie.getId());
                if (recepie2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(recepie.getLastUpdateTime(), recepie2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), recepie.getId() + " already updated");
                        continue;
                    }
                    long l = recepie2.getVersion();
                    recepie.setVersion(l);
                } else {
                    this.save(recepie, session);
                }
                List<RecepieItem> list3 = null;
                if (recepie2 != null && recepie2.getRecepieItems() != null) {
                    list3 = recepie2.getRecepieItems();
                }
                if (list3 == null) {
                    list3 = new ArrayList<RecepieItem>();
                }
                if (list2 != null && list2.size() > 0) {
                    for (RecepieItem recepieItem : list2) {
                        String string2;
                        MenuItem menuItem2 = recepieItem.getInventoryItem();
                        if (menuItem2 == null || StringUtils.isEmpty((String)(string2 = menuItem2.getId()))) continue;
                        MenuItem menuItem3 = (MenuItem)hashMap.get(string2);
                        if (menuItem3 == null) {
                            menuItem3 = MenuItemDAO.getInstance().get(string2);
                            if (menuItem3 == null) {
                                throw new Exception("No item found with id " + string2);
                            }
                            hashMap.put(menuItem3.getId(), menuItem3);
                        }
                        recepieItem.setInventoryItem(menuItem3);
                        recepieItem.setRecepie(recepie);
                        int n = list3.indexOf(recepieItem);
                        RecepieItem recepieItem2 = null;
                        if (n != -1) {
                            recepieItem2 = list3.get(n);
                            if (recepieItem2 == null) {
                                recepieItem.setVersion(0L);
                                RecepieItemDAO.getInstance().save(recepieItem, session);
                                continue;
                            }
                            recepieItem.setVersion(recepieItem2.getVersion());
                            continue;
                        }
                        recepieItem.setVersion(0L);
                        RecepieItemDAO.getInstance().save(recepieItem, session);
                    }
                }
                recepie.setRecepieItems(list2);
                this.saveOrUpdate(recepie, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }
}

