/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopFloorTemplate;
import com.floreantpos.model.dao.BaseShopFloorTemplateDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ShopFloorTemplateDAO
extends BaseShopFloorTemplateDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ShopFloorTemplate> findByParent(ShopFloor shopFloor) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)ShopFloorTemplate.PROP_FLOOR, (Object)shopFloor));
            List list = criteria.list();
            return list;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdateTemplates(List<ShopFloorTemplate> list) {
        if (list == null) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ShopFloorTemplate shopFloorTemplate : list) {
                session.saveOrUpdate((Object)shopFloorTemplate);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTemplates(List<ShopFloorTemplate> list) {
        if (list == null) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ShopFloorTemplate shopFloorTemplate : list) {
                session.delete((Object)shopFloorTemplate);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    public void setDefaultTemplate(ShopFloorTemplate shopFloorTemplate, ShopFloor shopFloor) {
        block14: {
            Transaction transaction = null;
            try (Session session = this.createNewSession();){
                transaction = session.beginTransaction();
                String string = "UPDATE %s template SET template.%s = :default WHERE template.%s = :floor";
                string = String.format(string, ShopFloorTemplate.REF, ShopFloorTemplate.PROP_DEFAULT_FLOOR, ShopFloorTemplate.PROP_FLOOR);
                Query query = session.createQuery(string);
                query.setParameter("default", (Object)Boolean.FALSE);
                query.setParameter("floor", (Object)shopFloor);
                query.executeUpdate();
                shopFloorTemplate.setDefaultFloor(true);
                session.update((Object)shopFloorTemplate);
                session.update((Object)shopFloor);
                transaction.commit();
            }
            catch (Exception exception) {
                if (transaction == null) break block14;
                transaction.commit();
            }
        }
    }

    public void saveOrUpdateShopFloorTemplates(List<ShopFloorTemplate> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (ShopFloorTemplate shopFloorTemplate : list) {
                ShopFloorTemplate shopFloorTemplate2 = this.get(shopFloorTemplate.getId());
                shopFloorTemplate.setUpdateLastUpdateTime(bl);
                shopFloorTemplate.setUpdateSyncTime(bl2);
                if (shopFloorTemplate2 == null) {
                    this.save(shopFloorTemplate, session);
                } else {
                    if (!BaseDataServiceDao.get().shouldSave(shopFloorTemplate.getLastUpdateTime(), shopFloorTemplate2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), shopFloorTemplate.getName() + " already updated");
                        continue;
                    }
                    shopFloorTemplate.setVersion(shopFloorTemplate2.getVersion());
                }
                this.update(shopFloorTemplate, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }
}

