/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.BaseTaxGroupDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class TaxGroupDAO
extends BaseTaxGroupDAO {
    @Override
    protected void delete(Object object, Session session) {
        TaxGroup taxGroup = (TaxGroup)object;
        if (taxGroup == null) {
            throw new PosException(Messages.getString("TaxGroupDAO.0"));
        }
        taxGroup.setDeleted(true);
        this.update(taxGroup, session);
    }

    @Override
    public List<TaxGroup> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(TaxGroup taxGroup, String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)TaxGroup.PROP_NAME, (Object)string).ignoreCase());
            if (taxGroup.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)TaxGroup.PROP_ID, (Object)taxGroup.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxGroup> findAllUnSyncTaxGroup() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression simpleExpression = Restrictions.eq((String)TaxGroup.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)TaxGroup.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void saveOrUpdateTaxGroups(List<TaxGroup> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (TaxGroup taxGroup : list) {
                ArrayList<Tax> arrayList = new ArrayList<Tax>();
                if (taxGroup.getTaxes() != null) {
                    for (Tax tax : taxGroup.getTaxes()) {
                        Tax tax2 = TaxDAO.getInstance().get(tax.getId());
                        if (arrayList == null) continue;
                        arrayList.add(tax2);
                    }
                }
                taxGroup.setTaxes(arrayList);
                TaxGroup taxGroup2 = this.get(taxGroup.getId());
                if (taxGroup2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(taxGroup.getLastUpdateTime(), taxGroup2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), taxGroup.getName() + " already updated");
                        continue;
                    }
                    long l = taxGroup2.getVersion();
                    PropertyUtils.copyProperties((Object)taxGroup2, (Object)taxGroup);
                    taxGroup2.setVersion(l);
                    taxGroup2.setUpdateLastUpdateTime(bl);
                    taxGroup2.setUpdateSyncTime(bl2);
                    this.update(taxGroup2, session);
                    continue;
                }
                taxGroup.setUpdateLastUpdateTime(bl);
                taxGroup.setUpdateSyncTime(bl2);
                this.save(taxGroup, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

