/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.dao._RootDAO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.TimeLimitExceededException;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;

public abstract class _BaseRootDAO {
    protected static Map<String, SessionFactory> sessionFactoryMap;
    protected static SessionFactory sessionFactory;
    protected static ThreadLocal<Map> mappedSessions;
    protected static ThreadLocal<Session> sessions;

    public static void initialize() {
        _RootDAO.initialize((String)null);
    }

    public static void initialize(String string) {
        _RootDAO.initialize(string, _RootDAO.getNewConfiguration(null));
    }

    public static void initialize(String string, Configuration configuration) {
        if (null == string && null != sessionFactory) {
            return;
        }
        if (null != sessionFactoryMap && null != sessionFactoryMap.get(string)) {
            return;
        }
        if (null == string) {
            configuration.configure();
            _RootDAO.setSessionFactory(configuration.buildSessionFactory());
        } else {
            configuration.configure(string);
            _RootDAO.setSessionFactory(string, configuration.buildSessionFactory());
        }
    }

    public static void setSessionFactory(SessionFactory sessionFactory) {
        _BaseRootDAO.setSessionFactory(null, sessionFactory);
    }

    public static void setSessionFactory(String string, SessionFactory sessionFactory) {
        if (null == string) {
            _BaseRootDAO.sessionFactory = sessionFactory;
        } else {
            if (null == sessionFactoryMap) {
                sessionFactoryMap = new HashMap<String, SessionFactory>();
            }
            sessionFactoryMap.put(string, _BaseRootDAO.sessionFactory);
        }
    }

    protected SessionFactory getSessionFactory() {
        return this.getSessionFactory(this.getConfigurationFileName());
    }

    protected SessionFactory getSessionFactory(String string) {
        if (null == string) {
            if (null == sessionFactory) {
                throw new RuntimeException("The session factory has not been initialized (or an error occured during initialization)");
            }
            return sessionFactory;
        }
        if (null == sessionFactoryMap) {
            throw new RuntimeException("The session factory for '" + string + "' has not been initialized (or an error occured during initialization)");
        }
        SessionFactory sessionFactory = sessionFactoryMap.get(string);
        if (null == sessionFactory) {
            throw new RuntimeException("The session factory for '" + string + "' has not been initialized (or an error occured during initialization)");
        }
        return sessionFactory;
    }

    public Session getSession() {
        return this.getSession(this.getConfigurationFileName(), false);
    }

    public Session createNewSession() {
        return this.getSession(this.getConfigurationFileName(), true);
    }

    protected Session getSession(String string, boolean bl) {
        Session session;
        HashMap<String, Session> hashMap;
        if (bl) {
            return this.getSessionFactory(string).openSession();
        }
        if (null == string) {
            Session session2;
            if (null == sessions) {
                sessions = new ThreadLocal();
            }
            if (null == (session2 = sessions.get()) || !session2.isOpen()) {
                session2 = this.getSessionFactory(null).openSession();
                sessions.set(session2);
            }
            return session2;
        }
        if (null == mappedSessions) {
            mappedSessions = new ThreadLocal();
        }
        if (null == (hashMap = mappedSessions.get())) {
            hashMap = new HashMap<String, Session>(1);
            mappedSessions.set(hashMap);
        }
        if (null == (session = (Session)hashMap.get(string)) || !session.isOpen()) {
            session = this.getSessionFactory(string).openSession();
            hashMap.put(string, session);
        }
        return session;
    }

    public static void closeCurrentThreadSessions() {
        Object object;
        if (null != sessions && null != (object = sessions.get()) && object.isOpen()) {
            object.close();
            sessions.set(null);
        }
        if (null != mappedSessions && null != (object = mappedSessions.get())) {
            HibernateException hibernateException = null;
            for (Session session : object.values()) {
                try {
                    if (null == session || !session.isOpen()) continue;
                    session.close();
                }
                catch (HibernateException hibernateException2) {
                    hibernateException = hibernateException2;
                }
            }
            object.clear();
            if (null != hibernateException) {
                throw hibernateException;
            }
        }
    }

    public void closeSession(Session session) {
        try {
            if (null != session) {
                session.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Transaction beginTransaction(Session session) {
        return session.beginTransaction();
    }

    public void commitTransaction(Transaction transaction) {
        transaction.commit();
    }

    public static Configuration getNewConfiguration(String string) {
        return new Configuration();
    }

    public String getConfigurationFileName() {
        return null;
    }

    protected abstract Class getReferenceClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object get(Class clazz, Serializable serializable) {
        Session session = null;
        try {
            session = this.getSession();
            Object object = this.get(clazz, serializable, session);
            return object;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Object get(Class clazz, Serializable serializable, Session session) {
        return session.get(clazz, serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object load(Class clazz, Serializable serializable) {
        Session session = null;
        try {
            session = this.getSession();
            Object object = this.load(clazz, serializable, session);
            return object;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Object load(Class clazz, Serializable serializable, Session session) {
        return session.load(clazz, serializable);
    }

    public List findAll() {
        Session session = null;
        try {
            session = this.getSession();
            List list = this.findAll(session);
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List findAll(Session session) {
        return this.findAll(session, this.getDefaultOrder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAll(Order order) {
        Session session = null;
        try {
            session = this.getSession();
            List list = this.findAll(session, order);
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List findAll(Session session, Order order) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        if (null != order) {
            criteria.addOrder(order);
        }
        return criteria.list();
    }

    protected Criteria findFiltered(String string, Object object) {
        return this.findFiltered(string, object, this.getDefaultOrder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Criteria findFiltered(String string, Object object, Order order) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = this.findFiltered(session, string, object, order);
            return criteria;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Criteria findFiltered(Session session, String string, Object object, Order order) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Expression.eq((String)string, (Object)object));
        if (null != order) {
            criteria.addOrder(order);
        }
        return criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query getNamedQuery(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Query query = this.getNamedQuery(string, session);
            return query;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Query getNamedQuery(String string, Session session) {
        Query query = session.getNamedQuery(string);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query getNamedQuery(String string, Serializable serializable) {
        Session session = null;
        try {
            session = this.getSession();
            Query query = this.getNamedQuery(string, serializable, session);
            return query;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Query getNamedQuery(String string, Serializable serializable, Session session) {
        Query query = session.getNamedQuery(string);
        query.setParameter(0, (Object)serializable);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query getNamedQuery(String string, Serializable[] serializableArray) {
        Session session = null;
        try {
            session = this.getSession();
            Query query = this.getNamedQuery(string, serializableArray, session);
            return query;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Query getNamedQuery(String string, Serializable[] serializableArray, Session session) {
        Query query = session.getNamedQuery(string);
        if (null != serializableArray) {
            for (int i = 0; i < serializableArray.length; ++i) {
                query.setParameter(i, (Object)serializableArray[i]);
            }
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query getNamedQuery(String string, Map map) {
        Session session = null;
        try {
            session = this.getSession();
            Query query = this.getNamedQuery(string, map, session);
            return query;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Query getNamedQuery(String string, Map map, Session session) {
        Query query = session.getNamedQuery(string);
        if (null != map) {
            for (Map.Entry entry : map.entrySet()) {
                query.setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query getQuery(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Query query = this.getQuery(string, session);
            return query;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Query getQuery(String string, Session session) {
        return session.createQuery(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query getQuery(String string, Serializable serializable) {
        Session session = null;
        try {
            session = this.getSession();
            Query query = this.getQuery(string, serializable, session);
            return query;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Query getQuery(String string, Serializable serializable, Session session) {
        Query query = this.getQuery(string, session);
        query.setParameter(0, (Object)serializable);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query getQuery(String string, Serializable[] serializableArray) {
        Session session = null;
        try {
            session = this.getSession();
            Query query = this.getQuery(string, serializableArray, session);
            return query;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Query getQuery(String string, Serializable[] serializableArray, Session session) {
        Query query = this.getQuery(string, session);
        if (null != serializableArray) {
            for (int i = 0; i < serializableArray.length; ++i) {
                query.setParameter(i, (Object)serializableArray[i]);
            }
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query getQuery(String string, Map map) {
        Session session = null;
        try {
            session = this.getSession();
            Query query = this.getQuery(string, map, session);
            return query;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Query getQuery(String string, Map map, Session session) {
        Query query = this.getQuery(string, session);
        if (null != map) {
            for (Map.Entry entry : map.entrySet()) {
                query.setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        return query;
    }

    protected Order getDefaultOrder() {
        return null;
    }

    protected Serializable save(final Object object) {
        return (Serializable)this.run(new TransactionRunnable(){

            @Override
            public Object run(Session session) {
                return _BaseRootDAO.this.save(object, session);
            }
        });
    }

    protected Serializable save(Object object, Session session) {
        return session.save(object);
    }

    protected void saveOrUpdate(final Object object) {
        this.run(new TransactionRunnable(){

            @Override
            public Object run(Session session) {
                _BaseRootDAO.this.saveOrUpdate(object, session);
                return null;
            }
        });
    }

    protected void saveOrUpdate(Object object, Session session) {
        session.saveOrUpdate(object);
    }

    protected void update(final Object object) {
        this.run(new TransactionRunnable(){

            @Override
            public Object run(Session session) {
                _BaseRootDAO.this.update(object, session);
                return null;
            }
        });
    }

    protected void update(Object object, Session session) {
        session.update(object);
    }

    protected int delete(final Query query) {
        Integer n = (Integer)this.run(new TransactionRunnable(){

            @Override
            public Object run(Session session) {
                return new Integer(_BaseRootDAO.this.delete(query, session));
            }
        });
        return n;
    }

    protected int delete(Query query, Session session) {
        List list = query.list();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.delete(iterator.next(), session);
        }
        return list.size();
    }

    protected void delete(final Object object) {
        this.run(new TransactionRunnable(){

            @Override
            public Object run(Session session) {
                _BaseRootDAO.this.delete(object, session);
                return null;
            }
        });
    }

    protected void delete(Object object, Session session) {
        session.delete(object);
    }

    protected void refresh(Object object, Session session) {
        session.refresh(object);
    }

    protected void throwException(Throwable throwable) {
        if (throwable instanceof HibernateException) {
            throw (HibernateException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new HibernateException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object run(TransactionRunnable transactionRunnable) {
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.getSession();
            transaction = this.beginTransaction(session);
            Object object = transactionRunnable.run(session);
            this.commitTransaction(transaction);
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable) {
            if (null != transaction) {
                try {
                    transaction.rollback();
                }
                catch (HibernateException hibernateException) {
                    this.handleError(hibernateException);
                }
            }
            if (transactionRunnable instanceof TransactionFailHandler) {
                try {
                    ((TransactionFailHandler)((Object)transactionRunnable)).onFail(session);
                }
                catch (Throwable throwable2) {
                    this.handleError(throwable2);
                }
            }
            this.throwException(throwable);
            Object var5_9 = null;
            return var5_9;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TransactionPointer runAsnyc(TransactionRunnable transactionRunnable) {
        TransactionPointer transactionPointer = new TransactionPointer(transactionRunnable);
        ThreadRunner threadRunner = new ThreadRunner(transactionPointer);
        threadRunner.start();
        return transactionPointer;
    }

    protected void handleError(Throwable throwable) {
    }

    private class ThreadRunner
    extends Thread {
        private TransactionPointer transactionPointer;

        public ThreadRunner(TransactionPointer transactionPointer) {
            this.transactionPointer = transactionPointer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Transaction transaction = null;
            Session session = null;
            try {
                session = _BaseRootDAO.this.getSession();
                transaction = _BaseRootDAO.this.beginTransaction(session);
                Object object = this.transactionPointer.getTransactionRunnable().run(session);
                transaction.commit();
                this.transactionPointer.setReturnValue(object);
            }
            catch (Throwable throwable) {
                if (null != transaction) {
                    try {
                        transaction.rollback();
                    }
                    catch (HibernateException hibernateException) {
                        _BaseRootDAO.this.handleError(hibernateException);
                    }
                }
                if (this.transactionPointer.getTransactionRunnable() instanceof TransactionFailHandler) {
                    try {
                        ((TransactionFailHandler)((Object)this.transactionPointer.getTransactionRunnable())).onFail(session);
                    }
                    catch (Throwable throwable2) {
                        _BaseRootDAO.this.handleError(throwable2);
                    }
                }
                this.transactionPointer.setThrownException(throwable);
            }
            finally {
                this.transactionPointer.complete();
                try {
                    _BaseRootDAO.this.closeSession(session);
                }
                catch (HibernateException hibernateException) {
                    this.transactionPointer.setThrownException(hibernateException);
                }
            }
        }
    }

    public class TransactionPointer {
        private TransactionRunnable transactionRunnable;
        private Throwable thrownException;
        private Object returnValue;
        private boolean hasCompleted = false;

        public TransactionPointer(TransactionRunnable transactionRunnable) {
            this.transactionRunnable = transactionRunnable;
        }

        public boolean hasCompleted() {
            return this.hasCompleted;
        }

        public void complete() {
            this.hasCompleted = true;
        }

        public Object getReturnValue() {
            return this.returnValue;
        }

        public void setReturnValue(Object object) {
            this.returnValue = object;
        }

        public Throwable getThrownException() {
            return this.thrownException;
        }

        public void setThrownException(Throwable throwable) {
            this.thrownException = throwable;
        }

        public TransactionRunnable getTransactionRunnable() {
            return this.transactionRunnable;
        }

        public void setTransactionRunnable(TransactionRunnable transactionRunnable) {
            this.transactionRunnable = transactionRunnable;
        }

        public Object waitUntilFinish(long l) throws Throwable {
            long l2 = -1L;
            if (l > 0L) {
                l2 = System.currentTimeMillis() + l;
            }
            do {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.hasCompleted && (l2 > 0L && System.currentTimeMillis() < l2 || l2 <= 0L));
            if (!this.hasCompleted) {
                throw new TimeLimitExceededException();
            }
            if (null != this.thrownException) {
                throw this.thrownException;
            }
            return this.returnValue;
        }
    }

    public abstract class TransactionRunnableFailHandler
    extends TransactionRunnable
    implements TransactionFailHandler {
    }

    public static interface TransactionFailHandler {
        public void onFail(Session var1);
    }

    public abstract class TransactionRunnable {
        public abstract Object run(Session var1) throws Exception;
    }
}

