/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.PrinterIsNotConfiguredException;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Printer;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.TipsCashoutReportTableModel;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.services.report.ServerSummaryReportService;
import com.floreantpos.services.report.StoreSessionSummaryReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import java.awt.print.PrinterAbortException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PosPrintService {
    private static final SimpleDateFormat a = new SimpleDateFormat("dd MMM, yyyy hh:mm aaa");
    private static Log b = LogFactory.getLog(PosPrintService.class);

    @Deprecated
    public static void printDrawerPullReport(CashDrawer cashDrawer) throws Exception {
        try {
            JasperPrint jasperPrint = PosPrintService.populateDrawerPullReportParameters(cashDrawer);
            PosPrintService.printReportByJasperPrint(jasperPrint);
        }
        catch (PrinterIsNotConfiguredException printerIsNotConfiguredException) {
            throw printerIsNotConfiguredException;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printCashDrawerSummaryReport(CashDrawer cashDrawer) {
        try {
            JasperPrint jasperPrint = PosPrintService.populateStoreSessionSummaryReportParameters(cashDrawer);
            PosPrintService.printReportByJasperPrint(jasperPrint);
        }
        catch (PrinterIsNotConfiguredException printerIsNotConfiguredException) {
            throw printerIsNotConfiguredException;
        }
        catch (PrinterAbortException printerAbortException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printServerSummaryReport(User user, StoreSession storeSession) throws Exception {
        List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
        if (list == null || list.isEmpty()) {
            throw new PrinterIsNotConfiguredException(Messages.getString("PosPrintService.11"));
        }
        ServerSummaryReportService serverSummaryReportService = new ServerSummaryReportService(user, storeSession);
        CashDrawer cashDrawer = serverSummaryReportService.populateServerSummaryReport();
        HashMap hashMap = PosPrintService.populateServerSummaryReportParams(cashDrawer);
        for (Printer printer : list) {
            String string = printer.getDeviceName();
            if (string == null) continue;
            ReceiptPrintService.setPrintProperty(hashMap, printer);
            ReceiptPrintService.getReceiptPrintServiceProvider(printer).printServerSummaryReport(cashDrawer, hashMap, string);
        }
    }

    public static void showServerSummaryReport(User user, StoreSession storeSession, JPanel jPanel) throws Exception {
        ServerSummaryReportService serverSummaryReportService = new ServerSummaryReportService(user, storeSession);
        CashDrawer cashDrawer = serverSummaryReportService.populateServerSummaryReport();
        HashMap hashMap = PosPrintService.populateServerSummaryReportParams(cashDrawer);
        ReceiptPrintService.getMainReceiptPrintPreviewService().showServerSummaryReport(cashDrawer, hashMap, jPanel);
    }

    public static void printCashDrawerReport(CashDrawer cashDrawer) throws Exception {
        List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
        if (list == null || list.isEmpty()) {
            throw new PrinterIsNotConfiguredException(Messages.getString("PosPrintService.11"));
        }
        CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(cashDrawer);
        cashDrawerReportService.populateReport();
        HashMap hashMap = PosPrintService.populateCashDrawerReportParams(cashDrawer);
        for (Printer printer : list) {
            String string = printer.getDeviceName();
            if (string == null) continue;
            ReceiptPrintService.setPrintProperty(hashMap, printer);
            ReceiptPrintService.getReceiptPrintServiceProvider(printer).printCashDrawerReport(cashDrawer, hashMap, string);
        }
    }

    public static void showCashDrawerReport(CashDrawer cashDrawer, JPanel jPanel) throws Exception {
        CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(cashDrawer);
        cashDrawerReportService.populateReport();
        HashMap hashMap = PosPrintService.populateCashDrawerReportParams(cashDrawer);
        ReceiptPrintService.getMainReceiptPrintPreviewService().showCashDrawerReport(cashDrawer, hashMap, jPanel);
    }

    public static void printStoreSessionSummaryReport(CashDrawer cashDrawer) throws Exception {
        List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
        if (list == null || list.isEmpty()) {
            throw new PrinterIsNotConfiguredException(Messages.getString("PosPrintService.11"));
        }
        HashMap hashMap = PosPrintService.populateStoreSessionSummaryReportParams(cashDrawer);
        for (Printer printer : list) {
            String string = printer.getDeviceName();
            if (string == null) continue;
            ReceiptPrintService.setPrintProperty(hashMap, printer);
            ReceiptPrintService.getReceiptPrintServiceProvider(printer).printStoreSessionSummaryReport(cashDrawer, hashMap, string);
        }
    }

    public static void showStoreSessionSummaryReport(CashDrawer cashDrawer, JPanel jPanel) throws Exception {
        HashMap<String, Object> hashMap = PosPrintService.populateStoreSessionSummaryReportParams(cashDrawer, Messages.getString("StoreSessionReportAction.1"));
        ReceiptPrintService.getMainReceiptPrintPreviewService().showStoreSessionSummaryReport(cashDrawer, hashMap, jPanel);
    }

    public static void printReportByJasperPrint(JasperPrint jasperPrint) {
        try {
            List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
            if (list == null || list.isEmpty()) {
                throw new PrinterIsNotConfiguredException(Messages.getString("PosPrintService.11"));
            }
            boolean bl = false;
            for (Printer printer : list) {
                String string = printer.getDeviceName();
                if (StringUtils.isEmpty((CharSequence)string)) continue;
                bl = true;
                jasperPrint.setProperty("printerName", string);
                ReceiptPrintService.printQuitely(jasperPrint);
            }
            if (!bl) {
                throw new PrinterIsNotConfiguredException(Messages.getString("PosPrintService.11"));
            }
        }
        catch (PrinterIsNotConfiguredException printerIsNotConfiguredException) {
            throw printerIsNotConfiguredException;
        }
        catch (Exception exception) {
            PosLog.error(PosPrintService.class, exception);
        }
    }

    public static void printServerTipsReport(TipsCashoutReport tipsCashoutReport) {
        try {
            JasperPrint jasperPrint = PosPrintService.createServerTipsReport(tipsCashoutReport);
            PosPrintService.printReportByJasperPrint(jasperPrint);
        }
        catch (Exception exception) {
            PosLog.error(PosPrintService.class, exception);
            b.error((Object)"error print tips report", (Throwable)exception);
        }
    }

    public static JasperPrint createServerTipsReport(TipsCashoutReport tipsCashoutReport) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("server", tipsCashoutReport.getServer());
        if (tipsCashoutReport.getFromDate() != null) {
            hashMap.put("fromDate", Application.formatDate(tipsCashoutReport.getFromDate()));
        }
        if (tipsCashoutReport.getToDate() != null) {
            hashMap.put("toDate", Application.formatDate(tipsCashoutReport.getToDate()));
        }
        hashMap.put("reportDate", new SimpleDateFormat("dd MMM yyyy, hh:mm aaa").format(tipsCashoutReport.getReportTime()));
        hashMap.put("transactionCount", tipsCashoutReport.getDatas() == null ? "0" : "" + tipsCashoutReport.getDatas().size());
        hashMap.put("cashTips", NumberUtil.getCurrencyFormat(tipsCashoutReport.getCashTipsAmount()));
        hashMap.put("chargedTips", NumberUtil.getCurrencyFormat(tipsCashoutReport.getChargedTipsAmount()));
        hashMap.put("declaredTips", tipsCashoutReport.getDeclaredTipsAmount());
        hashMap.put("tipsDue", tipsCashoutReport.getTipsDue());
        hashMap.put("tokenNoTitle", Messages.getString("PosPrintService.7"));
        hashMap.put("ticketTotalTitle", Messages.getString("PosPrintService.15"));
        hashMap.put("totalChargedTipsTitle", Messages.getString("PosPrintService.20"));
        hashMap.put("totalCashTipsTitle", Messages.getString("PosPrintService.23"));
        hashMap.put("totalTipsPaidTitle", Messages.getString("PosPrintService.28"));
        hashMap.put(Messages.getString("PosPrintService.29"), Messages.getString("PosPrintService.30"));
        hashMap.put("serverTitle", Messages.getString("PosPrintService.32"));
        hashMap.put("reportTimeTitle", Messages.getString("PosPrintService.34"));
        hashMap.put("transCountTitle", Messages.getString("PosPrintService.38"));
        hashMap.put("cashTipsTitle", Messages.getString("PosPrintService.40"));
        hashMap.put("chargedTipsTitle", Messages.getString("PosPrintService.42"));
        hashMap.put("declaredTipsTitle", Messages.getString("PosPrintService.44"));
        hashMap.put("totalTipsTitle", Messages.getString("PosPrintService.46"));
        hashMap.put("bottomDeclaredTipsTitle", "-" + Messages.getString("PosPrintService.51"));
        hashMap.put("bottomPaidTipsTitle", "-" + Messages.getString("PosPrintService.54"));
        hashMap.put("bottomTipsDueTitle", Messages.getString("PosPrintService.56"));
        hashMap.put("currency", CurrencyUtil.getCurrencySymbol());
        Store store = StoreDAO.getRestaurant();
        ReportUtil.populatePatternExpression(hashMap, store);
        hashMap.put("headerLine1", store.getName());
        JasperReport jasperReport = ReportUtil.getReport("ServerTipsReport");
        JRTableModelDataSource jRTableModelDataSource = new JRTableModelDataSource((TableModel)new TipsCashoutReportTableModel(tipsCashoutReport.getDatas(), new String[]{"ticketId", "saleType", "ticketTotal", "tips", "chargedTips", "tipsPaid"}));
        return JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)jRTableModelDataSource);
    }

    public static JasperPrint populateDrawerPullReportParameters(CashDrawer cashDrawer) throws Exception {
        String string;
        boolean bl = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        ReportUtil.populatePatternExpression(hashMap, store);
        hashMap.put("headerLine1", store.getName());
        hashMap.put("reportTitle", bl ? "Staff bank report" : "Cash drawer report");
        PosPrintService.a(hashMap);
        hashMap.put("IS_IGNORE_PAGINATION", true);
        User user = cashDrawer.getAssignedUser();
        if (user != null) {
            string = user.getFullName();
            hashMap.put("user", (bl ? "Staff: " : Messages.getString("PosPrintService.4") + " ") + string);
        }
        if (cashDrawer.getStartTime() != null) {
            hashMap.put("startTime", Messages.getString("PosPrintService.12") + a.format(cashDrawer.getStartTime()));
        }
        hashMap.put("date", Messages.getString("PosPrintService.13") + a.format(new Date()));
        hashMap.put("totalVoid", cashDrawer.getTotalVoid());
        hashMap.put("declaredTips", cashDrawer.getDeclaredTips());
        string = ReportUtil.getReport("drawer-currency-balance");
        JasperReport jasperReport = ReportUtil.getReport("drawer-pull-void-veport");
        hashMap.put("currencyBalanceReport", string);
        hashMap.put("subreportParameter", jasperReport);
        JasperReport jasperReport2 = ReportUtil.getReport("terminal_status_report");
        JRBeanCollectionDataSource jRBeanCollectionDataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport2, hashMap, (JRDataSource)jRBeanCollectionDataSource);
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        jasperPrint.setName("DrawerPullReport" + cashDrawer.getId());
        return jasperPrint;
    }

    @Deprecated
    public static JasperPrint populateStoreSessionSummaryReportParameters(CashDrawer cashDrawer) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        ReportUtil.populatePatternExpression(hashMap, store);
        hashMap.put("headerLine1", store.getName());
        hashMap.put("reportTitle", ReportUtil.reportLabelWithBoldTag(Messages.getString("StoreSessionReportTitle")));
        hashMap.put("salesBalance", Messages.getString("SALES_BALANCE"));
        hashMap.put("rowNetSales", POSConstants.NET_SALES);
        hashMap.put("rowDiscount", "-" + POSConstants.DISCOUNT);
        hashMap.put("rowSalesTax", "+" + POSConstants.SALES_TAX);
        hashMap.put("rowSC", "+" + POSConstants.SERVICE_CHARGE);
        hashMap.put("rowTotal", "=" + POSConstants.TOTAL);
        hashMap.put("rowTips", "+" + POSConstants.TIPS);
        hashMap.put("rowGReceivable", "=" + Messages.getString("grossReceivable"));
        hashMap.put("rowCReceipts", "-" + Messages.getString("cashReceipts"));
        hashMap.put("rowCCards", "-" + Messages.getString("creditCards"));
        hashMap.put("rowDCards", "-" + Messages.getString("debitCards"));
        hashMap.put("rowMPayments", "-" + Messages.getString("memberPayments"));
        hashMap.put("rowCPayments", "-" + Messages.getString("customPayments"));
        hashMap.put("rowGCert", "-" + Messages.getString("giftCertificate"));
        hashMap.put("rowRefundPlus", "+" + POSConstants.REFUND_BUTTON_TEXT);
        hashMap.put("rowTolerance", "+" + Messages.getString("CurrencyExplorer.8"));
        hashMap.put("rowReceiptDiff", "=" + Messages.getString("receiptDifferential"));
        hashMap.put("rowCashTips", "+" + Messages.getString("TipsCashoutReportTableModel.9"));
        hashMap.put("rowChargedTips", "+" + Messages.getString("chargedTips"));
        hashMap.put("rowTipsPaid", "-" + Messages.getString("TipsCashoutReportTableModel.5"));
        hashMap.put("rowTipsDiff", "=" + Messages.getString("tipsDiff"));
        hashMap.put("cashBalance", Messages.getString("CASH_BALANCE"));
        hashMap.put("rowCash", POSConstants.CASH);
        hashMap.put("rowTipsPaid", "-" + Messages.getString("TipsCashoutReportTableModel.5"));
        hashMap.put("rowPayOut", "-" + Messages.getString("UserPermission.13"));
        hashMap.put("rowRefundMinus", "-" + POSConstants.REFUND_BUTTON_TEXT);
        hashMap.put("rowBeginCash", "+" + Messages.getString("beginCash"));
        hashMap.put("rowDBleed", "-" + Messages.getString("CashDropDialog.2"));
        hashMap.put("rowDAcc", "=" + Messages.getString("drawerAccountable"));
        hashMap.put("rowDTips", ">" + Messages.getString("declaredTips"));
        hashMap.put("IS_IGNORE_PAGINATION", true);
        hashMap.put("startTime", Messages.getString("PosPrintService.14") + a.format(cashDrawer.getStartTime()));
        hashMap.put("user", Messages.getString("PosPrintService.16") + cashDrawer.getAssignedBy());
        if (cashDrawer.getReportTime() != null) {
            hashMap.put("date", Messages.getString("PosPrintService.17") + a.format(cashDrawer.getReportTime()));
            hashMap.put("reportUser", Messages.getString("PosPrintService.18") + cashDrawer.getClosedBy());
        }
        hashMap.put("totalVoid", cashDrawer.getTotalVoid());
        hashMap.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport jasperReport = ReportUtil.getReport("drawer-currency-balance");
        JasperReport jasperReport2 = ReportUtil.getReport("drawer-pull-void-veport");
        hashMap.put("currencyBalanceReport", jasperReport);
        hashMap.put("subreportParameter", jasperReport2);
        JasperReport jasperReport3 = ReportUtil.getReport("store-session-summary-report_72");
        JRBeanCollectionDataSource jRBeanCollectionDataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport3, hashMap, (JRDataSource)jRBeanCollectionDataSource);
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        jasperPrint.setName("StoreSessionSummaryReport");
        return jasperPrint;
    }

    public static JasperPrint createStoreSessionSummaryReportPrint(CashDrawer cashDrawer, HashMap<String, Object> hashMap) throws Exception {
        JasperReport jasperReport = ReportUtil.getReport("drawer-currency-balance");
        JasperReport jasperReport2 = ReportUtil.getReport("drawer-pull-void-veport");
        JasperReport jasperReport3 = ReportUtil.getReport("category-break-out-sub-report");
        hashMap.put("currencyBalanceReport", jasperReport);
        hashMap.put("subreportParameter", jasperReport2);
        hashMap.put("catBreakOutSubReport", jasperReport3);
        JasperReport jasperReport4 = ReportUtil.getReport("store-session-summary-report_72");
        JRBeanCollectionDataSource jRBeanCollectionDataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport4, hashMap, (JRDataSource)jRBeanCollectionDataSource);
        jasperPrint.setName("StoreSessionSummaryReport");
        return jasperPrint;
    }

    public static HashMap populateStoreSessionSummaryReportParams(CashDrawer cashDrawer) throws Exception {
        return PosPrintService.populateStoreSessionSummaryReportParams(cashDrawer, ReportUtil.reportLabelWithBoldTag(Messages.getString("StoreSessionReportAction.1")));
    }

    public static HashMap<String, Object> populateStoreSessionSummaryReportParams(CashDrawer cashDrawer, String string) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        ReportUtil.populatePatternExpression(hashMap, store);
        hashMap.put("headerLine1", store.getName());
        hashMap.put("reportTitle", string);
        hashMap.put("salesBalance", Messages.getString("SALES_BALANCE"));
        hashMap.put("rowNetSales", "=" + POSConstants.NET_SALES);
        hashMap.put("rowDiscount", "-" + POSConstants.DISCOUNT);
        hashMap.put("rowSalesTax", "+" + POSConstants.SALES_TAX);
        hashMap.put("rowSC", "+" + POSConstants.SERVICE_CHARGE);
        hashMap.put("rowTotal", "=" + POSConstants.TOTAL);
        hashMap.put("rowTips", "+" + POSConstants.TIPS);
        hashMap.put("rowGReceivable", "=" + Messages.getString("grossReceivable"));
        hashMap.put("rowCReceipts", "-" + Messages.getString("cashReceipts"));
        hashMap.put("rowCCards", "-" + Messages.getString("creditCards"));
        hashMap.put("rowDCards", "-" + Messages.getString("debitCards"));
        hashMap.put("rowMPayments", "-" + Messages.getString("PosPrintService.22"));
        hashMap.put("rowCPayments", "-" + Messages.getString("customPayments"));
        hashMap.put("rowGCert", "-" + Messages.getString("giftCertificate"));
        hashMap.put("rowRefundPlus", "+" + POSConstants.REFUND_BUTTON_TEXT);
        hashMap.put("rowTolerance", "+" + Messages.getString("CurrencyExplorer.8"));
        hashMap.put("rowReceiptDiff", "=" + Messages.getString("receiptDifferential"));
        hashMap.put("rowCashTips", "+" + Messages.getString("TipsCashoutReportTableModel.9"));
        hashMap.put("rowChargedTips", "+" + Messages.getString("chargedTips"));
        hashMap.put("rowTipsPaid", "-" + Messages.getString("TipsCashoutReportTableModel.5"));
        hashMap.put("rowTipsDiff", "=" + Messages.getString("tipsDiff"));
        hashMap.put("cashBalance", Messages.getString("CASH_BALANCE"));
        hashMap.put("rowCash", POSConstants.CASH);
        hashMap.put("rowTipsPaid", "-" + Messages.getString("TipsCashoutReportTableModel.5"));
        hashMap.put("rowPayOut", "-" + Messages.getString("UserPermission.13"));
        hashMap.put("rowRefundMinus", "-" + POSConstants.REFUND_BUTTON_TEXT);
        hashMap.put("rowBeginCash", "+" + Messages.getString("beginCash"));
        hashMap.put("rowCashIn", "+" + Messages.getString("cashIn"));
        hashMap.put("rowDBleed", "-" + Messages.getString("CashDropDialog.2"));
        hashMap.put("rowDAcc", "=" + Messages.getString("drawerAccountable"));
        hashMap.put("rowDTips", ">" + Messages.getString("declaredTips"));
        hashMap.put("rowFee", "+" + POSConstants.FEE_AMOUNT);
        hashMap.put("rowGrossSales", POSConstants.GROSS_SALES);
        hashMap.put("rowReturn", "-" + POSConstants.RETURN);
        hashMap.put("lblRounding", POSConstants.LABEL_ROUNDING);
        hashMap.put("roundingAmount", NumberUtil.format(cashDrawer.getRoundedAmount()));
        hashMap.put("IS_IGNORE_PAGINATION", true);
        hashMap.put("startTime", Messages.getString("PosPrintService.14") + a.format(cashDrawer.getStartTime()));
        hashMap.put("user", Messages.getString("PosPrintService.16") + cashDrawer.getAssignedBy());
        if (cashDrawer.getReportTime() != null) {
            hashMap.put("date", Messages.getString("PosPrintService.17") + a.format(cashDrawer.getReportTime()));
            hashMap.put("reportUser", Messages.getString("PosPrintService.18") + cashDrawer.getClosedBy());
        }
        hashMap.put("totalVoid", cashDrawer.getTotalVoid());
        hashMap.put("declaredTips", cashDrawer.getDeclaredTips());
        hashMap.put("TitleCatBreakOut", Messages.getString("CategoryBreakout"));
        return hashMap;
    }

    public static JasperPrint createCashDrawerReportPrint(CashDrawer cashDrawer, HashMap hashMap) throws Exception {
        JasperReport jasperReport = ReportUtil.getReport("drawer-currency-balance");
        hashMap.put("currencyBalanceReport", jasperReport);
        boolean bl = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        JasperReport jasperReport2 = null;
        jasperReport2 = bl ? ReportUtil.getReport("terminal_status_report_staffbank_72") : ReportUtil.getReport("terminal_status_report_72");
        JRBeanCollectionDataSource jRBeanCollectionDataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport2, (Map)hashMap, (JRDataSource)jRBeanCollectionDataSource);
        jasperPrint.setName("TerminalStatusReport" + cashDrawer.getTerminalId());
        return jasperPrint;
    }

    public static HashMap populateCashDrawerReportParams(CashDrawer cashDrawer) {
        Object object;
        boolean bl = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        ReportUtil.populatePatternExpression(hashMap, store);
        hashMap.put("headerLine1", store.getName());
        hashMap.put("reportTitle", bl ? Messages.getString("StaffBankReportTitle") : Messages.getString("CashDrawerReportTitle"));
        hashMap.put("salesBalance", Messages.getString("SALES_BALANCE"));
        hashMap.put("rowGrossReceipts", Messages.getString("grossReceipts"));
        hashMap.put("rowCReceipts", "-" + Messages.getString("cashReceipts"));
        hashMap.put("rowCCards", "-" + Messages.getString("creditCards"));
        hashMap.put("rowDCards", "-" + Messages.getString("debitCards"));
        hashMap.put("rowMPayments", "-" + Messages.getString("memberPayments"));
        hashMap.put("rowCPayments", "-" + Messages.getString("customPayments"));
        hashMap.put("rowGReturns", "-" + Messages.getString("giftReurns"));
        hashMap.put("rowGCChange", "-" + Messages.getString("giftCertChange"));
        hashMap.put("rowRefundPlus", "+" + POSConstants.REFUND_BUTTON_TEXT);
        hashMap.put("rowReceiptDiff", "=" + Messages.getString("receiptDifferential"));
        hashMap.put("rowCashTips", "+" + Messages.getString("TipsCashoutReportTableModel.9"));
        hashMap.put("rowChargedTips", "+" + Messages.getString("chargedTips"));
        if (bl && cashDrawer.isOpen()) {
            hashMap.put("rowTipsPaid", "-" + Messages.getString("PosPrintService.5"));
        } else if (bl && cashDrawer.isClosed()) {
            hashMap.put("rowTipsPaid", "-" + Messages.getString("TipsCashoutReportTableModel.5"));
        } else {
            hashMap.put("rowTipsPaid", "-" + Messages.getString("TipsCashoutReportTableModel.5"));
        }
        hashMap.put("rowTipsPaidByOtherTerminal", "(" + Messages.getString("PosPrintService.8") + ")");
        hashMap.put("rowTipsDiff", "=" + Messages.getString("tipsDiff"));
        hashMap.put("cashBalance", Messages.getString("CASH_BALANCE"));
        hashMap.put("rowCash", POSConstants.CASH);
        hashMap.put("rowPayOut", "-" + Messages.getString("UserPermission.13"));
        hashMap.put("rowRefundMinus", "-" + POSConstants.REFUND_BUTTON_TEXT);
        hashMap.put("rowBeginCash", "+" + Messages.getString("beginCash"));
        hashMap.put("rowCashIn", "+" + Messages.getString("cashIn"));
        hashMap.put("rowDBleed", "-" + Messages.getString("CashDropDialog.2"));
        hashMap.put("rowDAcc", "=" + Messages.getString("drawerAccountable"));
        hashMap.put("rowDTips", ">" + Messages.getString("declaredTips"));
        hashMap.put("rowCToDipo", ">" + Messages.getString("cashToDeposit"));
        hashMap.put("rowCBreakD", Messages.getString("CBreakDown"));
        hashMap.put("rowCSRAmount", POSConstants.AMOUNT);
        hashMap.put("rowVRExceptions", Messages.getString("VRExceptions"));
        hashMap.put("rowVRTax", Messages.getString("VRTax"));
        hashMap.put("rowVRAmount", POSConstants.AMOUNT);
        hashMap.put("rowVRTotal", POSConstants.TOTAL);
        hashMap.put("rowTotalTips", "=" + Messages.getString("PosPrintService.6"));
        hashMap.put("rowCashDueOrOwedToServer", cashDrawer.getDrawerAccountable() < 0.0 ? Messages.getString("PosPrintService.9") : Messages.getString("PosPrintService.10"));
        hashMap.put("IS_IGNORE_PAGINATION", true);
        User user = cashDrawer.getAssignedUser();
        if (user != null) {
            object = user.getFullName();
            hashMap.put("user", (bl ? Messages.getString("PosPrintService.21") : Messages.getString("PosPrintService.4") + " ") + (String)object);
        }
        if (cashDrawer.getStartTime() != null) {
            hashMap.put("startTime", Messages.getString("FROM_DATE") + a.format(cashDrawer.getStartTime()));
        }
        if ((object = cashDrawer.getReportTime()) != null) {
            hashMap.put("closeTime", Messages.getString("TO") + " " + a.format((Date)object));
        }
        hashMap.put("date", Messages.getString("PosPrintService.25") + a.format(new Date()));
        hashMap.put("totalVoid", cashDrawer.getTotalVoid());
        hashMap.put("declaredTips", cashDrawer.getDeclaredTips());
        return hashMap;
    }

    @Deprecated
    public static JasperPrint populateTerminalStatusReport(CashDrawer cashDrawer) throws Exception {
        boolean bl = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        ReportUtil.populatePatternExpression(hashMap, store);
        hashMap.put("headerLine1", store.getName());
        hashMap.put("reportTitle", bl ? Messages.getString("StaffBankReportTitle") : Messages.getString("CashDrawerReportTitle"));
        PosPrintService.a(hashMap);
        JasperPrint jasperPrint = PosPrintService.populateTerminalStatusReport(cashDrawer, bl, hashMap);
        return jasperPrint;
    }

    @Deprecated
    private static void a(HashMap hashMap) {
        hashMap.put("salesBalance", Messages.getString("SALES_BALANCE"));
        hashMap.put("rowGrossReceipts", Messages.getString("grossReceipts"));
        hashMap.put("rowCReceipts", "-" + Messages.getString("cashReceipts"));
        hashMap.put("rowCCards", "-" + Messages.getString("creditCards"));
        hashMap.put("rowDCards", "-" + Messages.getString("debitCards"));
        hashMap.put("rowMPayments", "-" + Messages.getString("memberPayments"));
        hashMap.put("rowCPayments", "-" + Messages.getString("customPayments"));
        hashMap.put("rowGReturns", "-" + Messages.getString("giftReurns"));
        hashMap.put("rowGCChange", "-" + Messages.getString("giftCertChange"));
        hashMap.put("rowRefundPlus", "+" + POSConstants.REFUND_BUTTON_TEXT);
        hashMap.put("rowReceiptDiff", "=" + Messages.getString("receiptDifferential"));
        hashMap.put("rowCashTips", "+" + Messages.getString("TipsCashoutReportTableModel.9"));
        hashMap.put("rowChargedTips", "+" + Messages.getString("chargedTips"));
        hashMap.put("rowTipsPaid", "-" + Messages.getString("TipsCashoutReportTableModel.5"));
        hashMap.put("rowTipsDiff", "=" + Messages.getString("tipsDiff"));
        hashMap.put("cashBalance", Messages.getString("CASH_BALANCE"));
        hashMap.put("rowCash", POSConstants.CASH);
        hashMap.put("rowTipsPaid", "-" + Messages.getString("TipsCashoutReportTableModel.5"));
        hashMap.put("rowPayOut", "-" + Messages.getString("UserPermission.13"));
        hashMap.put("rowRefundMinus", "-" + POSConstants.REFUND_BUTTON_TEXT);
        hashMap.put("rowBeginCash", "+" + Messages.getString("beginCash"));
        hashMap.put("rowDBleed", "-" + Messages.getString("CashDropDialog.2"));
        hashMap.put("rowDAcc", "=" + Messages.getString("drawerAccountable"));
        hashMap.put("rowDTips", ">" + Messages.getString("declaredTips"));
        hashMap.put("rowCToDipo", ">" + Messages.getString("cashToDeposit"));
        hashMap.put("rowCBreakD", Messages.getString("CBreakDown"));
        hashMap.put("rowCSRAmount", POSConstants.AMOUNT);
        hashMap.put("rowVRExceptions", Messages.getString("VRExceptions"));
        hashMap.put("rowVRTax", Messages.getString("VRTax"));
        hashMap.put("rowVRAmount", POSConstants.AMOUNT);
        hashMap.put("rowVRTotal", POSConstants.TOTAL);
    }

    public static JasperPrint createServerSummaryReportPrint(CashDrawer cashDrawer, HashMap hashMap) throws Exception {
        JasperReport jasperReport = ReportUtil.getReport("drawer-currency-balance");
        JasperReport jasperReport2 = ReportUtil.getReport("category-break-out-sub-report");
        hashMap.put("currencyBalanceReport", jasperReport);
        hashMap.put("catBreakOutSubReport", jasperReport2);
        JasperReport jasperReport3 = ReportUtil.getReport("server-summary-report_72");
        JRBeanCollectionDataSource jRBeanCollectionDataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport3, (Map)hashMap, (JRDataSource)jRBeanCollectionDataSource);
        jasperPrint.setName("ServerSummaryReport");
        return jasperPrint;
    }

    public static HashMap populateServerSummaryReportParams(CashDrawer cashDrawer) {
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        ReportUtil.populatePatternExpression(hashMap, store);
        hashMap.put("headerLine1", store.getName());
        hashMap.put("SSReportTitle", Messages.getString("SSReportTitle"));
        hashMap.put("salesBalance", Messages.getString("SALES_BALANCE"));
        hashMap.put("rowGrossSales", Messages.getString("Gross_Sales"));
        hashMap.put("TitleCatBreakOut", Messages.getString("CategoryBreakout"));
        hashMap.put("rowNetSales", "=" + POSConstants.NET_SALES);
        hashMap.put("rowDiscount", "-" + POSConstants.DISCOUNT);
        hashMap.put("rowReturn", "-" + Messages.getString("Return"));
        hashMap.put("rowSalesTax", "+" + POSConstants.SALES_TAX);
        hashMap.put("rowSC", "+" + POSConstants.SERVICE_CHARGE);
        hashMap.put("rowDC", "+" + POSConstants.RECEIPT_REPORT_DELIVERY_CHARGE_LABEL);
        hashMap.put("rowTotal", "=" + POSConstants.TOTAL);
        hashMap.put("rowTips", "+" + POSConstants.TIPS);
        hashMap.put("rowFee", "+" + POSConstants.FEE_AMOUNT);
        hashMap.put("rowGReceivable", "=" + Messages.getString("grossReceivable"));
        hashMap.put("rowCReceipts", "-" + Messages.getString("cashReceipts"));
        hashMap.put("rowCCards", "-" + Messages.getString("creditCards"));
        hashMap.put("rowDCards", "-" + Messages.getString("debitCards"));
        hashMap.put("rowMPayments", "-" + Messages.getString("memberPayments"));
        hashMap.put("rowCPayments", "-" + Messages.getString("customPayments"));
        hashMap.put("rowGCert", "-" + Messages.getString("giftCertificate"));
        hashMap.put("rowRefundPlus", "+" + POSConstants.REFUND_BUTTON_TEXT);
        hashMap.put("rowTolerance", "+" + Messages.getString("CurrencyExplorer.8"));
        hashMap.put("rowReceiptDiff", "=" + Messages.getString("receiptDifferential"));
        hashMap.put("rowCashTips", Messages.getString("TipsCashoutReportTableModel.9"));
        hashMap.put("rowChargedTips", Messages.getString("chargedTips"));
        hashMap.put("lblRounding", POSConstants.LABEL_ROUNDING);
        hashMap.put("roundingAmount", NumberUtil.formatNumber(cashDrawer.getRoundedAmount(), true));
        hashMap.put("IS_IGNORE_PAGINATION", true);
        User user = cashDrawer.getAssignedUser();
        if (user != null) {
            string = user.getFullName();
            hashMap.put("user", Messages.getString("PosPrintService.27") + string);
        }
        string = DateUtil.formatFullDateAndTimeAsString(cashDrawer.getStartTime());
        if (cashDrawer.getReportTime() != null) {
            hashMap.put("date", "<b>" + Messages.getString("FROM") + "</b> " + string + "<br><b>" + Messages.getString("TO") + "</b> " + DateUtil.formatFullDateAndTimeAsString(cashDrawer.getReportTime()));
        } else {
            hashMap.put("date", "<b>" + Messages.getString("FROM") + "</b> " + string + "<br><b>" + Messages.getString("TO") + "</b> " + DateUtil.formatFullDateAndTimeAsString(new Date()));
        }
        hashMap.put("totalVoid", cashDrawer.getTotalVoid());
        hashMap.put("declaredTips", cashDrawer.getDeclaredTips());
        return hashMap;
    }

    @Deprecated
    public static JasperPrint populateTerminalStatusReport(CashDrawer cashDrawer, boolean bl, HashMap hashMap) throws JRException {
        String string;
        hashMap.put("IS_IGNORE_PAGINATION", true);
        User user = cashDrawer.getAssignedUser();
        if (user != null) {
            string = user.getFullName();
            hashMap.put("user", (bl ? Messages.getString("PosPrintService.21") : Messages.getString("PosPrintService.4") + " ") + string);
        }
        if (cashDrawer.getStartTime() != null) {
            hashMap.put("startTime", Messages.getString("PosPrintService.24") + a.format(cashDrawer.getStartTime()));
        }
        hashMap.put("date", Messages.getString("PosPrintService.25") + a.format(new Date()));
        hashMap.put("totalVoid", cashDrawer.getTotalVoid());
        hashMap.put("declaredTips", cashDrawer.getDeclaredTips());
        string = ReportUtil.getReport("drawer-currency-balance");
        JasperReport jasperReport = ReportUtil.getReport("drawer-pull-void-veport");
        hashMap.put("currencyBalanceReport", string);
        hashMap.put("subreportParameter", jasperReport);
        JasperReport jasperReport2 = ReportUtil.getReport("terminal_status_report_72");
        JRBeanCollectionDataSource jRBeanCollectionDataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport2, (Map)hashMap, (JRDataSource)jRBeanCollectionDataSource);
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        jasperPrint.setName("TerminalStatusReport" + cashDrawer.getTerminalId());
        return jasperPrint;
    }

    public static CashDrawer populateCashDrawerReportSummary(List<CashDrawer> list) {
        CashDrawer cashDrawer = new CashDrawer();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (CashDrawer cashDrawer2 : list) {
                if (cashDrawer2.getReportTime() == null) {
                    try {
                        CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(cashDrawer2);
                        cashDrawerReportService.populateReport();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                arrayList.add(cashDrawer2.getId());
                cashDrawer.setBeginCash(cashDrawer.getBeginCash() + cashDrawer2.getBeginCash());
                cashDrawer.setNetSales(cashDrawer.getNetSales() + cashDrawer2.getNetSales());
                cashDrawer.setSalesTax(cashDrawer.getSalesTax() + cashDrawer2.getSalesTax());
                cashDrawer.setSalesDeliveryCharge(cashDrawer.getSalesDeliveryCharge() + cashDrawer2.getSalesDeliveryCharge());
                cashDrawer.setTotalVoid(cashDrawer.getTotalVoid() + cashDrawer2.getTotalVoid());
                cashDrawer.setTotalVoidWst(cashDrawer.getTotalVoidWst() + cashDrawer2.getTotalVoidWst());
                cashDrawer.setTipsPaid(cashDrawer.getTipsPaid() + cashDrawer2.getTipsPaid());
                cashDrawer.setTotalDiscountCount(cashDrawer.getTotalDiscountCount() + cashDrawer2.getTotalDiscountCount());
                cashDrawer.setTotalDiscountAmount(cashDrawer.getTotalDiscountAmount() + cashDrawer2.getTotalDiscountAmount());
                cashDrawer.setCashReceiptCount(cashDrawer.getCashReceiptCount() + cashDrawer2.getCashReceiptCount());
                cashDrawer.setCashReceiptAmount(cashDrawer.getCashReceiptAmount() + cashDrawer2.getCashReceiptAmount());
                cashDrawer.setCreditCardReceiptCount(cashDrawer.getCreditCardReceiptCount() + cashDrawer2.getCreditCardReceiptCount());
                cashDrawer.setCreditCardReceiptAmount(cashDrawer.getCreditCardReceiptAmount() + cashDrawer2.getCreditCardReceiptAmount());
                cashDrawer.setDebitCardReceiptCount(cashDrawer.getDebitCardReceiptCount() + cashDrawer2.getDebitCardReceiptCount());
                cashDrawer.setDebitCardReceiptAmount(cashDrawer.getDebitCardReceiptAmount() + cashDrawer2.getDebitCardReceiptAmount());
                cashDrawer.setGiftCertReturnCount(cashDrawer.getGiftCertReturnCount() + cashDrawer2.getGiftCertReturnCount());
                cashDrawer.setGiftCertReturnAmount(cashDrawer.getGiftCertReturnAmount() + cashDrawer2.getGiftCertReturnAmount());
                cashDrawer.setGiftCertChangeAmount(cashDrawer.getGiftCertChangeAmount() + cashDrawer2.getGiftCertChangeAmount());
                cashDrawer.setCustomPaymentCount(cashDrawer.getCustomPaymentCount() + cashDrawer2.getCustomPaymentCount());
                cashDrawer.setCustomPaymentAmount(cashDrawer.getCustomPaymentAmount() + cashDrawer2.getCustomPaymentAmount());
                cashDrawer.setRefundReceiptCount(cashDrawer.getRefundReceiptCount() + cashDrawer2.getRefundReceiptCount());
                cashDrawer.setRefundAmount(cashDrawer.getRefundAmount() + cashDrawer2.getRefundAmount());
                cashDrawer.setPayOutCount(cashDrawer.getPayOutCount() + cashDrawer2.getPayOutCount());
                cashDrawer.setPayOutAmount(cashDrawer.getPayOutAmount() + cashDrawer2.getPayOutAmount());
                cashDrawer.setDrawerBleedCount(cashDrawer.getDrawerBleedCount() + cashDrawer2.getDrawerBleedCount());
                cashDrawer.setDrawerBleedAmount(cashDrawer.getDrawerBleedAmount() + cashDrawer2.getDrawerBleedAmount());
                cashDrawer.setCashTips(cashDrawer.getCashTips() + cashDrawer2.getCashTips());
                cashDrawer.setChargedTips(cashDrawer.getChargedTips() + cashDrawer2.getChargedTips());
                cashDrawer.setCashBack(cashDrawer.getCashBack() + cashDrawer2.getCashBack());
                cashDrawer.setCashToDeposit(cashDrawer.getCashToDeposit() + cashDrawer2.getCashToDeposit());
                cashDrawer.setStoreSession(cashDrawer2.getStoreSession());
            }
        }
        cashDrawer.calculate();
        return cashDrawer;
    }

    @Deprecated
    public static void printCashDrawerReportSummary(StoreSession storeSession) {
        List<CashDrawer> list = CashDrawerDAO.getInstance().findByStoreOperationData(storeSession, false);
        CashDrawer cashDrawer = PosPrintService.populateCashDrawerReportSummary(list);
        cashDrawer.setStartTime(storeSession.getOpenTime());
        cashDrawer.setAssignedBy(storeSession.getOpenedBy());
        cashDrawer.setReportTime(storeSession.getCloseTime());
        cashDrawer.setClosedBy(storeSession.getClosedBy());
        PosPrintService.printCashDrawerSummaryReport(cashDrawer);
    }

    public static JasperPrint createSessionSummaryReportPrint(StoreSession storeSession) throws Exception {
        CashDrawer cashDrawer = StoreSessionSummaryReportService.createSessionSummaryReport(storeSession);
        JasperPrint jasperPrint = PosPrintService.populateStoreSessionSummaryReportParameters(cashDrawer);
        return jasperPrint;
    }

    public static void printStoreSessionSummaryReport(StoreSession storeSession) throws Exception {
        CashDrawer cashDrawer = StoreSessionSummaryReportService.createSessionSummaryReport(storeSession);
        try {
            PosPrintService.printStoreSessionSummaryReport(cashDrawer);
        }
        catch (PrinterIsNotConfiguredException printerIsNotConfiguredException) {
            POSMessageDialog.showError(Messages.getString("DrawerAndStaffBankReportDialog.14") + printerIsNotConfiguredException.getMessage());
        }
    }

    public static CashDrawer populateCloudCashDrawerReportSummary(List<CashDrawer> list) {
        CashDrawer cashDrawer = new CashDrawer();
        HashMap<String, CashBreakdown> hashMap = new HashMap<String, CashBreakdown>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (CashDrawer cashDrawer2 : list) {
                arrayList.add(cashDrawer2.getId());
                cashDrawer.setBeginCash(cashDrawer.getBeginCash() + cashDrawer2.getBeginCash());
                cashDrawer.setNetSales(cashDrawer.getNetSales() + cashDrawer2.getNetSales());
                cashDrawer.setSalesTax(cashDrawer.getSalesTax() + cashDrawer2.getSalesTax());
                cashDrawer.setSalesDeliveryCharge(cashDrawer.getSalesDeliveryCharge() + cashDrawer2.getSalesDeliveryCharge());
                cashDrawer.setTotalVoid(cashDrawer.getTotalVoid() + cashDrawer2.getTotalVoid());
                cashDrawer.setTotalVoidWst(cashDrawer.getTotalVoidWst() + cashDrawer2.getTotalVoidWst());
                cashDrawer.setTipsPaid(cashDrawer.getTipsPaid() + cashDrawer2.getTipsPaid());
                cashDrawer.setTotalDiscountCount(cashDrawer.getTotalDiscountCount() + cashDrawer2.getTotalDiscountCount());
                cashDrawer.setTotalDiscountAmount(cashDrawer.getTotalDiscountAmount() + cashDrawer2.getTotalDiscountAmount());
                cashDrawer.setCashReceiptCount(cashDrawer.getCashReceiptCount() + cashDrawer2.getCashReceiptCount());
                cashDrawer.setCashReceiptAmount(cashDrawer.getCashReceiptAmount() + cashDrawer2.getCashReceiptAmount());
                cashDrawer.setCreditCardReceiptCount(cashDrawer.getCreditCardReceiptCount() + cashDrawer2.getCreditCardReceiptCount());
                cashDrawer.setCreditCardReceiptAmount(cashDrawer.getCreditCardReceiptAmount() + cashDrawer2.getCreditCardReceiptAmount());
                cashDrawer.setDebitCardReceiptCount(cashDrawer.getDebitCardReceiptCount() + cashDrawer2.getDebitCardReceiptCount());
                cashDrawer.setDebitCardReceiptAmount(cashDrawer.getDebitCardReceiptAmount() + cashDrawer2.getDebitCardReceiptAmount());
                cashDrawer.setGiftCertReturnCount(cashDrawer.getGiftCertReturnCount() + cashDrawer2.getGiftCertReturnCount());
                cashDrawer.setGiftCertReturnAmount(cashDrawer.getGiftCertReturnAmount() + cashDrawer2.getGiftCertReturnAmount());
                cashDrawer.setGiftCertChangeAmount(cashDrawer.getGiftCertChangeAmount() + cashDrawer2.getGiftCertChangeAmount());
                cashDrawer.setCustomPaymentCount(cashDrawer.getCustomPaymentCount() + cashDrawer2.getCustomPaymentCount());
                cashDrawer.setCustomPaymentAmount(cashDrawer.getCustomPaymentAmount() + cashDrawer2.getCustomPaymentAmount());
                cashDrawer.setRefundReceiptCount(cashDrawer.getRefundReceiptCount() + cashDrawer2.getRefundReceiptCount());
                cashDrawer.setRefundAmount(cashDrawer.getRefundAmount() + cashDrawer2.getRefundAmount());
                cashDrawer.setPayOutCount(cashDrawer.getPayOutCount() + cashDrawer2.getPayOutCount());
                cashDrawer.setPayOutAmount(cashDrawer.getPayOutAmount() + cashDrawer2.getPayOutAmount());
                cashDrawer.setDrawerBleedCount(cashDrawer.getDrawerBleedCount() + cashDrawer2.getDrawerBleedCount());
                cashDrawer.setDrawerBleedAmount(cashDrawer.getDrawerBleedAmount() + cashDrawer2.getDrawerBleedAmount());
                cashDrawer.setCashTips(cashDrawer.getCashTips() + cashDrawer2.getCashTips());
                cashDrawer.setChargedTips(cashDrawer.getChargedTips() + cashDrawer2.getChargedTips());
                cashDrawer.setCashBack(cashDrawer.getCashBack() + cashDrawer2.getCashBack());
                cashDrawer.setCashToDeposit(cashDrawer.getCashToDeposit() + cashDrawer2.getCashToDeposit());
                List<CashBreakdown> list2 = cashDrawer2.getCashBreakdownList();
                if (list2 != null) {
                    for (CashBreakdown cashBreakdown : list2) {
                        CashBreakdown cashBreakdown2 = (CashBreakdown)hashMap.get(cashBreakdown.getCurrency().getName());
                        if (cashBreakdown2 == null) {
                            cashBreakdown2 = new CashBreakdown();
                            hashMap.put(cashBreakdown.getCurrency().getName(), cashBreakdown2);
                        }
                        cashBreakdown2.setBalance(cashBreakdown2.getBalance() + cashBreakdown.getBalance());
                        cashBreakdown2.setBalance(cashBreakdown2.getTotalAmount() + cashBreakdown.getTotalAmount());
                    }
                }
                cashDrawer.setStoreSession(cashDrawer2.getStoreSession());
            }
        }
        cashDrawer.calculate();
        return cashDrawer;
    }

    public static void printClockInOutReceipt(User user) throws Exception {
        Date date = new Date();
        Store store = DataProvider.get().getStore();
        Outlet outlet = DataProvider.get().getOutlet();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM, yyyy");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd MMM, hh:mm aaa");
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("hh:mm:ss aaa");
        String string = "";
        string = user.isClockedIn() != false ? Messages.getString("PosPrintService.36") + simpleDateFormat3.format(date) : Messages.getString("PosPrintService.37") + simpleDateFormat3.format(date);
        String string2 = "\n.......................................................................";
        String string3 = "\n" + store.getName();
        string3 = string3 + "\n" + outlet.getAddressLine1();
        string3 = string3 + string2;
        string3 = string3 + "\n*" + user.getFullName() + " (#" + user.getId() + ")" + (user.isClockedIn() != false ? " clock in" : " clock out") + "*";
        string3 = string3 + string2;
        string3 = string3 + Messages.getString("PosPrintService.47") + simpleDateFormat.format(date);
        string3 = string3 + "\n" + string;
        string3 = string3 + Messages.getString("PosPrintService.49") + simpleDateFormat2.format(new Date());
        string3 = string3 + string2;
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("title", "");
        hashMap.put("data", string3);
        JasperReport jasperReport = ReportUtil.getReport("generic-receipt");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JREmptyDataSource());
        PosPrintService.printReportByJasperPrint(jasperPrint);
    }
}

