/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CashInTransaction;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.TransactionUtil;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.WordUtils;

public class CashDrawerTransactionReportModel
extends AbstractTableModel {
    private String[] a = new String[]{"transTime", "ticketId", "member", "totalAmount", "transType"};
    private List<PosTransaction> b;

    @Override
    public int getRowCount() {
        if (this.b == null) {
            return 0;
        }
        return this.b.size();
    }

    @Override
    public int getColumnCount() {
        return this.a.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.a[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PosTransaction posTransaction = this.b.get(n);
        Ticket ticket = posTransaction.getTicket();
        switch (n2) {
            case 0: {
                if (posTransaction.getTransactionTime() == null) {
                    return "";
                }
                return DateUtil.formatDateWithTimeAndSec(posTransaction.getTransactionTime());
            }
            case 1: {
                if (ticket != null) {
                    return ticket.getId();
                }
                if (posTransaction instanceof CashDropTransaction) {
                    return POSConstants.DRAWER_BLEED;
                }
                if (posTransaction instanceof PayOutTransaction) {
                    return Messages.getString("ActionHistory.9");
                }
                if (posTransaction instanceof CashInTransaction) {
                    return Messages.getString("cashIn");
                }
                return null;
            }
            case 2: {
                return TransactionUtil.getCustomerName(posTransaction);
            }
            case 3: {
                if (posTransaction instanceof RefundTransaction || posTransaction instanceof CashDropTransaction || posTransaction instanceof PayOutTransaction) {
                    return posTransaction.getAmount() * -1.0;
                }
                return posTransaction.getAmount();
            }
            case 4: {
                return WordUtils.capitalizeFully((String)posTransaction.getPaymentType().getDisplayString());
            }
        }
        return null;
    }

    public List<PosTransaction> getItems() {
        return this.b;
    }

    public void setItems(List<PosTransaction> list) {
        this.b = list;
    }
}

