/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.DeliverySummaryReportData;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.DeliverySummaryReportModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class DeliverySummaryReportView
extends TransparentPanel {
    private JButton a;
    private JXDatePicker b;
    private JXDatePicker c;
    private JPanel d;
    private JPanel e;
    private JComboBox f;

    public DeliverySummaryReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() {
        try {
            Date date = this.b.getDate();
            Date date2 = this.c.getDate();
            DateUtil.validateDate(date, date2);
            date = DateUtil.startOfDay(this.b.getDate());
            date2 = DateUtil.endOfDay(this.c.getDate());
            User user = null;
            if (!this.f.getSelectedItem().equals(POSConstants.ALL)) {
                user = (User)this.f.getSelectedItem();
            }
            PosLog.debug(this.getClass(), String.format("Delivery summary report, start: %s end: %s", date, date2));
            List<DeliverySummaryReportData> list = TicketDAO.getInstance().findTicketsItemForDeliverySummaryReport(date, date2, user);
            PosLog.debug(this.getClass(), String.format("Found %s tickets", list.size()));
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("delivery_summary_report"));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(hashMap);
            ReportUtil.populateReportTime(hashMap, date, date2);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            DeliverySummaryReportModel deliverySummaryReportModel = new DeliverySummaryReportModel();
            deliverySummaryReportModel.setRows(list);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)deliverySummaryReportModel));
            JRViewer jRViewer = new JRViewer(jasperPrint);
            this.d.removeAll();
            this.d.add((Component)jRViewer);
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(HashMap hashMap) {
        hashMap.put("reportTitle", POSConstants.DELIVERY_SUMMARY_REPORT);
        hashMap.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("colSubtotal", POSConstants.SUBTOTAL + ":");
        hashMap.put("colItemName", POSConstants.ITEM);
        hashMap.put("colItemSubTotalAmount", POSConstants.AMOUNT);
        hashMap.put("colDiscount", POSConstants.DISCOUNT);
        hashMap.put("colTax", POSConstants.TAX);
        hashMap.put("colTotal", POSConstants.TOTAL);
    }

    private void b() {
        this.setLayout(new BorderLayout());
        this.b = UiUtil.getDeafultDate();
        this.b.setDate(new Date());
        this.c = UiUtil.getDeafultDate();
        this.c.setDate(new Date());
        this.f = new JComboBox();
        List<User> list = UserDAO.getInstance().findDrivers();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.f.setModel(new DefaultComboBoxModel(vector));
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(actionEvent -> this.a());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.b.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.b);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add(new JLabel(Messages.getString("DRIVER") + ":"));
        jPanel.add(this.f);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
    }

    public JComponent getRootComponent() {
        return this.e;
    }
}

