/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.DiscountReportDataModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class DiscountReportView
extends JPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private JPanel d;

    public DiscountReportView() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        jPanel.add((Component)this.a);
        jPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        jPanel.add((Component)this.b);
        jPanel.add((Component)this.c, "skip 1, al right");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
        this.c.addActionListener(actionEvent -> this.a());
    }

    private void a() {
        try {
            Date date = this.a.getDate();
            Date date2 = this.b.getDate();
            DateUtil.validateDate(date, date2);
            date = DateUtil.startOfDay(date);
            date2 = DateUtil.endOfDay(date2);
            ReportService reportService = new ReportService();
            DiscountReportDataModel discountReportDataModel = reportService.createTicketDiscountDataList(date, date2);
            DiscountReportDataModel discountReportDataModel2 = reportService.createItemDiscountDataList(date, date2);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(hashMap, true);
            ReportUtil.populateReportHeader(hashMap, null, date, date2, null);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("discount-sub-report"));
            JasperReport jasperReport2 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("discount-sub-report"));
            hashMap.put("ticketDiscountDataSource", new JRTableModelDataSource((TableModel)discountReportDataModel));
            hashMap.put("itemDiscountDataSource", new JRTableModelDataSource((TableModel)discountReportDataModel2));
            hashMap.put("ticketDiscountReport", jasperReport);
            hashMap.put("itemDiscountReport", jasperReport2);
            JasperReport jasperReport3 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("discount-report"));
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport3, hashMap, (JRDataSource)new JREmptyDataSource());
            JRViewer jRViewer = new JRViewer(jasperPrint);
            this.d.removeAll();
            this.d.add((Component)jRViewer);
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(HashMap<String, Object> hashMap) {
        hashMap.put("reportTitle", Messages.getString("DiscountReportView.0"));
        hashMap.put("colItemName", POSConstants.ITEM_NAME);
        hashMap.put("colTicketId", POSConstants.TICKET_ID);
        hashMap.put("colDate", POSConstants.DATE);
        hashMap.put("colDiscount", POSConstants.DISCOUNT);
        hashMap.put("coltotalWithDiscount", POSConstants.TICKET + " " + POSConstants.TOTAL.toLowerCase());
        hashMap.put("colItemTotalWithDiscount", POSConstants.ITEM + " " + POSConstants.TOTAL.toLowerCase());
        hashMap.put("colDiscountName", Messages.getString("DiscountReportView.1"));
        hashMap.put("lblTicketDiscount", Messages.getString("PaymentInputView.0"));
        hashMap.put("lblTicketItemDiscount", Messages.getString("PaymentInputView.1"));
        hashMap.put("lblGrandTotal", POSConstants.TOTAL + ":");
    }
}

