/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.PrintException;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.LabelItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BaseCustomer;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.base.BaseSalesArea;
import com.floreantpos.model.base.BaseTerminal;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.base.BaseUser;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalPrintersDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.ext.KitchenStickerPaperSize;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.EscPosPrintService;
import com.floreantpos.print.JasperPrintService;
import com.floreantpos.print.ReceiptPrintServiceProvider;
import com.floreantpos.report.CurrencyBreakdownReportModel;
import com.floreantpos.report.CurrencyDataRow;
import com.floreantpos.report.KitchenStickerModel;
import com.floreantpos.report.LabelPrinterTableModel;
import com.floreantpos.report.OrderDataSource;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PrintServiceUtil;
import com.floreantpos.util.ReceiptUtil;
import com.floreantpos.versioning.VersionInfo;
import com.floreantpos.webservice.CloudDataUploader;
import com.orocube.common.util.TerminalUtil;
import com.orocube.common.util.TicketStatus;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReceiptPrintService {
    public static final String SYSTEM_INFORMATION = "System Information";
    public static final String ADDITIONAL_ORDER_INFO = "additionalOrderInfo";
    public static final String SPLIT_TICKET_ID = "splitTicketId";
    public static final String PREVIOUS_DUE = "previousDue";
    public static final String PREVIOUS_DUE_TEXT = "previousDueText";
    public static final String CASH_REFUND = "cashRefund";
    public static final String CASH_REFUND_TEXT = "cashRefundText";
    public static final String TICKET_HEADER = "ticketHeader";
    public static final String TAX_BREAKDOWN_TEXT = "taxBreakdownText";
    public static final String IS_SHOW_TAX_BREAKDOWN = "isShowTaxBreakdown";
    public static final String SHOW_TIPS_BLOCK = "showTipsBlock";
    public static final String SHOW_TIPS = "showTips";
    public static final String STORE_LOGO_IMAGE = "storeLogoIcon";
    public static final String STORE_LOGO_ICON = "storeLogoIcon";
    public static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    public static final String ADDITIONAL_PAYMENT_PROPERTIES = "additionalPaymentProperties";
    public static final String APPROVAL_CODE = "approvalCode";
    public static final String CARD_PAYMENT = "cardPayment";
    public static final String CHANGE_AMOUNT = "changeAmount";
    public static final String COPY_TYPE = "copyType";
    public static final String BOTTOM_MESSAGE = "bottomMessage";
    public static final String ORDER_DETAILS = "orderDetails";
    public static final String FOOTER_MESSAGE = "footerMessage";
    public static final String GRAND_SUBTOTAL = "grandSubtotal";
    public static final String DUE_AMOUNT = "dueAmount";
    public static final String REFUND_AMOUNT = "refundAmount";
    public static final String REFUND_AMOUNT_TEXT = "refundAmountText";
    public static final String TENDER_AMOUNT = "tenderAmount";
    public static final String TENDER_AMOUNT_TEXT = "tenderAmountText";
    public static final String PAID_AMOUNT = "paidAmount";
    public static final String NET_AMOUNT = "netAmount";
    public static final String ROUNDING_AMOUNT = "roundingAmount";
    public static final String FEE_AMOUNT = "feeAmount";
    public static final String FEE_AMOUNT_TEXT = "feeAmountText";
    public static final String CHANGE_AMOUNT_TEXT = "changeAmountText";
    public static final String DUE_AMOUNT_TEXT = "dueAmountText";
    public static final String PAID_AMOUNT_TEXT = "paidAmountText";
    public static final String NET_AMOUNT_TEXT = "netAmountText";
    public static final String ROUNDING_AMOUNT_TEXT = "Rounding";
    public static final String TIPS_TEXT = "tipsText";
    public static final String DELIVERY_CHARGE_TEXT = "deliveryChargeText";
    public static final String SERVICE_CHARGE_TEXT = "serviceChargeText";
    public static final String TAX_TEXT = "taxText";
    public static final String DISCOUNT_TEXT = "discountText";
    public static final String TOTAL_TEXT = "totalText";
    public static final String DATA = "data";
    public static final String TITLE = "title";
    public static final String ORDER_ = "ORDER-";
    public static final String PROP_PRINTER_NAME = "printerName";
    public static final String TIP_AMOUNT = "tipAmount";
    public static final String SERVICE_CHARGE = "serviceCharge";
    public static final String DELIVERY_CHARGE = "deliveryCharge";
    public static final String TAX_AMOUNT = "taxAmount";
    public static final String DISCOUNT_AMOUNT = "discountAmount";
    public static final String HEADER_LINE1 = "headerLine1";
    private static final String a = "reportDate";
    private static final String b = "showFooter";
    public static final String SHOW_HEADER_SEPARATOR = "showHeaderSeparator";
    private static final String c = "showSubtotal";
    private static final String d = "receiptType";
    private static final String e = "subTotalText";
    private static final String f = "quantityText";
    private static final String g = "itemText";
    public static final String CUSTOMER_COPY = "Customer Copy";
    public static final String DRIVER_COPY = "Driver Copy";
    public static final String CENTER = "center";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String FONT_TYPE = ".font-type";
    public static final String FONT_SIZE = ".font-size";
    public static final String FONT_WEIGHT = ".font-weight";
    public static final String OROPOS_PDF_PRINTER = Messages.getString("ReceiptPrintService.11");
    public static final String GRAND_NET_AMOUNT = "grandNetAmount";
    public static final String GRAND_NET_AMOUNT_TEXT = "grandNetAmountText";
    private static File h;
    private static Log i;

    public static void printGenericReport(String string, String string2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put(TITLE, string);
        hashMap.put(DATA, string2);
        ReceiptPrintService.getJasperPrintService().printGenericReport(hashMap);
    }

    public static void testPrinter(Printer printer, String string, String string2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put(TITLE, string);
        hashMap.put(DATA, string2);
        ReceiptPrintService.setPrintProperty(hashMap, printer);
        ReceiptPrintService.getReceiptPrintServiceProvider(printer).testPrinter(hashMap, printer.getDeviceName());
    }

    public static String getSystemInfo(String string, String string2) {
        String string3 = string + "-" + string2;
        string3 = string3 + "\n Terminal : " + Application.getInstance().getTerminal().getName();
        string3 = string3 + "\n Current User : " + Application.getCurrentUser().getFirstName();
        string3 = string3 + "\n " + VersionInfo.getAppName() + Messages.getString("PrinterGroupView.1") + VersionInfo.getVersion();
        string3 = string3 + "\n Database Name : " + AppConfig.getDatabaseName() + AppConfig.getDatabaseHost() + AppConfig.getDatabasePort();
        return string3;
    }

    public static void setPrintProperty(HashMap<String, Object> hashMap, Printer printer) {
        hashMap.put("receipt.printer_type", printer.getPrintSystem());
        hashMap.put("printerType", printer.getPrinterType());
        hashMap.put("ipAddress", printer.getIpAddress());
        hashMap.put("ipPort", printer.getIpPort());
        hashMap.put("serialPort", printer.getSerialPort());
        hashMap.put("textLength", printer.getTextLength());
    }

    public static void printTicket(Ticket ticket) {
        ReceiptPrintService.printTicket(ticket, true);
    }

    public static void printTicket(Ticket ticket, boolean bl) {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        ReceiptPrintService.printTicket(ticket, ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null), bl);
    }

    public static void printTicket(Ticket ticket, String string) {
        ReceiptPrintService.printTicket(ticket, string, true);
    }

    public static void printTicket(Ticket ticket, String string, boolean bl) {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
        hashMap.put(COPY_TYPE, string);
        hashMap.put(CARD_PAYMENT, true);
        ReceiptPrintService.printTicket(ticket, hashMap, bl);
    }

    public static void printTicket(Ticket ticket, HashMap<String, Object> hashMap) {
        ReceiptPrintService.printTicket(ticket, hashMap, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTicket(Ticket ticket, HashMap<String, Object> hashMap, boolean bl) {
        try {
            boolean bl2;
            ticket.setShouldUpdateStock(true);
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            boolean bl3 = bl2 = paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal();
            if (bl2) {
                ReceiptPrintService.c(ticket);
                paymentGatewayPlugin.printTicket(ticket);
                return;
            }
            List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
            if (list == null) {
                return;
            }
            ReceiptPrintService.c(ticket);
            for (Printer printer : list) {
                String string = printer.getDeviceName();
                if (string == null) continue;
                i.info((Object)String.format("Printing ticket %s payment using printer %s. Total amount %s", ticket.getId(), string, ticket.getTotalAmount()));
                ReceiptPrintService.setPrintProperty(hashMap, printer);
                ReceiptPrintService.a(hashMap, string);
                ReceiptPrintService.getReceiptPrintServiceProvider(printer).printTicket(ticket, hashMap, string);
            }
            ReceiptPrintService.d(ticket);
        }
        catch (Exception exception) {
            i.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
            if (!bl) {
                throw new PrintException(Messages.getString("SettleTicketProcessor.23"), exception);
            }
        }
        finally {
            ticket.setShouldUpdateStock(false);
        }
    }

    public static void printTransaction(PosTransaction posTransaction, boolean bl) {
        ReceiptPrintService.printTransaction(posTransaction, false, bl);
    }

    public static void printTransaction(PosTransaction posTransaction, boolean bl, boolean bl2) {
        try {
            Ticket ticket = posTransaction.getTicket();
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            if (paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal()) {
                paymentGatewayPlugin.printTransaction(posTransaction, bl, bl2);
                return;
            }
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.6"), true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
            if (posTransaction != null && posTransaction.isCard()) {
                hashMap.put(CARD_PAYMENT, true);
                hashMap.put(COPY_TYPE, Messages.getString("ReceiptPrintService.7"));
                ReceiptPrintService.printTransaction(posTransaction, hashMap);
                if (bl2) {
                    hashMap.put(COPY_TYPE, Messages.getString("ReceiptPrintService.8"));
                    ReceiptPrintService.printTransaction(posTransaction, hashMap);
                }
            } else {
                ReceiptPrintService.printTransaction(posTransaction, hashMap);
            }
        }
        catch (Exception exception) {
            i.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
            throw new PrintException(Messages.getString("SettleTicketProcessor.23"), exception);
        }
    }

    public static void printTransaction(PosTransaction posTransaction, HashMap<String, Object> hashMap) {
        try {
            boolean bl;
            Ticket ticket = posTransaction.getTicket();
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            boolean bl2 = bl = paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal();
            if (bl) {
                paymentGatewayPlugin.printTransaction(posTransaction, false, false);
                return;
            }
            List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
            for (Printer printer : list) {
                String string = printer.getDeviceName();
                if (string == null) continue;
                i.info((Object)String.format("Printing ticket %s payment using printer %s. Total amount %s", ticket.getId(), string, ticket.getTotalAmount()));
                ReceiptPrintService.setPrintProperty(hashMap, printer);
                ReceiptPrintService.a(hashMap, string);
                ReceiptPrintService.getReceiptPrintServiceProvider(printer).printTransaction(ticket, hashMap, posTransaction, string);
            }
        }
        catch (Exception exception) {
            i.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
            throw new PrintException(Messages.getString("SettleTicketProcessor.23"), exception);
        }
    }

    public static void printTransaction(PosTransaction posTransaction) {
        boolean bl;
        Ticket ticket = posTransaction.getTicket();
        PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
        boolean bl2 = posTransaction.getPaymentType().equals((Object)PaymentType.CASH);
        boolean bl3 = bl = paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal();
        if (bl && bl2) {
            return;
        }
        if (bl) {
            paymentGatewayPlugin.printTransaction(posTransaction, false, false);
            return;
        }
        String string = Application.getPrinters().getReceiptPrinter();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
        if (posTransaction != null && posTransaction.isCard()) {
            hashMap.put(CARD_PAYMENT, true);
            hashMap.put(COPY_TYPE, Messages.getString("ReceiptPrintService.4"));
            ReceiptPrintService.printTransaction(posTransaction, hashMap);
            hashMap.put(COPY_TYPE, Messages.getString("ReceiptPrintService.5"));
            ReceiptPrintService.printTransaction(posTransaction, hashMap);
        } else {
            ReceiptPrintService.printTransaction(posTransaction, hashMap);
        }
    }

    public static void printRefundTicket(Ticket ticket, RefundTransaction refundTransaction) {
        try {
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.47"), true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, refundTransaction, false, true);
            hashMap.put(REFUND_AMOUNT_TEXT, Messages.getString("ReceiptPrintService.1") + CurrencyUtil.getCurrencySymbol());
            hashMap.put(REFUND_AMOUNT, NumberUtil.formatNumber(refundTransaction.getAmount()));
            hashMap.put(CASH_REFUND_TEXT, Messages.getString("ReceiptPrintService.2") + CurrencyUtil.getCurrencySymbol());
            hashMap.put(CASH_REFUND, NumberUtil.formatNumber(refundTransaction.getAmount()));
            List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
            for (Printer printer : list) {
                String string = printer.getDeviceName();
                if (string == null) continue;
                ReceiptPrintService.setPrintProperty(hashMap, printer);
                ReceiptPrintService.a(hashMap, string);
                ReceiptPrintService.getReceiptPrintServiceProvider(printer).printTransaction(ticket, hashMap, refundTransaction, string);
            }
        }
        catch (Exception exception) {
            i.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static void printVoidTicket(Ticket ticket) {
        try {
            Collection<Serializable> collection;
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties("*** VOID RECEIPT ***", true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
            String string = "";
            if (ticket.getTransactions() != null) {
                collection = ticket.getTransactions();
                double d = 0.0;
                if (collection != null) {
                    for (PosTransaction posTransaction : collection) {
                        if (!(posTransaction instanceof RefundTransaction) && !posTransaction.isVoided().booleanValue()) continue;
                        d += posTransaction.getAmount().doubleValue();
                    }
                }
                d = NumberUtil.roundToTwoDigit(d);
            }
            hashMap.put(ADDITIONAL_PROPERTIES, "<html><b>" + string + "</b></html>");
            hashMap.put(ADDITIONAL_PAYMENT_PROPERTIES, "");
            collection = DataProvider.get().getPrinters().getReceiptPrinters();
            for (Printer printer : collection) {
                String string2 = printer.getDeviceName();
                if (string2 == null) continue;
                ReceiptPrintService.setPrintProperty(hashMap, printer);
                ReceiptPrintService.a(hashMap, string2);
                ReceiptPrintService.getReceiptPrintServiceProvider(printer).printVoidTicket(ticket, hashMap, string2);
            }
        }
        catch (Exception exception) {
            i.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static JasperPrint createPurchaseOrderPrint(PurchaseOrder purchaseOrder) throws Exception {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        HashMap<String, Object> hashMap = ReceiptPrintService.populatePurchaseOrderProperties(purchaseOrder, ticketPrintProperties);
        hashMap.put(COPY_TYPE, "");
        OrderDataSource orderDataSource = new OrderDataSource(purchaseOrder);
        String string = "order_receipt";
        hashMap.put(PREVIOUS_DUE_TEXT, "Previous Due  ");
        hashMap.put(PREVIOUS_DUE, "");
        return ReceiptPrintService.getJasperPrintService().createJasperPrint(ReportUtil.getReport(string), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)orderDataSource));
    }

    public static JasperPrint createPurchaseOrderItemsBarcodePrint(List<LabelItem> list) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        LabelPrinterTableModel labelPrinterTableModel = new LabelPrinterTableModel(list);
        String string = "barcode_report";
        return ReceiptPrintService.getJasperPrintService().createJasperPrint(ReportUtil.getReport(string), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)labelPrinterTableModel));
    }

    public static JasperPrint printKitchenStickerItems(List<KitchenStickerModel.KitchenSticker> list) throws Exception {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            KitchenStickerModel kitchenStickerModel = new KitchenStickerModel(list);
            String string = "kitchenStickerReport";
            hashMap.put("colTicket", Messages.getString("ReceiptPrintService.38"));
            hashMap.put("colToken", Messages.getString("ReceiptPrintService.45"));
            KitchenStickerPaperSize kitchenStickerPaperSize = ReceiptPrintService.b("kitchen.sticker.paper_size");
            return ReceiptPrintService.getJasperPrintService().createJasperPrint(ReportUtil.getReport(kitchenStickerPaperSize.getReportNameAccording2Size(string)), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)kitchenStickerModel));
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception.getMessage(), exception);
            return null;
        }
    }

    public static byte[] createPDFStream(Ticket ticket) {
        try {
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
            hashMap.put("IS_IGNORE_PAGINATION", true);
            JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createPrint(ticket, hashMap, null);
            jasperPrint.setName("TICKET_RECEIPT" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception);
            return null;
        }
    }

    public static byte[] createPDFStream(PosTransaction posTransaction) {
        try {
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.6"), true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            Ticket ticket = posTransaction.getTicket();
            HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
            hashMap.put("IS_IGNORE_PAGINATION", true);
            JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createPrint(ticket, hashMap, null);
            jasperPrint.setName("TICKET_RECEIPT" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception);
            return null;
        }
    }

    public static JasperPrintService getJasperPrintService() {
        return new JasperPrintService();
    }

    public static ReceiptPrintServiceProvider getReceiptPrintService() {
        List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
        if (list == null || list.isEmpty()) {
            return ReceiptPrintService.getJasperPrintService();
        }
        return ReceiptPrintService.getReceiptPrintServiceProvider(list.get(0));
    }

    public static ReceiptPrintServiceProvider getKitchenReceiptPrintPreviewService() {
        String string = DataProvider.get().getCurrentTerminal().getProperty("kitchen.receipt.print_preview_system");
        if (string != null && string.equals("EscPOS")) {
            return new EscPosPrintService();
        }
        return new JasperPrintService();
    }

    public static ReceiptPrintServiceProvider getMainReceiptPrintPreviewService() {
        String string = DataProvider.get().getCurrentTerminal().getProperty("main.receipt.print_preview_system");
        if (string != null && string.equals("EscPOS")) {
            return new EscPosPrintService();
        }
        return new JasperPrintService();
    }

    public static ReceiptPrintServiceProvider getReceiptPrintServiceProvider(Printer printer) {
        if (printer == null) {
            return new JasperPrintService();
        }
        String string = printer.getDeviceName();
        if (string != null && string.equals(OROPOS_PDF_PRINTER)) {
            return new JasperPrintService();
        }
        if (printer.getPrintSystem().equals("EscPOS")) {
            return new EscPosPrintService();
        }
        return new JasperPrintService();
    }

    private static String a(Ticket ticket) {
        Customer customer = CustomerDAO.getInstance().findById(ticket.getCustomerId());
        String string = new String();
        string = string + ReceiptPrintService.a();
        string = string + Messages.getString("ReceiptPrintService.25") + ReceiptPrintService.a();
        string = string + Messages.getString("ReceiptPrintService.26") + customer.getId() + ReceiptPrintService.a();
        string = string + Messages.getString("NAME") + ": " + customer.getName() + ReceiptPrintService.a();
        string = string + Messages.getString("Balance") + ": \\" + CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumberAcceptNegative(customer.getBalance());
        return string;
    }

    private static void a(StringBuilder stringBuilder) {
        stringBuilder.append("<div>");
    }

    private static String a() {
        return "<br>";
    }

    private static void b(StringBuilder stringBuilder) {
        stringBuilder.append("</div>\n");
    }

    private static void a(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<span>" + string + "</span>");
    }

    public static HashMap<String, Object> populateTicketProperties(Ticket ticket, TicketPrintProperties ticketPrintProperties, PosTransaction posTransaction) {
        return ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction, false, false);
    }

    public static HashMap<String, Object> populateTicketProperties(Ticket ticket, TicketPrintProperties ticketPrintProperties, PosTransaction posTransaction, boolean bl, boolean bl2) {
        return ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction, bl, bl2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static HashMap<String, Object> populateTicketProperties(Ticket ticket, TicketPrintProperties ticketPrintProperties, PosTransaction posTransaction, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder;
        boolean bl4;
        List<TicketDiscount> list;
        Set<PosTransaction> set;
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        Application.getInstance().refreshStore();
        Store store = DataProvider.get().getStore();
        Outlet outlet = DataProvider.get().getOutlet();
        String string3 = "";
        OrderType orderType = ticket.getOrderType();
        String string4 = "";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (orderType != null) {
            string4 = orderType.getId();
        }
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        int n = POSUtil.parseInteger(ticket.getProperty("printCount"));
        if (bl) {
            string5 = ReceiptUtil.getReceiptSection(store, "kitchen.header", string4);
            string8 = ReceiptUtil.getReceiptSection(store, "kitchen.order.info", string4);
            string3 = ReceiptUtil.getReceiptSection(store, "kitchen.order.extrainfo1", string4);
            string6 = ReceiptUtil.getReceiptSection(store, "kitchen.footer", string4);
            string7 = ReceiptUtil.getReceiptSection(store, "kitchen.bottom", string4);
            string7 = string7 + ReceiptPrintService.b();
            ReceiptPrintService.a(store, HEADER_LINE1, "kitchen.header", hashMap);
            ReceiptPrintService.a(store, TICKET_HEADER, "kitchen.order.info", hashMap);
            ReceiptPrintService.a(store, ADDITIONAL_ORDER_INFO, "kitchen.order.extrainfo1", hashMap);
            ReceiptPrintService.a(store, BOTTOM_MESSAGE, "kitchen.footer", hashMap);
            ReceiptPrintService.a(store, FOOTER_MESSAGE, "kitchen.bottom", hashMap);
            ReceiptPrintService.a(store, ORDER_DETAILS, "kitchen.details", hashMap);
        } else {
            String string9 = "";
            if (n > 1 && posTransaction == null) {
                string9 = "<center>RE-PRINT\n</center>";
            }
            string5 = ReceiptUtil.getReceiptSection(store, "ticket.header", string4);
            string8 = string9 + ReceiptUtil.getReceiptSection(store, "ticket.order.info", string4);
            string3 = ReceiptUtil.getReceiptSection(store, "ticket.order.extrainfo1", string4);
            string6 = ReceiptUtil.getReceiptSection(store, "ticket.footer", string4);
            string7 = ReceiptUtil.getReceiptSection(store, "ticket.bottom", string4);
            ReceiptPrintService.a(hashMap, DataProvider.get().getPrinters().getReceiptPrinter());
            ReceiptPrintService.a(store, HEADER_LINE1, "ticket.header", hashMap);
            ReceiptPrintService.a(store, TICKET_HEADER, "ticket.order.info", hashMap);
            ReceiptPrintService.a(store, ADDITIONAL_ORDER_INFO, "ticket.order.extrainfo1", hashMap);
            ReceiptPrintService.a(store, BOTTOM_MESSAGE, "ticket.footer", hashMap);
            ReceiptPrintService.a(store, FOOTER_MESSAGE, "ticket.bottom", hashMap);
            ReceiptPrintService.a(store, ORDER_DETAILS, "ticket.details", hashMap);
        }
        hashMap.put(ReceiptParam.STORE_LOGO.getParamName(), " ");
        boolean bl5 = Boolean.valueOf(ReceiptUtil.getReceiptSection(store, bl ? "kitchen.header.logo.show" : "ticket.header.logo.show", string4));
        double d = ticket.getTotalAmount();
        double d2 = 0.0;
        String string10 = CurrencyUtil.getCurrencySymbol();
        hashMap.put(ReceiptParam.STORE_NAME.getParamName(), store.getName());
        hashMap.put(ReceiptParam.STORE_ADDRESS1.getParamName(), outlet.getAddressLine1());
        hashMap.put(ReceiptParam.STORE_ADDRESS2.getParamName(), outlet.getAddressLine2());
        hashMap.put(ReceiptParam.STORE_ADDRESS3.getParamName(), outlet.getAddressLine3());
        hashMap.put(ReceiptParam.STORE_STATE.getParamName(), outlet.getState());
        hashMap.put(ReceiptParam.STORE_CITY.getParamName(), outlet.getCity());
        hashMap.put(ReceiptParam.STORE_POST_CODE.getParamName(), outlet.getZipCode());
        hashMap.put(ReceiptParam.STORE_PHONE_NO.getParamName(), outlet.getTelephone());
        hashMap.put(ReceiptParam.CURRENCY_SYMBOL.getParamName(), string10);
        hashMap.put(ReceiptParam.TICKET_ID.getParamName(), ticket.getId());
        hashMap.put(ReceiptParam.TICKET_SHORT_ID.getParamName(), ticket.getShortId());
        hashMap.put(ReceiptParam.ORDER_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(ticket.getCreateDate()));
        hashMap.put(ReceiptParam.TOKEN_NO.getParamName(), "" + ticket.getTokenNo());
        if (StringUtils.isNotBlank((String)ticket.getNote()) && store.isShowGuestNote()) {
            hashMap.put(ReceiptParam.GUEST_NOTE.getParamName(), ticket.getNote());
        }
        hashMap.put(ReceiptParam.BARTAB_NAME.getParamName(), ticket.getBartabName());
        if (posTransaction != null && posTransaction.getPaymentType() == PaymentType.MEMBER_ACCOUNT) {
            hashMap.put(ReceiptParam.MEMBER_ACCOUNT_INFO.getParamName(), ReceiptPrintService.a(ticket));
        }
        if (orderType != null && (orderType.isDelivery().booleanValue() || orderType.isPickup().booleanValue())) {
            if (orderType.isDelivery().booleanValue() && ticket.isCustomerWillPickup().booleanValue()) {
                hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), ticket.getOrderType() + Messages.getString("ReceiptPrintService.46"));
            } else {
                hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), ticket.getOrderType());
            }
            object3 = ticket.getFullDeliveryAddress();
            Object object4 = object2 = ticket.getExtraDeliveryInfo() == null ? "" : ticket.getExtraDeliveryInfo();
            if (StringUtils.isNotBlank((String)object3)) {
                hashMap.put(ReceiptParam.DELIVERY_ADDRESS.getParamName(), object3);
            }
            if (StringUtils.isNotBlank((String)object2)) {
                hashMap.put(ReceiptParam.EXTRA_DELIVERYINFO.getParamName(), object2);
            }
            if (ticket.getDeliveryDate() != null) {
                hashMap.put(ReceiptParam.DELIVERY_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(ticket.getDeliveryDate()));
            }
        } else if (orderType != null && orderType.isHasForHereAndToGo().booleanValue()) {
            object3 = ticket.getSubOrderType();
            hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), object3 != null ? ((SubOrderType)((Object)object3)).getDisplayString() : ticket.getOrderType());
        } else {
            hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), ticket.getOrderType());
        }
        object3 = ticket.getTerminal();
        if (object3 != null) {
            hashMap.put(ReceiptParam.TERMINAL_ID.getParamName(), ((BaseTerminal)object3).getId());
            hashMap.put(ReceiptParam.TERMINAL_NAME.getParamName(), ((BaseTerminal)object3).getName());
        }
        if ((object2 = ticket.getOwner()) != null) {
            hashMap.put(ReceiptParam.SERVER_NAME.getParamName(), ((User)object2).getFullName());
            hashMap.put(ReceiptParam.SERVER_ID.getParamName(), ((BaseUser)object2).getId());
        }
        hashMap.put(ReceiptParam.GUEST_COUNT.getParamName(), ticket.getNumberOfGuests().toString());
        if (n > 0) {
            hashMap.put(ReceiptParam.PRINT_COUNT.getParamName(), n);
        }
        hashMap.put(ReceiptParam.TABLE_NO.getParamName(), ticket.getTableNameDisplay());
        if (bl && orderType.isBarTab().booleanValue()) {
            hashMap.put(ReceiptParam.TABLE_NO.getParamName(), ticket.getBartabName());
        }
        hashMap.put(ReceiptParam.CUSTOMER_NAME.getParamName(), ticket.getCustomerName());
        hashMap.put(ReceiptParam.CUSTOMER_PHONE.getParamName(), ticket.getCustomerMobileNo());
        if (ticket.getCustomer() != null) {
            object = ticket.getCustomer();
            hashMap.put(ReceiptParam.CUSTOMER_ID.getParamName(), ((BaseCustomer)object).getMemberId() != null ? ((BaseCustomer)object).getMemberId() : "");
            hashMap.put(ReceiptParam.CUSTOMER_SIGNATURE.getParamName(), ((BaseCustomer)object).getSignatureImageId());
            if (POSUtil.getBoolean(store.getProperty("loyalty.enabled"))) {
                if (posTransaction != null) {
                    string2 = String.valueOf(posTransaction.getLoyaltyChargedAmount());
                    if (StringUtils.isNotBlank((String)string2)) {
                        hashMap.put(ReceiptParam.LOYALTY_REDEEM.getParamName(), string2);
                    }
                    if (StringUtils.isNotBlank((String)(string = String.valueOf(posTransaction.getLoyaltyEarnedForPurchase())))) {
                        hashMap.put(ReceiptParam.LOYALTY_EARNED.getParamName(), string);
                    }
                } else {
                    int n2 = 0;
                    int n3 = 0;
                    set = ticket.getTransactions();
                    if (set == null || set.isEmpty()) {
                        list = ticket.getDiscounts();
                        if (list != null) {
                            for (TicketDiscount comparable2 : list) {
                                if (comparable2.isLoyaltyCharged()) continue;
                                n2 += comparable2.getLoyaltyPoint().intValue();
                            }
                        }
                    } else {
                        n2 = ticket.getTotalLoyaltyChargedAmount();
                        n3 += ticket.getTotalLoyaltyEarned();
                    }
                    if (n2 > 0) {
                        hashMap.put(ReceiptParam.LOYALTY_REDEEM.getParamName(), n2);
                    }
                    if (n3 > 0) {
                        hashMap.put(ReceiptParam.LOYALTY_EARNED.getParamName(), n3);
                    }
                    hashMap.put(ReceiptParam.LOYALTY_TOTAL.getParamName(), StringUtils.isBlank((String)ticket.getCustomerTotalLoyaltyPoint()) ? ((BaseCustomer)object).getLoyaltyPoint() : ticket.getCustomerTotalLoyaltyPoint());
                }
            }
        }
        if (ticket.getSalesArea() != null) {
            object = ticket.getSalesArea();
            hashMap.put(ReceiptParam.SALES_AREA.getParamName(), ((BaseSalesArea)object).getName());
        }
        if (ticket.getTransactions() != null) {
            object = ReceiptPrintService.e(ticket);
            hashMap.put(ReceiptParam.PAYMENT_TYPE.getParamName(), object);
        }
        if (ticket.getAssignedDriver() != null) {
            object = ticket.getAssignedDriver();
            hashMap.put(ReceiptParam.DRIVER_NAME.getParamName(), ((User)object).getFullName());
            hashMap.put(ReceiptParam.DRIVER_ID.getParamName(), ((BaseUser)object).getId());
        }
        if (string5.contains((CharSequence)(object = ReceiptParam.BARCODE.getParamName())) || string8.contains((CharSequence)object) || string3.contains((CharSequence)object) || string6.contains((CharSequence)object) || string7.contains((CharSequence)object)) {
            hashMap.put((String)object, String.valueOf(ticket.getId()));
        }
        hashMap.put(ReceiptParam.RECEIPT_TYPE.getParamName(), ticketPrintProperties.getReceiptTypeName());
        string2 = ticket.getProperty("SPLIT_TICKET");
        if (StringUtils.isNotEmpty((String)string2)) {
            hashMap.put(SPLIT_TICKET_ID, string2);
        }
        hashMap.put(ReceiptParam.PRINT_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(new Date()));
        hashMap.put(g, POSConstants.RECEIPT_REPORT_ITEM_LABEL);
        hashMap.put(f, POSConstants.RECEIPT_REPORT_QUANTITY_LABEL);
        hashMap.put(e, POSConstants.RECEIPT_REPORT_SUBTOTAL_LABEL);
        hashMap.put(c, ticketPrintProperties.isShowSubtotal());
        hashMap.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        hashMap.put(b, ticketPrintProperties.isShowFooter());
        string = ReceiptPrintService.a(hashMap, string8);
        if (ticket.isVoided().booleanValue()) {
            string = string + Messages.getString("ReceiptPrintService.16") + "<br>";
        }
        hashMap.put(TICKET_HEADER, string);
        hashMap.put(ADDITIONAL_ORDER_INFO, ReceiptPrintService.a(hashMap, string3));
        hashMap.put(HEADER_LINE1, ReceiptPrintService.a(hashMap, string5));
        if (ticketPrintProperties.isShowFooter()) {
            CharSequence charSequence;
            void var31_40;
            ReceiptPrintService.a(hashMap, ticket);
            set = POSConstants.RECEIPT_REPORT_TAX_LABEL + string10;
            list = NumberUtil.formatNumber(ticket.getTaxAmount(), true);
            if (ticket.isTaxIncluded().booleanValue()) {
                set = (String)((Object)set) + Messages.getString("ReceiptPrintService.18");
                if (!store.isShowSubtotalWithoutTax()) {
                    list = " (" + (String)((Object)list) + ")";
                }
            }
            if (ticket.getTaxAmount() != 0.0) {
                hashMap.put(TAX_AMOUNT, list);
            }
            if (ticket.getServiceCharge() != 0.0) {
                hashMap.put(SERVICE_CHARGE, NumberUtil.formatNumberAcceptNegative(ticket.getServiceCharge()));
            }
            if (ticket.getDeliveryCharge() > 0.0) {
                hashMap.put(DELIVERY_CHARGE, NumberUtil.formatNumberAcceptNegative(ticket.getDeliveryCharge()));
            }
            if (ticket.getGratuity() != null) {
                hashMap.put(TIPS_TEXT, POSConstants.RECEIPT_REPORT_TIPS_LABEL + string10);
                d2 = ticket.getGratuity().getAmount();
                if (d2 > 0.0) {
                    hashMap.put(TIP_AMOUNT, NumberUtil.formatNumber(d2));
                }
                hashMap.put(GRAND_NET_AMOUNT_TEXT, Messages.getString("ReceiptPrintService.48") + string10);
                hashMap.put(GRAND_NET_AMOUNT, NumberUtil.formatNumber(d + ticket.getGratuity().getAmount(), true));
            }
            hashMap.put(TOTAL_TEXT, POSConstants.SUBTOTAL + string10);
            hashMap.put(TAX_TEXT, set);
            hashMap.put(SERVICE_CHARGE_TEXT, POSConstants.RECEIPT_REPORT_SERVICE_CHARGE_LABEL + string10);
            hashMap.put(DELIVERY_CHARGE_TEXT, POSConstants.RECEIPT_REPORT_DELIVERY_CHARGE_LABEL + string10);
            hashMap.put(NET_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_TOTAL_LABEL + string10);
            hashMap.put(ROUNDING_AMOUNT_TEXT, POSConstants.LABEL_ROUNDING + string10);
            hashMap.put(FEE_AMOUNT_TEXT, POSConstants.FEE_AMOUNT + string10);
            if (ticket.getFeeAmount() > 0.0) {
                hashMap.put(FEE_AMOUNT, NumberUtil.formatNumber(ticket.getFeeAmount()));
            }
            hashMap.put(NET_AMOUNT, NumberUtil.formatNumber(d, true));
            Double d3 = ticket.getRefundAmount();
            if (posTransaction != null) {
                Double d4 = posTransaction.getTenderAmount();
                hashMap.put(TENDER_AMOUNT_TEXT, POSConstants.RECEIPT_TENDERED_AMOUNT_LABEL + string10);
                hashMap.put(TENDER_AMOUNT, NumberUtil.formatNumber(d4, true));
            }
            if (d3 > 0.0) {
                hashMap.put(REFUND_AMOUNT_TEXT, Messages.getString("ReceiptPrintService.40") + string10);
                hashMap.put(REFUND_AMOUNT, NumberUtil.formatNumber(d3));
            }
            Double d5 = ticket.getSubtotalAmount();
            if (store.isShowSubtotalWithoutTax()) {
                Double d6 = ticket.getSubtotalWithoutIncludedTax();
            }
            if (ticket.getRoundedAmount() != 0.0) {
                hashMap.put("roundingText", POSConstants.LABEL_ROUNDING + string10);
                hashMap.put(ROUNDING_AMOUNT, String.valueOf(ticket.getRoundedAmount()));
                hashMap.put(ROUNDING_AMOUNT, NumberUtil.formatNumber(ticket.getRoundedAmount(), true));
            }
            boolean bl6 = ReceiptPrintService.isEnabledMulticurrency(ticket);
            hashMap.put(DUE_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_DUEAMOUNT_LABEL + string10);
            hashMap.put(DUE_AMOUNT, NumberUtil.formatNumber(ticket.getDueAmount(), true));
            hashMap.put(GRAND_SUBTOTAL, NumberUtil.formatNumber((Double)var31_40, true));
            hashMap.put(FOOTER_MESSAGE, ReceiptPrintService.a(hashMap, string6));
            hashMap.put(BOTTOM_MESSAGE, ReceiptPrintService.a(hashMap, string7));
            hashMap.put(COPY_TYPE, ticketPrintProperties.getReceiptCopyType());
            if (posTransaction != null) {
                if (!bl6 && posTransaction.getChangeAmount() > 0.0) {
                    hashMap.put(CHANGE_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_CHANGEAMOUNT_LABEL + string10);
                    hashMap.put(CHANGE_AMOUNT, NumberUtil.formatNumber(posTransaction.getChangeAmount()));
                }
                if (posTransaction.isCard()) {
                    if (!orderType.isRetailOrder().booleanValue()) {
                        hashMap.put(CARD_PAYMENT, true);
                    }
                    if (StringUtils.isEmpty((String)(charSequence = CardConfig.getPaymentGateway().getProcessor().getCardInformationForReceipt(posTransaction)))) {
                        charSequence = ReceiptPrintService.b(posTransaction);
                    }
                    hashMap.put(APPROVAL_CODE, charSequence);
                }
                if (posTransaction instanceof CustomerAccountTransaction && !orderType.isRetailOrder().booleanValue()) {
                    hashMap.put(CARD_PAYMENT, true);
                }
                if (posTransaction instanceof GiftCertificateTransaction) {
                    hashMap.put(CARD_PAYMENT, true);
                    hashMap.put(APPROVAL_CODE, ReceiptPrintService.a(posTransaction));
                }
            }
            if (!bl2 && bl6 && (charSequence = ReceiptPrintService.buildAllMultiCurrency(hashMap, ticket, posTransaction, false)) != null && string2 == null) {
                hashMap.put(ADDITIONAL_PROPERTIES, ((StringBuilder)charSequence).toString());
            }
        }
        if (bl5 && (set = store.getStoreLogo()) != null) {
            hashMap.put("storeLogoIcon", ((ImageIcon)((Object)set)).getImage());
        }
        if (bl4 = ReceiptUtil.getReceiptBooleanProp(store, "receipt.show_tips_suggestion", string4)) {
            hashMap.put(SHOW_TIPS, ReceiptPrintService.b(ticket));
        }
        boolean bl7 = ReceiptUtil.getReceiptBooleanProp(store, "receipt.show_tips_block", string4);
        hashMap.put(SHOW_TIPS_BLOCK, bl7);
        boolean bl8 = ReceiptUtil.getReceiptBooleanProp(store, "receipt.show_tax_breakdown", string4);
        hashMap.put(IS_SHOW_TAX_BREAKDOWN, bl8);
        if (bl8 && (stringBuilder = ReceiptPrintService.getTaxBreakdown(ticket, store)) != null) {
            hashMap.put(TAX_BREAKDOWN_TEXT, stringBuilder.toString());
        }
        return hashMap;
    }

    private static String b() {
        return "<" + (Object)((Object)ReceiptParam.GUEST_NOTE) + ">" + Messages.getString("ReceiptPrintService.51") + " $" + (Object)((Object)ReceiptParam.GUEST_NOTE) + "</" + (Object)((Object)ReceiptParam.GUEST_NOTE) + ">";
    }

    private static void a(HashMap<String, Object> hashMap, Ticket ticket) {
        String string = CurrencyUtil.getCurrencySymbol();
        String string2 = "";
        String string3 = "";
        double d = ticket.getDiscountAmount();
        double d2 = ticket.getLoyaltyDiscountAmount();
        double d3 = d - d2;
        if (d > 0.0) {
            if (d3 > 0.0) {
                string2 = string2 + POSConstants.RECEIPT_REPORT_DISCOUNT_LABEL + string;
                string3 = string3 + "-" + NumberUtil.formatNumber(d3, true);
            }
            if (d3 > 0.0 && d2 > 0.0) {
                string3 = string3 + "<br>";
                string2 = string2 + "<br>";
            }
            if (d2 > 0.0) {
                string3 = string3 + "-" + NumberUtil.formatNumber(d2, true);
                string2 = string2 + POSConstants.LOYALTY_REDEEM + string;
            }
            hashMap.put(DISCOUNT_AMOUNT, string3);
        }
        hashMap.put(DISCOUNT_TEXT, string2);
    }

    private static void a(Store store, String string, String string2, HashMap<String, Object> hashMap) {
        hashMap.put(string + FONT_WEIGHT, store.getBooleanProperty(string2 + FONT_WEIGHT, false));
        hashMap.put(string + FONT_SIZE, store.getProperty(string2 + FONT_SIZE));
        hashMap.put(string + FONT_TYPE, store.getProperty(string2 + FONT_TYPE));
    }

    private static String a(PosTransaction posTransaction) {
        GiftCard giftCard = GiftCardDAO.getInstance().get(posTransaction.getGiftCertNumber());
        if (giftCard == null) {
            return "";
        }
        String string = giftCard.getCardNumber();
        String string2 = string.length() > 4 ? "***" + string.substring(string.length() - 4) : string;
        String string3 = new String();
        string3 = string3 + ReceiptPrintService.a();
        string3 = string3 + Messages.getString("ReceiptPrintService.30") + "------------" + ReceiptPrintService.a();
        string3 = string3 + Messages.getString("ReceiptPrintService.32") + ": " + string2 + ReceiptPrintService.a();
        string3 = string3 + Messages.getString("ReceiptPrintService.33") + ": " + CurrencyUtil.getCurrencySymbol() + NumberUtil.format(giftCard.getBalance());
        return string3;
    }

    private static void a(HashMap<String, Object> hashMap, String string) {
        if (string != null && string.equalsIgnoreCase(OROPOS_PDF_PRINTER)) {
            hashMap.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        } else {
            hashMap.put("IS_IGNORE_PAGINATION", false);
        }
    }

    public static void setPaginationProperty(HashMap<String, Object> hashMap, String string, boolean bl) {
        if (string != null && string.equalsIgnoreCase(OROPOS_PDF_PRINTER)) {
            hashMap.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        } else {
            hashMap.put("IS_IGNORE_PAGINATION", bl);
        }
    }

    private static String a(Map<String, Object> map, String string) {
        ReceiptParam[] receiptParamArray;
        if (string == null) {
            return "";
        }
        for (ReceiptParam receiptParam : receiptParamArray = ReceiptParam.values()) {
            String string2;
            String string3 = receiptParam.getParamName();
            Object object = map.get(string3);
            if (object == null || StringUtils.isEmpty((String)object.toString()) || object.toString().equals("[]")) {
                string2 = "<" + receiptParam.getParamName() + ">.*</" + receiptParam.getParamName() + ">";
                string = string.replaceAll("<br>" + string2, "");
                string = string.replaceAll(string2, "");
                continue;
            }
            string2 = object.toString();
            string = string.replaceAll("\\$" + string3, Matcher.quoteReplacement(string2));
        }
        String string4 = ReceiptPrintService.a(string);
        return string4;
    }

    private static String a(String string) {
        Pattern pattern = Pattern.compile("\\{\\{(\\d+)\\}\\}");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                int n = Integer.parseInt(string2);
                String string3 = "";
                for (int i = 0; i < n; ++i) {
                    string3 = string3 + " ";
                }
                matcher.appendReplacement(stringBuffer, string3);
            }
            catch (Exception exception) {}
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static HashMap<String, Object> populatePurchaseOrderProperties(PurchaseOrder purchaseOrder, TicketPrintProperties ticketPrintProperties) {
        String string;
        CharSequence charSequence;
        Store store = DataProvider.get().getStore();
        Outlet outlet = DataProvider.get().getOutlet();
        double d = purchaseOrder.getTotalAmount();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReceiptPrintService.a(hashMap, DataProvider.get().getPrinters().getReceiptPrinter());
        String string2 = CurrencyUtil.getCurrencySymbol();
        hashMap.put("currencySymbol", string2);
        hashMap.put("slNoText", Messages.getString("ReceiptPrintService.41"));
        hashMap.put(g, POSConstants.DESCRIPTION);
        hashMap.put(f, POSConstants.RECEIPT_REPORT_QUANTITY_LABEL);
        hashMap.put("priceText", Messages.getString("InventoryItemEntryDialog.15") + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("unitText", POSConstants.UNIT);
        hashMap.put(e, POSConstants.AMOUNT + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("note", Messages.getString("ReceiptPrintService.75"));
        String string3 = purchaseOrder.getShipDate() != null ? DateUtil.formatFullDateAndTimeAsString(purchaseOrder.getShipDate()) : null;
        hashMap.put("shipDate", Messages.getString("ReceiptPrintService.76") + " " + string3);
        hashMap.put("signature1", Messages.getString("ReceiptPrintService.42"));
        hashMap.put("signature2", Messages.getString("ReceiptPrintService.43"));
        InventoryVendor inventoryVendor = purchaseOrder.getVendor();
        if (inventoryVendor != null) {
            charSequence = inventoryVendor.getName();
            string = inventoryVendor.getAddress();
            String string4 = inventoryVendor.getPhone();
            hashMap.put("vendorName", Messages.getString("InventoryStockInForm.7") + ": " + (String)charSequence);
            String string5 = "";
            if (string != null && !string.isEmpty()) {
                string5 = string5 + string;
            }
            if (string4 != null && !string4.isEmpty()) {
                hashMap.put("phone", "Phone: " + string4);
            }
            hashMap.put("vendorAddress", StringUtils.isNotEmpty((String)string5) ? Messages.getString("DepartmentExplorer.6") + ": " + string5 + "  " : null);
        }
        hashMap.put(d, ticketPrintProperties.getReceiptTypeName());
        hashMap.put(c, ticketPrintProperties.isShowSubtotal());
        hashMap.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        hashMap.put(b, ticketPrintProperties.isShowFooter());
        hashMap.put(a, POSConstants.RECEIPT_REPORT_DATE_LABEL + DateUtil.formatFullDateAndTimeAsString(new Date()));
        charSequence = ReceiptPrintService.a(purchaseOrder, ticketPrintProperties);
        hashMap.put("ticketHeader2", ((StringBuilder)charSequence).toString());
        hashMap.put("ticketHeader3", Messages.getString("InventoryLocationDAO.4"));
        string = purchaseOrder.getInvoiceNumber() != null ? Messages.getString("ReceiptPrintService.77") + purchaseOrder.getInvoiceNumber() : null;
        hashMap.put("invoiceNumber", string);
        hashMap.put("reportTitle", Messages.getString("ReceiptPrintService.58"));
        hashMap.put(HEADER_LINE1, store.getName());
        hashMap.put("headerLine9", store.getTelephone());
        hashMap.put("headerLine2", outlet.getAddressLine1());
        hashMap.put("headerLine3", outlet.getAddressLine2());
        hashMap.put("headerLine4", outlet.getStreet());
        hashMap.put("headerLine5", outlet.getCity() + ", " + outlet.getZipCode());
        hashMap.put("headerLine6", outlet.getState());
        hashMap.put("headerLine8", outlet.getCountry());
        if (ticketPrintProperties.isShowFooter()) {
            if (purchaseOrder.getDiscountAmount() > 0.0) {
                hashMap.put(DISCOUNT_AMOUNT, NumberUtil.formatNumber(purchaseOrder.getDiscountAmount()));
            }
            if (purchaseOrder.getTaxAmount() > 0.0) {
                hashMap.put(TAX_AMOUNT, NumberUtil.formatNumber(purchaseOrder.getTaxAmount()));
            }
            hashMap.put(TOTAL_TEXT, POSConstants.RECEIPT_REPORT_TOTAL_LABEL + string2);
            hashMap.put(DISCOUNT_TEXT, POSConstants.RECEIPT_REPORT_DISCOUNT_LABEL + string2);
            hashMap.put(TAX_TEXT, POSConstants.RECEIPT_REPORT_TAX_LABEL + string2);
            hashMap.put(SERVICE_CHARGE_TEXT, POSConstants.RECEIPT_REPORT_SERVICE_CHARGE_LABEL + string2);
            hashMap.put(TIPS_TEXT, POSConstants.RECEIPT_REPORT_TIPS_LABEL + string2);
            hashMap.put(NET_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_NETAMOUNT_LABEL + string2);
            hashMap.put(DUE_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_DUEAMOUNT_LABEL + string2);
            hashMap.put(CHANGE_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_CHANGEAMOUNT_LABEL + string2);
            hashMap.put(NET_AMOUNT, NumberUtil.getCurrencyFormatWithoutCurrencySymbol(d));
            hashMap.put(DUE_AMOUNT, NumberUtil.getCurrencyFormatWithoutCurrencySymbol(purchaseOrder.getDueAmount()));
            hashMap.put(GRAND_SUBTOTAL, NumberUtil.getCurrencyFormatWithoutCurrencySymbol(purchaseOrder.getSubtotalAmount()));
            hashMap.put(FOOTER_MESSAGE, store.getTicketFooterMessage());
            hashMap.put(COPY_TYPE, ticketPrintProperties.getReceiptCopyType());
        }
        return hashMap;
    }

    private static String b(Ticket ticket) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        double d = ticket.getTotalAmountWithTips();
        String string = ReceiptUtil.getReceiptSection(DataProvider.get().getStore(), "tips_suggestion", ticket.getOrderType().getId());
        if (string == null) {
            string = "[{\"percentage\":25,\"sortOrder\":1},{\"percentage\":20,\"sortOrder\":2},{\"percentage\":18,\"sortOrder\":3},{\"percentage\":15,\"sortOrder\":4}]";
        }
        JSONArray jSONArray = new JSONArray(string);
        ReceiptPrintService.a(stringBuilder);
        for (int i = 0; i < jSONArray.length(); ++i) {
            Object object = jSONArray.get(i);
            if (object == null) continue;
            JSONObject jSONObject = new JSONObject(object.toString());
            double d2 = jSONObject.getDouble("percentage");
            ReceiptPrintService.a(stringBuilder, "<br>" + NumberUtil.trimDecilamIfNotNeeded(d2) + "% " + Messages.getString("ReceiptPrintService.99") + NumberUtil.formatNumber(d * d2 / 100.0));
        }
        ReceiptPrintService.b(stringBuilder);
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private static StringBuilder a(PurchaseOrder purchaseOrder, TicketPrintProperties ticketPrintProperties) {
        String string = " ";
        if (purchaseOrder.getOrderId() != null) {
            string = purchaseOrder.getOrderId();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        InventoryLocation inventoryLocation = purchaseOrder.getInventoryLocation();
        String string2 = "";
        String string3 = "";
        if (inventoryLocation != null) {
            string2 = inventoryLocation.getName();
            string3 = inventoryLocation.getAddress();
        }
        if (purchaseOrder.getVarificationDate() != null) {
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, "Date: " + DateUtil.formatFullDateAndTimeAsString(purchaseOrder.getVarificationDate()));
            ReceiptPrintService.b(stringBuilder);
        }
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, "Purchase Order #" + string);
        ReceiptPrintService.b(stringBuilder);
        if (StringUtils.isNotEmpty((String)string2)) {
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, "Inventory Location: " + string2);
            ReceiptPrintService.b(stringBuilder);
        }
        if (StringUtils.isNotEmpty((String)string3)) {
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, "Inventory Location Address: " + string3);
            ReceiptPrintService.b(stringBuilder);
        }
        stringBuilder.append("</html>");
        return stringBuilder;
    }

    public static StringBuilder getTaxBreakdown(Ticket ticket, Store store) {
        return ReceiptPrintService.getTaxBreakdown(ticket, 20, 27, false, store);
    }

    public static StringBuilder getTaxBreakdown(Ticket ticket, int n, int n2, boolean bl, Store store) {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, Double> map = ReceiptPrintService.populateTaxBreakdownMap(ticket);
        if (map.isEmpty()) {
            return null;
        }
        String string = CurrencyUtil.getCurrencySymbol();
        stringBuilder.append("<html><table>");
        Boolean bl2 = ticket.isTaxIncluded();
        String string2 = "(" + POSConstants.RECEIPT_REPORT_TAX_LABEL + ") ";
        Iterator<Map.Entry<String, Double>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Double> entry = iterator.next();
            String string3 = NumberUtil.formatNumber(entry.getValue());
            String string4 = entry.getKey();
            if (!bl && string4.length() > 15) {
                string4 = string4.substring(0, 13) + "..";
            }
            string4 = string4 + string;
            if (bl2.booleanValue()) {
                string4 = string4 + Messages.getString("ReceiptPrintService.18");
            }
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string2 + string4, string4.length(), RIGHT));
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string3, n2 - (bl ? 0 : string3.length()), RIGHT));
            if (!iterator.hasNext()) continue;
            ReceiptPrintService.b(stringBuilder);
        }
        stringBuilder.append("</div></table></html>");
        return stringBuilder;
    }

    public static Map<String, Double> populateTaxBreakdownMap(Ticket ticket) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        if (ticket.isTaxExempt().booleanValue()) {
            return hashMap;
        }
        List<TicketItem> list = ticket.getTicketItems();
        ArrayList<TicketItemTax> arrayList = new ArrayList<TicketItemTax>();
        for (TicketItem ticketItem : list) {
            for (TicketItemTax ticketItemTax : ticketItem.getTaxes()) {
                Object object = ticketItemTax.getName();
                Object object2 = (Double)hashMap.get(object);
                if (object2 == null) {
                    object2 = 0.0;
                }
                object2 = (Double)object2 + ticketItemTax.getTaxAmount();
                hashMap.put((String)object, (Double)object2);
                arrayList.add(ticketItemTax);
            }
            List<TicketItemModifier> list2 = ticketItem.getTicketItemModifiers();
            if (list2 == null) continue;
            for (Object object : list2) {
                if (((BaseTicketItemModifier)object).isInfoOnly().booleanValue()) continue;
                for (TicketItemTax ticketItemTax : ((TicketItemModifier)object).getTaxes()) {
                    String string = ticketItemTax.getName();
                    Double d = (Double)hashMap.get(string);
                    if (d == null) {
                        d = 0.0;
                    }
                    d = d + ticketItemTax.getTaxAmount();
                    hashMap.put(string, d);
                    arrayList.add(ticketItemTax);
                }
            }
        }
        return hashMap;
    }

    @Deprecated
    public static StringBuilder buildMulticurrencyBreakdown(Ticket ticket, TicketPrintProperties ticketPrintProperties, boolean bl) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><table>");
        String string = "------------------------------------";
        ReceiptPrintService.a(stringBuilder);
        String string2 = " ";
        ReceiptPrintService.a(stringBuilder, string2);
        ReceiptPrintService.a(stringBuilder, string2);
        ReceiptPrintService.a(stringBuilder, string2);
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, "<b>Currency breakdown</b>");
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("", 13, RIGHT));
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("Net Amount", bl ? 13 : 11, RIGHT));
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("Due", bl ? 13 : 17, RIGHT));
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.b(stringBuilder);
        int n = 0;
        List<Currency> list = CurrencyUtil.getAllCurrency();
        if (list != null) {
            for (Currency currency : list) {
                if (currency == null) continue;
                String string3 = currency.getName();
                double d = currency.getExchangeRate();
                ReceiptPrintService.a(stringBuilder);
                ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string3, string3.length(), RIGHT));
                String string4 = decimalFormat.format(ticket.getTotalAmountWithTips() * d);
                String string5 = decimalFormat.format(ticket.getDueAmount() * d);
                ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string4, bl ? 13 : 20 - string4.length(), RIGHT));
                ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string5, bl ? 13 : 20 - string5.length(), RIGHT));
                ReceiptPrintService.b(stringBuilder);
                ++n;
            }
        }
        if (n == 0) {
            return null;
        }
        stringBuilder.append("</table></html>");
        return stringBuilder;
    }

    public static StringBuilder buildAllMultiCurrency(Map map, Ticket ticket, PosTransaction posTransaction, boolean bl) {
        return ReceiptPrintService.buildAllMultiCurrency(map, ticket, posTransaction, bl, false);
    }

    public static StringBuilder buildAllMultiCurrency(Map map, Ticket ticket, PosTransaction posTransaction, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        String string = "------------------------------------";
        String string2 = ticket.getProperty("GROUP_SETTLE_TICKETS");
        if (string2 == null) {
            string2 = "";
        }
        if (ticket.getDueAmount() > 0.0 && !bl2) {
            ReceiptPrintService.a(map, bl, stringBuilder, string, string2, ticket);
        }
        if (posTransaction != null) {
            ReceiptPrintService.a(ticket, posTransaction, bl, stringBuilder, string, string2);
        }
        if (!bl) {
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a();
            ReceiptPrintService.b(stringBuilder);
        }
        stringBuilder.append("</html>");
        return stringBuilder;
    }

    private static void a(Ticket ticket, PosTransaction posTransaction, boolean bl, StringBuilder stringBuilder, String string, String string2) {
        Set<PosTransaction> set = ticket.getTransactions();
        if (set == null || set.isEmpty()) {
            return;
        }
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
        for (Comparable comparable : set) {
            if (comparable.equals(posTransaction)) continue;
            arrayList.add((PosTransaction)comparable);
        }
        List<TransactionDataRow> list = ReceiptPrintService.a(ticket, arrayList);
        if (list != null && list.size() > 0) {
            Comparable comparable;
            comparable = new StringBuilder();
            ReceiptPrintService.a((StringBuilder)comparable);
            ReceiptPrintService.a();
            ReceiptPrintService.b((StringBuilder)comparable);
            ReceiptPrintService.a((StringBuilder)comparable);
            ReceiptPrintService.a((StringBuilder)comparable, string2 + "<b>" + Messages.getString("ReceiptPrintService.34") + "</b>");
            ReceiptPrintService.b((StringBuilder)comparable);
            ReceiptPrintService.a((StringBuilder)comparable);
            ReceiptPrintService.a((StringBuilder)comparable, string);
            ReceiptPrintService.b((StringBuilder)comparable);
            for (TransactionDataRow transactionDataRow : list) {
                ReceiptPrintService.a((StringBuilder)comparable);
                String string3 = transactionDataRow.getPaymentType();
                String string4 = NumberUtil.formatNumberAcceptNegative(transactionDataRow.getAmount());
                ReceiptPrintService.a((StringBuilder)comparable, ReceiptPrintService.getHtmlText(string3, string3.length(), RIGHT));
                ReceiptPrintService.a((StringBuilder)comparable, ReceiptPrintService.getHtmlText(string4, bl ? 13 : 20 - string4.length(), RIGHT));
                ReceiptPrintService.b((StringBuilder)comparable);
            }
            stringBuilder.append((CharSequence)((Object)comparable));
        }
    }

    private static void a(Map map, boolean bl, StringBuilder stringBuilder, String string, String string2, Ticket ticket) {
        List<Currency> list = CurrencyUtil.getAllCurrency();
        if (list == null) {
            return;
        }
        if (bl) {
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a();
            ReceiptPrintService.b(stringBuilder);
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, string2 + "<b>" + Messages.getString("ReceiptPrintService.37") + "</b>");
            ReceiptPrintService.b(stringBuilder);
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, string);
            ReceiptPrintService.b(stringBuilder);
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("", 10, RIGHT));
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(Messages.getString("PosMessage.87"), bl ? 14 : 16, RIGHT));
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(Messages.getString("ReceiptPrintService.39"), bl ? 14 : 12, RIGHT));
            ReceiptPrintService.b(stringBuilder);
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, string);
            ReceiptPrintService.b(stringBuilder);
            for (Currency currency : list) {
                if (currency == null) continue;
                double d = currency.getExchangeRate();
                String string3 = currency.getCode();
                String string4 = " " + NumberUtil.format(ticket.getTotalAmount() * d);
                String string5 = " " + NumberUtil.format(ticket.getDueAmount() * d);
                ReceiptPrintService.a(stringBuilder);
                ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string3, string3.length(), RIGHT));
                ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string4, bl ? 14 : 20 - string4.length(), RIGHT));
                ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string5, bl ? 14 : 20 - string5.length(), RIGHT));
                ReceiptPrintService.b(stringBuilder);
            }
        } else {
            List<CurrencyDataRow> list2 = ReceiptPrintService.buildCurrencyBreakdownRows(ticket, list);
            if (list2.size() > 0) {
                ReciptPaperSize reciptPaperSize = ReceiptPrintService.getReceiptPaperSize("main.recipt.paper_size");
                map.put("currencyBreakdownTitle", Messages.getString("ReceiptPrintService.37"));
                map.put("currencyTotalAmountText", Messages.getString("PosMessage.87"));
                map.put("currencyDueAmountText", Messages.getString("ReceiptPrintService.39"));
                CurrencyBreakdownReportModel currencyBreakdownReportModel = new CurrencyBreakdownReportModel();
                currencyBreakdownReportModel.setRows(list2);
                map.put("currencyBreakdownDataSource", new JRTableModelDataSource((TableModel)currencyBreakdownReportModel));
                JasperReport jasperReport = ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size("ticket-recipt-currency-breakdown"));
                map.put("currencyBreakdownReport", jasperReport);
            }
        }
    }

    public static List<CurrencyDataRow> buildCurrencyBreakdownRows(Ticket ticket, List<Currency> list) {
        ArrayList<CurrencyDataRow> arrayList = new ArrayList<CurrencyDataRow>();
        if (list == null) {
            return arrayList;
        }
        for (Currency currency : list) {
            if (currency == null) continue;
            double d = currency.getExchangeRate();
            CurrencyDataRow currencyDataRow = new CurrencyDataRow(currency.getCode(), ticket.getTotalAmount() * d, ticket.getDueAmount() * d);
            arrayList.add(currencyDataRow);
        }
        return arrayList;
    }

    @Deprecated
    public static StringBuilder buildMultiCurrency(Ticket ticket, PosTransaction posTransaction, TicketPrintProperties ticketPrintProperties, boolean bl) {
        if (posTransaction == null) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><table>");
        String string = "------------------------------------";
        ReceiptPrintService.a(stringBuilder);
        String string2 = " ";
        ReceiptPrintService.a(stringBuilder, string2);
        ReceiptPrintService.b(stringBuilder);
        String string3 = ticket.getProperty("GROUP_SETTLE_TICKETS");
        if (string3 == null) {
            string3 = "";
        }
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string3 + "<b>\nCurrency breakdown</b>");
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("", 10, RIGHT));
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("Paid", bl ? 13 : 16, RIGHT));
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("Cashback", bl ? 13 : 12, RIGHT));
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.b(stringBuilder);
        int n = 0;
        for (Currency currency : CurrencyUtil.getAllCurrency()) {
            if (currency == null) continue;
            String string4 = currency.getName();
            String string5 = currency.getId() + "_TENDERED";
            String string6 = currency.getId() + "_CASH_BACK";
            String string7 = posTransaction.getProperty(string5);
            String string8 = posTransaction.getProperty(string6);
            if (string7 == null) {
                string7 = "0";
            }
            if (string8 == null) {
                string8 = "0";
            }
            Double d = Double.valueOf(string7);
            Double d2 = Double.valueOf(string8);
            if (d == 0.0 && d2 == 0.0) continue;
            String string9 = decimalFormat.format(d);
            String string10 = decimalFormat.format(d2);
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string4, string4.length(), RIGHT));
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string9, bl ? 13 : 20 - string9.length(), RIGHT));
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string10, bl ? 13 : 20 - string10.length(), RIGHT));
            ReceiptPrintService.b(stringBuilder);
            ++n;
        }
        if (n == 0) {
            return null;
        }
        stringBuilder.append("</table></html>");
        return stringBuilder;
    }

    public static String getHtmlText(String string, int n, String string2) {
        block4: {
            String string3;
            block5: {
                block3: {
                    string3 = "&nbsp;";
                    if (!string2.equals(CENTER)) break block3;
                    int n2 = (n - string.length()) / 2;
                    for (int i = 1; i <= n2; ++i) {
                        string = string3 + string + string3;
                    }
                    break block4;
                }
                if (!string2.equals(RIGHT)) break block5;
                int n3 = n - string.length();
                for (int i = 1; i <= n3; ++i) {
                    string = string3 + string;
                }
                break block4;
            }
            if (!string2.equals(LEFT)) break block4;
            int n4 = n - string.length();
            for (int i = 1; i <= n4; ++i) {
                string = string + string3;
            }
        }
        return string;
    }

    public static void printVoidKitchenTicket(String string, KitchenTicket kitchenTicket, String string2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(HEADER_LINE1, DataProvider.get().getStore().getName());
        hashMap.put(CARD_PAYMENT, true);
        hashMap.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        hashMap.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        hashMap.put(ReceiptParam.TICKET_ID.getParamName(), POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + kitchenTicket.getTicketId());
        if (kitchenTicket.getTableNumbers() != null && kitchenTicket.getTableNumbers().size() > 0) {
            hashMap.put(ReceiptParam.TABLE_NO.getParamName(), POSConstants.RECEIPT_REPORT_TABLE_NO_LABEL + kitchenTicket.getTableNumbers());
        }
        if (StringUtils.isNotEmpty((String)kitchenTicket.getCustomerName())) {
            hashMap.put("customer", Messages.getString("ReceiptPrintService.0") + kitchenTicket.getCustomerName());
        }
        hashMap.put(ReceiptParam.SERVER_NAME.getParamName(), POSConstants.RECEIPT_REPORT_SERVER_LABEL + kitchenTicket.getServerName());
        hashMap.put(a, Messages.getString("ReceiptPrintService.119") + DateUtil.getReportDate());
        hashMap.put(TICKET_HEADER, Messages.getString("ReceiptPrintService.12"));
        String string3 = kitchenTicket.getOrderType().toString();
        if (StringUtils.isNotEmpty((String)string3)) {
            string3 = string3.replaceAll("_", " ");
        }
        hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), "** VOID **");
        hashMap.put(PROP_PRINTER_NAME, Messages.getString("ReceiptPrintService.14") + string);
        ReceiptPrintService.getJasperPrintService().printVoidKitchenTicket(kitchenTicket, hashMap, string, string2);
    }

    public static void printToKitchen(Ticket ticket) {
        ReceiptPrintService.printToKitchen(ticket, true);
    }

    public static void printToKitchen(Ticket ticket, boolean bl) {
        ReceiptPrintService.printToKitchen(ticket, bl, true);
    }

    public static void printToKitchen(Ticket ticket, boolean bl, boolean bl2) {
        try {
            List<KitchenTicket> list = KitchenTicket.fromTicket(ticket, bl);
            if (list == null || list.isEmpty()) {
                return;
            }
            ReceiptPrintService.doPrintToKitchenAndSaveStatus(ticket, list, bl2);
            ReceiptPrintService.c();
            CloudDataUploader.get().uploadTicketIfOnlineOrder(ticket);
        }
        catch (Exception exception) {
            throw new PrintException(Messages.getString("ReceiptPrintService.28"), exception);
        }
    }

    private static void c() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
            jSONObject.put("command", (Object)"3");
            jSONObject.put("isKds", (Object)Boolean.FALSE);
            OroMqttClient.getInstance().publishData("MQTT-COMMAND-KIT-DIS-UPDATE", jSONObject.toString());
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception);
        }
    }

    public static void printCourseItemsToKitchen(Ticket ticket, List<TicketItem> list, boolean bl) {
        try {
            if (ticket == null && list == null) {
                return;
            }
            List<KitchenTicket> list2 = KitchenTicket.fromTicket(ticket, bl, list);
            ReceiptPrintService.doPrintToKitchenAndSaveStatus(ticket, list2, bl);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CourseOrganizeTableView.0") + " " + POSConstants.COURSE + " " + list.get(0).getCourseName());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public static void printItemsToKitchen(Ticket ticket, List<TicketItem> list) {
        try {
            if (ticket == null && list == null) {
                return;
            }
            List<KitchenTicket> list2 = KitchenTicket.fromTicket(ticket, true, list);
            ReceiptPrintService.doPrintToKitchenAndSaveStatus(ticket, list2, true);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public static void doPrintToKitchenAndSaveStatus(Ticket ticket, List<KitchenTicket> list, boolean bl) throws Exception {
        ReceiptPrintService.doPrintToKitchenAndSaveStatus(ticket, list, bl, false);
    }

    public static void doPrintToKitchenAndSaveStatus(Ticket ticket, List<KitchenTicket> list, boolean bl, boolean bl2) throws Exception {
        if (bl) {
            ticket.setShouldUpdateStock(true);
        }
        for (KitchenTicket kitchenTicket : list) {
            kitchenTicket.setParentTicket(ticket);
            Printer printer = kitchenTicket.getPrinter();
            String string = printer.getDeviceName();
            if (printer.getVirtualPrinter().getType() == 2 && string != null) {
                i.info((Object)("Printing to kitchen using printer: " + string));
                HashMap hashMap = ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, string, printer.getVirtualPrinter().getName(), bl2);
                ReceiptPrintService.setPrintProperty(hashMap, printer);
                hashMap.put("beep_after_print_to_kitchen_is_done ", printer.getVirtualPrinter().isBeepAfterPrintToKitchenIsDone());
                ReceiptPrintService.getReceiptPrintServiceProvider(printer).printKitchenTicket(kitchenTicket, hashMap, ticket, printer.getVirtualPrinter().getName(), string);
                if (!bl || !DataProvider.get().getStore().isKDSenabled()) continue;
                TicketDAO.getInstance().saveKitchenPrintStatus(ticket, kitchenTicket);
                continue;
            }
            if (printer.getVirtualPrinter().getType() == 6 && string != null) {
                i.info((Object)("Printing to sticker using printer: " + string));
                ReceiptPrintService.a(kitchenTicket, string);
                continue;
            }
            if (!bl || printer.getVirtualPrinter().getType() != 4) continue;
            TicketDAO.getInstance().saveKitchenPrintStatus(ticket, kitchenTicket);
        }
        if (bl) {
            ticket.clearDeletedItems();
            ticket.setTicketStatus(TicketStatus.Preparing);
            TicketDAO.getInstance().saveOrUpdate(ticket);
        }
    }

    public static void doPrintKitchenTicketAfterBump(Ticket ticket) throws Exception {
        if (ticket == null) {
            return;
        }
        List<Printer> list = DataProvider.get().getPrinters().getPackingPrinters();
        if (list == null || list.size() == 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NO_PACKING_PRINTER_CONFIGURED"));
            return;
        }
        for (Printer printer : list) {
            String string = printer.getDeviceName();
            if (printer.getVirtualPrinter().getType() != 3 || string == null) continue;
            i.info((Object)("Printing to kitchen using packing printer: " + string));
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, true, true, true);
            HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
            ReceiptPrintService.setPrintProperty(hashMap, printer);
            ReceiptPrintService.getReceiptPrintServiceProvider(printer).printTicket(ticket, hashMap, string);
        }
    }

    public static void doPrintKitchenStickers(Ticket ticket) {
        try {
            List<Printer> list = DataProvider.get().getPrinters().getStickerPrinters();
            if (list.isEmpty()) {
                return;
            }
            List<KitchenTicket> list2 = KitchenTicket.fromTicket(ticket, true);
            for (KitchenTicket kitchenTicket : list2) {
                Printer printer = kitchenTicket.getPrinter();
                String string = printer.getDeviceName();
                kitchenTicket.setParentTicket(ticket);
                if (printer.getVirtualPrinter().getType() != 6 || string == null) continue;
                ReceiptPrintService.a(kitchenTicket, string);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private static void a(KitchenTicket kitchenTicket, String string) {
        try {
            List<KitchenTicketItem> list = kitchenTicket.getTicketItems();
            ArrayList<KitchenStickerModel.KitchenSticker> arrayList = new ArrayList<KitchenStickerModel.KitchenSticker>();
            int n = 0;
            int n2 = ReceiptPrintService.a(list);
            for (KitchenTicketItem object : list) {
                if (!object.isPrintKitchenSticker().booleanValue() || object.isModifierItem().booleanValue() || object.isCookingInstruction().booleanValue()) continue;
                int jasperPrint = 0;
                while ((double)jasperPrint < object.getQuantity()) {
                    String string2;
                    KitchenStickerModel.KitchenSticker kitchenSticker = new KitchenStickerModel.KitchenSticker();
                    kitchenSticker.setToken(kitchenTicket.getTokenNo());
                    kitchenSticker.setCustomerName(ReceiptPrintService.a(kitchenTicket));
                    String string3 = object.getMenuItemName();
                    if (StringUtils.isNotEmpty((String)string3)) {
                        string3 = object.getQuantity() > 1.0 ? string3.substring(string3.indexOf(32) + 1) : string3;
                    }
                    kitchenSticker.setItemName(string3);
                    kitchenSticker.setModifiers(kitchenTicket.getModifiersForTicketItem(object.getTicketItemId()));
                    kitchenSticker.setCookingInstructions(kitchenTicket.getCookingInstructionForTicketItem(object.getTicketItemId()));
                    kitchenSticker.setTime(Messages.getString("ReceiptPrintService.102") + DateUtil.formatAsMonthDateWithTime(new Date()));
                    if (kitchenTicket.getOrderType() != null) {
                        kitchenSticker.setOrderType(kitchenTicket.getOrderType().getName());
                    }
                    if (StringUtils.isNotBlank((String)(string2 = kitchenTicket.getTicketId()))) {
                        kitchenSticker.setTicketId(string2);
                    }
                    kitchenSticker.setItemCount(Messages.getString("ReceiptPrintService.103") + (n + 1) + Messages.getString("ReceiptPrintService.104") + n2);
                    arrayList.add(kitchenSticker);
                    ++n;
                    ++jasperPrint;
                }
            }
            if (arrayList.isEmpty()) {
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                KitchenStickerModel.KitchenSticker kitchenSticker = (KitchenStickerModel.KitchenSticker)arrayList.get(i);
                JasperPrint jasperPrint = ReceiptPrintService.printKitchenStickerItems(Arrays.asList(kitchenSticker));
                jasperPrint.setName("Kitchen_Sticker_" + kitchenTicket.getTokenNo() + "_" + i);
                jasperPrint.setProperty(PROP_PRINTER_NAME, string);
                JasperPrintService.printQuitely(jasperPrint);
            }
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception.getMessage(), exception);
        }
    }

    private static String a(KitchenTicket kitchenTicket) {
        Ticket ticket = kitchenTicket.getParentTicket();
        if (ticket == null) {
            return null;
        }
        Customer customer = ticket.getCustomer();
        String string = ticket.getNote();
        String string2 = "";
        if (customer != null) {
            string2 = customer.getName();
        }
        if (StringUtils.isNotBlank((String)string)) {
            string2 = StringUtils.isNotBlank((String)string2) ? string2 + "/" + string : string;
        }
        return string2;
    }

    private static int a(List<KitchenTicketItem> list) {
        int n = 0;
        for (KitchenTicketItem kitchenTicketItem : list) {
            if (!kitchenTicketItem.isPrintKitchenSticker().booleanValue() || kitchenTicketItem.isModifierItem().booleanValue() || kitchenTicketItem.isCookingInstruction().booleanValue()) continue;
            n = (int)((double)n + kitchenTicketItem.getQuantity());
        }
        return n;
    }

    @Deprecated
    public static JasperPrint getKitchenJasperPrint(Ticket ticket, boolean bl) {
        return ReceiptPrintService.getKitchenJasperPrint(ticket, bl, false);
    }

    @Deprecated
    public static JasperPrint getKitchenJasperPrint(Ticket ticket, boolean bl, boolean bl2) {
        try {
            List<KitchenTicket> list = KitchenTicket.fromTicket(ticket, bl);
            for (KitchenTicket kitchenTicket : list) {
                kitchenTicket.setParentTicket(ticket);
                Printer printer = kitchenTicket.getPrinter();
                String string = printer.getDeviceName();
                if (string == null) continue;
                HashMap hashMap = ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, string, printer.getVirtualPrinter().getName(), bl2);
                JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createKitchenPrint(hashMap, printer.getVirtualPrinter().getName(), kitchenTicket, string, bl2);
                jasperPrint.setName("FP_KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                jasperPrint.setProperty(PROP_PRINTER_NAME, string);
                return jasperPrint;
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
        return null;
    }

    public static void printVoidItemsToKitchen(Ticket ticket) {
        try {
            Serializable serializable;
            Object object;
            Comparable comparable22;
            if (!ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Comparable comparable22 : ticket.getTicketItems()) {
                VoidItem voidItem = comparable22.getVoidItem();
                if (voidItem == null) continue;
                if (voidItem.getVoidedModifiers() != null) {
                    arrayList.addAll(voidItem.getVoidedModifiers());
                }
                arrayList.add(voidItem);
            }
            HashMap hashMap = new HashMap();
            comparable22 = StoreDAO.getServerTimestamp();
            for (VoidItem comparable3 : arrayList) {
                if (comparable3.isCooked() || (object = ReceiptPrintService.getPrinters((PrinterGroup)(serializable = comparable3.getPrinterGroup()))) == null) continue;
                Iterator<Printer> iterator = object.iterator();
                while (iterator.hasNext()) {
                    Printer printer = iterator.next();
                    KitchenTicket kitchenTicket = (KitchenTicket)hashMap.get(printer);
                    if (kitchenTicket == null) {
                        kitchenTicket = new KitchenTicket();
                        kitchenTicket.setPrinterGroup((PrinterGroup)serializable);
                        kitchenTicket.setTicketId(ticket.getId());
                        kitchenTicket.setTokenNo(ticket.getTokenNo());
                        kitchenTicket.setCreateDate((Date)comparable22);
                        kitchenTicket.setOrderType(ticket.getOrderType());
                        if (ticket.getTableNumbers() != null) {
                            kitchenTicket.setTableNumbers(new ArrayList<Integer>(ticket.getTableNumbers()));
                        }
                        kitchenTicket.setServerName(ticket.getOwner().getFirstName());
                        kitchenTicket.setStatus(KitchenStatus.WAITING.name());
                        if (StringUtils.isNotEmpty((String)ticket.getProperty("CUSTOMER_NAME"))) {
                            kitchenTicket.setCustomerName(ticket.getProperty("CUSTOMER_NAME"));
                        }
                        kitchenTicket.setPrinter(printer);
                        hashMap.put(printer, kitchenTicket);
                    }
                    KitchenTicketItem kitchenTicketItem = new KitchenTicketItem();
                    kitchenTicketItem.setTicketItemId(comparable3.getId());
                    kitchenTicketItem.setMenuItemCode(String.valueOf(comparable3.getMenuItemId()));
                    kitchenTicketItem.setMenuItemName(comparable3.getMenuItemName());
                    kitchenTicketItem.setQuantity(comparable3.getQuantity());
                    kitchenTicketItem.setUnitName("");
                    kitchenTicketItem.setMenuItemGroupName("VOID");
                    kitchenTicketItem.setSortOrder(10001);
                    kitchenTicketItem.setStatus(KitchenStatus.VOID.name());
                    kitchenTicketItem.setKitchenTicket(kitchenTicket);
                    kitchenTicket.addToticketItems(kitchenTicketItem);
                }
            }
            for (KitchenTicket kitchenTicket : hashMap.values()) {
                serializable = kitchenTicket.getPrinter();
                object = ((Printer)serializable).getDeviceName();
                ReceiptPrintService.printVoidKitchenTicket(((Printer)serializable).getVirtualPrinter().getName(), kitchenTicket, (String)object);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public static List<Printer> getPrinters(PrinterGroup printerGroup) {
        PosPrinters posPrinters = DataProvider.get().getPrinters();
        if (printerGroup == null) {
            printerGroup = PrinterGroupDAO.getInstance().getDefaultPrinterGroup();
        }
        ArrayList<Printer> arrayList = new ArrayList<Printer>();
        if (printerGroup == null) {
            arrayList.addAll(posPrinters.getKitchenPrinters());
            return arrayList;
        }
        List<String> list = printerGroup.getPrinterNames();
        List<Printer> list2 = posPrinters.getKitchenPrinters();
        for (Printer printer : list2) {
            if (!list.contains(printer.getVirtualPrinter().getName())) continue;
            arrayList.add(printer);
        }
        if (arrayList.isEmpty() && PrintServiceUtil.getFallBackPrinter() != null) {
            arrayList.add(PrintServiceUtil.getFallBackPrinter());
        }
        return arrayList;
    }

    public static Log getLogger() {
        return i;
    }

    public static File getPdfPrinterDir() {
        return h;
    }

    private static String b(PosTransaction posTransaction) {
        String string = "<br>";
        String string2 = string + Messages.getString("ReceiptPrintService.15") + " ------------------------";
        try {
            String string3;
            if (posTransaction.getCardReader() != null) {
                string2 = string2 + string + Messages.getString("ReceiptPrintService.17") + posTransaction.getCardReader();
            }
            if (posTransaction.getCardType() != null) {
                string2 = string2 + string + Messages.getString("ReceiptPrintService.20") + posTransaction.getCardType();
            }
            if ((string3 = posTransaction.getCardNumber()) != null) {
                string2 = string2 + string + Messages.getString("ReceiptPrintService.21") + " **** **** **** " + string3.substring(string3.length() - 4, string3.length());
            }
            if (posTransaction.getCardHolderName() != null) {
                string2 = string2 + string + Messages.getString("ReceiptPrintService.23") + posTransaction.getCardHolderName();
            }
            if (posTransaction.getCardTransactionId() != null) {
                string2 = string2 + string + Messages.getString("ReceiptPrintService.24") + posTransaction.getCardTransactionId();
            }
            string2 = string2 + string + Messages.getString("ReceiptPrintService.29") + posTransaction.getCardAuthCode();
        }
        catch (Exception exception) {
            i.error((Object)exception);
        }
        return string2;
    }

    public static void printCloudTicket(Ticket ticket, Terminal terminal, PosTransaction posTransaction) {
        try {
            Printer printer;
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
            List<TerminalPrinters> list = TerminalPrintersDAO.getInstance().findTerminalPrinters(terminal);
            ArrayList<Printer> arrayList = new ArrayList<Printer>();
            for (TerminalPrinters serializable : list) {
                int n = serializable.getVirtualPrinter().getType();
                if (n != 1) continue;
                printer = new Printer(serializable.getVirtualPrinter(), serializable.getPrinterName());
                arrayList.add(printer);
            }
            if (arrayList == null || arrayList.isEmpty()) {
                JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createPrint(ticket, hashMap, null);
                jasperPrint.setName(ORDER_ + ticket.getId());
                jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
                JasperPrintService.printQuitely(jasperPrint);
            } else {
                for (Printer printer2 : arrayList) {
                    String string = printer2.getDeviceName();
                    if (string == null) continue;
                    printer = ReceiptPrintService.getJasperPrintService().createPrint(ticket, hashMap, null);
                    printer.setName(ORDER_ + ticket.getId() + string);
                    printer.setProperty(PROP_PRINTER_NAME, string);
                    JasperPrintService.printQuitely((JasperPrint)printer);
                }
            }
        }
        catch (Exception exception) {
            i.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static ReciptPaperSize getReceiptPaperSize(String string) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        String string2 = terminal.getProperty(string);
        ReciptPaperSize reciptPaperSize = ReciptPaperSize.Eighty;
        try {
            if (StringUtils.isNotEmpty((String)string2)) {
                reciptPaperSize = ReciptPaperSize.valueOf(string2);
            }
        }
        catch (Exception exception) {
            reciptPaperSize = ReciptPaperSize.Eighty;
        }
        return reciptPaperSize;
    }

    private static KitchenStickerPaperSize b(String string) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        String string2 = terminal.getProperty(string);
        KitchenStickerPaperSize kitchenStickerPaperSize = KitchenStickerPaperSize.FiftyOneMM;
        try {
            if (StringUtils.isNotEmpty((String)string2)) {
                kitchenStickerPaperSize = KitchenStickerPaperSize.fromName(string2);
            }
        }
        catch (Exception exception) {
            kitchenStickerPaperSize = KitchenStickerPaperSize.FiftyOneMM;
        }
        return kitchenStickerPaperSize;
    }

    public static boolean hasNoReceiptPrinters() {
        boolean bl;
        PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
        boolean bl2 = paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal();
        List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
        boolean bl3 = bl = list == null || list.isEmpty() || list.size() == 0;
        return bl && !bl2;
    }

    public static boolean hasNoKitchenReceiptPrinters() {
        PosPrinters posPrinters = DataProvider.get().getPrinters();
        return posPrinters == null || posPrinters.getKitchenPrinters() == null || posPrinters.getKitchenPrinters().size() == 0 && posPrinters.getStickerPrinters().size() == 0 && !posPrinters.isPrintToKds();
    }

    private static void c(Ticket ticket) {
        int n = POSUtil.getIntegerOrZero(ticket.getProperty("printCount"));
        ticket.addProperty("printCount", String.valueOf(++n));
        OrderController.saveOrder(ticket);
    }

    public static HashMap populateKitchenTicketProperties(KitchenTicket kitchenTicket, String string, String string2, boolean bl) {
        return ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, string, string2, bl, false);
    }

    public static HashMap populateKitchenTicketProperties(KitchenTicket kitchenTicket, String string, String string2, boolean bl, boolean bl2) {
        OrderType orderType;
        String string3;
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(kitchenTicket.getParentTicket(), ticketPrintProperties, null, true, false, bl2);
        ReceiptPrintService.setPaginationProperty(hashMap, string, bl);
        if (ReceiptPrintService.b(kitchenTicket)) {
            hashMap.put(HEADER_LINE1, "**");
        }
        if (StringUtils.isNotEmpty((String)(string3 = kitchenTicket.getOrderType().toString()))) {
            string3 = string3.replaceAll("_", " ");
        }
        if ((orderType = kitchenTicket.getOrderType()).isDelivery().booleanValue() || orderType.isPickup().booleanValue()) {
            if (kitchenTicket.getParentTicket().isCustomerWillPickup().booleanValue()) {
                hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), "*" + Messages.getString("PICKUP") + "*");
            } else {
                hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), "*" + Messages.getString("DELIVERY") + "*");
            }
        } else {
            hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), "* " + string3 + " *");
        }
        hashMap.put(PROP_PRINTER_NAME, "Printer Name : " + string2);
        return hashMap;
    }

    private static boolean b(KitchenTicket kitchenTicket) {
        for (KitchenTicketItem kitchenTicketItem : kitchenTicket.getTicketItems()) {
            if (kitchenTicketItem.isVoided().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static void printQuitely(JasperPrint jasperPrint) throws JRException {
        JasperPrintService.printQuitely(jasperPrint);
    }

    private static void d(Ticket ticket) {
        String string = "Ticket is printed at %s. Total: %s";
        string = String.format(string, new Date(), ticket.getTotalAmount());
        ActionHistoryDAO.saveHistory(ticket, "Print receipt", string);
    }

    public static void printTestTicket(Ticket ticket) throws Exception {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        ReceiptPrintService.a(ticket, ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null));
    }

    private static void a(Ticket ticket, HashMap hashMap) throws Exception {
        List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
        if (list == null) {
            return;
        }
        for (Printer printer : list) {
            String string = printer.getDeviceName();
            if (string == null) continue;
            i.info((Object)String.format("Printing ticket %s payment using printer %s. Total amount %s", ticket.getId(), string, ticket.getTotalAmount()));
            ReceiptPrintService.setPrintProperty(hashMap, printer);
            ReceiptPrintService.a((HashMap<String, Object>)hashMap, string);
            ReceiptPrintService.getReceiptPrintServiceProvider(printer).printTicket(ticket, hashMap, string);
        }
    }

    private static String e(Ticket ticket) {
        Set<PosTransaction> set = ticket.getTransactions();
        if (set == null || set.isEmpty()) {
            return null;
        }
        BasePosTransaction basePosTransaction = null;
        for (PosTransaction posTransaction : set) {
            if (basePosTransaction == null) {
                basePosTransaction = posTransaction;
                continue;
            }
            if (posTransaction.getTransactionTime().compareTo(basePosTransaction.getTransactionTime()) <= 0) continue;
            basePosTransaction = posTransaction;
        }
        if (basePosTransaction instanceof CustomPaymentTransaction) {
            return basePosTransaction.getCustomPaymentName();
        }
        return basePosTransaction.getPaymentTypeString();
    }

    public static List<TransactionDataRow> buildPayments(PosTransaction posTransaction2, Ticket ticket) {
        if (ticket.getTransactions() == null) {
            return null;
        }
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>(ticket.getTransactions().stream().filter(posTransaction -> posTransaction.isVoided() == false).collect(Collectors.toList()));
        if (posTransaction2 == null && arrayList.size() == 0) {
            return null;
        }
        PosTransactionService.sortTransactionsByDateDesc(arrayList);
        if (posTransaction2 != null) {
            return ReceiptPrintService.a(ticket, posTransaction2);
        }
        return ReceiptPrintService.a(ticket, arrayList);
    }

    private static List<TransactionDataRow> a(Ticket ticket, PosTransaction posTransaction) {
        ArrayList<TransactionDataRow> arrayList = new ArrayList<TransactionDataRow>();
        if (ReceiptPrintService.isEnabledMulticurrency(ticket) && ReceiptPrintService.c(posTransaction) && ReceiptPrintService.d(posTransaction)) {
            arrayList.addAll(ReceiptPrintService.a(true, (Boolean)false, posTransaction));
            arrayList.addAll(ReceiptPrintService.a(false, (Boolean)true, posTransaction));
        } else {
            arrayList.add(ReceiptPrintService.a(posTransaction, CurrencyUtil.getCurrencySymbol(), posTransaction.getTenderAmount()));
        }
        return arrayList;
    }

    private static List<TransactionDataRow> a(Ticket ticket, List<PosTransaction> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<TransactionDataRow> arrayList = new ArrayList<TransactionDataRow>();
        for (PosTransaction posTransaction : list) {
            if (ReceiptPrintService.isEnabledMulticurrency(ticket) && ReceiptPrintService.c(posTransaction) && ReceiptPrintService.d(posTransaction)) {
                arrayList.addAll(ReceiptPrintService.a(false, (Boolean)false, posTransaction));
                continue;
            }
            arrayList.add(ReceiptPrintService.a(posTransaction, CurrencyUtil.getCurrencySymbol(), posTransaction.getAmount()));
        }
        return arrayList;
    }

    private static boolean c(PosTransaction posTransaction) {
        return posTransaction.getPaymentType() == null || posTransaction.getPaymentType() == PaymentType.CASH;
    }

    public static boolean isEnabledMulticurrency(Ticket ticket) {
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal != null && terminal.isEnableMultiCurrency().booleanValue()) {
            return true;
        }
        if (ticket == null) {
            return false;
        }
        return ticket.getBooleanProperty("enableMultiCurrency", false);
    }

    private static boolean d(PosTransaction posTransaction) {
        String string = posTransaction.getProperty("paymentCurrencies");
        if (StringUtils.isNotBlank((String)string)) {
            return true;
        }
        for (Currency currency : CurrencyUtil.getAllCurrency()) {
            String string2;
            if (currency == null || !StringUtils.isNotBlank((String)posTransaction.getProperty(string2 = currency.getId() + "_TENDERED"))) continue;
            return true;
        }
        return false;
    }

    private static List<TransactionDataRow> a(Boolean bl, Boolean bl2, PosTransaction ... posTransactionArray) {
        ArrayList<TransactionDataRow> arrayList = new ArrayList<TransactionDataRow>();
        List<Currency> list = CurrencyUtil.getAllCurrency();
        HashMap<String, Currency> hashMap = new HashMap<String, Currency>();
        for (Currency currency : list) {
            hashMap.put(currency.getId(), currency);
        }
        for (PosTransaction posTransaction : posTransactionArray) {
            String string;
            Object object;
            if (posTransaction.isVoided().booleanValue()) continue;
            String string2 = posTransaction.getProperty("paymentCurrencies");
            if (StringUtils.isBlank((String)string2)) {
                for (Currency currency : list) {
                    double d;
                    if (currency == null) continue;
                    object = currency.getId() + "_PAID";
                    string = currency.getId() + "_TENDERED";
                    String string3 = currency.getId() + "_CASH_BACK";
                    String string4 = posTransaction.getProperty(string);
                    String string5 = posTransaction.getProperty(string3);
                    double d2 = string4 == null ? 0.0 : NumberUtil.parseDouble(string4);
                    double d3 = d = string5 == null ? 0.0 : NumberUtil.parseDouble(string5);
                    if (d2 == 0.0 && d == 0.0) continue;
                    if (bl2.booleanValue()) {
                        if (!(d > 0.0)) continue;
                        arrayList.add(ReceiptPrintService.b(posTransaction, currency.getSymbol(), d));
                        continue;
                    }
                    if (d < 0.0) continue;
                    String string6 = posTransaction.getProperty((String)object);
                    double d4 = 0.0;
                    d4 = StringUtils.isNotBlank((String)string6) ? NumberUtil.parseDouble(string6) : d2 - d;
                    double d5 = bl != false ? d2 : d4;
                    if (d5 == 0.0) continue;
                    arrayList.add(ReceiptPrintService.a(posTransaction, currency.getSymbol(), d5));
                }
                continue;
            }
            List<MultiCurrencyTenderDialog.PaymentByCurrency> list2 = CurrencyUtil.createPaymentByCurrencies(string2);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                double d;
                object = (MultiCurrencyTenderDialog.PaymentByCurrency)iterator.next();
                if (((MultiCurrencyTenderDialog.PaymentByCurrency)object).tenderedAmount == 0.0 && ((MultiCurrencyTenderDialog.PaymentByCurrency)object).cashBackAmount == 0.0) continue;
                string = ((MultiCurrencyTenderDialog.PaymentByCurrency)object).currency.getSymbol();
                if (bl2.booleanValue()) {
                    if (!(((MultiCurrencyTenderDialog.PaymentByCurrency)object).cashBackAmount > 0.0)) continue;
                    arrayList.add(ReceiptPrintService.b(posTransaction, string, ((MultiCurrencyTenderDialog.PaymentByCurrency)object).cashBackAmount));
                    continue;
                }
                if (((MultiCurrencyTenderDialog.PaymentByCurrency)object).cashBackAmount < 0.0 || (d = bl != false ? ((MultiCurrencyTenderDialog.PaymentByCurrency)object).tenderedAmount : ((MultiCurrencyTenderDialog.PaymentByCurrency)object).paidAmount) == 0.0) continue;
                arrayList.add(ReceiptPrintService.a(posTransaction, string, d));
            }
        }
        return arrayList;
    }

    private static TransactionDataRow a(PosTransaction posTransaction, String string, Double d) {
        PaymentType paymentType = posTransaction.getPaymentType();
        String string2 = null;
        string2 = paymentType == PaymentType.CUSTOM_PAYMENT ? posTransaction.getCustomPaymentName() : WordUtils.capitalizeFully((String)paymentType.getDisplayString());
        string2 = posTransaction instanceof RefundTransaction ? string2 + Messages.getString("EscPosPrintService.0") + string : string2 + string;
        if (posTransaction instanceof RefundTransaction) {
            d = -1.0 * Math.abs(d);
        }
        return new TransactionDataRow(string2, d);
    }

    private static TransactionDataRow b(PosTransaction posTransaction, String string, Double d) {
        if (posTransaction instanceof RefundTransaction) {
            d = -1.0 * d;
        }
        return new TransactionDataRow(POSConstants.RECEIPT_REPORT_CHANGEAMOUNT_LABEL + string, d);
    }

    static {
        i = LogFactory.getLog(ReceiptPrintService.class);
        String string = System.getProperty("user.home");
        h = new File(string, "oropos-pdf-print");
        if (!h.exists()) {
            h.mkdirs();
        }
    }

    public static class TransactionDataRow {
        private String a;
        private Double b;

        public TransactionDataRow(String string, Double d) {
            this.a = string;
            this.b = d;
        }

        public String getPaymentType() {
            return this.a;
        }

        public void setPaymentType(String string) {
            this.a = string;
        }

        public Double getAmount() {
            return this.b;
        }

        public void setAmount(Double d) {
            this.b = d;
        }
    }
}

