/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.ServerProductivityReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.MultiSelectionOverflowCombobox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class ServerProductivityReportView
extends JPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private JPanel d;
    private MultiSelectComboBox<User> e;
    private List<User> f;

    public ServerProductivityReportView() {
        super(new BorderLayout());
        this.a();
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.e = new MultiSelectionOverflowCombobox<User>();
        this.f = UserDAO.getInstance().findAllActive();
        this.e.setItems(this.f);
        jPanel.add(new JLabel(POSConstants.USER + ":"));
        jPanel.add(this.e);
        jPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        jPanel.add((Component)this.a);
        jPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        jPanel.add((Component)this.b);
        jPanel.add((Component)this.c, "skip 1, al right");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
        this.c.addActionListener(actionEvent -> this.b());
    }

    private void b() {
        try {
            Date date = this.a.getDate();
            Date date2 = this.b.getDate();
            DateUtil.validateDate(date, date2);
            date = DateUtil.startOfDay(date);
            date2 = DateUtil.startOfNextDay(date2);
            ReportService reportService = new ReportService();
            ServerProductivityReport serverProductivityReport = reportService.getServerProductivityReport(date, date2, this.e.getSelectedItems() == null ? this.f : this.e.getSelectedItems());
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(hashMap, true);
            ReportUtil.populateReportTime(hashMap, date, date2);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("server_productivity_report"));
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)serverProductivityReport.getTableModel()));
            JRViewer jRViewer = new JRViewer(jasperPrint);
            this.d.removeAll();
            this.d.add((Component)jRViewer);
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(HashMap hashMap) {
        hashMap.put("reportTitle", Messages.getString("ServerProductivityReportView.0"));
        hashMap.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("colServer", POSConstants.SERVER);
        hashMap.put("colCategory", POSConstants.CATEGORY);
        hashMap.put("colTCCount", Messages.getString("TCHKCount"));
        hashMap.put("colTGuest", Messages.getString("TotalGuest"));
        hashMap.put("colGross", Messages.getString("HourlySalesReportView.7"));
        hashMap.put("colTSales", Messages.getString("TotalSales"));
        hashMap.put("colDiscount", POSConstants.DISCOUNT);
        hashMap.put("colReturnAmount", Messages.getString("Return"));
        hashMap.put("colAVGCheck", Messages.getString("AVGCHK"));
        hashMap.put("colNet", Messages.getString("NET_SALES"));
        hashMap.put("colAVGGuest", Messages.getString("AverageGuest"));
        hashMap.put("colAVGNet", Messages.getString("AVGNet"));
        hashMap.put("colAlloc", Messages.getString("Alloc"));
        hashMap.put("colItemCount", Messages.getString("ServerProductivityReportView.1"));
        hashMap.put("colGrandTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GRAND_TOTAL));
    }
}

