/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.DeletedItem;
import com.floreantpos.report.Report;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.VoidItemReportModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.calendar.DateUtils;

public class VoidItemReport
extends Report {
    private VoidItemReportModel a;
    private VoidItemReportModel b;

    @Override
    public void refresh() throws Exception {
        boolean bl = this.createModels();
        if (!bl) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("VoidItemReport.0"));
            this.viewer = null;
            return;
        }
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("deleteItem_sub_report"));
        JasperReport jasperReport2 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("deleteItem_ticket_sub_report"));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap);
        ReportUtil.populateReportHeader(hashMap, this.getTerminal(), this.getStartDate(), this.getEndDate(), null);
        ReportUtil.populateReportFooter(hashMap);
        this.a(hashMap);
        hashMap.put("reportTitle", Messages.getString("VoidItemReport.4"));
        hashMap.put("itemDataSource", new JRTableModelDataSource((TableModel)this.a));
        hashMap.put("ticketDataSource", new JRTableModelDataSource((TableModel)this.b));
        hashMap.put("ticketSection", Messages.getString("VoidItemReport.16"));
        hashMap.put("ticketReport", jasperReport2);
        hashMap.put("itemSection", Messages.getString("VoidItemReport.18"));
        hashMap.put("itemReport", jasperReport);
        JasperReport jasperReport3 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("void_item_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport3, hashMap, (JRDataSource)new JREmptyDataSource());
        this.viewer = new JRViewer(jasperPrint);
    }

    private void a(HashMap<String, Object> hashMap) {
        hashMap.put("VSRDate", POSConstants.DATE);
        hashMap.put("VSRTicketId", POSConstants.TICKET_ID);
        hashMap.put("VSRItem", POSConstants.ITEM);
        hashMap.put("VSRQty", POSConstants.QTY);
        hashMap.put("VSRReason", Messages.getString("VSRReason"));
        hashMap.put("VSRWasted", Messages.getString("VSRWasted"));
        hashMap.put("VSRDeletedBy", Messages.getString("VSRDeletedBy"));
        hashMap.put("VSRAmount", POSConstants.AMOUNT);
        hashMap.put("VSRGrandT", POSConstants.GRAND_TOTAL);
    }

    @Override
    public boolean isDateRangeSupported() {
        return true;
    }

    @Override
    public boolean isTypeSupported() {
        return true;
    }

    public boolean createModels() {
        Object object;
        DeletedItem deletedItem;
        ArrayList<DeletedItem> arrayList;
        Object object2;
        Date date = DateUtils.startOfDay((Date)this.getStartDate());
        Date date2 = DateUtils.endOfDay((Date)this.getEndDate());
        List<TicketItem> list = TicketItemDAO.getInstance().findTicketItems(date, date2, true, false, this.getTerminal(), null);
        if (list != null && !list.isEmpty()) {
            object2 = new HashMap();
            arrayList = new ArrayList<DeletedItem>();
            for (TicketItem propertyContainer : list) {
                deletedItem = new DeletedItem();
                deletedItem.setId(propertyContainer.getId());
                deletedItem.setVoidDate(propertyContainer.getVoidDate());
                deletedItem.setTicketId(propertyContainer.getTicket().getId());
                deletedItem.setQuantity(Math.abs(propertyContainer.getQuantity()));
                object = this.getNameDisplay(propertyContainer);
                deletedItem.setName((String)object);
                deletedItem.setTotal(Math.abs(propertyContainer.getTotalAmount()));
                deletedItem.setVoidReason(propertyContainer.getVoidReason());
                deletedItem.setItemWasted(propertyContainer.isItemWasted());
                String string = propertyContainer.getProperty("voidedByUser");
                if (StringUtils.isNotBlank((String)string)) {
                    String string2 = (String)object2.get(string);
                    if (string2 == null) {
                        string2 = UserDAO.getInstance().get(string).getFullName();
                        object2.put(string, string2);
                    }
                    deletedItem.setVoidUserName(string2);
                } else {
                    deletedItem.setVoidUserName(propertyContainer.getTicket().getOwnerName());
                }
                arrayList.add(deletedItem);
            }
            this.a = new VoidItemReportModel();
            this.a.setItems(arrayList);
        } else {
            this.a = new VoidItemReportModel();
            this.a.setItems(null);
        }
        object2 = TicketDAO.getInstance().findVoidTicketByDate(date, date2, this.getTerminal());
        if (object2 != null && !object2.isEmpty()) {
            arrayList = new ArrayList();
            Iterator<TicketItem> iterator = object2.iterator();
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)((Object)iterator.next());
                deletedItem = new DeletedItem();
                deletedItem.setId(ticket.getId());
                deletedItem.setVoidDate(ticket.getClosingDate());
                deletedItem.setTicketId(ticket.getId());
                object = VoidItemDAO.getInstance().getVoidItems(ticket.getId());
                double d = 0.0;
                double d2 = 0.0;
                if (object != null) {
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        VoidItem voidItem = (VoidItem)iterator2.next();
                        d += voidItem.getTotalPrice().doubleValue();
                        d2 += voidItem.getQuantity().doubleValue();
                    }
                    deletedItem.setQuantity(d2);
                    deletedItem.setTotal(d);
                }
                deletedItem.setVoidReason(ticket.getVoidReason());
                deletedItem.setOwner(ticket.getOwner());
                deletedItem.setVoidUserName(ticket.getVoidedBy() == null ? "" : ticket.getVoidedBy().getFullName());
                arrayList.add(deletedItem);
            }
            this.b = new VoidItemReportModel();
            this.b.setItems(arrayList);
        } else {
            this.b = new VoidItemReportModel();
            this.b.setItems(null);
        }
        return true;
    }

    public String getNameDisplay(TicketItem ticketItem) {
        String string = ticketItem.getName();
        String string2 = "";
        if (ticketItem.isComboItem().booleanValue()) {
            List<TicketItem> list = ticketItem.getComboItems();
            if (list != null && !list.isEmpty()) {
                string2 = string2 + string;
                string2 = string2 + "\n";
                Iterator<TicketItem> iterator = list.iterator();
                while (iterator.hasNext()) {
                    TicketItem ticketItem2 = iterator.next();
                    string2 = string2 + " #" + NumberUtil.trimDecilamIfNotNeeded(ticketItem2.getQuantity() / ticketItem.getQuantity(), true) + " " + ticketItem2.getName();
                    List<TicketItemModifier> list2 = ticketItem2.getTicketItemModifiers();
                    if (iterator.hasNext() || list2 != null) {
                        string2 = string2 + "\n";
                    }
                    if (list2 == null || list2.isEmpty()) continue;
                    Iterator<TicketItemModifier> iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        TicketItemModifier ticketItemModifier = iterator2.next();
                        string2 = string2 + ticketItemModifier.getNameDisplay();
                        if (iterator2.hasNext()) {
                            string2 = string2 + "\n";
                            continue;
                        }
                        if (!iterator.hasNext()) continue;
                        string2 = string2 + "\n";
                    }
                }
                return string2;
            }
        } else if (ticketItem.getSizeModifier() != null) {
            string2 = string2 + ticketItem.getSizeModifier().getNameDisplay().replaceAll(" -- ", "").trim() + " " + ticketItem.getName();
            return string2;
        }
        string2 = string2 + string;
        return string2;
    }
}

