/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.POSConstants;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class PaymentReceivedReportModel
extends ListTableModel {
    private boolean a;

    public PaymentReceivedReportModel(boolean bl) {
        super(new String[]{"user", "transTime", "transNo", "ticket", "transType", "total", "memberName"});
        this.a = bl;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PosTransaction posTransaction = (PosTransaction)this.rows.get(n);
        Ticket ticket = posTransaction.getTicket();
        switch (n2) {
            case 0: {
                User user = posTransaction.getUser();
                if (user == null) {
                    if (ticket.getOwner() != null) {
                        return ticket.getOwner().getFullName();
                    }
                    return POSConstants.NONE;
                }
                return user.getFullName();
            }
            case 1: {
                Date date;
                if (this.a && (date = posTransaction.getVoidDate()) != null) {
                    return DateUtil.formatFullDateAndTimeWithoutYearAsString(date);
                }
                return DateUtil.formatFullDateAndTimeWithoutYearAsString(posTransaction.getTransactionTime());
            }
            case 2: {
                return posTransaction.getId();
            }
            case 3: {
                if (ticket == null) {
                    return "";
                }
                return posTransaction.getTicket().getId();
            }
            case 4: {
                String string;
                PaymentType paymentType = posTransaction.getPaymentType();
                if (paymentType == null) {
                    return null;
                }
                String string2 = paymentType.equals((Object)PaymentType.CUSTOM_PAYMENT) ? (StringUtils.isEmpty((CharSequence)(string = posTransaction.getCustomPaymentName())) ? null : string) : paymentType.getDisplayString();
                return string2;
            }
            case 5: {
                if (posTransaction.getTransactionType().equalsIgnoreCase(TransactionType.DEBIT.name())) {
                    return NumberUtil.round(-1.0 * posTransaction.getAmount());
                }
                return NumberUtil.round(posTransaction.getAmount());
            }
            case 6: {
                if (ticket == null) {
                    return "";
                }
                if (posTransaction.getTicket().getCustomer() != null) {
                    return posTransaction.getTicket().getCustomer().getName();
                }
                return "";
            }
        }
        return null;
    }
}

