/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.CustomerDAO;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class MembershipService {
    public void process(TicketItem ticketItem, Ticket ticket, Session session) {
        String string = ticket.getCustomerId();
        if (StringUtils.isBlank((String)string)) {
            throw new PosException(Messages.getString("CustomerIsNotSelectedForTicket"));
        }
        Customer customer = CustomerDAO.getInstance().get(string, session);
        this.a(ticketItem, customer);
        this.a(ticketItem, ticket.getCustomer());
        CustomerDAO.getInstance().update(customer, session);
    }

    private void a(TicketItem ticketItem, Customer customer) {
        if (customer == null) {
            return;
        }
        customer.setMember(true);
        customer.setMembershipActive(true);
        if (customer.getMembershipStartDate() == null) {
            customer.setMembershipStartDate(ticketItem.getServiceStartDate());
        } else {
            customer.setMembershipRenewDate(ticketItem.getServiceStartDate());
        }
        customer.setMembershipExpiryDate(ticketItem.getServiceEndDate());
        customer.setMembershipType(ticketItem.getProperty("attribute_id"));
        String string = "attribute_name";
        if (ticketItem.hasProperty(string)) {
            customer.addProperty(string, ticketItem.getProperty(string));
        } else {
            customer.removeProperty(string);
        }
    }
}

