/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.Messages;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TransactionListView
extends JPanel {
    private JTable a;
    private TransactionListTableModel b;
    private boolean c;

    public TransactionListView() {
        this(false);
    }

    public TransactionListView(boolean bl) {
        this.c = bl;
        this.a = new JTable();
        this.b = new TransactionListTableModel();
        this.a.setModel(this.b);
        this.a.setRowHeight(PosUIManager.getSize(40));
        this.a.setAutoResizeMode(3);
        this.a.setDefaultRenderer(Object.class, new TransactionListTableCellRenderer());
        this.a.setGridColor(Color.LIGHT_GRAY);
        DoubleTextField doubleTextField = new DoubleTextField();
        doubleTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(doubleTextField);
        defaultCellEditor.setClickCountToStart(1);
        this.a.getColumnModel().getColumn(7).setCellEditor(defaultCellEditor);
        PosScrollPane posScrollPane = new PosScrollPane(this.a, 20, 31);
        JScrollBar jScrollBar = posScrollPane.getVerticalScrollBar();
        jScrollBar.setPreferredSize(PosUIManager.getSize(30, 60));
        this.setLayout(new BorderLayout());
        this.add(posScrollPane);
    }

    public void setTransactions(List<PosTransaction> list) {
        this.b.setRows(list);
    }

    public void addTransaction(PosTransaction posTransaction) {
        this.b.addItem(posTransaction);
    }

    public PosTransaction getSelectedTransaction() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return (PosTransaction)this.b.getRowData(n);
    }

    public List<PosTransaction> getAllTransactions() {
        return this.b.getRows();
    }

    public List<PosTransaction> getSelectedTransactions() {
        int[] nArray = this.a.getSelectedRows();
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            PosTransaction posTransaction = (PosTransaction)this.b.getRowData(nArray[i]);
            arrayList.add(posTransaction);
        }
        return arrayList;
    }

    public PosTransaction getFirstSelectedTransaction() {
        List<PosTransaction> list = this.getSelectedTransactions();
        if (list.size() == 0 || list.size() > 1) {
            POSMessageDialog.showMessage(Messages.getString("TransactionListView.8"));
            return null;
        }
        PosTransaction posTransaction = list.get(0);
        return posTransaction;
    }

    public JTable getTable() {
        return this.a;
    }

    private class TransactionListTableCellRenderer
    extends DefaultTableCellRenderer {
        private TransactionListTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setOpaque(true);
            PosTransaction posTransaction = (PosTransaction)TransactionListView.this.b.getRowData(n);
            if (TransactionListView.this.b.isRowEdited(posTransaction.getId())) {
                if (bl) {
                    jLabel.setBackground(new Color(0, 155, 0));
                    jLabel.setForeground(jTable.getSelectionForeground());
                } else {
                    jLabel.setBackground(Color.GREEN);
                    jLabel.setForeground(jTable.getForeground());
                }
            } else if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }
    }

    public class TransactionListTableModel
    extends ListTableModel<PosTransaction> {
        public Set<String> editedTransactionIds;

        public TransactionListTableModel() {
            super(new String[]{Messages.getString("TransactionListView.0"), Messages.getString("TransactionListView.1"), Messages.getString("TransactionListView.10"), Messages.getString("TransactionListView.2"), Messages.getString("TransactionListView.3"), Messages.getString("TransactionListView.13"), Messages.getString("TransactionListView.14"), Messages.getString("TransactionListView.4") + " (" + CurrencyUtil.getCurrencySymbol() + ")", Messages.getString("TransactionListView.5") + " (" + CurrencyUtil.getCurrencySymbol() + ")", Messages.getString("TransactionListView.6") + " (" + CurrencyUtil.getCurrencySymbol() + ")"});
            this.editedTransactionIds = new HashSet<String>();
        }

        public void addEditedRow(String string) {
            this.editedTransactionIds.add(string);
        }

        public boolean isRowEdited(String string) {
            return this.editedTransactionIds.contains(string);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 7 && TransactionListView.this.c) {
                return true;
            }
            return super.isCellEditable(n, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object == null) {
                return;
            }
            PosTransaction posTransaction = (PosTransaction)this.getRowData(n);
            if (n2 == 7) {
                double d = posTransaction.getTipsAmount();
                Double d2 = 0.0;
                String string = object.toString();
                try {
                    d2 = POSUtil.parseDouble(string, Messages.getString("POSUtil.1"), true);
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                    return;
                }
                if (d2 < 0.0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("POSUtil.1"));
                    return;
                }
                if (d == d2) {
                    return;
                }
                Ticket ticket = posTransaction.getTicket();
                TicketDAO.getInstance().loadFullTicket(ticket);
                Set<PosTransaction> set = ticket.getTransactions();
                for (PosTransaction posTransaction2 : set) {
                    if (!posTransaction.getId().equals(posTransaction2.getId())) continue;
                    posTransaction = posTransaction2;
                    break;
                }
                posTransaction.setTipsAmount(d2);
                posTransaction.setAmount(posTransaction.getAmount() - d + d2);
                if (ticket.hasGratuity()) {
                    double d3 = ticket.getGratuity().getAmount();
                    double d4 = ticket.getPaidAmount();
                    double d5 = d3 - d + d2;
                    double d6 = d4 - d + d2;
                    ticket.setGratuityAmount(NumberUtil.round(d5));
                    ticket.setPaidAmount(NumberUtil.round(d6));
                } else {
                    ticket.setGratuityAmount(NumberUtil.round(d2));
                    ticket.setPaidAmount(NumberUtil.round(ticket.getPaidAmount() + d2));
                }
                ticket.calculatePrice();
                TicketDAO.getInstance().saveOrUpdate(ticket);
                for (PosTransaction posTransaction2 : ticket.getTransactions()) {
                    if (!posTransaction.getId().equals(posTransaction2.getId())) continue;
                    TransactionListView.this.b.getRows().set(n, posTransaction2);
                    break;
                }
                this.addEditedRow(posTransaction.getId());
                this.fireTableRowsUpdated(n, n);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PosTransaction posTransaction = (PosTransaction)this.rows.get(n);
            Ticket ticket = posTransaction.getTicket();
            switch (n2) {
                case 0: {
                    return posTransaction.getId();
                }
                case 1: {
                    return ticket.getId();
                }
                case 2: {
                    return posTransaction.getCardMerchantGateway();
                }
                case 3: {
                    User user = ticket.getOwner();
                    if (user == null) {
                        return null;
                    }
                    return user.getFirstName();
                }
                case 4: {
                    return posTransaction.getCardType();
                }
                case 5: {
                    return posTransaction.getCardNumber();
                }
                case 6: {
                    return posTransaction.getCardHolderName();
                }
                case 7: {
                    return posTransaction.getTipsAmount();
                }
                case 8: {
                    return NumberUtil.format(posTransaction.getAmount() - posTransaction.getTipsAmount());
                }
                case 9: {
                    return NumberUtil.format(posTransaction.getAmount());
                }
            }
            return null;
        }
    }

    private class TransactionListTable
    extends PosTable {
        public TransactionListTable() {
            this.setColumnControlVisible(false);
        }
    }
}

