/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PrintException;
import com.floreantpos.actions.ReceiptEmailSendAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TransactionCompletionDialog
extends POSDialog {
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;
    private double g;
    private double h;
    private JLabel i;
    private JLabel j;
    private JLabel k;
    private JLabel l;
    private JLabel m;
    private JLabel n;
    private JLabel o;
    private JLabel p;
    private PosTransaction q;
    private List<PosTransaction> r;
    private boolean s;
    private List<Ticket> t;
    private PosButton u;
    private PosButton v;
    private PosButton w;
    private JLabel x;
    private JLabel y;
    private JLabel z;

    public TransactionCompletionDialog(PosTransaction posTransaction) {
        this.q = posTransaction;
        this.s = this.q.isCard();
        this.a();
    }

    public TransactionCompletionDialog(List<PosTransaction> list) {
        this.r = list;
        this.a();
    }

    private void a() {
        JComponent jComponent;
        this.setTitle(POSConstants.TRANSACTION_COMPLETED);
        this.setLayout((LayoutManager)new MigLayout("hidemode 3, align 50% 0%, ins 20", "[]20[]", ""));
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.3") + ":", 2), "grow");
        this.j = this.createLabel("0.0", 4);
        this.add((Component)this.j, "span, grow");
        this.y = this.createLabel(Messages.getString("TransactionCompletionDialog.2") + ":", 2);
        this.add((Component)this.y, "newline,grow");
        this.z = this.createLabel("0.0", 4);
        this.add((Component)this.z, "span, grow");
        this.p = this.createLabel(Messages.getString("TransactionCompletionDialog.6") + ":", 2);
        this.add((Component)this.p, "newline,grow, ,hidemode 3");
        this.o = this.createLabel("0.0", 4);
        this.add((Component)this.o, "span, grow, ,hidemode 3");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.8") + ":", 2), "newline,grow");
        this.i = this.createLabel("0.0", 4);
        this.add((Component)this.i, "span, grow");
        this.add((Component)new JSeparator(), "newline,span, grow");
        JLabel jLabel = this.createLabel(Messages.getString("TransactionCompletionDialog.14") + ":", 2);
        this.k = this.createLabel("0.0", 4);
        this.x = this.createLabel("", 2);
        if (Application.getInstance().getTerminal().isEnableMultiCurrency().booleanValue()) {
            jComponent = new JPanel(new BorderLayout());
            jComponent.add(jLabel);
            jComponent.add((Component)this.x, "South");
            this.add((Component)jComponent, "newline,grow");
            this.add((Component)this.k, "span, growx, aligny top");
        } else {
            this.add((Component)jLabel, "newline,grow");
            this.add((Component)this.k, "span, grow");
        }
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.19") + ":", 2), "newline,grow");
        this.l = this.createLabel("0.0", 4);
        this.add((Component)this.l, "span, grow");
        this.add((Component)new JSeparator(), "newline,span, grow");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.25") + ":", 2), "newline,grow");
        this.n = this.createLabel("0.0", 4);
        this.add((Component)this.n, "span, grow");
        this.add((Component)new JSeparator(), "newline,span, grow");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.31") + ":", 2), "grow");
        this.m = this.createLabel("0.0", 4);
        this.add((Component)this.m, "span, grow");
        this.add((Component)new JSeparator(), "sg mygroup,newline,span,grow");
        this.u = new PosButton(Messages.getString("TransactionCompletionDialog.1"));
        this.u.setAction(new ReceiptEmailSendAction(this.q));
        this.v = new PosButton(Messages.getString("TransactionCompletionDialog.37"));
        this.v.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionCompletionDialog.this.dispose();
            }
        });
        this.w = new PosButton(Messages.getString("TransactionCompletionDialog.38"));
        this.w.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ReceiptPrintService.hasNoReceiptPrinters()) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
                        return;
                    }
                    if (TransactionCompletionDialog.this.t != null) {
                        for (Ticket ticket : TransactionCompletionDialog.this.t) {
                            ReceiptPrintService.printTicket(ticket, false);
                        }
                    } else {
                        ReceiptPrintService.printTransaction(TransactionCompletionDialog.this.q, true, false);
                    }
                }
                catch (PrintException printException) {
                    POSMessageDialog.showError(Application.getPosWindow(), printException.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TransactionCompletionDialog.39"), exception);
                }
            }
        });
        jComponent = new PosButton(Messages.getString("TransactionCompletionDialog.40"));
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ReceiptPrintService.hasNoReceiptPrinters()) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
                        return;
                    }
                    if (TransactionCompletionDialog.this.t != null) {
                        for (Ticket ticket : TransactionCompletionDialog.this.t) {
                            ReceiptPrintService.printTicket(ticket, false);
                        }
                    } else {
                        ReceiptPrintService.printTransaction(TransactionCompletionDialog.this.q, true, true);
                    }
                }
                catch (PrintException printException) {
                    POSMessageDialog.showError(Application.getPosWindow(), printException.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TransactionCompletionDialog.41"), exception);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.u);
        if (this.s) {
            jPanel.add((Component)jComponent, "newline,skip, h 50");
            jPanel.add((Component)this.w, "skip, h 50");
            jPanel.add((Component)this.v, "skip, h 50");
        } else {
            this.w.setText(Messages.getString("TransactionCompletionDialog.0"));
            jPanel.add((Component)this.w, "skip, h 50");
            jPanel.add((Component)this.v, "skip, h 50");
        }
        this.add((Component)jPanel, "newline, span 2, grow, gaptop 15px");
    }

    protected JLabel createLabel(String string, int n) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(jLabel.getFont().deriveFont(1, 24.0f));
        jLabel.setHorizontalAlignment(n);
        jLabel.setText(string);
        return jLabel;
    }

    public double getTenderedAmount() {
        return this.a;
    }

    public void setTenderedAmount(double d) {
        this.a = d;
    }

    public void updateView() {
        boolean bl = this.e != 0.0;
        this.y.setVisible(bl);
        this.z.setVisible(bl);
        this.o.setVisible(this.h != 0.0);
        this.p.setVisible(this.h != 0.0);
        this.j.setText(NumberUtil.formatNumber(this.b));
        this.z.setText(NumberUtil.formatNumber(this.e));
        this.i.setText(NumberUtil.formatNumber(this.a));
        this.o.setText(NumberUtil.formatNumber(this.h));
        this.k.setText(NumberUtil.formatNumber(this.c));
        this.x.setText(this.b());
        this.l.setText(NumberUtil.formatNumber(this.d));
        this.n.setText(NumberUtil.formatNumber(this.f));
        this.m.setText(this.c());
    }

    private String b() {
        Terminal terminal = Application.getInstance().getTerminal();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        if (terminal.isEnableMultiCurrency().booleanValue() && this.q != null) {
            String string = this.q.getProperty("paymentCurrencies");
            String string2 = CurrencyUtil.getCurrencySymbol();
            if (StringUtils.isNotBlank((String)string)) {
                boolean bl = Boolean.FALSE;
                List<MultiCurrencyTenderDialog.PaymentByCurrency> list = CurrencyUtil.createPaymentByCurrencies(string);
                for (MultiCurrencyTenderDialog.PaymentByCurrency paymentByCurrency : list) {
                    if (paymentByCurrency.paidAmount <= 0.0) continue;
                    if (paymentByCurrency.currency.getSymbol() != null && !paymentByCurrency.currency.getSymbol().equalsIgnoreCase(string2)) {
                        ++n;
                    }
                    String string3 = paymentByCurrency.currency.getSymbol() + NumberUtil.formatNumber(paymentByCurrency.paidAmount);
                    if (bl) {
                        stringBuilder.append(" + ");
                        stringBuilder.append(string3);
                        continue;
                    }
                    stringBuilder.append(string3);
                    bl = Boolean.TRUE;
                }
                if (!bl) {
                    stringBuilder.append(NumberUtil.formatNumber(this.c));
                }
            }
        } else {
            stringBuilder.append(NumberUtil.formatNumber(this.c));
        }
        if (n > 0) {
            return "<html><h3 style='color:red'>(" + stringBuilder.toString() + ")</h3></html></html>";
        }
        return "";
    }

    private String c() {
        Terminal terminal = Application.getInstance().getTerminal();
        StringBuilder stringBuilder = new StringBuilder("<html>");
        if (terminal.isEnableMultiCurrency().booleanValue() && this.q != null) {
            String string = this.q.getProperty("paymentCurrencies");
            if (StringUtils.isNotBlank((String)string)) {
                boolean bl = Boolean.FALSE;
                List<MultiCurrencyTenderDialog.PaymentByCurrency> list = CurrencyUtil.createPaymentByCurrencies(string);
                for (MultiCurrencyTenderDialog.PaymentByCurrency paymentByCurrency : list) {
                    if (paymentByCurrency.getCashBackAmount() <= 0.0) continue;
                    String string2 = paymentByCurrency.currency.getSymbol() + NumberUtil.formatNumber(paymentByCurrency.getCashBackAmount());
                    if (bl) {
                        stringBuilder.append(" + ");
                        stringBuilder.append(string2);
                        continue;
                    }
                    stringBuilder.append(string2);
                    bl = Boolean.TRUE;
                }
                if (!bl) {
                    stringBuilder.append(NumberUtil.formatNumber(this.g));
                }
            } else {
                stringBuilder.append(NumberUtil.formatNumber(this.g));
            }
        } else {
            stringBuilder.append(NumberUtil.formatNumber(this.g));
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public double getDueAmount() {
        return this.d;
    }

    public void setDueAmount(double d) {
        this.d = d;
    }

    public double getPaidAmount() {
        return this.c;
    }

    public void setPaidAmount(double d) {
        this.c = d;
    }

    public double getTotalAmount() {
        return this.b;
    }

    public void setTotalAmount(double d) {
        this.b = d;
    }

    public double getGratuityAmount() {
        return this.f;
    }

    public void setGratuityAmount(double d) {
        this.f = d;
    }

    public double getChangeAmount() {
        return this.g;
    }

    public void setChangeAmount(double d) {
        this.g = d;
    }

    public void setCompletedTransaction(PosTransaction posTransaction) {
        this.q = posTransaction;
    }

    public boolean isCard() {
        return this.s;
    }

    public void setCard(boolean bl) {
        this.s = bl;
    }

    public void setTickets(List<Ticket> list) {
        this.t = list;
    }

    public List<PosTransaction> getCompletedTransactions() {
        return this.r;
    }

    public double getRoundedAmount() {
        return this.h;
    }

    public void setRoundedAmount(double d) {
        this.h = d;
    }

    public double getFeeAmount() {
        return this.e;
    }

    public void setFeeAmount(double d) {
        this.e = d;
    }
}

