/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MonthOfYear;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.GeneratePasswordUtil;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AddressUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.jidesoft.swing.AutoCompletionComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.LayoutManager;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.hibernate.StaleObjectStateException;
import org.jdesktop.swingx.JXDatePicker;

public class CustomerForm
extends BeanEditor<Customer> {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private FixedLengthTextField d;
    private FixedLengthTextField e;
    private JComboBox<Attribute> f;
    private JXDatePicker g;
    private JXDatePicker h;
    private JTextArea i;
    private FixedLengthTextField j;
    private FixedLengthTextField k;
    private IntegerTextField l;
    private DoubleTextField m;
    private DoubleTextField n;
    private AddressUtil o;
    private AutoCompletionComboBox p;
    private AutoCompletionComboBox q;
    private AutoCompletionComboBox r;
    private JCheckBox s;
    private JCheckBox t;
    private JLabel u;
    private PosSmallButton v;
    private PosSmallButton w;
    private JComboBox x;
    private QwertyKeyPad y;
    public boolean isKeypad;
    private ImageResource z;
    private MyOwnFocusTraversalPolicy A;
    private Image B;
    private FixedLengthTextField C;
    private JPanel D;
    private AutoCompletionComboBox E;
    private AutoCompletionComboBox F;
    private AutoCompletionComboBox G;
    private JCheckBox H;
    private JButton I;

    public CustomerForm() {
        this.o = new AddressUtil();
        this.a();
    }

    public CustomerForm(boolean bl) {
        this.isKeypad = bl;
        this.o = new AddressUtil();
        this.a();
    }

    private void a() {
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][][]"));
        jPanel.add((Component)this.b(), "grow");
        jPanel.add((Component)this.c(), "grow");
        jPanel.add((Component)this.f(), "grow");
        jPanel.setPreferredSize(PosUIManager.getSize(400, 350));
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        jScrollPane.setBorder(null);
        jScrollPane.setFocusable(false);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(jScrollPane);
        this.y = new QwertyKeyPad();
        this.y.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (this.isKeypad) {
            jPanel2.add((Component)((Object)this.y), "South");
        }
        this.v.addActionListener(actionEvent -> this.doSelectImageFile());
        this.w.addActionListener(actionEvent -> this.doClearImage());
        this.add(jPanel2);
        this.enableCustomerFields(false);
        this.callOrderController();
    }

    private JPanel b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.u = new JLabel("");
        this.B = IconFactory.getIcon("/images/", "generic-profile-pic-v2.png").getImage();
        this.u = new JLabel("");
        this.u.setPreferredSize(PosUIManager.getSize(200, 200));
        this.u.setIcon(new ImageIcon(this.B.getScaledInstance(200, 200, 1)));
        this.u.setIconTextGap(0);
        this.u.setHorizontalAlignment(0);
        jPanel.setBorder(new TitledBorder(null, Messages.getString("CustomerForm.10"), 4, 2, null, null));
        jPanel.add((Component)this.u, "grow,wrap,center");
        this.v = new PosSmallButton();
        this.v.setText(Messages.getString("CustomerForm.44"));
        jPanel.add((Component)this.v, "split 2,center");
        this.w = new PosSmallButton();
        this.w.setText(Messages.getString("CustomerForm.45"));
        jPanel.add(this.w);
        return jPanel;
    }

    private JPanel c() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]", ""));
        JLabel jLabel = new JLabel(Messages.getString("CustomerForm.0"));
        this.x = new JComboBox();
        this.x.addItem(Messages.getString("CustomerForm.2"));
        this.x.addItem(Messages.getString("CustomerForm.4"));
        this.x.addItem(Messages.getString("CustomerForm.5"));
        this.x.addItem(Messages.getString("CustomerForm.6"));
        this.x.setPreferredSize(PosUIManager.getSize(100, 0));
        JLabel jLabel2 = new JLabel(Messages.getString("CustomerForm.22"));
        this.c = new FixedLengthTextField(30);
        JLabel jLabel3 = new JLabel(Messages.getString("CustomerForm.3"));
        this.a = new FixedLengthTextField(30);
        JLabel jLabel4 = new JLabel(Messages.getString("CustomerForm.11"));
        this.b = new FixedLengthTextField();
        JLabel jLabel5 = new JLabel(Messages.getString("CustomerForm.14"));
        this.E = new AutoCompletionComboBox((Object[])MonthOfYear.values());
        this.E.setSelectedIndex(-1);
        this.F = new AutoCompletionComboBox();
        List<Integer> list = POSUtil.getDayList();
        this.F.setModel((ComboBoxModel)new ListComboBoxModel(list));
        this.F.setSelectedIndex(-1);
        this.G = new AutoCompletionComboBox();
        List<Integer> list2 = POSUtil.getYearList(1900);
        this.G.setModel((ComboBoxModel)new ListComboBoxModel(list2));
        this.G.setSelectedIndex(-1);
        JLabel jLabel6 = new JLabel(Messages.getString("CustomerForm.16"));
        this.d = new FixedLengthTextField(30);
        JLabel jLabel7 = new JLabel(Messages.getString("CustomerForm.17"));
        this.e = new FixedLengthTextField();
        JLabel jLabel8 = new JLabel(Messages.getString("CustomerForm.8"));
        this.C = new FixedLengthTextField();
        JLabel jLabel9 = new JLabel(Messages.getString("CustomerForm.19"));
        this.k = new FixedLengthTextField();
        JButton jButton = new JButton(Messages.getString("CustomerForm.13"));
        jButton.addActionListener(actionEvent -> this.e());
        JLabel jLabel10 = new JLabel(Messages.getString("CustomerForm.20"));
        this.l = new IntegerTextField();
        this.l.setEditable(false);
        JLabel jLabel11 = new JLabel(Messages.getString("CustomerForm.23"));
        this.m = new DoubleTextField();
        this.m.setText("500.00");
        JLabel jLabel12 = new JLabel(Messages.getString("Balance"));
        this.n = new DoubleTextField(true);
        this.n.setEditable(false);
        this.D = new JPanel((LayoutManager)new MigLayout("fillx,ins 0", "[][grow][]", ""));
        this.D.add((Component)this.G, "grow");
        this.D.add((Component)this.E, "grow");
        this.D.add((Component)this.F, "w 50!");
        jPanel.add((Component)jLabel2, "right");
        jPanel.add((Component)this.c, "wrap,grow");
        jPanel.add((Component)jLabel, "right");
        jPanel.add((Component)this.x, "wrap,grow");
        jPanel.add((Component)jLabel3, "right");
        jPanel.add((Component)this.a, "wrap,grow");
        jPanel.add((Component)jLabel4, "right");
        jPanel.add((Component)this.b, "wrap,grow");
        jPanel.add((Component)jLabel5, "right");
        jPanel.add((Component)this.D, "wrap,grow");
        jPanel.add((Component)jLabel6, "right");
        jPanel.add((Component)this.d, "wrap,grow");
        jPanel.add((Component)jLabel7, "right");
        jPanel.add((Component)this.e, "wrap,grow");
        jPanel.add((Component)jLabel8, "right");
        jPanel.add((Component)this.C, "wrap,grow");
        jPanel.add((Component)jLabel9, "right");
        jPanel.add((Component)this.k, "grow,split 2");
        jPanel.add((Component)jButton, "wrap");
        jPanel.add((Component)jLabel10, "right");
        jPanel.add((Component)this.l, "wrap,grow");
        jPanel.add((Component)jLabel11, "right");
        jPanel.add((Component)this.m, "wrap,grow");
        jPanel.add((Component)jLabel12, "right");
        jPanel.add((Component)this.n, "grow");
        this.E.addActionListener(actionEvent -> this.d());
        this.G.addActionListener(actionEvent -> this.d());
        return jPanel;
    }

    private void d() {
        int n = this.E.getSelectedIndex();
        int n2 = this.G.getSelectedIndex();
        List<Integer> list = POSUtil.getDayList(n, n2);
        this.F.setModel((ComboBoxModel)new ListComboBoxModel(list));
        this.F.setSelectedIndex(-1);
    }

    private void e() {
        try {
            GeneratePasswordUtil generatePasswordUtil = new GeneratePasswordUtil();
            this.k.setText(generatePasswordUtil.createRandPass("16"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage());
        }
    }

    private JPanel f() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]"));
        JLabel jLabel = new JLabel(Messages.getString("CustomerForm.24"));
        this.f = new JComboBox();
        List<Attribute> list = AttributeDAO.getInstance().findMembershipAttribute();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        arrayList.add(null);
        if (list != null && list.size() > 0) {
            arrayList.addAll(list);
        }
        this.f.setModel(new com.floreantpos.swing.ComboBoxModel(arrayList));
        this.I = new JButton("+");
        JLabel jLabel2 = new JLabel(Messages.getString("CustomerForm.28"));
        this.g = new JXDatePicker();
        this.g.setFormats(new String[]{DateUtil.getStoreDateFormat()});
        this.g.getEditor().setEditable(false);
        JLabel jLabel3 = new JLabel(Messages.getString("CustomerForm.29"));
        this.h = new JXDatePicker();
        this.h.setFormats(new String[]{DateUtil.getStoreDateFormat()});
        this.h.getEditor().setEditable(false);
        JLabel jLabel4 = new JLabel(Messages.getString("CustomerForm.51"));
        this.i = new JTextArea();
        this.i.setRows(3);
        this.i.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.i);
        JLabel jLabel5 = new JLabel(Messages.getString("CustomerForm.55"));
        this.j = new FixedLengthTextField();
        this.j.setColumns(30);
        this.j.setLength(10);
        JLabel jLabel6 = new JLabel(Messages.getString("CustomerForm.56"));
        this.p = new AutoCompletionComboBox();
        this.p.setStrict(false);
        this.p.setModel(new DefaultComboBoxModel<Object>(this.o.getCountryNames().toArray()));
        JLabel jLabel7 = new JLabel(Messages.getString("CustomerForm.53"));
        this.q = new AutoCompletionComboBox();
        this.q.setStrict(false);
        JLabel jLabel8 = new JLabel(Messages.getString("CustomerForm.52"));
        this.r = new AutoCompletionComboBox();
        this.r.setStrict(false);
        this.s = new JCheckBox(Messages.getString("CustomerForm.58"));
        this.s.setFocusable(false);
        this.t = new JCheckBox(Messages.getString("CustomerForm.59"));
        this.H = new JCheckBox(Messages.getString("CustomerForm.30"));
        this.H.setSelected(true);
        this.H.setFocusable(false);
        jPanel.add((Component)jLabel, "right");
        jPanel.add(this.f, "w 119!,split 2");
        jPanel.add((Component)this.I, "wrap");
        jPanel.add((Component)jLabel2, "right");
        jPanel.add((Component)this.g, "w 119!,wrap");
        jPanel.add((Component)jLabel3, "right");
        jPanel.add((Component)this.h, "w 119!,wrap");
        jPanel.add((Component)jLabel4, "right");
        jPanel.add((Component)jScrollPane, "wrap, span 0 1, grow");
        jPanel.add((Component)jLabel6, "right");
        jPanel.add((Component)this.p, "wrap");
        jPanel.add((Component)jLabel7, "right");
        jPanel.add((Component)this.q, "w 119!,wrap");
        jPanel.add((Component)jLabel8, "right");
        jPanel.add((Component)this.r, "w 119!,wrap");
        jPanel.add((Component)jLabel5, "right");
        jPanel.add((Component)this.j, "w 119!,wrap");
        jPanel.add((Component)this.s, "skip 1,wrap");
        jPanel.add((Component)this.t, "skip 1,wrap");
        jPanel.add((Component)this.H, "skip 1");
        this.p.addActionListener(actionEvent -> this.i());
        this.q.addActionListener(actionEvent -> this.j());
        this.g.addActionListener(actionEvent -> this.a(Boolean.FALSE));
        this.h.addActionListener(actionEvent -> this.a(Boolean.TRUE));
        this.I.addActionListener(actionEvent -> this.g());
        return jPanel;
    }

    private void g() {
        String string = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)Messages.getString("CustomerForm.35"));
        if (string == null) {
            return;
        }
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showError(Messages.getString("CustomerForm.36"));
            return;
        }
        AttributeGroupDAO attributeGroupDAO = AttributeGroupDAO.getInstance();
        AttributeGroup attributeGroup = attributeGroupDAO.get("membership_type");
        if (attributeGroup == null) {
            attributeGroup = new AttributeGroup("membership_type");
            attributeGroup.setName(Messages.getString("CustomerForm.37"));
            attributeGroupDAO.save(attributeGroup);
        }
        Attribute attribute = new Attribute();
        attribute.setName(string);
        AttributeDAO attributeDAO = AttributeDAO.getInstance();
        boolean bl = attributeDAO.nameExists(attribute, string, "membership_type");
        if (bl) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.38"));
            return;
        }
        attribute.setGroup(attributeGroup);
        attributeGroup.addToattributes(attribute);
        attributeGroupDAO.saveOrUpdate(attributeGroup);
        com.floreantpos.swing.ComboBoxModel comboBoxModel = (com.floreantpos.swing.ComboBoxModel)this.f.getModel();
        comboBoxModel.addElement(attribute);
        this.f.setSelectedItem(attribute);
    }

    public void callOrderController() {
        Vector<Component> vector = new Vector<Component>();
        vector.add(this.a);
        vector.add(this.b);
        vector.add((Component)this.G);
        vector.add((Component)this.E);
        vector.add((Component)this.F);
        vector.add(this.d);
        vector.add(this.e);
        vector.add(this.C);
        vector.add(this.k);
        vector.add(this.l);
        vector.add(this.m);
        vector.add(this.n);
        vector.add(this.f);
        vector.add((Component)this.g);
        vector.add((Component)this.h);
        vector.add(this.i);
        vector.add((Component)this.p);
        vector.add((Component)this.q);
        vector.add((Component)this.r);
        vector.add(this.j);
        this.A = new MyOwnFocusTraversalPolicy(vector);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(this.A);
    }

    public void enableCustomerFields(boolean bl) {
        this.x.setEnabled(bl);
        this.b.setEnabled(bl);
        this.a.setEnabled(bl);
        this.D.setEnabled(bl);
        this.d.setEnabled(bl);
        this.e.setEnabled(bl);
        this.C.setEnabled(bl);
        this.f.setEnabled(bl);
        this.g.setEnabled(bl);
        this.h.setEnabled(bl);
        this.i.setEnabled(bl);
        this.p.setEnabled(bl);
        this.q.setEditable(bl);
        this.r.setEnabled(bl);
        this.j.setEnabled(bl);
        this.k.setEnabled(bl);
        this.l.setEnabled(bl);
        this.m.setEnabled(bl);
        this.n.setEnabled(bl);
        this.s.setEnabled(bl);
        this.t.setEnabled(bl);
        this.H.setEnabled(bl);
        this.w.setEnabled(bl);
        this.v.setEnabled(bl);
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.x.setEnabled(bl);
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
        this.e.setEnabled(bl);
        this.C.setEnabled(bl);
        this.k.setEnabled(bl);
        this.f.setEnabled(bl);
        this.g.setEnabled(bl);
        this.h.setEnabled(bl);
        this.i.setEnabled(bl);
        this.p.setEnabled(bl);
        this.r.setEnabled(bl);
        this.m.setEnabled(bl);
        this.j.setEnabled(bl);
        this.s.setEnabled(bl);
        this.t.setEnabled(bl);
        this.H.setEnabled(bl);
        this.D.setEnabled(bl);
        this.n.setEnabled(bl);
        this.w.setEnabled(bl);
        this.v.setEnabled(bl);
        this.l.setEnabled(bl);
        this.d.setEnabled(bl);
    }

    public void setFieldsEditable(boolean bl) {
        this.x.setEditable(bl);
        this.a.setEditable(bl);
        this.b.setEditable(bl);
        this.e.setEditable(bl);
        this.C.setEditable(bl);
        this.k.setEditable(bl);
        this.i.setEditable(bl);
        this.p.setEditable(bl);
        this.r.setEditable(bl);
        this.m.setEditable(bl);
        this.j.setEditable(bl);
        this.s.setEnabled(bl);
        this.t.setEnabled(bl);
        this.H.setEnabled(bl);
        this.w.setEnabled(bl);
        this.v.setEnabled(bl);
        this.l.setEditable(bl);
        this.d.setEditable(bl);
    }

    @Override
    public void createNew() {
        this.setBean(new Customer());
        this.c.setText("");
        this.a.setText("");
        this.b.setText("");
        this.x.setSelectedIndex(0);
        this.i.setText("");
        this.m.setText("");
        this.e.setText("");
        this.C.setText("");
        this.k.setText("");
        this.l.setText("");
        this.n.setText("");
        this.j.setText("");
        this.s.setSelected(false);
        this.t.setSelected(false);
        this.H.setSelected(true);
        this.d.setText("");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Customer customer = (Customer)this.getBean();
            CustomerDAO.getInstance().saveOrUpdate(customer);
            this.updateView();
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (IllegalModelStateException illegalModelStateException) {
        }
        catch (StaleObjectStateException staleObjectStateException) {
            BOMessageDialog.showError(this, Messages.getString("CustomerForm.47"));
        }
        return false;
    }

    @Override
    protected void updateView() {
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            return;
        }
        this.c.setText(customer.getMemberId());
        this.c.setEditable(StringUtils.isBlank((String)customer.getMemberId()));
        this.x.setSelectedItem(customer.getSalutation());
        this.a.setText(customer.getFirstName());
        this.b.setText(customer.getLastName());
        this.a(customer);
        this.f.setSelectedItem(customer.getMembershipTypeDisplayString());
        String string = customer.getMembershipType();
        if (StringUtils.isNotBlank((String)string)) {
            int n = this.f.getItemCount();
            for (int i = 0; i < n; ++i) {
                Attribute attribute = this.f.getItemAt(i);
                if (attribute == null || !string.equals(attribute.getId())) continue;
                this.f.setSelectedItem(attribute);
                break;
            }
            this.f.setEnabled(StringUtils.isBlank((String)string));
            this.I.setEnabled(StringUtils.isBlank((String)string));
        }
        this.g.setDate(customer.getMembershipStartDate() == null ? null : customer.getMembershipStartDate());
        this.g.setEditable(customer.getMembershipStartDate() == null);
        this.h.setDate(customer.getMembershipExpiryDate() == null ? null : customer.getMembershipExpiryDate());
        this.h.setEditable(customer.getMembershipExpiryDate() == null);
        this.i.setText(customer.getAddress() == null ? "" : customer.getAddress());
        this.p.setSelectedItem((Object)customer.getCountry());
        this.q.setSelectedItem((Object)customer.getState());
        this.r.setSelectedItem((Object)customer.getCity());
        this.m.setText(NumberUtil.formatNumber(customer.getCreditLimit()));
        this.e.setText(customer.getEmail());
        this.C.setText(customer.getEmail2());
        this.k.setText(customer.getLoyaltyNo());
        this.l.setText(customer.getLoyaltyPoint().toString());
        this.n.setText(String.valueOf(NumberUtil.formatNumber(customer.getBalance())));
        this.j.setText(customer.getZipCode());
        this.s.setSelected(customer.isVip());
        this.t.setSelected(customer.isTaxExempt());
        this.H.setSelected(customer.isActive());
        this.d.setText(customer.getMobileNo());
        if (customer.getSsn() != null) {
            // empty if block
        }
        this.z = ImageResourceDAO.getInstance().findById(customer.getImageId());
        if (this.z != null) {
            this.u.setIcon(new ImageIcon(this.z.getImage().getScaledInstance(200, 200, 1)));
        } else {
            this.u.setIcon(new ImageIcon(this.B.getScaledInstance(200, 200, 1)));
        }
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog imageGalleryDialog = ImageGalleryDialog.getInstance();
        imageGalleryDialog.setTitle(Messages.getString("CustomerForm.1"));
        imageGalleryDialog.setSelectBtnVisible(true);
        imageGalleryDialog.setSize(PosUIManager.getSize(650, 600));
        imageGalleryDialog.setResizable(false);
        imageGalleryDialog.open();
        if (imageGalleryDialog.isCanceled()) {
            return;
        }
        this.z = imageGalleryDialog.getImageResource();
        if (this.z != null) {
            this.u.setIcon(new ImageIcon(this.z.getImage().getScaledInstance(200, 200, 1)));
        }
    }

    protected void doClearImage() {
        this.u.setIcon(new ImageIcon(this.B.getScaledInstance(200, 200, 1)));
        this.z = null;
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Object object;
        String string = this.c.getText().trim();
        String string2 = this.e.getText();
        String string3 = this.C.getText();
        String string4 = this.a.getText();
        String string5 = this.b.getText();
        String string6 = this.d.getText();
        String string7 = this.p.getSelectedItem() == null ? "" : this.p.getSelectedItem().toString();
        String string8 = this.q.getSelectedItem() == null ? "" : this.q.getSelectedItem().toString();
        String string9 = this.r.getSelectedItem() == null ? "" : this.r.getSelectedItem().toString();
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            customer = new Customer();
            this.setBean(customer, false);
        }
        if (StringUtils.isBlank((String)string4)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.7"));
            return false;
        }
        Date date = this.h();
        if (date != null && date.compareTo(new Date()) > 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.15"));
            return false;
        }
        if (StringUtils.isNotEmpty((String)string2) && !this.a(string2)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)string3) && !this.a(string3)) {
            return false;
        }
        if (StringUtils.isNotBlank((String)string6) && !POSUtil.validatePhoneNo(string6)) {
            POSMessageDialog.showError(this, Messages.getString("QuickCustomerForm.10"));
            return false;
        }
        if (StringUtils.isNotBlank((String)string)) {
            try {
                GenericDAO.getInstance().checkDifferentObjectExists(((Customer)this.bean).getId(), string, Customer.class, Customer.PROP_MEMBER_ID);
            }
            catch (PosException posException) {
                throw new PosException(Messages.getString("CustomerForm.22") + " " + string + " " + Messages.getString("GenericDAO.22"));
            }
        }
        if ((object = this.x.getSelectedItem()) != null) {
            customer.setSalutation(object.toString());
        }
        customer.setMemberId(string);
        customer.setFirstName(string4);
        customer.setLastName(string5);
        customer.setDob(date != null ? DateUtil.formatAsGiftCardDateFormat(date) : null);
        Attribute attribute = (Attribute)this.f.getSelectedItem();
        if (attribute != null) {
            customer.setMembershipType(attribute.getId());
        } else {
            customer.setMembershipType("");
        }
        Date date2 = this.g.getDate();
        Date date3 = this.h.getDate();
        if (date2 == null && date3 != null) {
            POSMessageDialog.showError(Messages.getString("CustomerForm.31"));
            return false;
        }
        if (date3 == null && date2 != null) {
            POSMessageDialog.showError(Messages.getString("CustomerForm.32"));
            return false;
        }
        if (StringUtils.isNotBlank((String)string) && date2 != null && date3 != null) {
            customer.setMember(true);
            customer.setMembershipActive(true);
        }
        customer.setMembershipExpiryDate(this.h.getDate());
        customer.setMembershipStartDate(this.g.getDate());
        customer.setAddress(StringUtils.isBlank((String)this.i.getText()) ? "" : this.i.getText().trim());
        customer.setCountry(string7);
        customer.setState(string8);
        customer.setCity(string9);
        customer.setCreditLimit(PosGuiUtil.parseDouble(this.m));
        customer.setEmail(string2);
        customer.setEmail2(this.C.getText());
        customer.setLoyaltyNo(this.k.getText());
        customer.setLoyaltyPoint(this.l.getInteger());
        customer.setZipCode(this.j.getText());
        customer.setVip(this.s.isSelected());
        customer.setTaxExempt(this.t.isSelected());
        customer.setActive(this.H.isSelected());
        customer.setMobileNo(string6);
        customer.setBalance(PosGuiUtil.parseDouble(this.n));
        if (this.z != null) {
            customer.setImageId(this.z.getId());
        } else {
            customer.setImageId("");
        }
        return true;
    }

    private void a(boolean bl) {
        try {
            Date date = this.g.getDate();
            Date date2 = this.h.getDate();
            String string = "";
            if (date != null && date2 != null && date.after(date2)) {
                if (bl) {
                    string = Messages.getString("CustomerForm.34");
                    this.h.setDate(null);
                } else {
                    string = Messages.getString("CustomerForm.33");
                    this.g.setDate(null);
                }
                throw new PosException(string);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage(), posException);
        }
    }

    private Date h() {
        if (this.E.getSelectedItem() == null || this.F.getSelectedItem() == null || this.G.getSelectedItem() == null) {
            return null;
        }
        MonthOfYear monthOfYear = (MonthOfYear)((Object)this.E.getSelectedItem());
        int n = (Integer)this.F.getSelectedItem();
        int n2 = (Integer)this.G.getSelectedItem();
        return POSUtil.createDate(n, monthOfYear.getValue(), n2);
    }

    private void a(Customer customer) {
        String string = customer.getDob();
        if (string == null) {
            return;
        }
        try {
            Date date = DateUtil.parseByGiftCardDateFormat(string);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int n = calendar.get(2);
            int n2 = calendar.get(5);
            int n3 = calendar.get(1);
            this.E.setSelectedItem((Object)MonthOfYear.getMonthOfYear(n + 1));
            this.G.setSelectedItem((Object)n3);
            this.F.setSelectedItem((Object)n2);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private boolean a(String string) {
        boolean bl = EmailValidator.getInstance().isValid(string);
        if (!bl) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.9"));
            return false;
        }
        return bl;
    }

    @Override
    public boolean delete() {
        try {
            Customer customer = (Customer)this.getBean();
            if (customer == null) {
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure to delete selected table?", "Confirm");
            if (n != 0) {
                return false;
            }
            CustomerDAO.getInstance().delete(customer);
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        if (this.getBean() == null) {
            return Messages.getString("CustomerForm.54");
        }
        return Messages.getString("CustomerForm.12");
    }

    public void setMobileNo(String string) {
        this.d.setText(string);
    }

    private void i() {
        try {
            this.q.setEnabled(true);
            this.r.setEnabled(false);
            String string = (String)this.p.getSelectedItem();
            List<String> list = this.o.getStateNames(string);
            this.q.removeAllItems();
            this.r.removeAllItems();
            this.q.addItem(null);
            for (String string2 : list) {
                this.q.addItem((Object)string2);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void j() {
        try {
            this.r.setEnabled(true);
            String string = (String)this.p.getSelectedItem();
            String string2 = (String)this.q.getSelectedItem();
            List<String> list = this.o.getCityNames(string, string2);
            this.r.removeAllItems();
            this.r.addItem(null);
            for (String string3 : list) {
                this.r.addItem((Object)string3);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    public static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> a;

        public MyOwnFocusTraversalPolicy(Vector<Component> vector) {
            this.a = new Vector(vector.size());
            this.a.addAll(vector);
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            int n = (this.a.indexOf(component) + 1) % this.a.size();
            return this.a.get(n);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            int n = this.a.indexOf(component) - 1;
            if (n < 0) {
                n = this.a.size() - 1;
            }
            return this.a.get(n);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.a.get(0);
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.a.lastElement();
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.a.get(0);
        }
    }
}

