/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.KitchenTicketItemDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.kitchendisplay.KichenButtonColumn;
import com.floreantpos.ui.kitchendisplay.KitchenDisplayView;
import com.floreantpos.ui.kitchendisplay.KitchenTicketActionListener;
import com.floreantpos.ui.kitchendisplay.TimerWatch;
import com.floreantpos.ui.ticket.MultiLineTableCellRenderer;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class KitchenTicketView
extends JPanel
implements ChangeListener {
    private static Border a;
    private static Border b;
    private ImageIcon c = IconFactory.getIcon("/ui_icons/", "check_mark.png");
    private TimerWatch d;
    private JScrollPane e;
    private JPanel f;
    private JLabel g;
    private JLabel h;
    private JLabel i;
    private BumpButton j;
    private KitchenTicketActionListener k;
    private JTable l;
    private KitchenTicketTableModel m;
    private KitchenTicket n;
    private boolean o;
    private Color p = Color.black;
    private Color q = Color.white;
    private JLabel r;

    public KitchenTicketView(KitchenTicket kitchenTicket, KitchenTicketActionListener kitchenTicketActionListener) {
        this.n = kitchenTicket;
        this.k = kitchenTicketActionListener;
        this.p = TerminalConfig.getColor("kds.background", Color.black);
        this.q = TerminalConfig.getColor("kds.textcolor", Color.white);
        boolean bl = AppConfig.getBoolean("kds.border", false);
        a = BorderFactory.createLineBorder(bl ? Color.GRAY : KitchenDisplayView.getInstance().getBackground());
        this.setLayout(new BorderLayout(1, 1));
        this.setOpaque(false);
        String string = Messages.getString("KitchenTicketView.DISPATCH");
        String string2 = Messages.getString("KitchenTicketView.11");
        this.j = new BumpButton(kitchenTicketActionListener.isDispatchMode() ? string : string2);
        this.a(kitchenTicket);
        this.b(kitchenTicket);
        this.b();
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setPreferredSize(PosUIManager.getSize(350, 240));
        this.d.start();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                KitchenTicketView.this.d.stop();
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }
        });
        this.a(false);
    }

    public void stopTimer() {
        this.d.stop();
    }

    private void a(KitchenTicket kitchenTicket) {
        Serializable serializable;
        String string;
        String string2 = kitchenTicket.getPrinterName();
        if (StringUtils.isEmpty((String)string2)) {
            string2 = kitchenTicket.getPrinters().toString();
        }
        String string3 = POSConstants.TOKEN + " " + kitchenTicket.getTokenNo() + " (" + kitchenTicket.getSequenceNumber() + ") ";
        if (kitchenTicket.getTableNumbers() != null && kitchenTicket.getTableNumbers().size() > 0) {
            string = kitchenTicket.getTableNumbers().toString();
            string = string.replace("[", "").replace("]", "");
            string3 = string3 + " " + POSConstants.TABLE + " " + string;
        }
        this.g = new JLabel(string3);
        this.h = new JLabel();
        string = kitchenTicket.getSubOrderType() != null ? kitchenTicket.getSubOrderType().getDisplayString() : kitchenTicket.getOrderType().getName();
        this.h.setText(string);
        this.i = new JLabel();
        if (kitchenTicket.getServerName() != null) {
            this.i.setText(POSConstants.RECEIPT_REPORT_SERVER_LABEL + " " + kitchenTicket.getServerName());
        }
        this.f = new JPanel((LayoutManager)new MigLayout("fill,ins 0", "[][]", ""));
        this.d = new TimerWatch(this.n.getCreateDate(), this);
        this.f.setBackground(Color.black);
        int n = TerminalConfig.getKDSTicketTokenSize();
        if (n == 0) {
            n = PosUIManager.getDefaultFontSize();
        }
        this.g.setFont(this.g.getFont().deriveFont(1, n));
        this.h.setFont(this.h.getFont().deriveFont(1, n));
        this.i.setFont(this.i.getFont().deriveFont(1, n));
        this.f.add((Component)this.g, "left");
        this.f.add((Component)this.d, "right,wrap, span");
        this.f.add((Component)this.h, "left");
        this.f.add((Component)this.i, "right,span");
        if (AppConfig.getBoolean("kds.sep", true)) {
            serializable = new JSeparator();
            ((JComponent)serializable).setBackground(Color.gray);
            this.f.add((Component)serializable, "newline,h 1!,grow,span");
        }
        this.r = new JLabel();
        serializable = DataProvider.get().getStore();
        if (((Store)serializable).isShowGuestNote() && StringUtils.isNotBlank((String)kitchenTicket.getNote())) {
            int n2 = TerminalConfig.getKDSTicketItemNameSize();
            if (n2 == 0) {
                n2 = PosUIManager.getDefaultFontSize();
            }
            this.r.setText("<html><right>" + Messages.getString("KitchenTicketView.0") + ": " + kitchenTicket.getNote() + "</right></html>");
            this.r.setFont(this.r.getFont().deriveFont(1, n2));
            this.f.add((Component)this.r, "gapleft 4, span");
        }
        this.add((Component)this.f, "North");
        this.a();
    }

    private void b(KitchenTicket kitchenTicket) {
        this.m = new KitchenTicketTableModel(kitchenTicket.getTicketItems());
        this.l = new JTable(this.m);
        Font font = this.l.getFont();
        int n = TerminalConfig.getKDSTicketItemNameSize();
        if (n == 0) {
            n = PosUIManager.getDefaultFontSize();
        }
        this.l.setFont(font.deriveFont(1, n));
        this.l.setRowSelectionAllowed(true);
        this.l.setCellSelectionEnabled(false);
        this.l.setTableHeader(null);
        this.l.setOpaque(false);
        this.l.setIntercellSpacing(new Dimension(0, 0));
        this.l.setShowGrid(false);
        this.l.setFocusable(false);
        this.l.setBackground(Color.BLACK);
        this.l.setForeground(Color.white);
        this.l.setDefaultRenderer(Object.class, new KitchenTicketTableCellRenderer());
        this.c();
        boolean bl = this.o = !AppConfig.getBoolean("kds.hide_item_bump", false);
        if (this.o) {
            new BumpColumnRenderer(this.l, new BumpAction(), 1);
        }
        this.e = new JScrollPane(this.l);
        this.e.getViewport().setOpaque(false);
        this.e.setOpaque(false);
        this.e.setBorder(BorderFactory.createLineBorder(KitchenDisplayView.getInstance().getBackground()));
        this.add(this.e);
    }

    protected void scrollKitchenTicket(int n, int n2) {
        if (this.getMaxYExtent() > 0) {
            Point point = this.e.getViewport().getViewPosition();
            point.x += this.e.getWidth() / 5 * n;
            point.y += this.e.getHeight() / 5 * n2;
            point.x = Math.max(0, point.x);
            point.x = Math.min(this.getMaxXExtent(), point.x);
            point.y = Math.max(0, point.y);
            point.y = Math.min(this.getMaxYExtent(), point.y);
            this.e.getViewport().setViewPosition(point);
        }
    }

    protected int getMaxXExtent() {
        return this.e.getViewport().getView().getWidth() - this.e.getViewport().getWidth();
    }

    protected int getMaxYExtent() {
        return this.e.getViewport().getView().getHeight() - this.e.getViewport().getHeight();
    }

    private void a() {
        if (this.d.applicableColorComponentIndex == 0) {
            this.d.setBackgroundColor(this.d.backColor);
            this.d.setForegroundColor(this.d.textColor);
        } else {
            this.f.setBackground(this.d.backColor);
        }
        this.g.setForeground(this.d.textColor);
        this.h.setForeground(this.d.textColor);
        this.i.setForeground(this.d.textColor);
        this.r.setForeground(this.d.textColor);
    }

    private void b() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.setOpaque(false);
        int n = TerminalConfig.getKDSTicketTokenSize();
        if (n == 0) {
            n = PosUIManager.getDefaultFontSize();
        }
        this.j.setFont(this.j.getFont().deriveFont(1, n));
        this.j.setPreferredSize(PosUIManager.getSize(100, 40));
        if (AppConfig.getBoolean("kds.sep", true)) {
            JSeparator jSeparator = new JSeparator();
            jSeparator.setBackground(Color.gray);
            jSeparator.setPreferredSize(new Dimension(0, 1));
            jPanel.add((Component)jSeparator, "North");
        }
        jPanel.add(this.j);
        this.add((Component)jPanel, "South");
    }

    protected String getKey() {
        return String.valueOf(this.getClientProperty("key"));
    }

    private void c() {
        this.l.setAutoResizeMode(4);
        this.a(1, PosUIManager.getSize(80));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.l.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    public boolean keySelected(int n) {
        String string = KeyEvent.getKeyText(n);
        if (string.contains("NumPad-")) {
            string = string.split("-")[1];
        }
        Object object = this.getClientProperty("key");
        String string2 = String.valueOf(object);
        boolean bl = string2.equals(string);
        this.j.setKeySelected(bl);
        return bl;
    }

    public void setSelected(boolean bl) {
        this.j.setKeySelected(bl);
    }

    public boolean isKeySelected() {
        return this.j.isKeySelected();
    }

    public void fireBumpSelected() {
        this.j.actionPerformed(null);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.d == null) {
            return;
        }
        this.a();
    }

    public KitchenTicket getTicket() {
        return this.n;
    }

    public void setTicket(KitchenTicket kitchenTicket) {
        this.n = kitchenTicket;
    }

    public void bump() {
        this.d.stop();
        this.k.bump(this);
    }

    private void a(Boolean bl) {
        this.setBorder(bl == false ? a : b);
    }

    private void d() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
            jSONObject.put("command", (Object)"3");
            jSONObject.put("isKds", (Object)Boolean.TRUE);
            OroMqttClient.getInstance().publishData("MQTT-COMMAND-KIT-DIS-UPDATE", jSONObject.toString());
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception);
        }
    }

    static {
        b = BorderFactory.createLineBorder(Color.green, 2);
    }

    private class BumpButton
    extends PosButton
    implements ActionListener {
        private Boolean b;

        public BumpButton(String string) {
            super(string);
            this.b = false;
            this.setOpaque(false);
            this.addActionListener(this);
            this.setForeground(Color.white);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Color color;
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            Color color2 = color = KitchenTicketView.this.d != null ? new Color(45, 45, 45) : this.getBackground();
            int n = 0;
            int n2 = 0;
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            GradientPaint gradientPaint = new GradientPaint(n, n2, color2, n3 - 2, n4 - 2, color, true);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(n, n2, n3, n4);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.b.booleanValue()) {
                graphics2D.setColor(new Color(0, 160, 0));
            } else {
                graphics2D.setColor(Color.black);
            }
            int n5 = this.getHeight() - 10;
            graphics2D.fillOval(10, 4, n5, n5);
            graphics2D.setColor(Color.WHITE);
            int n6 = TerminalConfig.getKDSTicketTokenSize();
            if (n6 == 0) {
                n6 = PosUIManager.getDefaultFontSize();
            }
            graphics2D.setFont(graphics2D.getFont().deriveFont(1, n6));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(KitchenTicketView.this.getKey(), graphics2D);
            int n7 = (n5 + 10 - (int)rectangle2D.getWidth() + 10) / 2;
            int n8 = (n5 - (int)rectangle2D.getHeight()) / 2 + fontMetrics.getAscent();
            graphics2D.drawString(KitchenTicketView.this.getKey(), n7, n8 + 2);
            graphics2D.setBackground(color);
            super.paintComponent(graphics2D);
        }

        public Boolean isKeySelected() {
            return this.b;
        }

        public void setKeySelected(Boolean bl) {
            this.b = bl;
            KitchenTicketView.this.a(bl);
            this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (KitchenTicketView.this.k.isDispatchMode()) {
                KitchenTicketView.this.k.dispatch(KitchenTicketView.this);
            } else {
                KitchenTicketView.this.k.bump(KitchenTicketView.this);
            }
        }
    }

    class KitchenTicketTableModel
    extends ListTableModel<KitchenTicketItem> {
        KitchenTicketTableModel(List<KitchenTicketItem> list) {
            super(new String[]{"", ""}, list);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            KitchenTicketItem kitchenTicketItem = (KitchenTicketItem)this.getRowData(n);
            return n2 == 1 && KitchenTicketView.this.o && !KitchenStatus.BUMP.name().equals(kitchenTicketItem.getStatus());
        }

        @Override
        public Object getValueAt(int n, int n2) {
            KitchenTicketItem kitchenTicketItem = (KitchenTicketItem)this.getRowData(n);
            switch (n2) {
                case 0: {
                    if (kitchenTicketItem.isModifierItem().booleanValue()) {
                        return "      " + kitchenTicketItem.getMenuItemNameDisplay();
                    }
                    return kitchenTicketItem.getMenuItemNameDisplay();
                }
                case 1: {
                    return kitchenTicketItem.isVoided() != false || !KitchenTicketView.this.o ? "" : POSConstants.BUMP;
                }
            }
            return null;
        }
    }

    private class KitchenTicketTableCellRenderer
    extends DefaultTableCellRenderer {
        MultiLineTableCellRenderer a = new MultiLineTableCellRenderer();

        KitchenTicketTableCellRenderer() {
            int n = PosUIManager.getSize(5);
            int n2 = PosUIManager.getSize(2);
            this.a.setBorder(new EmptyBorder(n, n2, n, n2));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            KitchenTicketItem kitchenTicketItem = (KitchenTicketItem)KitchenTicketView.this.m.getRowData(n);
            Component component = null;
            if (n2 == 0) {
                if (kitchenTicketItem.isVoided().booleanValue() && object != null) {
                    object = "*** " + POSConstants.VOID + " *** " + object;
                }
                component = this.a.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            } else {
                component = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (kitchenTicketItem.isVoided().booleanValue()) {
                component.setBackground(Color.red);
                component.setForeground(Color.white);
                return component;
            }
            component.setBackground(KitchenTicketView.this.p);
            component.setForeground(KitchenTicketView.this.q);
            if (kitchenTicketItem != null && kitchenTicketItem.getStatus() != null) {
                if (kitchenTicketItem.getStatus().equalsIgnoreCase(KitchenStatus.BUMP.name())) {
                    component.setBackground(Color.green);
                    component.setForeground(Color.black);
                } else {
                    if (kitchenTicketItem.isVoided().booleanValue() || kitchenTicketItem.getStatus().equalsIgnoreCase(KitchenStatus.VOID.name())) {
                        JLabel jLabel = (JLabel)component;
                        if (n2 == 0) {
                            jLabel.setText("<html><strike>" + kitchenTicketItem.getMenuItemName() + "</strike></html>");
                        }
                        jLabel.setBackground(new Color(128, 0, 128));
                        jLabel.setForeground(Color.white);
                        return jLabel;
                    }
                    component.setBackground(KitchenTicketView.this.p);
                    component.setForeground(KitchenTicketView.this.q);
                }
            }
            JLabel jLabel = new JLabel();
            jLabel.setOpaque(false);
            if (n2 == 1 && (kitchenTicketItem.isModifierItem().booleanValue() || kitchenTicketItem.isCookingInstruction().booleanValue() || kitchenTicketItem.isVoided().booleanValue() || KitchenStatus.BUMP.name().equals(kitchenTicketItem.getStatus()))) {
                jLabel.setText("");
                return jLabel;
            }
            return component;
        }
    }

    private class BumpAction
    extends AbstractAction {
        private BumpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = Integer.parseInt(actionEvent.getActionCommand());
            KitchenTicketItem kitchenTicketItem = (KitchenTicketItem)KitchenTicketView.this.m.getRowData(n);
            if (kitchenTicketItem.isInformationOnly() || kitchenTicketItem.isVoided().booleanValue() || kitchenTicketItem.getStatus().equals(KitchenStatus.BUMP.name())) {
                return;
            }
            KitchenTicketView.this.k.pushToStacK(kitchenTicketItem.getKitchenTicket());
            KitchenTicketItemDAO.getInstance().refresh(kitchenTicketItem);
            KitchenTicketItemDAO.getInstance().bumpTicketItem(kitchenTicketItem);
            KitchenTicketView.this.d();
            KitchenTicketView.this.m.fireTableRowsUpdated(n, n);
        }
    }

    private class BumpColumnRenderer
    extends KichenButtonColumn {
        JLabel a;
        Font b;

        private BumpColumnRenderer(JTable jTable, Action action, int n) {
            super(jTable, action, n);
            this.a = new JLabel();
            this.b = this.getFont().deriveFont(1, PosUIManager.getDefaultFontSize() + 3);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            KitchenTicketItem kitchenTicketItem = (KitchenTicketItem)KitchenTicketView.this.m.getRowData(n);
            if (kitchenTicketItem.isModifierItem().booleanValue() || kitchenTicketItem.isInformationOnly() || kitchenTicketItem.isVoided().booleanValue()) {
                this.a.setText("X");
                this.a.setBackground(Color.black);
                return this.a;
            }
            if (KitchenStatus.BUMP.name().equals(kitchenTicketItem.getStatus())) {
                this.a.setText("");
                this.a.setBackground(Color.green);
                return this.a;
            }
            if (kitchenTicketItem.getQuantity() <= 0.0) {
                this.a.setText("X");
                this.a.setBackground(Color.black);
                this.a.setIcon(null);
                return this.a;
            }
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setFont(this.b);
            return component;
        }
    }
}

