/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.SlideShowImageDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.ticket.TicketViewerTableModel;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class LineDisplayWindow
extends JFrame
implements TicketEditListener,
WindowListener {
    public static final String VIEW_NAME = "KD";
    private JLabel a;
    private JLabel b;
    private JLabel c;
    private JLabel d;
    private JLabel e;
    private JLabel f;
    private JPanel g;
    private JLabel h;
    private JLabel i;
    private JLabel j;
    private JLabel k;
    private JLabel l;
    private JPanel m;
    private TicketViewerTable n = new TicketViewerTable(null, 0, 2);
    private Store o;
    private boolean p;
    private boolean q;
    private boolean r;
    private Timer s;
    private JPanel t;
    private JPanel u;
    private JLabel v;
    private JLabel w;
    private JLabel x;
    private JLabel y;
    private JLabel z;
    private JLabel A;
    private PosScrollPane B;
    private PaginatedTableModel C;
    private JLabel D;
    private JSeparator E;
    private JSeparator F;
    private JLabel G;

    public LineDisplayWindow() {
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.n.setModel(new TicketViewerTableModel(this.n));
        this.n.setShowGrid(false);
        this.n.setFont(this.n.getFont().deriveFont((float)PosUIManager.getFontSize(18)));
        TableColumnModel tableColumnModel = this.n.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(PosUIManager.getSize(250));
        this.d();
        this.e();
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setTitle(Application.getTitle() + "- " + Messages.getString("LineDisplayWindow.1"));
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        OrderView.getInstance().getOrderController().addTicketUpdateListener(this);
        this.a();
        this.b();
    }

    private void a() {
        this.C = new PaginatedTableModel(){

            @Override
            public Object getValueAt(int n, int n2) {
                return null;
            }
        };
        this.C.setRows(new ArrayList());
        this.C.setPageSize(1);
        this.C.setNumRows(SlideShowImageDAO.getInstance().rowCount());
    }

    private void b() {
        this.o = DataProvider.get().getStore();
        int n = this.o.getCustomerMonitorDisplayOption();
        switch (n) {
            case 0: {
                this.p = true;
                break;
            }
            case 1: {
                this.q = true;
                break;
            }
            case 2: {
                this.r = true;
                break;
            }
        }
        this.c();
        this.b.setText(this.o.getName());
    }

    private void c() {
        if (!this.q && !this.r) {
            return;
        }
        int n = this.o.getCustomerMonitorDisplaySlideDuration();
        this.s = new Timer(n * 1000, new ImageUpdateTask());
        this.s.setInitialDelay(0);
        this.s.start();
    }

    private void d() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.WHITE);
        this.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.setOpaque(true);
        jPanel2.setBackground(Color.black);
        this.a = new JLabel();
        this.a.setHorizontalAlignment(0);
        jPanel2.add((Component)this.a, "Center");
        jPanel.add((Component)jPanel2, "Center");
        this.m = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.m.setOpaque(true);
        this.m.setBackground(Color.WHITE);
        this.g = new JPanel((LayoutManager)new MigLayout("fill"));
        this.g.setOpaque(false);
        this.g.setPreferredSize(PosUIManager.getSize(500, 750));
        this.t = new JPanel((LayoutManager)new MigLayout("fillx, center"));
        this.u = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3, center, ins 10 10 10 10", "[][right]", ""));
        this.u.setOpaque(true);
        this.u.setBackground(Color.WHITE);
        JLabel jLabel = new JLabel(Messages.getString("LineDisplayWindow.5"));
        this.A = new JLabel();
        JLabel jLabel2 = new JLabel(Messages.getString("LineDisplayWindow.9"));
        this.z = new JLabel();
        JLabel jLabel3 = new JLabel(Messages.getString("LineDisplayWindow.11"));
        this.x = new JLabel();
        this.G = new JLabel(POSConstants.SERVICE_CHARGE);
        this.y = new JLabel();
        JLabel jLabel4 = new JLabel(Messages.getString("LineDisplayWindow.12"));
        this.w = new JLabel();
        JLabel jLabel5 = new JLabel(Messages.getString("LineDisplayWindow.13"));
        this.v = new JLabel();
        this.u.add(jLabel);
        this.u.add((Component)this.A, "wrap");
        this.u.add(jLabel2);
        this.u.add((Component)this.z, "wrap");
        this.u.add(jLabel3);
        this.u.add((Component)this.x, "wrap");
        this.u.add(this.G);
        this.u.add((Component)this.y, "wrap");
        this.u.add(jLabel4);
        this.u.add((Component)this.w, "wrap");
        this.u.add(jLabel5);
        this.u.add((Component)this.v, "wrap");
        this.E = new JSeparator(){
            private static final long b = 1L;

            @Override
            public void paintComponent(Graphics graphics) {
                for (int i = 0; i < 640; i += 15) {
                    graphics.drawLine(i, 0, i + 10, 0);
                }
            }
        };
        this.F = new JSeparator(){
            private static final long b = 1L;

            @Override
            public void paintComponent(Graphics graphics) {
                for (int i = 0; i < 640; i += 15) {
                    graphics.drawLine(i, 0, i + 10, 0);
                }
            }
        };
        this.m.add((Component)this.t, "grow, wrap");
        this.m.add((Component)this.E, "center, grow, wrap");
        this.m.add((Component)this.g, "growx, wrap");
        this.m.add((Component)this.F, "center, grow, wrap");
        this.m.add((Component)this.u, "grow");
        int n = 48;
        int n2 = 20;
        int n3 = 32;
        this.b = new JLabel();
        Font font = this.b.getFont();
        this.b.setFont(new Font(font.getName(), 1, n));
        this.D = new JLabel();
        this.c = new JLabel(Messages.getString("LineDisplayWindow.6"));
        Font font2 = this.c.getFont();
        Font font3 = new Font(font2.getName(), 0, n2);
        this.c.setFont(font3);
        this.k = new JLabel(Messages.getString("LineDisplayWindow.7"));
        this.k.setFont(font3);
        this.l = new JLabel();
        this.l.setFont(font3);
        this.d = new JLabel();
        this.d.setFont(font3);
        this.h = new JLabel(Messages.getString("LineDisplayWindow.8"));
        this.h.setFont(font3);
        this.i = new JLabel();
        this.i.setFont(font3);
        this.j = new JLabel();
        this.j.setFont(new Font(font2.getName(), 1, n2));
        this.j.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.BLACK));
        this.e = new JLabel(Messages.getString("LineDisplayWindow.10"));
        this.e.setFont(new Font(font2.getName(), 1, n3));
        this.f = new JLabel();
        this.f.setFont(new Font(font2.getName(), 1, n3));
        this.n.setOpaque(true);
        this.n.setBackground(Color.WHITE);
        this.n.setTableHeader(null);
        this.n.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.n.setRowSelectionAllowed(false);
        this.n.setRowHeight(30);
        this.B = new PosScrollPane(this.n);
        this.B.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.B.getViewport().setBorder(null);
        this.B.setOpaque(true);
        this.B.getViewport().setOpaque(true);
        this.B.getViewport().setBackground(Color.WHITE);
        this.B.setBackground(Color.WHITE);
        this.B.setHorizontalScrollBarPolicy(31);
        this.B.setVerticalScrollBarPolicy(20);
        this.B.setPreferredSize(PosUIManager.getSize(180, 200));
        this.g.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.g.add((Component)this.B, "grow");
        this.t.setOpaque(true);
        this.t.setBackground(Color.WHITE);
        this.t.add((Component)this.b, "center, wrap");
        this.t.add((Component)this.D, "center, wrap");
        jPanel.add((Component)this.m, "East");
        jLabel.setFont(font3);
        this.A.setFont(font3);
        jLabel2.setFont(font3);
        this.z.setFont(font3);
        jLabel3.setFont(font3);
        this.x.setFont(font3);
        this.G.setFont(font3);
        this.y.setFont(font3);
        jLabel4.setFont(font3);
        this.w.setFont(font3);
        jLabel5.setFont(font3);
        this.v.setFont(font3);
        this.D.setFont(new Font(font2.getName(), 1, n3));
        this.D.setForeground(Color.RED);
        jLabel.setForeground(Color.RED);
        this.A.setForeground(Color.RED);
        jLabel2.setForeground(Color.RED);
        this.z.setForeground(Color.RED);
        jLabel3.setForeground(Color.RED);
        this.x.setForeground(Color.RED);
        this.G.setForeground(Color.RED);
        this.y.setForeground(Color.RED);
        jLabel4.setForeground(Color.RED);
        this.w.setForeground(Color.RED);
        jLabel5.setForeground(Color.RED);
        this.v.setForeground(Color.RED);
    }

    public void saveSizeAndLocation() {
        AppConfig.putInt("ldwwidth", this.getWidth());
        AppConfig.putInt("ldwheight", this.getHeight());
        AppConfig.putInt("ldwx", this.getX());
        AppConfig.putInt("ldwy", this.getY());
        AppConfig.putInt("ldwextendedstate", this.getExtendedState());
    }

    private void e() {
        int n = AppConfig.getInt("ldwwidth", 900);
        int n2 = AppConfig.getInt("ldwheight", 650);
        this.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = dimension.width - n >> 1;
        int n4 = dimension.height - n2 >> 1;
        n3 = AppConfig.getInt("ldwx", n3);
        n4 = AppConfig.getInt("ldwy", n4);
        this.setLocation(n3, n4);
        int n5 = AppConfig.getInt("ldwextendedstate", -1);
        if (n5 != -1) {
            this.setExtendedState(n5);
        }
    }

    @Override
    public void itemAdded(Ticket ticket, ITicketItem iTicketItem) {
        SwingUtilities.invokeLater(() -> {
            if (!(iTicketItem instanceof TicketItem)) {
                return;
            }
            TicketItem ticketItem = (TicketItem)iTicketItem;
            this.n.setVisible(true);
            this.n.setTicket(ticket);
            this.n.scrollLast();
            if (this.p || this.r) {
                MenuItem menuItem;
                if (this.s != null) {
                    this.s.stop();
                }
                if ((menuItem = ticketItem.getMenuItem()) == null || StringUtils.isBlank((String)menuItem.getImageId())) {
                    this.a((Image)null);
                } else {
                    String string = menuItem.getImageId();
                    ImageIcon imageIcon = IconFactory.getIconFromImageResource(string);
                    if (imageIcon != null) {
                        Image image = imageIcon.getImage();
                        this.a(image);
                    }
                }
            }
            this.a(ticket);
        });
    }

    @Override
    public void ticketEditingStart(Ticket ticket) {
        if (StringUtils.isNotBlank((String)ticket.getId()) && ticket.getTicketItems().size() > 0) {
            this.ticketEdited(ticket);
        } else {
            this.n.setTicket(ticket);
            this.n.setVisible(true);
        }
    }

    @Override
    public void ticketEdited(Ticket ticket) {
        SwingUtilities.invokeLater(() -> {
            if ((this.p || this.r) && this.s != null) {
                this.s.stop();
            }
            if (ticket.getId() == null) {
                this.D.setText(Messages.getString("LineDisplayWindow.28"));
            } else {
                this.D.setText(Messages.getString("LineDisplayWindow.29") + ticket.getTokenNo());
            }
            this.n.setTicket(ticket);
            this.n.setVisible(true);
            this.a(ticket);
        });
    }

    private void a(Ticket ticket) {
        String string = CurrencyUtil.getCurrencySymbol();
        this.A.setText(string + NumberUtil.formatNumber(ticket.getSubtotalAmount()));
        this.z.setText(string + NumberUtil.formatNumber(ticket.getTaxAmount()));
        this.x.setText(string + NumberUtil.formatNumber(ticket.getDiscountAmount()));
        this.y.setText(string + NumberUtil.formatNumber(ticket.getServiceCharge()));
        this.w.setText(string + NumberUtil.formatNumber(ticket.getGratuityAmount()));
        this.v.setText(string + NumberUtil.formatNumber(ticket.getTotalAmountWithTips()));
        this.G.setVisible(ticket.getServiceCharge() > 0.0);
        this.y.setVisible(ticket.getServiceCharge() > 0.0);
    }

    @Override
    public void itemRemoved(ITicketItem iTicketItem) {
        if (iTicketItem instanceof TicketItem) {
            this.ticketEdited(((TicketItem)iTicketItem).getTicket());
        } else {
            this.ticketEdited(this.n.getTicket());
        }
    }

    @Override
    public void ticketEditingFinish(Ticket ticket) {
        SwingUtilities.invokeLater(() -> {
            if (this.s != null && !this.s.isRunning()) {
                this.s.restart();
            }
            this.D.setText("");
            this.n.setVisible(false);
            this.A.setText("");
            this.z.setText("");
            this.x.setText("");
            this.y.setText("");
            this.w.setText("");
            this.v.setText("");
            this.y.setVisible(false);
            this.G.setVisible(false);
        });
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        OrderView.getInstance().getOrderController().removeTicketUpdateListener(this);
        this.saveSizeAndLocation();
        this.setVisible(false);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.setVisible(false);
        if (this.s != null) {
            this.s.stop();
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void openFullScreen() {
        this.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        this.setResizable(true);
        this.setVisible(true);
    }

    private void a(Image image) {
        if (image == null) {
            this.a.setIcon(null);
            return;
        }
        this.b(image);
        this.a.revalidate();
        this.a.repaint();
    }

    private void b(Image image) {
        if (image == null) {
            return;
        }
        int n = image.getHeight(null);
        int n2 = image.getWidth(null);
        int n3 = this.a.getWidth();
        int n4 = this.a.getHeight();
        if (n2 > n) {
            int n5 = n3;
            int n6 = n3 * n / n2;
            image = image.getScaledInstance(n5, n6, 4);
        } else {
            int n7 = n4;
            int n8 = n4 * n2 / n;
            image = image.getScaledInstance(n8, n7, 4);
        }
        if (image != null) {
            this.a.setIcon(new ImageIcon(image));
        }
    }

    class LineDisplayTableModel
    extends TicketViewerTableModel {
        public LineDisplayTableModel(TicketViewerTable ticketViewerTable) {
            super(ticketViewerTable);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        protected void calculateRows() {
            if (this.ticket == null) {
                return;
            }
            List<TicketItem> list = this.ticket.getTicketItems();
            if (list != null) {
                int n = 0;
                this.tableRows.clear();
                for (int i = list.size() - 1; i >= 0; --i) {
                    this.tableRows.put(String.valueOf(n++), list.get(i));
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ITicketItem iTicketItem = (ITicketItem)this.tableRows.get(String.valueOf(n));
            if (iTicketItem == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return iTicketItem.getNameDisplay();
                }
                case 1: {
                    return NumberUtil.getCurrencyFormat(iTicketItem.getSubTotalAmountDisplay());
                }
            }
            return null;
        }
    }

    private class ImageUpdateTask
    implements ActionListener {
        private ImageUpdateTask() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ImageResource imageResource;
                ImageIcon imageIcon;
                SlideShowImageDAO.getInstance().getImages(LineDisplayWindow.this.C);
                if (LineDisplayWindow.this.C.getRows() == null) {
                    if (LineDisplayWindow.this.s != null) {
                        LineDisplayWindow.this.s.stop();
                    }
                    return;
                }
                if (LineDisplayWindow.this.C.getRows().isEmpty()) {
                    LineDisplayWindow.this.C.setCurrentRowIndex(0);
                    SlideShowImageDAO.getInstance().getImages(LineDisplayWindow.this.C);
                }
                if ((imageIcon = IconFactory.getIconFromImageResource((imageResource = (ImageResource)LineDisplayWindow.this.C.getRowData(0)).getId())) != null) {
                    LineDisplayWindow.this.a(imageIcon.getImage());
                }
                if (!LineDisplayWindow.this.C.hasNext()) {
                    LineDisplayWindow.this.C.setCurrentRowIndex(0);
                } else {
                    LineDisplayWindow.this.C.setCurrentRowIndex(LineDisplayWindow.this.C.getCurrentRowIndex() + 1);
                }
                LineDisplayWindow.this.s.start();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }
}

