/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.MenuItemVariantExplorer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ServicePaymentType;
import com.floreantpos.model.ServiceType;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IUpdatebleView;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.menuitem.ButtonStylePanel;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class ServiceForm
extends BeanEditor<MenuItem>
implements RefreshableView,
ActionListener,
ChangeListener {
    private MenuItem a;
    private JComboBox b = new JComboBox();
    private JComboBox c = new JComboBox();
    private JComboBox d = new JComboBox();
    private JCheckBox e = new JCheckBox();
    private JCheckBox f = new JCheckBox();
    private JLabel g = new JLabel();
    private JLabel h = new JLabel();
    private JLabel i = new JLabel();
    private JPanel j = new JPanel();
    private JTabbedPane k = new JTabbedPane();
    private FixedLengthTextField l = new FixedLengthTextField(20, 255);
    private FixedLengthTextField m = new FixedLengthTextField(20, 255);
    private DoubleTextField n = new DoubleTextField(10);
    private JTextArea o = new JTextArea(new FixedLengthDocument(512));
    private JLabel p = new JLabel(Messages.getString("MenuItemForm.lblBarcode.text"));
    private FixedLengthTextField q = new FixedLengthTextField(21, 128);
    private JButton r = new JButton("+");
    private MenuItemVariantExplorer s;
    private JComboBox<MenuGroup> t = new JComboBox();
    private ButtonStylePanel u;
    private Double v;

    public ServiceForm(MenuItem menuItem) throws Exception {
        this.a = menuItem;
        this.a();
        this.initData();
        this.setBean(menuItem);
    }

    public void initData() {
        MenuGroupDAO menuGroupDAO = new MenuGroupDAO();
        ArrayList<MenuGroup> arrayList = new ArrayList<MenuGroup>();
        arrayList.add(null);
        List<MenuGroup> list = menuGroupDAO.findAll();
        if (list != null && list.size() > 0) {
            arrayList.addAll(list);
        }
        this.t.setModel(new ComboBoxModel(arrayList));
        this.b.setModel(new ComboBoxModel(Arrays.asList(ServiceType.values())));
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        List<ServicePaymentType> list2 = Arrays.asList(ServicePaymentType.values());
        for (ServicePaymentType object2 : list2) {
            comboBoxModel.addElement((Object)object2);
        }
        this.c.setModel(comboBoxModel);
        ComboBoxModel comboBoxModel2 = new ComboBoxModel();
        comboBoxModel2.addElement((Object)null);
        List<TaxGroup> list3 = TaxGroupDAO.getInstance().findAll();
        for (TaxGroup taxGroup : list3) {
            comboBoxModel2.addElement(taxGroup);
        }
        this.d.setModel(comboBoxModel2);
        this.s.setParentMenuItem(this.a);
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.initGeneralTab();
        this.b();
        this.initBtnstyleTab();
        this.k.addChangeListener(this);
    }

    private void b() {
        this.s = new MenuItemVariantExplorer(true);
        this.s.setVisibleResetCostButton(false);
        this.k.addTab(Messages.getString("ServiceVariants"), this.s);
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.c().get(i));
        }
    }

    private List c() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(200);
        arrayList.add(50);
        arrayList.add(50);
        return arrayList;
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuItem menuItem = (MenuItem)this.getBean();
            MenuItemDAO menuItemDAO = MenuItemDAO.getInstance();
            boolean bl = menuItemDAO.isNameExist(menuItem.getId(), menuItem.getName());
            if (bl) {
                String string = Messages.getString("MenuItemForm.0");
                String string2 = Messages.getString("MenuItemForm.1");
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string, string2, Messages.getString("MenuItemForm.3"), Messages.getString("MenuItemForm.5"));
                if (n != 0) {
                    return false;
                }
            }
            menuItemDAO.saveOrUpdate(menuItem);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        String string;
        MenuItem menuItem = (MenuItem)this.getBean();
        this.l.setText(menuItem.getName());
        this.o.setText(menuItem.getDescription());
        this.m.setText(menuItem.getTranslatedName());
        this.q.setText(menuItem.getBarcode());
        this.v = menuItem.getPrice();
        this.n.setText(NumberUtil.formatAmount(this.v));
        this.f.setSelected(menuItem.isVisible());
        this.u.setShowTextWithImage(menuItem.isShowImageOnly());
        ImageResource imageResource = ImageResourceDAO.getInstance().findById(menuItem.getImageId());
        if (imageResource != null) {
            this.u.setImageResource(imageResource);
        }
        this.d.setSelectedItem(menuItem.getTaxGroup());
        if (menuItem.getMenuGroupId() != null) {
            PosGuiUtil.selectComboItemById(this.t, menuItem.getMenuGroupId());
        }
        if (StringUtils.isNotBlank((String)(string = ((MenuItem)this.getBean()).getServiceType()))) {
            this.b.setSelectedItem((Object)ServiceType.valueOf(string));
        } else {
            this.b.setSelectedIndex(0);
        }
        ServicePaymentType servicePaymentType = ((MenuItem)this.getBean()).getPaymentType();
        this.c.setSelectedItem((Object)servicePaymentType);
        this.u.setSortOrder(menuItem.getSortOrder());
        Color color = menuItem.getButtonColor();
        if (color != null) {
            this.u.setButtonColor(color);
            this.u.setTextColor(color);
        }
        if (menuItem.getTextColor() != null) {
            this.u.setTextForegroundColor(menuItem.getTextColor());
        }
        this.e.setSelected(true);
        this.e.setEnabled(false);
        this.s.setParentMenuItem(menuItem);
    }

    @Override
    public boolean updateModel() {
        Object object;
        Serializable serializable;
        String string = this.l.getText();
        if (POSUtil.isBlankOrNull(string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NAME_REQUIRED);
            return false;
        }
        ServicePaymentType servicePaymentType = (ServicePaymentType)((Object)this.c.getSelectedItem());
        if (servicePaymentType == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PaymentTypeIsRequired"));
            return false;
        }
        double d = this.n.getDoubleOrZero();
        if (d < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.12"));
            return false;
        }
        MenuItem menuItem = (MenuItem)this.getBean();
        menuItem.setName(string);
        if (StringUtils.isNotBlank((String)this.o.getText())) {
            menuItem.setDescription(this.o.getText().trim());
        }
        menuItem.setService(true);
        menuItem.setBarcode(this.q.getText());
        menuItem.setPrice(d);
        menuItem.setTaxGroup((TaxGroup)this.d.getSelectedItem());
        menuItem.setVisible(this.f.isSelected());
        menuItem.setShowImageOnly(this.u.isShowTextWithImage());
        menuItem.setTranslatedName(this.m.getText());
        menuItem.setSortOrder(this.u.getSortOrder());
        menuItem.setButtonColorCode(this.u.getButtonColorCode());
        menuItem.setTextColorCode(this.u.getTextColorCode());
        menuItem.setHasMandatoryModifiers(false);
        menuItem.setServiceChargeApplicable(false);
        menuItem.setServiceChargeRefundable(false);
        menuItem.setTaxOnServiceCharge(false);
        int n = this.k.getTabCount();
        for (int i = 0; i < n; ++i) {
            serializable = this.k.getComponent(i);
            if (!(serializable instanceof IUpdatebleView) || (object = (IUpdatebleView)((Object)serializable)).updateModel(menuItem)) continue;
            return false;
        }
        MenuGroup menuGroup = (MenuGroup)this.t.getSelectedItem();
        menuItem.setMenuGroup(menuGroup);
        menuItem.setComboItem(false);
        menuItem.setServiceType(((ServiceType)((Object)this.b.getSelectedItem())).name());
        menuItem.setPaymentType(servicePaymentType);
        menuItem.setCustomerRequired(this.e.isSelected());
        serializable = menuItem.getVariants();
        if (serializable == null) {
            serializable = new ArrayList<MenuItem>();
        }
        if ((object = this.s.getVariants()) != null && object.size() > 0) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                MenuItem menuItem2 = (MenuItem)iterator.next();
                menuItem2.setName(menuItem2.createVariantName(string));
                menuItem2.setLastUpdateTime(StoreDAO.getServerTimestamp());
                menuItem2.setInventoryItem(false);
                menuItem2.setParentMenuItem(menuItem);
                menuItem2.setMenuGroup(menuGroup);
                menuItem2.setService(true);
                menuItem2.setPaymentType(menuItem.getPaymentType());
                menuItem2.setServiceType(menuItem.getServiceType());
                menuItem2.setCustomerRequired(menuItem.isCustomerRequired());
                menuItem2.setShouldPrintToKitchen(false);
                if (serializable.contains(menuItem2)) continue;
                serializable.add(menuItem2);
            }
            for (MenuItem menuItem2 : serializable) {
                if (object.contains(menuItem2)) continue;
                menuItem2.setDeleted(true);
            }
            menuItem.setVariants((List<MenuItem>)((Object)serializable));
        }
        menuItem.setHasVariant(menuItem.getActiveVariants() != null && menuItem.getActiveVariants().size() > 0);
        menuItem.setImageId(this.u.getImageResourceId());
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuItem menuItem = (MenuItem)this.getBean();
        if (menuItem.getId() == null) {
            return Messages.getString("NewService");
        }
        return Messages.getString("EditService") + " " + menuItem.getName();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Component component = this.k.getSelectedComponent();
        if (!(component instanceof IUpdatebleView)) {
            return;
        }
        IUpdatebleView iUpdatebleView = (IUpdatebleView)((Object)component);
        MenuItem menuItem = (MenuItem)this.getBean();
        iUpdatebleView.initView(menuItem);
    }

    private void d() {
        MenuGroupForm menuGroupForm = new MenuGroupForm();
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog(POSUtil.getFocusedWindow(), (BeanEditor)menuGroupForm);
        beanEditorDialog.open();
        if (!beanEditorDialog.isCanceled()) {
            MenuGroup menuGroup = (MenuGroup)menuGroupForm.getBean();
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.t.getModel();
            comboBoxModel.addElement(menuGroup);
            comboBoxModel.setSelectedItem(menuGroup);
        }
    }

    public void initGeneralTab() {
        int n = PosUIManager.getSize(200);
        this.g.setText(Messages.getString("Service.Name"));
        this.g.setHorizontalAlignment(11);
        this.h.setHorizontalAlignment(11);
        this.h.setText(Messages.getString("Service.Price") + " (" + CurrencyUtil.getCurrencySymbol() + ")");
        this.i.setHorizontalAlignment(11);
        this.i.setText(Messages.getString("MenuItemForm.81"));
        this.n.setHorizontalAlignment(4);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow]", ""));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("hidemode 3, fillx", "[][grow]", ""));
        Dimension dimension = PosUIManager.getSize(280, 450);
        jPanel.setPreferredSize(dimension);
        jPanel2.setPreferredSize(dimension);
        this.j.setLayout(new GridLayout(1, 2, 40, 5));
        jPanel.add((Component)this.g, "right");
        jPanel.add((Component)this.l, "grow, wrap");
        jPanel.add((Component)new JLabel(Messages.getString("Service.Group")), "right");
        jPanel.add(this.t, "split 2, w " + n);
        jPanel.add((Component)this.r, "wrap");
        jPanel.add((Component)new JLabel(Messages.getString("Service.Type")), "right");
        jPanel.add((Component)this.b, "wrap,w " + n);
        jPanel.add((Component)new JLabel(Messages.getString("Service.PaymentType")), "right");
        jPanel.add((Component)this.c, "wrap,w " + n);
        jPanel.add((Component)this.p, "right");
        jPanel.add((Component)this.q, "wrap, w " + n);
        jPanel.add((Component)this.h, "right");
        jPanel.add((Component)this.n, "wrap");
        jPanel.add((Component)this.e, "skip 1,wrap");
        jPanel.add((Component)this.f, "skip 1,wrap");
        this.f.setText(POSConstants.ACTIVE);
        this.f.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.f.setMargin(new Insets(0, 0, 0, 0));
        this.e.setText(Messages.getString("CustomerRequired"));
        this.e.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.e.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add((Component)this.i, "right");
        jPanel2.add((Component)this.d, "wrap, w " + n + "!");
        JLabel jLabel = new JLabel(Messages.getString("MenuItemForm.104"));
        jLabel.setVerticalAlignment(1);
        jLabel.setHorizontalAlignment(11);
        this.o.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.o, 20, 30);
        jPanel2.add((Component)jLabel, "align right, grow");
        jPanel2.add((Component)jScrollPane, "h 25%,grow,wrap");
        this.j.add((Component)jPanel, "grow,wrap");
        this.j.add((Component)jPanel2, "grow,wrap");
        JScrollPane jScrollPane2 = new JScrollPane(this.j, 20, 30);
        jScrollPane2.setBorder(null);
        this.k.addTab(POSConstants.GENERAL, jScrollPane2);
        Dimension dimension2 = PosUIManager.getSize(700, 470);
        this.k.setPreferredSize(dimension2);
        this.add(this.k);
        this.r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceForm.this.d();
            }
        });
        this.l.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ServiceForm.this.a.setName(ServiceForm.this.l.getText());
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
    }

    public void initBtnstyleTab() {
        this.u = new ButtonStylePanel();
        this.k.addTab("Style", this.u);
    }

    @Override
    public void refresh() {
        MenuItem menuItem = MenuItemDAO.getInstance().getInitialized(this.a.getId());
        this.setBean(menuItem, false);
    }
}

