/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.util;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.jpeg.segments.App14Segment;

public class JpegReader {
    public static final int COLOR_TYPE_RGB = 1;
    public static final int COLOR_TYPE_CMYK = 2;
    public static final int COLOR_TYPE_YCCK = 3;
    private static int a = 1;
    private static boolean b = false;

    public static BufferedImage readImage(File file) throws IOException, ImageReadException {
        block16: {
            a = 1;
            b = false;
            try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);){
                BufferedImage bufferedImage;
                Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                if (!iterator.hasNext()) break block16;
                ImageReader imageReader = iterator.next();
                imageReader.setInput(imageInputStream);
                try {
                    bufferedImage = imageReader.read(0);
                }
                catch (IIOException iIOException) {
                    bufferedImage = JpegReader.a(file, imageReader);
                }
                BufferedImage bufferedImage2 = bufferedImage;
                return bufferedImage2;
            }
        }
        return null;
    }

    private static BufferedImage a(File file, ImageReader imageReader) throws IOException, ImageReadException {
        a = 2;
        JpegReader.checkAdobeMarker(file);
        ICC_Profile iCC_Profile = Imaging.getICCProfile((File)file);
        WritableRaster writableRaster = (WritableRaster)imageReader.readRaster(0, null);
        if (a == 3) {
            JpegReader.convertYcckToCmyk(writableRaster);
        }
        if (b) {
            JpegReader.convertInvertedColors(writableRaster);
        }
        BufferedImage bufferedImage = JpegReader.convertCmykToRgb(writableRaster, iCC_Profile);
        return bufferedImage;
    }

    public static void checkAdobeMarker(File file) throws IOException, ImageReadException {
        App14Segment app14Segment;
        byte[] byArray;
        JpegImageParser jpegImageParser = new JpegImageParser();
        ByteSourceFile byteSourceFile = new ByteSourceFile(file);
        ArrayList arrayList = (ArrayList)jpegImageParser.readSegments((ByteSource)byteSourceFile, new int[]{65518}, true);
        if (arrayList != null && arrayList.size() >= 1 && (byArray = (app14Segment = (App14Segment)arrayList.get(0)).getSegmentData()).length >= 12 && byArray[0] == 65 && byArray[1] == 100 && byArray[2] == 111 && byArray[3] == 98 && byArray[4] == 101) {
            b = true;
            int n = byArray[11] & 0xFF;
            if (n == 2) {
                a = 3;
            }
        }
    }

    public static void convertYcckToCmyk(WritableRaster writableRaster) {
        int n = writableRaster.getHeight();
        int n2 = writableRaster.getWidth();
        int n3 = n2 * 4;
        int[] nArray = new int[n3];
        for (int i = 0; i < n; ++i) {
            writableRaster.getPixels(0, i, n2, 1, nArray);
            for (int j = 0; j < n3; j += 4) {
                int n4 = nArray[j];
                int n5 = nArray[j + 1];
                int n6 = nArray[j + 2];
                int n7 = (int)((double)n4 + 1.402 * (double)n6 - 178.956);
                int n8 = (int)((double)n4 - 0.34414 * (double)n5 - 0.71414 * (double)n6 + 135.95984);
                n4 = (int)((double)n4 + 1.772 * (double)n5 - 226.316);
                if (n7 < 0) {
                    n7 = 0;
                } else if (n7 > 255) {
                    n7 = 255;
                }
                if (n8 < 0) {
                    n8 = 0;
                } else if (n8 > 255) {
                    n8 = 255;
                }
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > 255) {
                    n4 = 255;
                }
                nArray[j] = 255 - n7;
                nArray[j + 1] = 255 - n8;
                nArray[j + 2] = 255 - n4;
            }
            writableRaster.setPixels(0, i, n2, 1, nArray);
        }
    }

    public static void convertInvertedColors(WritableRaster writableRaster) {
        int n = writableRaster.getHeight();
        int n2 = writableRaster.getWidth();
        int n3 = n2 * 4;
        int[] nArray = new int[n3];
        for (int i = 0; i < n; ++i) {
            writableRaster.getPixels(0, i, n2, 1, nArray);
            for (int j = 0; j < n3; ++j) {
                nArray[j] = 255 - nArray[j];
            }
            writableRaster.setPixels(0, i, n2, 1, nArray);
        }
    }

    public static BufferedImage convertCmykToRgb(Raster raster, ICC_Profile iCC_Profile) throws IOException {
        Object object;
        if (iCC_Profile == null) {
            object = "/ISOcoated_v2_300_eci.icc";
            iCC_Profile = ICC_Profile.getInstance(JpegReader.class.getResourceAsStream((String)object));
        }
        if (iCC_Profile.getProfileClass() != 1 && (object = (Object)iCC_Profile.getData())[64] == false) {
            JpegReader.a(1835955314, (byte[])object, 12);
            iCC_Profile = ICC_Profile.getInstance((byte[])object);
        }
        object = new ICC_ColorSpace(iCC_Profile);
        BufferedImage bufferedImage = new BufferedImage(raster.getWidth(), raster.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorSpace colorSpace = bufferedImage.getColorModel().getColorSpace();
        ColorConvertOp colorConvertOp = new ColorConvertOp((ColorSpace)object, colorSpace, null);
        colorConvertOp.filter(raster, writableRaster);
        return bufferedImage;
    }

    static void a(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 3] = (byte)n;
    }
}

