/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.model.Currency;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.util.OrgJsonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class CurrencyUtil {
    public static Currency getMainCurrency() {
        return DataProvider.get().getMainCurrency();
    }

    public static List<Currency> getAllCurrency() {
        return DataProvider.get().getCurrencies();
    }

    public static String getCurrencyName() {
        return CurrencyUtil.getMainCurrency().getName();
    }

    public static String getCurrencySymbol() {
        Currency currency = CurrencyUtil.getMainCurrency();
        if (currency == null) {
            return "";
        }
        return currency.getSymbol();
    }

    public static Currency getCurrencyById(String string) {
        List<Currency> list = CurrencyUtil.getAllCurrency();
        for (Currency currency : list) {
            if (!currency.getId().equals(string)) continue;
            return currency;
        }
        return null;
    }

    public static String getCurrencySymbolWithBracket() {
        return " (" + CurrencyUtil.getCurrencySymbol() + ")";
    }

    public static List<Currency> getAllPreFillCurrencies() {
        Set set = com.ibm.icu.util.Currency.getAvailableCurrencies();
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (com.ibm.icu.util.Currency currency : set) {
            Currency currency2 = new Currency();
            currency2.setName(currency.getDisplayName());
            currency2.setCode(currency.getCurrencyCode());
            String string = currency.getSymbol();
            currency2.setSymbol(string);
            arrayList.add(currency2);
        }
        Collections.sort(arrayList, new Comparator<Currency>(){

            @Override
            public int compare(Currency currency, Currency currency2) {
                return currency.getName().compareTo(currency2.getName());
            }
        });
        return arrayList;
    }

    public static List<MultiCurrencyTenderDialog.PaymentByCurrency> createPaymentByCurrencies(String string) {
        ArrayList<MultiCurrencyTenderDialog.PaymentByCurrency> arrayList = new ArrayList<MultiCurrencyTenderDialog.PaymentByCurrency>();
        JSONArray jSONArray = new JSONArray(string);
        for (Object e : jSONArray) {
            JSONObject jSONObject = (JSONObject)e;
            String string2 = OrgJsonUtil.getString(jSONObject, "currency.id");
            double d = OrgJsonUtil.getDouble(jSONObject, "currency.tendered");
            double d2 = OrgJsonUtil.getDouble(jSONObject, "currency.change");
            double d3 = OrgJsonUtil.getDouble(jSONObject, "currency.paidAmount");
            MultiCurrencyTenderDialog.PaymentByCurrency paymentByCurrency = new MultiCurrencyTenderDialog.PaymentByCurrency();
            paymentByCurrency.tenderedAmount = d;
            paymentByCurrency.cashBackAmount = d2;
            paymentByCurrency.paidAmount = d3;
            paymentByCurrency.currency = CurrencyUtil.getCurrencyById(string2);
            if (paymentByCurrency.currency == null) {
                paymentByCurrency.currency = new Currency(string2);
                paymentByCurrency.currency.setName(OrgJsonUtil.getString(jSONObject, "currency.name"));
                paymentByCurrency.currency.setCode(OrgJsonUtil.getString(jSONObject, "currency.code"));
                paymentByCurrency.currency.setSymbol(OrgJsonUtil.getString(jSONObject, "currency.symbol"));
                paymentByCurrency.currency.setExchangeRate(OrgJsonUtil.getDouble(jSONObject, "currency.rate"));
            }
            arrayList.add(paymentByCurrency);
        }
        return arrayList;
    }
}

