/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.db.update.UpdateDBTo101;
import com.floreantpos.db.update.UpdateDBTo104;
import com.floreantpos.db.update.UpdateDBTo122;
import com.floreantpos.db.update.UpdateDBTo129;
import com.floreantpos.db.update.UpdateDBTo135;
import com.floreantpos.db.update.UpdateDBTo151;
import com.floreantpos.db.update.UpdateDBTo160;
import com.floreantpos.db.update.UpdateDBTo165;
import com.floreantpos.db.update.UpdateDBTo171;
import com.floreantpos.db.update.UpdateDBTo185;
import com.floreantpos.db.update.UpdateDBTo188;
import com.floreantpos.db.update.UpdateDBTo194;
import com.floreantpos.db.update.UpdateDBTo207;
import com.floreantpos.db.update.UpdateDBTo209;
import com.floreantpos.db.update.UpdateDBTo210;
import com.floreantpos.db.update.UpdateDBTo213;
import com.floreantpos.db.update.UpdateDBTo228;
import com.floreantpos.db.update.UpdateDBTo239;
import com.floreantpos.db.update.UpdateDBTo252;
import com.floreantpos.db.update.UpdateDBTo254;
import com.floreantpos.db.update.UpdateDBTo262;
import com.floreantpos.db.update.UpdateDBTo263;
import com.floreantpos.db.update.UpdateDBTo265;
import com.floreantpos.db.update.UpdateDBTo268;
import com.floreantpos.db.update.UpdateDBTo271;
import com.floreantpos.db.update.UpdateDBTo277;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.util.DashboardUtil;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DefaultDataInserter;
import com.floreantpos.util.datamigrate.DbConnectionInfo;
import com.floreantpos.versioning.VersionInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;

public class DatabaseUtil {
    public static final Integer DATABASE_VERSION = 280;
    public static final String FK_NAME = "FK_NAME";
    public static final String FKTABLE_NAME = "FKTABLE_NAME";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String TYPE_NAME = "TYPE_NAME";
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String TABLE = "TABLE";
    private static Log a = LogFactory.getLog(DatabaseUtil.class);

    public static void checkConnection(String string, String string2, String string3, String string4, String string5) throws DatabaseConnectionException {
        try {
            Class.forName(string3);
            DriverManager.getConnection(string, string4, string5);
        }
        catch (Exception exception) {
            throw new DatabaseConnectionException(Messages.getString("DatabaseUtil.0") + exception.getMessage());
        }
    }

    public static void initialize() throws DatabaseConnectionException {
        _RootDAO.initialize();
    }

    public static void initialize(String string) throws DatabaseConnectionException {
        _RootDAO.initialize(string);
    }

    public static void initialize(String string, String string2, String string3, String string4, String string5, String string6) {
        _RootDAO.initialize(string, string2, string3, string4, string5, string6);
    }

    public static void initialize(String string, Map<String, String> map) {
        _RootDAO.initialize(string, map);
    }

    public static void initialize(Map<String, String> map) {
        _RootDAO.initialize(map);
    }

    public static boolean createDatabase(String string, String string2, String string3, String string4, String string5, boolean bl) {
        return DatabaseUtil.createDatabase(Application.getInstance().getHibernateConfigurationFileName(), string, string2, string3, string4, string5, bl, false);
    }

    public static boolean createDatabase(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) {
        return DatabaseUtil.createDatabase(Application.getInstance().getHibernateConfigurationFileName(), string, string2, string3, string4, string5, bl, bl2);
    }

    public static boolean createDatabase(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        try {
            _RootDAO.releaseConnection();
            StandardServiceRegistryBuilder standardServiceRegistryBuilder = new StandardServiceRegistryBuilder().configure(string);
            standardServiceRegistryBuilder.applySetting("hibernate.dialect", (Object)string3);
            standardServiceRegistryBuilder.applySetting("hibernate.connection.driver_class", (Object)string4);
            standardServiceRegistryBuilder.applySetting("hibernate.connection.url", (Object)string2);
            standardServiceRegistryBuilder.applySetting("hibernate.connection.username", (Object)string5);
            standardServiceRegistryBuilder.applySetting("hibernate.connection.password", (Object)string6);
            standardServiceRegistryBuilder.applySetting("hibernate.hbm2ddl.auto", (Object)"create");
            standardServiceRegistryBuilder.applySetting("hibernate.c3p0.checkoutTimeout", (Object)"0");
            standardServiceRegistryBuilder.applySetting("hibernate.cache.use_second_level_cache", (Object)"false");
            StandardServiceRegistry standardServiceRegistry = standardServiceRegistryBuilder.build();
            Metadata metadata = new MetadataSources((ServiceRegistry)standardServiceRegistry).getMetadataBuilder().build();
            SchemaExport schemaExport = new SchemaExport();
            EnumSet<TargetType> enumSet = EnumSet.of(TargetType.DATABASE);
            schemaExport.create(enumSet, metadata);
            _RootDAO.setSessionFactory(metadata.buildSessionFactory());
            DefaultDataInserter defaultDataInserter = new DefaultDataInserter();
            defaultDataInserter.insertDefaultData(280, false);
            if (!bl) {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
                return true;
            }
            if (bl2) {
                defaultDataInserter.createSampleTestData();
            } else {
                defaultDataInserter.createSampleData(false);
            }
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
            return true;
        }
        catch (Exception exception) {
            PosLog.error(DatabaseUtil.class, exception);
            a.error((Object)exception);
            return false;
        }
    }

    public static void updateLegacyDatabase() {
    }

    public static boolean updateDatabase(String string, String string2, String string3, String string4, String string5) {
        return DatabaseUtil.updateDatabase(Application.getInstance().getHibernateConfigurationFileName(), string, string2, string3, string4, string5);
    }

    public static boolean updateDatabase(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            Object object;
            Integer n;
            _RootDAO.releaseConnection();
            StandardServiceRegistry standardServiceRegistry = DatabaseUtil.a(string, string2, string3, string4, string5, string6);
            Metadata metadata = new MetadataSources((ServiceRegistry)standardServiceRegistry).getMetadataBuilder().build();
            SchemaUpdate schemaUpdate = new SchemaUpdate();
            EnumSet<TargetType> enumSet = EnumSet.of(TargetType.DATABASE, TargetType.STDOUT);
            schemaUpdate.execute(enumSet, metadata);
            SessionFactory sessionFactory = metadata.buildSessionFactory();
            _RootDAO.setSessionFactory(sessionFactory);
            Store store = StoreDAO.getRestaurant();
            Integer n2 = n = store == null ? null : store.getDatabaseVersion();
            if (n == null || n < 135) {
                object = new UpdateDBTo135(sessionFactory);
                ((UpdateDBTo135)object).update();
            }
            if (n == null || n < 101) {
                object = new UpdateDBTo101(string2, string5, string6, sessionFactory);
                ((UpdateDBTo101)object).update();
            }
            if (n == null || n < 104) {
                PosLog.debug(DashboardUtil.class, "updating db to 104");
                object = new UpdateDBTo104();
                ((UpdateDBTo104)object).update();
            }
            if (n == null || n < 122) {
                PosLog.debug(DashboardUtil.class, "updating db to 122");
                object = new UpdateDBTo122();
                ((UpdateDBTo122)object).update();
            }
            if (n == null || n < 129) {
                PosLog.debug(DashboardUtil.class, "updating db to 129");
                object = new UpdateDBTo129();
                ((UpdateDBTo129)object).update();
            }
            if (n == null || n < 151) {
                PosLog.debug(DashboardUtil.class, "updating db to 151");
                object = new UpdateDBTo151();
                ((UpdateDBTo151)object).update();
            }
            if (n == null || n < 160) {
                PosLog.debug(DashboardUtil.class, "updating db to 160");
                object = new UpdateDBTo160(sessionFactory);
                ((UpdateDBTo160)object).update();
            }
            if (n == null || n < 165) {
                PosLog.debug(DashboardUtil.class, "updating db to 165");
                object = new UpdateDBTo165();
                ((UpdateDBTo165)object).update(sessionFactory);
            }
            if (n == null || n < 171) {
                PosLog.debug(DashboardUtil.class, "updating db to 171");
                object = new UpdateDBTo171(sessionFactory);
                ((UpdateDBTo171)object).updateTickets();
                ((UpdateDBTo171)object).updateTransactions();
            }
            if (n == null || n < 185) {
                PosLog.debug(DashboardUtil.class, "updating db to 185");
                object = new UpdateDBTo185();
                ((UpdateDBTo185)object).update();
            }
            if (n == null || n < 188) {
                PosLog.debug(DashboardUtil.class, "updating db to 188");
                object = new UpdateDBTo188(schemaUpdate, enumSet, metadata, string3, sessionFactory, string5);
                ((UpdateDBTo188)object).update();
            }
            if (n == null || n < 195) {
                PosLog.debug(DashboardUtil.class, "updating db to 195");
                object = new UpdateDBTo194();
                ((UpdateDBTo194)object).update();
            }
            if (n == null || n < 208) {
                PosLog.debug(DashboardUtil.class, "updating db to 208");
                object = new UpdateDBTo207(string2, string5, string6);
                ((UpdateDBTo207)object).update();
            }
            if (n == null || n < 209) {
                PosLog.debug(DashboardUtil.class, "updating db to 209");
                object = new UpdateDBTo209(string2, string5, string6);
                ((UpdateDBTo209)object).update();
            }
            if (n == null || n < 210) {
                PosLog.debug(DashboardUtil.class, "updating db to 210");
                object = new UpdateDBTo210(string2, string5, string6);
                ((UpdateDBTo210)object).update();
            }
            if (n == null || n < 213) {
                PosLog.debug(DashboardUtil.class, "updating db to 213");
                object = new UpdateDBTo213();
                ((UpdateDBTo213)object).update();
            }
            if (n == null || n < 228) {
                PosLog.debug(DashboardUtil.class, "updating db to 228");
                object = new UpdateDBTo228();
                ((UpdateDBTo228)object).update();
            }
            if (n == null || n < 239) {
                PosLog.debug(DashboardUtil.class, "updating db to 239");
                object = new UpdateDBTo239(sessionFactory);
                ((UpdateDBTo239)object).update();
            }
            if (n == null || n < 252) {
                PosLog.debug(DashboardUtil.class, "updating db to 252");
                object = new UpdateDBTo252(string2, string5, string6);
                ((UpdateDBTo252)object).update();
            }
            if (n == null || n < 254) {
                PosLog.debug(DashboardUtil.class, "updating db to 254");
                object = new UpdateDBTo254();
                ((UpdateDBTo254)object).update();
            }
            if (n == null || n < 262) {
                PosLog.debug(DashboardUtil.class, "updating db to 262");
                object = new UpdateDBTo262(sessionFactory);
                ((UpdateDBTo262)object).update();
            }
            if (n == null || n < 263) {
                PosLog.debug(DashboardUtil.class, "updating db to 263");
                object = new UpdateDBTo263(string2, string5, string6);
                ((UpdateDBTo263)object).update();
            }
            if (n == null || n < 265) {
                PosLog.debug(DashboardUtil.class, "updating db to 265");
                object = new UpdateDBTo265(string2, string5, string6);
                ((UpdateDBTo265)object).update();
            }
            if (n == null || n < 268) {
                PosLog.debug(DashboardUtil.class, "updating db to 268");
                object = new UpdateDBTo268(sessionFactory);
                ((UpdateDBTo268)object).update();
            }
            if (n == null || n < 271) {
                PosLog.debug(DashboardUtil.class, "updating db to 271");
                object = new UpdateDBTo271(sessionFactory);
                ((UpdateDBTo271)object).update();
            }
            if (n == null || n < 277) {
                PosLog.debug(DashboardUtil.class, "updating db to 277");
                object = new UpdateDBTo277(sessionFactory);
                ((UpdateDBTo277)object).update();
            }
            if ((store = StoreDAO.getRestaurant()) != null) {
                store.setDatabaseVersion(280);
                store.setSoftwareVersion(VersionInfo.getVersion());
                store.setSoftwareNumericVersion(VersionInfo.getNumericVersion());
                StoreDAO.getInstance().update(store);
            } else {
                DefaultDataInserter.createStore(280);
            }
            sessionFactory.close();
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
            return true;
        }
        catch (Exception exception) {
            PosLog.error(DatabaseUtil.class, exception);
            a.error((Object)exception);
            return false;
        }
    }

    public static void updateSchema(String string, String string2, String string3, String string4, String string5) {
        String string6 = Application.getInstance().getHibernateConfigurationFileName();
        StandardServiceRegistry standardServiceRegistry = DatabaseUtil.a(string6, string, string2, string3, string4, string5);
        Metadata metadata = new MetadataSources((ServiceRegistry)standardServiceRegistry).getMetadataBuilder().build();
        SchemaUpdate schemaUpdate = new SchemaUpdate();
        EnumSet<TargetType> enumSet = EnumSet.of(TargetType.DATABASE, TargetType.STDOUT);
        schemaUpdate.execute(enumSet, metadata);
    }

    private static StandardServiceRegistry a(String string, String string2, String string3, String string4, String string5, String string6) {
        StandardServiceRegistryBuilder standardServiceRegistryBuilder = new StandardServiceRegistryBuilder().configure(string);
        standardServiceRegistryBuilder.applySetting("hibernate.dialect", (Object)string3);
        standardServiceRegistryBuilder.applySetting("hibernate.connection.driver_class", (Object)string4);
        standardServiceRegistryBuilder.applySetting("hibernate.connection.url", (Object)string2);
        standardServiceRegistryBuilder.applySetting("hibernate.connection.username", (Object)string5);
        standardServiceRegistryBuilder.applySetting("hibernate.connection.password", (Object)string6);
        standardServiceRegistryBuilder.applySetting("hibernate.max_fetch_depth", (Object)"3");
        standardServiceRegistryBuilder.applySetting("hibernate.connection.isolation", (Object)String.valueOf(1));
        standardServiceRegistryBuilder.applySetting("hibernate.cache.use_second_level_cache", (Object)"false");
        return standardServiceRegistryBuilder.build();
    }

    public static boolean isDbUpdateNeeded() {
        try {
            Store store = StoreDAO.getRestaurant();
            if (store == null) {
                throw new PosException(Messages.getString("DatabaseUtil.3") + Messages.getString("DatabaseUtil.4"));
            }
            Integer n = store.getDatabaseVersion();
            return n == null || n < 280;
        }
        catch (SQLGrammarException sQLGrammarException) {
            Pattern pattern;
            boolean bl;
            String string;
            Throwable throwable = sQLGrammarException.getCause();
            if (throwable != null && (string = throwable.getMessage()) != null && (bl = (pattern = Pattern.compile("Column .* is either not in any table")).matcher(string).find())) {
                return true;
            }
            a.error((Object)sQLGrammarException);
            return false;
        }
    }

    public static boolean isDbUpdateNeeded(Integer n) {
        return n == null || n < 280;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getStoreProperties(String string, String string2, String string3, String string4) throws Exception {
        Class.forName(string2);
        try (Connection connection = null;){
            Object object;
            String string5 = Messages.getString("DatabaseUtil.6");
            string5 = String.format(string5, VersionInfo.getAppName());
            connection = DriverManager.getConnection(string, string3, string4);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string6 = DatabaseUtil.getActualTableName(databaseMetaData, "store_properties");
            if (string6 == null) {
                throw new PosException(string5);
            }
            String string7 = DatabaseUtil.getActualColumnName(databaseMetaData, string6, "property_name");
            String string8 = DatabaseUtil.getActualColumnName(databaseMetaData, string6, "property_value");
            if (string7 == null || string8 == null) {
                throw new PosException(string5);
            }
            String string9 = String.format("select * from %s", string6);
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string9);
            while (resultSet.next()) {
                object = resultSet.getString(string7);
                String string10 = resultSet.getString(string8);
                hashMap.put(object, string10);
            }
            resultSet.close();
            statement.close();
            object = hashMap;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTable(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        try (ResultSet resultSet = null;){
            resultSet = databaseMetaData.getTables(null, null, null, new String[]{TABLE});
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                String string2 = resultSet.getString(TABLE_NAME);
                arrayList.add(string2.toLowerCase());
            }
            if (arrayList.contains(string.toLowerCase())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActualTableName(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        try (ResultSet resultSet = null;){
            String string2;
            resultSet = databaseMetaData.getTables(null, null, null, new String[]{TABLE});
            while (resultSet.next()) {
                string2 = resultSet.getString(TABLE_NAME);
                if (!string2.equalsIgnoreCase(string)) continue;
                String string3 = string2;
                return string3;
            }
            string2 = null;
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActualColumnName(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        try (ResultSet resultSet = null;){
            String string3;
            resultSet = databaseMetaData.getColumns(null, null, string, null);
            while (resultSet.next()) {
                string3 = resultSet.getString(COLUMN_NAME);
                if (!string3.equalsIgnoreCase(string2)) continue;
                String string4 = string3;
                return string4;
            }
            string3 = null;
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConstrainsFromDestDB(DbConnectionInfo dbConnectionInfo) throws Exception {
        try (Connection connection = null;){
            dbConnectionInfo.openConnection();
            connection = dbConnectionInfo.getConnection();
            connection.setAutoCommit(false);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = dbConnectionInfo.getSelectedDatabase().getHibernateDialect();
            Dialect dialect = (Dialect)Class.forName(string).newInstance();
            String string2 = dialect.getDropForeignKeyString();
            String string3 = dialect.getSchemaNameResolver().resolveSchemaName(connection, dialect);
            Statement statement = connection.createStatement();
            ResultSet resultSet = databaseMetaData.getTables(null, string3, null, new String[]{TABLE});
            while (resultSet.next()) {
                Object object;
                Object object2;
                String string4 = resultSet.getString(TABLE_NAME);
                ResultSet resultSet2 = databaseMetaData.getImportedKeys(null, string3, string4);
                while (resultSet2.next()) {
                    object2 = "alter table " + string4 + string2 + resultSet2.getString(FK_NAME);
                    statement.execute((String)object2);
                }
                resultSet2.close();
                resultSet2 = databaseMetaData.getExportedKeys(null, string3, string4);
                while (resultSet2.next()) {
                    object2 = "alter table " + resultSet2.getString(FKTABLE_NAME) + string2 + resultSet2.getString(FK_NAME);
                    statement.execute((String)object2);
                }
                resultSet2.close();
                object2 = new ArrayList();
                ResultSet resultSet3 = databaseMetaData.getColumns(null, string3, string4, null);
                ResultSet resultSet4 = databaseMetaData.getPrimaryKeys(null, string3, string4);
                while (resultSet4.next()) {
                    object = resultSet4.getString(COLUMN_NAME);
                    ((ArrayList)object2).add(object);
                }
                object = resultSet3.getMetaData();
                int n = 1;
                while (resultSet3.next()) {
                    int n2;
                    String string5 = resultSet3.getString(COLUMN_NAME);
                    if (n < object.getColumnCount() && (n2 = object.isNullable(n)) == 0 && !((ArrayList)object2).contains(string5)) {
                        String string6 = "ALTER TABLE " + string4 + " ALTER COLUMN " + string5 + " null";
                        statement.execute(string6);
                    }
                    ++n;
                }
                resultSet3.close();
                resultSet4.close();
            }
            resultSet.close();
            System.out.println("=======================");
            statement.close();
            connection.commit();
        }
    }

    public static void restoreDbConstraints(DbConnectionInfo dbConnectionInfo) {
        Database database = dbConnectionInfo.getSelectedDatabase();
        DatabaseUtil.updateDatabase(dbConnectionInfo.getConnectionString(), database.getHibernateDialect(), database.getHibernateConnectionDriverClass(), dbConnectionInfo.getUserName(), dbConnectionInfo.getPassword());
    }
}

