/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static String IMAGE_FORMAT_PNG = "png";

    public static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bufferedImage, IMAGE_FORMAT_PNG, byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static BufferedImage doScaleImageWithRatio(BufferedImage bufferedImage, boolean bl, int n, int n2) throws IOException {
        if (bl) {
            if (n > n2) {
                n2 = n2 * (n -= 200) / n;
            } else {
                n = n * (n2 -= 200) / n2;
            }
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        byte[] byArray = ImageUtil.convertImageToByteArray(bufferedImage2);
        if (byArray.length / 1024 > 1000) {
            bufferedImage2 = null;
            byArray = null;
            return ImageUtil.doScaleImageWithRatio(bufferedImage, true, n, n2);
        }
        return bufferedImage2;
    }
}

