/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.Course;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.base.BaseCourse;
import com.floreantpos.model.base.BaseModifiableTicketItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.base.BaseTicketItemCookingInstruction;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.NumericGlobalIdGenerator;
import com.floreantpos.util.ShiftUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class PreviewTicketUtil {
    public static Ticket createPreviewTicket(OrderType orderType, String string) {
        Object object;
        Cloneable cloneable;
        SalesArea salesArea;
        int n = 4;
        Date date = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Double d = 0.0;
        Customer customer = new Customer();
        customer.setFirstName("Firstname");
        customer.setLastName("Lastname");
        customer.setMobileNo("+02............");
        customer.setZipCode("565656");
        customer.setMemberId(Messages.getString("ReceiptConfigurationView.97"));
        customer.setSignatureImageId(Messages.getString("ReceiptConfigurationView.98"));
        customer.setLoyaltyPoint(100);
        if (orderType.isDelivery().booleanValue()) {
            date = new Date();
            string2 = "Customer address.....";
            string3 = Messages.getString("ReceiptConfigurationView.70");
            string4 = "Phone extension..";
            string5 = "Manager instructions..";
            bl = false;
            d = 0.0;
        }
        Application application = Application.getInstance();
        Ticket ticket = new Ticket(true);
        ticket.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticket.setOrderType(orderType);
        ticket.setNote(Messages.getString("ReceiptConfigurationView.4"));
        ticket.setNumberOfGuests(n);
        ticket.addExtraProperty("ticket.sub_order_type", POSConstants.FOR_HERE_TO_GO_BUTTON_TEXT);
        ticket.addProperty("reciprocal_member.note", Messages.getString("ReceiptConfigurationView.5"));
        if (bl) {
            ticket.setCustomerWillPickup(true);
        } else {
            ticket.setDeliveryDate(date);
            ticket.setDeliveryAddress(string2);
            ticket.setExtraDeliveryInfo(string3);
            ticket.addProperty("PHONE_EXTENSION", string4);
            ticket.addProperty("MANAGER_INSTRUCTION", string5);
            ticket.setDeliveryCharge(d);
            ticket.setCustomerWillPickup(false);
        }
        if (customer != null) {
            ticket.setCustomer(customer);
        }
        Terminal terminal = application.getTerminal();
        ticket.setTerminal(terminal);
        Department department = terminal.getDepartment();
        if (department != null) {
            ticket.setDepartmentId(department.getId());
        }
        if ((salesArea = terminal.getSalesArea()) != null) {
            ticket.setSalesAreaId(salesArea.getId());
        }
        User user = Application.getCurrentUser();
        ticket.setOwner(user);
        ticket.setShift(ShiftUtil.getCurrentShift());
        if (orderType.isShowTableSelection().booleanValue()) {
            cloneable = new ArrayList();
            cloneable.add(1);
            cloneable.add(2);
            ticket.setTableNumbers((List<Integer>)((Object)cloneable));
        }
        cloneable = DateUtil.getServerTimeCalendar();
        ticket.setCreateDate(((Calendar)cloneable).getTime());
        ticket.setCreationHour(((Calendar)cloneable).get(11));
        ticket.addProperty("printCount", String.valueOf(1));
        ticket.addProperty("previewTicket", String.valueOf(Boolean.TRUE));
        ticket.setId(NumericGlobalIdGenerator.generateGlobalId());
        ticket.setTokenNo(1);
        TicketItemTax ticketItemTax = new TicketItemTax();
        ticketItemTax.setId(GlobalIdGenerator.generateGlobalId());
        ticketItemTax.setName(Messages.getString("ReceiptConfigurationView.99"));
        ticketItemTax.setRate(6.0);
        TicketItemTax ticketItemTax2 = new TicketItemTax();
        ticketItemTax2.setId(GlobalIdGenerator.generateGlobalId());
        ticketItemTax2.setName(Messages.getString("ReceiptConfigurationView.100"));
        ticketItemTax2.setRate(15.0);
        for (int i = 0; i < 5; ++i) {
            Comparable comparable;
            Comparable comparable2;
            object = new PreviewTicketItem();
            ((BaseTicketItem)object).setId(NumericGlobalIdGenerator.generateGlobalId());
            ((BaseTicketItem)object).setMenuItemId("0");
            ((BaseTicketItem)object).setName("Item " + (i + 1));
            ((BaseTicketItem)object).setQuantity((double)i + 1.0);
            ((BaseTicketItem)object).setUnitPrice(2.5);
            ((BaseTicketItem)object).setShouldPrintToKitchen(true);
            ((TicketItem)object).setTaxes(Arrays.asList(ticketItemTax, ticketItemTax2));
            if (orderType.isEnableCourse().booleanValue()) {
                comparable2 = new Course(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                ((BaseCourse)comparable2).setShortName(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                ((BaseTicketItem)object).setCourseId(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                ((BaseTicketItem)object).setCourseName(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
            }
            ticket.addToticketItems((TicketItem)object);
            ((BaseTicketItem)object).setTicket(ticket);
            if (i == 1) {
                for (int j = 0; j <= 1; ++j) {
                    comparable = new TicketItemModifier();
                    ((BaseTicketItemModifier)comparable).setId(NumericGlobalIdGenerator.generateGlobalId());
                    ((BaseTicketItemModifier)comparable).setItemId("0");
                    ((BaseTicketItemModifier)comparable).setGroupId("0");
                    ((BaseTicketItemModifier)comparable).setItemQuantity(2.0);
                    ((BaseTicketItemModifier)comparable).setName("Modifier " + (j + 1));
                    ((BaseTicketItemModifier)comparable).setUnitPrice(1.5);
                    ((BaseTicketItemModifier)comparable).setShouldPrintToKitchen(true);
                    ((BaseTicketItemModifier)comparable).setTicketItem((TicketItem)object);
                    ((BaseModifiableTicketItem)object).addToticketItemModifiers((TicketItemModifier)comparable);
                }
            } else if (i == 2) {
                comparable2 = new TicketItemCookingInstruction();
                ((BaseTicketItemCookingInstruction)comparable2).setDescription("Fry (Cooking Ins.)");
                ((TicketItem)object).addCookingInstruction((TicketItemCookingInstruction)comparable2);
            }
            if (i == 2) {
                TicketItem ticketItem = new TicketItem();
                comparable = new TicketItemSeat();
                ticketItem.setName("Seat** 1");
                ticketItem.setShouldPrintToKitchen(true);
                ticketItem.setTreatAsSeat(true);
                ticketItem.setSeatNumber(1);
                ticketItem.setPrintedToKitchen(false);
                ticketItem.setShouldPrintToKitchen(true);
                ticketItem.setSeat((TicketItemSeat)comparable);
                ticketItem.setTicket(ticket);
                ((BaseTicketItemSeat)comparable).setSeatNumber(1);
                ticket.addToticketItems(ticketItem);
                continue;
            }
            if (i != 3) continue;
            TicketItem ticketItem = new TicketItem();
            comparable = new TicketItemSeat();
            ticketItem.setName("Seat** Shared");
            ticketItem.setShouldPrintToKitchen(true);
            ticketItem.setTreatAsSeat(true);
            ticketItem.setSeatNumber(null);
            ticketItem.setPrintedToKitchen(false);
            ticketItem.setShouldPrintToKitchen(true);
            ticketItem.setSeat((TicketItemSeat)comparable);
            ticketItem.setTicket(ticket);
            ((BaseTicketItemSeat)comparable).setSeatNumber(1);
            ticket.addToticketItems(ticketItem);
        }
        ticket.calculatePrice();
        PosTransaction posTransaction = null;
        object = null;
        if (string != null && string.equals("creditCard")) {
            object = PaymentType.CREDIT_CARD;
            posTransaction = ((PaymentType)((Object)object)).createTransaction();
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway("Payment gateway name..");
            posTransaction.setCardReader(CardReader.MANUAL.name());
            posTransaction.setCardHolderName("Card holder name");
            posTransaction.setCardNumber("4111111111111111");
            posTransaction.setCardExpMonth("12");
            posTransaction.setCardExpYear("2020");
            posTransaction.setCardType(CardTypeEnum.VISA.name());
            posTransaction.setCardAuthCode("00000");
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            ticket.setCashier(user);
        } else {
            object = PaymentType.CASH;
            posTransaction = ((PaymentType)((Object)object)).createTransaction();
        }
        posTransaction.setTenderAmount(ticket.getDueAmount());
        posTransaction.setAmount(ticket.getDueAmount());
        posTransaction.setTicket(ticket);
        ticket.addTotransactions(posTransaction);
        ticket.setVoided(false);
        ticket.setTerminal(terminal);
        ticket.setPaidAmount(ticket.getPaidAmount() + posTransaction.getAmount());
        ticket.calculatePrice();
        Date date2 = new Date();
        if (ticket.getDueAmount() == 0.0) {
            ticket.setPaid(true);
        } else {
            ticket.setPaid(false);
            ticket.setClosed(false);
        }
        posTransaction.setTerminal(terminal);
        posTransaction.setUser(user);
        posTransaction.setServer(user);
        posTransaction.setTransactionTime(date2);
        return ticket;
    }

    public static class PreviewTicketItem
    extends ModifiableTicketItem {
        private static final long b = 1L;

        @Override
        public List<Printer> getPrinters(OrderType orderType) {
            PrinterGroup printerGroup = this.getPrinterGroup();
            ArrayList<Printer> arrayList = new ArrayList<Printer>();
            arrayList.add(VirtualPrinter.getKdsPrinter());
            PosPrinters posPrinters = DataProvider.get().getPrinters();
            arrayList.addAll(posPrinters.getStickerPrinters());
            if (printerGroup == null) {
                arrayList.addAll(posPrinters.getKitchenPrinters());
                return arrayList;
            }
            List<String> list = printerGroup.getPrinterNames();
            List<Printer> list2 = posPrinters.getKitchenPrinters();
            for (Printer printer : list2) {
                if (!list.contains(printer.getVirtualPrinter().getName())) continue;
                arrayList.add(printer);
            }
            return arrayList;
        }
    }
}

