/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Address;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.Course;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DataSyncInfo;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.DeletedData;
import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.DeliveryInstruction;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopFloorTemplate;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.base.BaseTax;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.util.ImageUtil;
import com.floreantpos.util.XMLTransientUtil;
import com.floreantpos.webservice.PosWebService;
import com.floreantpos.webservice.SyncService;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.ws.rs.core.GenericEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;

public class CloudDataUploader {
    private static final int a = 100;
    private static Logger b = Logger.getLogger(CloudDataUploader.class);
    private ProgressObserver c;
    private PosWebService d;
    private boolean e;
    private boolean f;
    private boolean g;
    private int h;
    private Date i;
    private Date j;
    private Integer k = 1;
    private Integer l = 0;
    private List<DataSyncInfo> m = new ArrayList<DataSyncInfo>();

    public CloudDataUploader(ProgressObserver progressObserver, Date date, Date date2) {
        this.c = progressObserver;
        this.d = PosWebService.get();
        this.i = date;
        this.j = date2;
    }

    public void uploadLocalSettings() throws Exception {
        this.f = true;
        this.e = true;
        this.l = 0;
        this.a(Messages.getString("SyncService.76"));
        Date date = StoreDAO.getServerTimestamp();
        this.uploadAddress();
        this.uploadStore();
        this.S();
        this.uploadCurrency();
        this.uploadTaxes();
        GenericDAO.getInstance().updateLastUpdateTimeProperty(Store.class, date);
    }

    public Integer uploadAllData(boolean bl, Integer n) throws Exception {
        this.e = bl;
        this.l = n;
        this.h = 0;
        this.k = 1;
        return this.a();
    }

    private Integer a() throws Exception {
        this.g = false;
        List<Department> list = null;
        List<OrderType> list2 = null;
        List<TerminalType> list3 = null;
        PosLog.info(this.getClass(), "  =======================Starting Upload=======================");
        if (!this.f) {
            this.S();
        }
        this.X();
        this.i();
        if (!this.f) {
            this.uploadCurrency();
        }
        this.uploadShift();
        this.z();
        this.b();
        this.B();
        list3 = this.x();
        this.y();
        if (!this.f) {
            this.uploadTaxes();
        }
        list2 = this.V();
        list = this.W();
        this.am();
        this.an();
        this.U();
        this.T();
        this.h();
        this.D();
        this.g();
        this.d();
        this.P();
        this.O();
        this.R();
        this.Q();
        this.w();
        this.v();
        this.H();
        this.I();
        this.E();
        this.C();
        this.J();
        this.K();
        this.F();
        this.G();
        this.L();
        this.M();
        this.uploadShopTablesStatus();
        this.N();
        this.uploadBookingInfos();
        this.uploadTickets();
        this.A();
        if (!this.f) {
            this.uploadAddress();
        }
        this.ap();
        this.t();
        this.s();
        this.r();
        this.q();
        this.p();
        this.o();
        this.n();
        this.l();
        this.m();
        this.k();
        this.Z();
        this.Y();
        this.aa();
        this.ab();
        this.ac();
        this.ad();
        this.ae();
        this.af();
        this.ag();
        this.ah();
        this.ai();
        this.ak();
        this.j();
        this.al();
        this.e();
        this.f();
        if (list != null && list.size() > 0) {
            this.e(list);
        }
        if (list2 != null && list2.size() > 0) {
            this.c(list2);
        }
        if (list3 != null && list3.size() > 0) {
            this.d(list3);
        }
        if (this.g) {
            GenericDAO.getInstance().updateOutletRelatedModelsIfNullExists(SyncService.getOutletRelatedModelClasses());
        }
        if (this.h == 0) {
            this.b("Nothing to upload. Everything is up to date.");
        } else {
            PosLog.info(this.getClass(), "=======================Upload Finished=======================");
        }
        return this.l;
    }

    public void uploadStore() throws Exception {
        this.a(this.l, Messages.getString("CloudDataUploader.55"));
        PosLog.info(this.getClass(), "");
        List<Store> list = StoreDAO.getInstance().findAll();
        if (list != null) {
            for (TimedModel timedModel : list) {
                timedModel.setLastUpdateTime(this.i);
            }
            this.d.uploadData((GenericEntity)new GenericEntity<List<Store>>(list){}, "store");
        }
    }

    private void b() throws Exception {
        int n = this.a(StoreSessionControl.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.57"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(StoreSessionControl.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (StoreSessionControl storeSessionControl : list) {
                arrayList.add(storeSessionControl.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<StoreSessionControl>>(list){}, "storesessioncontrol");
            this.b(dataSyncInfo, arrayList, StoreSessionControl.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void c() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(MenuPage.class, this.e, this.j);
        this.a(list, " menu page.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.53"));
            for (MenuPage menuPage : list) {
                arrayList.add(menuPage.getId());
                XMLTransientUtil.makeXMLTransient(menuPage);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<MenuPage>>(list){}, "menuPage");
            this.b(dataSyncInfo, arrayList, MenuPage.REF);
            this.b(arrayList.size());
        }
    }

    private void d() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(PizzaPrice.class, this.e, this.j);
        this.a(list, " pizza price.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.52"));
            for (PizzaPrice pizzaPrice : list) {
                arrayList.add(pizzaPrice.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<PizzaPrice>>(list){}, "pizzaPrice");
            this.b(dataSyncInfo, arrayList, PizzaPrice.REF);
            this.b(arrayList.size());
        }
    }

    private void e() throws Exception {
        int n = this.a(PriceTable.class);
        if (n <= 0) {
            return;
        }
        this.a(n, "Uploading price table");
        for (int i = 0; i < n; i += 100) {
            ArrayList<String> arrayList = new ArrayList<String>();
            GenericDAO genericDAO = GenericDAO.getInstance();
            List list = genericDAO.findAllUnSyncItem(PriceTable.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            for (PriceTable priceTable : list) {
                if (StringUtils.isBlank((String)priceTable.getOutletId())) {
                    this.g = true;
                    priceTable.setOutletId(this.ao());
                }
                priceTable.setPriceTableItems(PriceTableItemDAO.getInstance().getItemsByPriceTable(priceTable, true));
                arrayList.add(priceTable.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<PriceTable>>(list){}, "priceTable");
            this.b(dataSyncInfo, arrayList, PriceTable.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void f() throws Exception {
        int n = this.a(PriceRule.class);
        if (n <= 0) {
            return;
        }
        this.a(n, "Uploading price rule");
        for (int i = 0; i < n; i += 100) {
            ArrayList<String> arrayList = new ArrayList<String>();
            GenericDAO genericDAO = GenericDAO.getInstance();
            List list = genericDAO.findAllUnSyncItem(PriceRule.class, this.e, this.j, 100);
            this.a(list, " price rule.");
            if (list == null || list.isEmpty()) continue;
            for (PriceRule priceRule : list) {
                if (StringUtils.isBlank((String)priceRule.getOutletId())) {
                    this.g = true;
                    priceRule.setOutletId(this.ao());
                }
                arrayList.add(priceRule.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<PriceRule>>(list){}, "priceRule");
            this.b(dataSyncInfo, arrayList, PriceRule.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void g() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(PizzaCrust.class, this.e, this.j);
        this.a(list, Messages.getString("CloudDataUploader.66"));
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.51"));
            for (PizzaCrust pizzaCrust : list) {
                arrayList.add(pizzaCrust.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<PizzaCrust>>(list){}, "pizzaCrust");
            this.b(dataSyncInfo, arrayList, PizzaCrust.REF);
            this.b(arrayList.size());
        }
    }

    private void h() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Multiplier.class, this.e, this.j);
        this.a(list, Messages.getString("CloudDataUploader.48"));
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.48"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Multiplier multiplier : list) {
                arrayList.add(multiplier.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Multiplier>>(list){}, "multiplier");
            this.b(dataSyncInfo, arrayList, Multiplier.REF);
            this.b(arrayList.size());
        }
    }

    private void i() throws Exception {
        int n = 10;
        int n2 = this.a(ImageResource.class);
        if (n2 <= 0) {
            return;
        }
        this.a(n2, Messages.getString("CloudDataUploader.56"));
        for (int i = 0; i < n2; i += n) {
            ArrayList<String> arrayList = new ArrayList<String>();
            GenericDAO genericDAO = GenericDAO.getInstance();
            List list = genericDAO.findAllUnSyncItem(ImageResource.class, this.e, this.j, n);
            if (list == null || list.isEmpty()) continue;
            for (ImageResource imageResource : list) {
                this.a(imageResource);
                arrayList.add(imageResource.getId());
                imageResource.setImageData(null);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<ImageResource>>(list){}, "imageResources");
            this.b(dataSyncInfo, arrayList, ImageResource.REF);
            this.a(n2, n, i);
        }
        this.a(n2);
    }

    private void a(int n, String string) {
        this.c(string);
        this.c.subProgress("Total records: " + n);
        b.debug((Object)(string + " Total records: " + n));
        this.h += n;
    }

    private void a(int n) {
        this.b(n);
        this.c.hideSubProgressView();
    }

    private void a(int n, int n2) throws Exception {
        this.a(n, 100, n2);
    }

    private void a(int n, int n2, int n3) throws Exception {
        int n4 = (int)((double)(n2 + n3) / (double)n * 100.0);
        this.c.subProgress(n4, "Total records: " + n);
    }

    private int a(Class<?> clazz) {
        return GenericDAO.getInstance().getUnSyncItemCount(clazz, this.e, this.j);
    }

    private void a(ImageResource imageResource) {
        try {
            String string = imageResource.getProperty("imageFormat");
            if (!ImageUtil.IMAGE_FORMAT_PNG.equals(string)) {
                if (imageResource.getImageBytes() == null || imageResource.getImageBytes().length == 0) {
                    return;
                }
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageResource.getImageBytes()));
                if (bufferedImage == null) {
                    return;
                }
                byte[] byArray = ImageUtil.convertImageToByteArray(bufferedImage);
                if (byArray.length / 1024 > 1000) {
                    bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                    bufferedImage = ImageUtil.doScaleImageWithRatio(bufferedImage, true, bufferedImage.getWidth(), bufferedImage.getHeight());
                }
                imageResource.setImageData(null);
                imageResource.addProperty("imageFormat", ImageUtil.IMAGE_FORMAT_PNG);
                imageResource.setImageBytes(ImageUtil.convertImageToByteArray(bufferedImage));
                ImageResourceDAO.getInstance().update(imageResource);
            }
        }
        catch (IOException iOException) {
            PosLog.error(this.getClass(), iOException);
        }
    }

    private void j() throws Exception {
        int n = this.a(GratuityPaymentHistory.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.46"));
        for (int i = 0; i < n; i += 100) {
            ArrayList<String> arrayList = new ArrayList<String>();
            GenericDAO genericDAO = GenericDAO.getInstance();
            List list = genericDAO.findAllUnSyncItem(GratuityPaymentHistory.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            for (GratuityPaymentHistory gratuityPaymentHistory : list) {
                arrayList.add(gratuityPaymentHistory.getId());
                XMLTransientUtil.makeXMLTransient(gratuityPaymentHistory);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<GratuityPaymentHistory>>(list){}, "gratuityPaymentHistory");
            this.b(dataSyncInfo, arrayList, GratuityPaymentHistory.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void k() throws Exception {
        int n = this.a(GiftCard.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.45"));
        for (int i = 0; i < n; i += 100) {
            ArrayList<String> arrayList = new ArrayList<String>();
            List list = GenericDAO.getInstance().findAllUnSyncItem(GiftCard.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            for (GiftCard giftCard : list) {
                arrayList.add(giftCard.getCardNumber());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<GiftCard>>(list){}, "giftCard");
            this.b(dataSyncInfo, arrayList, GiftCard.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void l() throws Exception {
        int n = this.a(DeliveryInstruction.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.47"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(DeliveryInstruction.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeliveryInstruction deliveryInstruction : list) {
                arrayList.add(deliveryInstruction.getId());
                XMLTransientUtil.makeXMLTransient(deliveryInstruction.getCustomer());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<DeliveryInstruction>>(list){}, "deliveryInstruction");
            this.b(dataSyncInfo, arrayList, DeliveryInstruction.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void m() throws Exception {
        int n = this.a(Discount.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.44"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(Discount.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Discount discount : list) {
                arrayList.add(discount.getId());
                XMLTransientUtil.makeLazy(discount);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Discount>>(list){}, "discount");
            this.b(dataSyncInfo, arrayList, Discount.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void n() throws Exception {
        int n = this.a(DeliveryCharge.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.43"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(DeliveryCharge.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeliveryCharge deliveryCharge : list) {
                arrayList.add(deliveryCharge.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<DeliveryCharge>>(list){}, "deliveryCharge");
            this.b(dataSyncInfo, arrayList, DeliveryCharge.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void o() throws Exception {
        int n = this.a(DeliveryAddress.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.42"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(DeliveryAddress.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeliveryAddress deliveryAddress : list) {
                arrayList.add(deliveryAddress.getId());
                String string = deliveryAddress.getCustomerId();
                deliveryAddress.setCustomer(null);
                deliveryAddress.setCustomerId(string);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<DeliveryAddress>>(list){}, "deliveryAddress");
            this.b(dataSyncInfo, arrayList, DeliveryAddress.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void p() throws Exception {
        int n = this.a(DeclaredTips.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.41"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(DeclaredTips.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeclaredTips declaredTips : list) {
                arrayList.add(declaredTips.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<DeclaredTips>>(list){}, "declaredTips");
            this.b(dataSyncInfo, arrayList, DeclaredTips.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void q() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CustomPayment.class, this.e, this.j);
        this.a(list, " custom payment.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.40"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CustomPayment customPayment : list) {
                arrayList.add(customPayment.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<CustomPayment>>(list){}, "customPayment");
            this.b(dataSyncInfo, arrayList, CustomPayment.REF);
            this.b(arrayList.size());
        }
    }

    private Date a(DataSyncInfo dataSyncInfo) {
        return dataSyncInfo.getLastUpdateTime();
    }

    private void r() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CustomerGroup.class, this.e, this.j);
        this.a(list, " customer group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.39"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CustomerGroup customerGroup : list) {
                arrayList.add(customerGroup.getId());
                CustomerGroupDAO.getInstance().initialize(customerGroup);
                customerGroup.setLastUpdateTime(this.i);
                this.a(customerGroup.getCustomers());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<CustomerGroup>>(list){}, "customerGroup");
            this.b(dataSyncInfo, arrayList, CustomerGroup.REF);
            this.b(arrayList.size());
        }
    }

    private void a(List<Customer> list) {
        if (list == null) {
            return;
        }
        for (Customer customer : list) {
            XMLTransientUtil.makeXMLTransient(customer);
        }
    }

    private void s() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Course.class, this.e, this.j);
        this.a(list, " course.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.38"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Course course : list) {
                arrayList.add(course.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Course>>(list){}, "course");
            this.b(dataSyncInfo, arrayList, Course.REF);
            this.b(arrayList.size());
        }
    }

    private void t() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CookingInstruction.class, this.e, this.j);
        this.a(list, " cooking instructions.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.37"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CookingInstruction cookingInstruction : list) {
                arrayList.add(cookingInstruction.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<CookingInstruction>>(list){}, "cookingInstruction");
            this.b(dataSyncInfo, arrayList, CookingInstruction.REF);
            this.b(arrayList.size());
        }
    }

    private void u() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(DeletedData.class, this.e, this.j);
        this.a(list, " deleted data.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading deleted data...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeletedData deletedData : list) {
                arrayList.add(deletedData.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<DeletedData>>(list){}, "deletedData");
            this.b(dataSyncInfo, arrayList, DeletedData.REF);
            this.b(arrayList.size());
        }
    }

    private void v() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Attribute.class, this.e, this.j);
        this.a(list, " attribute.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.17"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Attribute attribute : list) {
                arrayList.add(attribute.getId());
                XMLTransientUtil.makeXMLTransient(attribute.getGroup());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Attribute>>(list){}, "attribute");
            this.b(dataSyncInfo, arrayList, Attribute.REF);
            this.b(arrayList.size());
        }
    }

    private void w() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(AttributeGroup.class, this.e, this.j);
        this.a(list, " attribute group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.16"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (AttributeGroup attributeGroup : list) {
                arrayList.add(attributeGroup.getId());
                attributeGroup.setAttributes(null);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<AttributeGroup>>(list){}, "attributeGroup");
            this.b(dataSyncInfo, arrayList, AttributeGroup.REF);
            this.b(arrayList.size());
        }
    }

    private List<TerminalType> x() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(TerminalType.class, this.e, this.j);
        this.a(list, " terminal type.");
        ArrayList<TerminalType> arrayList = new ArrayList<TerminalType>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.4"));
            for (TerminalType terminalType : list) {
                TerminalTypeDAO.getInstance().initialize(terminalType);
                terminalType.setLastUpdateTime(this.i);
                TerminalType terminalType2 = XMLTransientUtil.getLazyData(terminalType);
                if (terminalType2 != null) {
                    arrayList.add(terminalType2);
                }
                arrayList2.add(terminalType.getId());
                XMLTransientUtil.makeXMLTransient(terminalType);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<TerminalType>>(list){}, "terminalType");
            this.b(dataSyncInfo, arrayList2, TerminalType.REF);
            this.b(arrayList2.size());
        }
        return arrayList;
    }

    private void y() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Terminal.class, this.e, this.j);
        this.a(list, " terminal.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.4"));
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Terminal terminal : list) {
                terminal.setProperties(null);
                arrayList.add(terminal.getId());
                if (!StringUtils.isBlank((String)terminal.getOutletId())) continue;
                this.g = true;
                terminal.setOutletId(this.ao());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Terminal>>(list){}, "terminal");
            this.a(dataSyncInfo, arrayList, Terminal.REF);
            this.b(arrayList.size());
        }
    }

    private void z() throws Exception {
        int n = this.a(StoreSession.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.2"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(StoreSession.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (StoreSession storeSession : list) {
                if (StringUtils.isEmpty((String)storeSession.getOutletId())) {
                    this.g = true;
                    storeSession.setOutletId(this.ao());
                }
                XMLTransientUtil.makeXMLTransient(storeSession.getClosedBy());
                XMLTransientUtil.makeXMLTransient(storeSession.getOpenedBy());
                arrayList.add(storeSession.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<StoreSession>>(list){}, "storesession");
            this.b(dataSyncInfo, arrayList, StoreSession.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    public void uploadTickets() throws Exception {
        int n = this.a(Ticket.class);
        if (n == 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.33"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.i);
        calendar.set(14, calendar.getMinimum(14));
        Date date = calendar.getTime();
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(Ticket.class, this.e, this.j, 100);
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            for (Ticket ticket : list) {
                TicketDAO.getInstance().loadFullTicket(ticket);
                Gratuity gratuity = ticket.getGratuity();
                if (StringUtils.isBlank((String)ticket.getOutletId())) {
                    this.g = true;
                    ticket.setOutletId(this.ao());
                }
                if (gratuity != null) {
                    gratuity.setLastUpdateTime(date);
                    if (StringUtils.isBlank((String)gratuity.getOutletId())) {
                        this.g = true;
                        gratuity.setOutletId(this.ao());
                    }
                }
                if (ticket.getTransactions() != null && ticket.getTransactions().size() > 0) {
                    for (PosTransaction posTransaction : ticket.getTransactions()) {
                        if (!StringUtils.isBlank((String)posTransaction.getOutletId())) continue;
                        this.g = true;
                        posTransaction.setOutletId(this.ao());
                    }
                }
                XMLTransientUtil.makeXMLTransient(ticket);
                arrayList.add(ticket);
            }
            this.doSendTicketToCloud(arrayList);
            this.a(n, i);
        }
        this.a(n);
    }

    private void A() throws Exception {
        int n = GenericDAO.getInstance().getUnSyncPosTransactionItemCount(this.e, this.j);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.61"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncPosTransactions(this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PosTransaction posTransaction : list) {
                posTransaction.setProperties(null);
                arrayList.add(posTransaction.getId());
                if (!StringUtils.isBlank((String)posTransaction.getOutletId())) continue;
                this.g = true;
                posTransaction.setOutletId(this.ao());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<PosTransaction>>(list){}, "transactions");
            this.b(dataSyncInfo, arrayList, PosTransaction.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    public void uploadTicketIfOnlineOrder(Ticket ticket) {
        if (ticket == null || !ticket.isShouldPublishMqtt() || ticket.getType().intValue() != TicketType.ONLINE.getTypeNo()) {
            return;
        }
        if (!this.d.isCloudConfigured()) {
            return;
        }
        AsyncAction.execute(() -> {
            try {
                Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                XMLTransientUtil.makeXMLTransient(ticket2);
                ticket2.setOutletId(DataProvider.get().getStore().getDefaultOutletId());
                List<Ticket> list = Arrays.asList(ticket2);
                GenericEntity<List<Ticket>> genericEntity = new GenericEntity<List<Ticket>>(list){};
                PosLog.debug(CloudDataUploader.class, "Ticket uploading: " + ticket2.getId() + " Gratuity: " + ticket2.getGratuity());
                this.d.uploadData((GenericEntity)genericEntity, "tickets", true);
                String string = ServiceUtils.createPosResponseAsString(list, true);
                OroMqttClient.getInstance().publishData("public", string, true);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), "Failed to upload ticket : " + ticket.getId() + " " + exception.getMessage());
            }
        });
    }

    public void doSendTicketToCloud(List<Ticket> list) throws Exception {
        GenericEntity<List<Ticket>> genericEntity = new GenericEntity<List<Ticket>>(list){};
        DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)genericEntity, "tickets");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Ticket ticket : list) {
            arrayList.add(ticket.getId());
        }
        this.a(dataSyncInfo, arrayList);
    }

    private void B() throws Exception {
        int n = this.a(CashDrawer.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.3"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(CashDrawer.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            this.b(list);
            this.a(n, i);
        }
        this.a(n);
    }

    private void b(List<CashDrawer> list) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CashDrawer cashDrawer : list) {
            arrayList.add(cashDrawer.getId());
            if (!StringUtils.isBlank((String)cashDrawer.getOutletId())) continue;
            this.g = true;
            cashDrawer.setOutletId(this.ao());
        }
        DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<CashDrawer>>(list){}, "cashdrawers");
        this.b(dataSyncInfo, arrayList, CashDrawer.REF);
    }

    private void C() throws Exception {
        int n = this.a(MenuItem.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.18"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().getUnSyncMenuItems(this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuItem menuItem : list) {
                arrayList.add(menuItem.getId());
                XMLTransientUtil.makeMenuItemXMLTransient(menuItem);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<MenuItem>>(list){}, "menuitem");
            this.b(dataSyncInfo, arrayList, MenuItem.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void D() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(MenuItemSize.class, this.e, this.j);
        this.a(list, " menu item size.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.19"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuItemSize menuItemSize : list) {
                arrayList.add(menuItemSize.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<MenuItemSize>>(list){}, "menuitemsizes");
            this.b(dataSyncInfo, arrayList, MenuItemSize.REF);
            this.b(arrayList.size());
        }
    }

    private void E() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(PackagingUnit.class, this.e, this.j);
        this.a(list, " packaging unit.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.24"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PackagingUnit packagingUnit : list) {
                arrayList.add(packagingUnit.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<PackagingUnit>>(list){}, "packagingunits");
            this.b(dataSyncInfo, arrayList, PackagingUnit.REF);
            this.b(arrayList.size());
        }
    }

    private void F() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryLocation.class, this.e, this.j);
        this.a(list, " inventory location.");
        if (list != null && !list.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = DataProvider.get().getCurrentOutletId();
            Object object = list.iterator();
            while (object.hasNext()) {
                InventoryLocation inventoryLocation = (InventoryLocation)object.next();
                if (StringUtils.isBlank((String)inventoryLocation.getOutletId())) {
                    this.g = true;
                } else if (inventoryLocation.isDeleted().booleanValue() && !inventoryLocation.getOutletId().equals(string)) {
                    object.remove();
                    continue;
                }
                inventoryLocation.setOutletId(string);
                arrayList.add(inventoryLocation.getId());
                XMLTransientUtil.makeXMLTransient(inventoryLocation);
            }
            if (list.size() > 0) {
                this.c(Messages.getString("CloudDataUploader.26"));
                object = this.d.uploadData((GenericEntity)new GenericEntity<List<InventoryLocation>>(list){}, "inventorylocation");
                this.b((DataSyncInfo)object, arrayList, InventoryLocation.REF);
                this.b(arrayList.size());
            }
        }
    }

    private void G() throws Exception {
        int n = this.a(InventoryTransaction.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.27"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryTransaction.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryTransaction inventoryTransaction : list) {
                arrayList.add(inventoryTransaction.getId());
                XMLTransientUtil.makeXMLTransient(inventoryTransaction);
                if (!StringUtils.isBlank((String)inventoryTransaction.getOutletId())) continue;
                this.g = true;
                inventoryTransaction.setOutletId(this.ao());
            }
            this.doSendInventoryTransactions(arrayList, list);
            this.a(n, i);
        }
        this.a(n);
    }

    public void doSendInventoryTransactions(List<String> list, List<InventoryTransaction> list2) throws Exception {
        DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<InventoryTransaction>>(list2){}, "inventorytransactions");
        this.b(dataSyncInfo, list, InventoryTransaction.REF);
    }

    private void H() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryUnitGroup.class, this.e, this.j);
        this.a(list, " inventory unit group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.22"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryUnitGroup inventoryUnitGroup : list) {
                inventoryUnitGroup.setUnits(null);
                arrayList.add(inventoryUnitGroup.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<InventoryUnitGroup>>(list){}, "inventoryunitgroups");
            this.b(dataSyncInfo, arrayList, InventoryUnitGroup.REF);
        }
    }

    private void I() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryUnit.class, this.e, this.j);
        this.a(list, " inventory unit.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.23"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryUnit inventoryUnit : list) {
                arrayList.add(inventoryUnit.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<InventoryUnit>>(list){}, "inventoryunits");
            this.b(dataSyncInfo, arrayList, InventoryUnit.REF);
            this.b(arrayList.size());
        }
    }

    private void J() throws Exception {
        int n = this.a(InventoryVendor.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.20"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryVendor.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryVendor inventoryVendor : list) {
                arrayList.add(inventoryVendor.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<InventoryVendor>>(list){}, "inventoryvendors");
            this.b(dataSyncInfo, arrayList, InventoryVendor.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void K() throws Exception {
        int n = this.a(InventoryVendorItems.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.21"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryVendorItems.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryVendorItems inventoryVendorItems : list) {
                arrayList.add(inventoryVendorItems.getId());
                XMLTransientUtil.makeXMLTransient(inventoryVendorItems);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<InventoryVendorItems>>(list){}, "inventoryvendoritems");
            this.b(dataSyncInfo, arrayList, InventoryVendorItems.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void L() throws Exception {
        int n = this.a(InventoryClosingBalance.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.29"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryClosingBalance.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryClosingBalance inventoryClosingBalance : list) {
                arrayList.add(inventoryClosingBalance.getId());
                if (!StringUtils.isBlank((String)inventoryClosingBalance.getOutletId())) continue;
                this.g = true;
                inventoryClosingBalance.setOutletId(DataProvider.get().getCurrentOutletId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<InventoryClosingBalance>>(list){}, "inventoryclosingbalances");
            this.b(dataSyncInfo, arrayList, InventoryClosingBalance.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void M() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ShopFloor.class, this.e, this.j);
        this.a(list, " shop floor.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.30"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ShopFloor shopFloor : list) {
                if (StringUtils.isBlank((String)shopFloor.getOutletId())) {
                    this.g = true;
                    shopFloor.setOutletId(this.ao());
                }
                arrayList.add(shopFloor.getId());
                XMLTransientUtil.makeXMLTransient(shopFloor);
                Set<ShopTable> set = shopFloor.getTables();
                if (set == null || set.size() <= 0) continue;
                for (ShopTable shopTable : set) {
                    if (!StringUtils.isBlank((String)shopTable.getOutletId())) continue;
                    shopTable.setOutletId(this.ao());
                }
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<ShopFloor>>(list){}, "shopfloors");
            this.b(dataSyncInfo, arrayList, ShopFloor.REF);
            this.b(arrayList.size());
        }
    }

    private void N() throws Exception {
        int n = this.a(ShopTable.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.31"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(ShopTable.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (ShopTable shopTable : list) {
                arrayList.add(shopTable.getId());
                if (StringUtils.isBlank((String)shopTable.getOutletId())) {
                    this.g = true;
                    shopTable.setOutletId(this.ao());
                }
                XMLTransientUtil.makeXMLTransient(shopTable);
                for (TimedModel timedModel : list) {
                    timedModel.setLastUpdateTime(this.i);
                }
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<ShopTable>>(list){}, "shoptables");
            this.a(dataSyncInfo, arrayList, ShopTable.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    public void uploadBookingInfos() throws Exception {
        int n = this.a(BookingInfo.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.32"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(BookingInfo.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BookingInfo bookingInfo : list) {
                arrayList.add(bookingInfo.getId());
                if (StringUtils.isBlank((String)bookingInfo.getOutletId())) {
                    this.g = true;
                    bookingInfo.setOutletId(this.ao());
                }
                XMLTransientUtil.makeXMLTransient(bookingInfo);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<BookingInfo>>(list){}, "bookinginfos");
            this.b(dataSyncInfo, arrayList, BookingInfo.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    public void uploadCurrency() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Currency.class, this.e, this.j);
        this.a(list, " currency.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.1"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Currency currency : list) {
                arrayList.add(currency.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Currency>>(list){}, "currencies");
            this.b(dataSyncInfo, arrayList, Currency.REF);
            this.b(arrayList.size());
        }
    }

    public void uploadCashBreakDown() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CashBreakdown.class, this.e, this.j);
        this.a(list, " cash breakdown.");
        if (list != null && !list.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CashBreakdown cashBreakdown : list) {
                arrayList.add(cashBreakdown.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<CashBreakdown>>(list){}, "cashbreakdowns");
            this.b(dataSyncInfo, arrayList, CashBreakdown.REF);
            this.b(arrayList.size());
        }
    }

    public void uploadShift() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Shift.class, this.e, this.j);
        this.a(list, " shift.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.34"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Shift shift : list) {
                arrayList.add(shift.getId());
                if (!StringUtils.isBlank((String)shift.getOutletId())) continue;
                shift.setOutletId(this.ao());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Shift>>(list){}, "shifts");
            this.b(dataSyncInfo, arrayList, Shift.REF);
            this.b(arrayList.size());
        }
    }

    public void uploadShopTablesStatus() throws Exception {
        int n = this.a(ShopTableStatus.class);
        if (n <= 0) {
            return;
        }
        this.a(n, "Uploading shop table status...");
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(ShopTableStatus.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (ShopTableStatus shopTableStatus : list) {
                arrayList.add(shopTableStatus.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<ShopTableStatus>>(list){}, "shoptablesstatus");
            this.a(dataSyncInfo, arrayList, ShopTableStatus.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void O() throws Exception {
        int n = this.a(ModifierGroup.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.13"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(ModifierGroup.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ModifierGroup modifierGroup : list) {
                arrayList.add(modifierGroup.getId());
                XMLTransientUtil.makeXMLTransient(modifierGroup);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<ModifierGroup>>(list){}, "modifiergroup");
            this.b(dataSyncInfo, arrayList, ModifierGroup.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void P() throws Exception {
        int n = this.a(MenuModifier.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.12"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(MenuModifier.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuModifier menuModifier : list) {
                arrayList.add(menuModifier.getId());
                MenuModifierDAO.getInstance().initialize(menuModifier);
                menuModifier.setLastUpdateTime(this.i);
                List<ModifierGroup> list2 = menuModifier.getModifierGroups();
                if (list2 == null) continue;
                for (ModifierGroup modifierGroup : list2) {
                    hashSet.add(modifierGroup.getId());
                    modifierGroup.setModifiers(null);
                    modifierGroup.setModifierPages(null);
                }
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<MenuModifier>>(list){}, "modifier");
            this.b(dataSyncInfo, arrayList, MenuModifier.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void Q() throws Exception {
        int n = this.a(MenuGroup.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.15"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(MenuGroup.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuGroup menuGroup : list) {
                arrayList.add(menuGroup.getId());
                XMLTransientUtil.makeXMLTransient(menuGroup);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<MenuGroup>>(list){}, "menugroup");
            this.b(dataSyncInfo, arrayList, MenuGroup.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void R() throws Exception {
        int n = this.a(MenuCategory.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.14"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(MenuCategory.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuCategory menuCategory : list) {
                arrayList.add(menuCategory.getId());
                menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
                menuCategory.setLastUpdateTime(this.i);
                XMLTransientUtil.makeXMLTransientCollection(menuCategory);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<MenuCategory>>(list){}, "menucategory");
            this.b(dataSyncInfo, arrayList, MenuCategory.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void S() throws Exception {
        OutletDAO outletDAO = OutletDAO.getInstance();
        Outlet outlet = DataProvider.get().getOutlet();
        boolean bl = outletDAO.isOutletSyncable(outlet.getId());
        if (!this.f && !bl) {
            return;
        }
        outletDAO.initialize(outlet);
        this.a(outlet);
        outlet.setLastUpdateTime(this.i);
        outlet.setDepartments(null);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Outlet> arrayList2 = new ArrayList<Outlet>();
        arrayList.add(outlet.getId());
        arrayList2.add(outlet);
        this.c(Messages.getString("CloudDataUploader.0"));
        DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Outlet>>(arrayList2){}, "outlet");
        this.b(dataSyncInfo, arrayList, Outlet.REF);
        this.b(arrayList.size());
    }

    private void a(Outlet outlet) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Store store = StoreDAO.getRestaurant();
        Map<String, String> map = store.getProperties();
        if (map != null) {
            for (String string : map.keySet()) {
                try {
                    outlet.addProperty(string, map.get(string));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        outlet.setItemPriceIncludesTax(store.isItemPriceIncludesTax());
    }

    private void a(String string) {
        if (this.c == null) {
            return;
        }
        this.c.printInfo("\n" + string);
    }

    public void uploadTaxes() throws Exception {
        Object object;
        ArrayList<String> arrayList;
        List list = GenericDAO.getInstance().findAllUnSyncItem(Tax.class, this.e, this.j);
        this.a(list, " tax.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.10"));
            arrayList = new ArrayList();
            for (Object object2 : list) {
                arrayList.add(((BaseTax)object2).getId());
            }
            object = this.d.uploadData((GenericEntity)new GenericEntity<List<Tax>>(list){}, "tax");
            this.b((DataSyncInfo)object, arrayList, Tax.REF);
            this.b(arrayList.size());
        }
        arrayList = new ArrayList<String>();
        object = GenericDAO.getInstance().findAllUnSyncItem(TaxGroup.class, this.e, this.j);
        this.a((List<?>)object, " tax group.");
        if (object != null && !object.isEmpty()) {
            Object object2;
            this.c("Uploading tax groups...");
            object2 = object.iterator();
            while (object2.hasNext()) {
                TaxGroup taxGroup = (TaxGroup)object2.next();
                arrayList.add(taxGroup.getId());
            }
            object2 = this.d.uploadData((GenericEntity)new GenericEntity<List<TaxGroup>>((List)object){}, "taxgroup");
            this.b((DataSyncInfo)object2, arrayList, TaxGroup.REF);
            this.b(arrayList.size());
        }
    }

    private void T() throws Exception {
        int n = this.a(Customer.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.11"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(Customer.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Customer customer : list) {
                CustomerDAO.getInstance().initialize(customer);
                customer.setLastUpdateTime(this.i);
                arrayList.add(customer.getId());
                XMLTransientUtil.makeXMLTransient(customer);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Customer>>(list){}, "customer");
            this.b(dataSyncInfo, arrayList, Customer.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void U() throws Exception {
        int n = this.a(BalanceUpdateTransaction.class);
        if (n <= 0) {
            return;
        }
        this.a(n, "Uploading balance update transaction");
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(BalanceUpdateTransaction.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BalanceUpdateTransaction balanceUpdateTransaction : list) {
                arrayList.add(balanceUpdateTransaction.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<BalanceUpdateTransaction>>(list){}, "balanceUpdateTransactions");
            this.b(dataSyncInfo, arrayList, BalanceUpdateTransaction.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private List<OrderType> V() throws Exception {
        ArrayList<OrderType> arrayList = new ArrayList<OrderType>();
        List list = GenericDAO.getInstance().findAllUnSyncItem(OrderType.class, this.e, this.j);
        this.a(list, " order type.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.6"));
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (OrderType orderType : list) {
                OrderTypeDAO.getInstance().initialize(orderType);
                orderType.setLastUpdateTime(this.i);
                OrderType orderType2 = XMLTransientUtil.getLazyData(orderType);
                if (orderType2 != null) {
                    arrayList.add(orderType2);
                }
                arrayList2.add(orderType.getId());
                XMLTransientUtil.makeXMLTransient(orderType);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<OrderType>>(list){}, "ordertype");
            this.b(dataSyncInfo, arrayList2, OrderType.REF);
            this.b(arrayList2.size());
        }
        return arrayList;
    }

    private void c(List<OrderType> list) throws Exception {
        this.a(list, " order type -> terminal types and menu categories and departments");
        if (list != null && !list.isEmpty()) {
            this.c(" order type -> terminal types and menu categories and departments");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (OrderType orderType : list) {
                orderType = OrderTypeDAO.getInstance().initialize(orderType);
                arrayList.add(orderType.getId());
                XMLTransientUtil.makeLazy(orderType);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<OrderType>>(list){}, "ordertype/categories");
        }
    }

    private void d(List<TerminalType> list) throws Exception {
        this.a(list, " terminal type -> outlets and menu categories");
        if (list != null && !list.isEmpty()) {
            this.c(" terminal type -> outlets and menu categories");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TerminalType terminalType : list) {
                arrayList.add(terminalType.getId());
                XMLTransientUtil.makeLazy(terminalType);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<TerminalType>>(list){}, "terminalType/categories");
        }
    }

    private List<Department> W() throws Exception {
        ArrayList<Department> arrayList = new ArrayList<Department>();
        List list = GenericDAO.getInstance().findAllUnSyncItem(Department.class, this.e, this.j);
        this.a(list, " department.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading department");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Department department : list) {
                try (Object object = DepartmentDAO.getInstance().createNewSession();){
                    object.refresh((Object)department);
                    Hibernate.initialize(department.getOutlets());
                    Hibernate.initialize(department.getOrderTypes());
                }
                object = XMLTransientUtil.getLazyData(department);
                if (object != null) {
                    arrayList.add((Department)object);
                }
                arrayList2.add(department.getId());
                XMLTransientUtil.makeXMLTransient(department);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Department>>(list){}, "departments");
            this.b(dataSyncInfo, arrayList2, Department.REF);
            this.b(arrayList2.size());
        }
        return arrayList;
    }

    private void e(List<Department> list) throws Exception {
        this.a(list, " department -> outlets and order types");
        if (list != null && !list.isEmpty()) {
            this.c(" department -> outlets and order types");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Department department : list) {
                arrayList.add(department.getId());
                XMLTransientUtil.makeLazy(department);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Department>>(list){}, "departments/orderTypesAndOutlets");
        }
    }

    private void X() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(SalesArea.class, this.e, this.j);
        this.a(list, " sales area.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading sales areas...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SalesArea salesArea : list) {
                arrayList.add(salesArea.getId());
                if (!StringUtils.isBlank((String)salesArea.getOutletId())) continue;
                salesArea.setOutletId(this.ao());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<SalesArea>>(list){}, "salesAreas");
            this.b(dataSyncInfo, arrayList, SalesArea.REF);
            this.b(arrayList.size());
        }
    }

    private void Y() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ReportGroup.class, this.e, this.j);
        this.a(list, " report group.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading report group...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ReportGroup reportGroup : list) {
                arrayList.add(reportGroup.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<ReportGroup>>(list){}, "reportGroups");
            this.b(dataSyncInfo, arrayList, ReportGroup.REF);
            this.b(arrayList.size());
        }
    }

    private void Z() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(PrinterGroup.class, this.e, this.j);
        this.a(list, " printer group.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading printer group...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PrinterGroup printerGroup : list) {
                arrayList.add(printerGroup.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<PrinterGroup>>(list){}, "printerGroups");
            this.b(dataSyncInfo, arrayList, PrinterGroup.REF);
            this.b(arrayList.size());
        }
    }

    private void aa() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(VoidReason.class, this.e, this.j);
        this.a(list, " void reason.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading void reason...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VoidReason voidReason : list) {
                arrayList.add(voidReason.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<VoidReason>>(list){}, "voidReasons");
            this.b(dataSyncInfo, arrayList, VoidReason.REF);
            this.b(arrayList.size());
        }
    }

    private void ab() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(VirtualPrinter.class, this.e, this.j);
        this.a(list, " virtual printer.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading printers...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VirtualPrinter virtualPrinter : list) {
                arrayList.add(virtualPrinter.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<VirtualPrinter>>(list){}, "printers");
            this.b(dataSyncInfo, arrayList, VirtualPrinter.REF);
            this.b(arrayList.size());
        }
    }

    private void ac() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ShopTableType.class, this.e, this.j);
        this.a(list, " shop table type.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading table types...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ShopTableType shopTableType : list) {
                arrayList.add(shopTableType.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<ShopTableType>>(list){}, "shopTableTypes");
            this.b(dataSyncInfo, arrayList, ShopTableType.REF);
            this.b(arrayList.size());
        }
    }

    private void ad() throws Exception {
        int n = this.a(ActionHistory.class);
        if (n <= 0) {
            return;
        }
        this.a(n, "Uploading action histories...");
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(ActionHistory.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ActionHistory actionHistory : list) {
                if (StringUtils.isBlank((String)actionHistory.getOutletId())) {
                    this.g = true;
                    actionHistory.setOutletId(this.ao());
                    if (actionHistory.getPerformer() != null) {
                        actionHistory.getPerformer().setOutletId(this.ao());
                    }
                }
                XMLTransientUtil.makeXMLTransient(actionHistory.getPerformer());
                arrayList.add(actionHistory.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<ActionHistory>>(list){}, "actionHistories");
            this.b(dataSyncInfo, arrayList, ActionHistory.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void b(int n) {
        if (this.c == null) {
            return;
        }
        this.c.printInfo(" (" + n + "): success");
    }

    private void ae() throws Exception {
        int n = this.a(VoidItem.class);
        if (n <= 0) {
            return;
        }
        this.a(n, "Uploading void items...");
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(VoidItem.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VoidItem voidItem : list) {
                arrayList.add(voidItem.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<VoidItem>>(list){}, "voidItems");
            this.b(dataSyncInfo, arrayList, VoidItem.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void af() throws Exception {
        int n = this.a(Recepie.class);
        if (n <= 0) {
            return;
        }
        this.a(n, "Uploading recipes...");
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(Recepie.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Recepie recepie : list) {
                XMLTransientUtil.makeLazy(recepie);
                arrayList.add(recepie.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Recepie>>(list){}, "recipes");
            this.b(dataSyncInfo, arrayList, Recepie.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void ag() throws Exception {
        int n = this.a(PurchaseOrder.class);
        if (n <= 0) {
            return;
        }
        this.a(n, "Uploading purchase orders...");
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(PurchaseOrder.class, this.e, this.j, 100);
            this.a(list, " purchase order.");
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PurchaseOrder purchaseOrder : list) {
                XMLTransientUtil.makeLazy(purchaseOrder);
                if (StringUtils.isBlank((String)purchaseOrder.getOutletId())) {
                    this.g = true;
                    purchaseOrder.setOutletId(this.ao());
                }
                arrayList.add(purchaseOrder.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<PurchaseOrder>>(list){}, "purchaseOrders");
            this.b(dataSyncInfo, arrayList, PurchaseOrder.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void ah() throws Exception {
        int n = this.a(StockCount.class);
        if (n <= 0) {
            return;
        }
        this.a(n, "Uploading stock counts...");
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(StockCount.class, this.e, this.j, 100);
            this.a(list, " stock count.");
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (StockCount stockCount : list) {
                XMLTransientUtil.makeLazy(stockCount);
                arrayList.add(stockCount.getId());
                if (!StringUtils.isBlank((String)stockCount.getOutletId())) continue;
                this.g = true;
                stockCount.setOutletId(this.ao());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<StockCount>>(list){}, "stockCounts");
            this.b(dataSyncInfo, arrayList, StockCount.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void ai() throws Exception {
        int n = this.a(ShopFloorTemplate.class);
        if (n <= 0) {
            return;
        }
        this.a(n, "Uploading shop floor templates...");
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(ShopFloorTemplate.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ShopFloorTemplate shopFloorTemplate : list) {
                XMLTransientUtil.makeXMLTransient(shopFloorTemplate);
                arrayList.add(shopFloorTemplate.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<ShopFloorTemplate>>(list){}, "shopFloorTemplates");
            this.b(dataSyncInfo, arrayList, ShopFloorTemplate.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void aj() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CronJob.class, this.e, this.j);
        this.a(list, " cron job.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading cron jobs...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CronJob cronJob : list) {
                arrayList.add(cronJob.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<CronJob>>(list){}, "cronJobs");
            this.b(dataSyncInfo, arrayList, CronJob.REF);
            this.b(list.size());
        }
    }

    private void ak() throws Exception {
        int n = this.a(Gratuity.class);
        if (n <= 0) {
            return;
        }
        this.a(n, "Uploading gratuities...");
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(Gratuity.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Gratuity gratuity : list) {
                arrayList.add(gratuity.getId());
                if (!StringUtils.isBlank((String)gratuity.getOutletId())) continue;
                gratuity.setOutletId(DataProvider.get().getCurrentOutletId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Gratuity>>(list){}, "gratuity");
            this.b(dataSyncInfo, arrayList, Gratuity.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void al() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(SlideShowImage.class, this.e, this.j);
        this.a(list, " slide images.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading slide images...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SlideShowImage slideShowImage : list) {
                arrayList.add(slideShowImage.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<SlideShowImage>>(list){}, "slideShowImages");
            this.b(dataSyncInfo, arrayList, SlideShowImage.REF);
        }
    }

    private void am() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(UserType.class, this.e, this.j);
        this.a(list, " user type.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.8"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (UserType userType : list) {
                arrayList.add(userType.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<UserType>>(list){}, "usertypes");
            this.b(dataSyncInfo, arrayList, UserType.REF);
            this.b(arrayList.size());
        }
    }

    private void an() throws Exception {
        int n = this.a(User.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.9"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(User.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (User user : list) {
                arrayList.add(user.getId());
                if (StringUtils.isBlank((String)user.getOutletId())) {
                    this.g = true;
                    user.setOutletId(this.ao());
                }
                XMLTransientUtil.makeXMLTransient(user);
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<User>>(list){}, "users");
            this.b(dataSyncInfo, arrayList, User.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private String ao() {
        Outlet outlet = DataProvider.get().getOutlet();
        return outlet == null ? null : outlet.getId();
    }

    public static CloudDataUploader get() {
        Date date = new Date();
        return new CloudDataUploader(null, date, date);
    }

    public void uploadOnSaveBookingInfo(BookingInfo bookingInfo) throws Exception {
        if (!Application.getInstance().isCloudConnected()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<BookingInfo> arrayList2 = new ArrayList<BookingInfo>();
        XMLTransientUtil.makeXMLTransient(bookingInfo);
        arrayList2.add(bookingInfo);
        arrayList.add(bookingInfo.getId());
        if (this.d == null) {
            this.d = PosWebService.get();
        }
        DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<BookingInfo>>(arrayList2){}, "bookinginfos");
        this.b(dataSyncInfo, arrayList, BookingInfo.REF);
    }

    public void sendTicketWithTransactions(String string) {
        if (!Application.getInstance().isCloudConnected()) {
            return;
        }
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        AsyncAction.execute(() -> {
            try {
                Ticket ticket = TicketDAO.getInstance().loadFullTicket(string);
                if (ticket == null) {
                    return;
                }
                this.d.doUploadTicketToCloud(ticket);
            }
            catch (Exception exception) {
                PosLog.error(PosWebService.class, "Uploading ticket/transaction/InvTransaction failed...", exception);
            }
        });
    }

    public void uploadAddress() throws Exception {
        int n = this.a(Address.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.35"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(Address.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Address address : list) {
                arrayList.add(address.getId());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<Address>>(list){}, "address");
            this.b(dataSyncInfo, arrayList, Address.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    private void ap() throws Exception {
        int n = this.a(AttendenceHistory.class);
        if (n <= 0) {
            return;
        }
        this.a(n, Messages.getString("CloudDataUploader.36"));
        for (int i = 0; i < n; i += 100) {
            List list = GenericDAO.getInstance().findAllUnSyncItem(AttendenceHistory.class, this.e, this.j, 100);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (AttendenceHistory attendenceHistory : list) {
                arrayList.add(attendenceHistory.getId());
                Integer n2 = attendenceHistory.getTerminalId();
                attendenceHistory.setTerminal(null);
                attendenceHistory.setTerminalId(n2);
                if (StringUtils.isBlank((String)attendenceHistory.getOutletId())) {
                    this.g = true;
                    attendenceHistory.setOutletId(this.ao());
                }
                XMLTransientUtil.makeXMLTransient(attendenceHistory.getUser());
            }
            DataSyncInfo dataSyncInfo = this.d.uploadData((GenericEntity)new GenericEntity<List<AttendenceHistory>>(list){}, "attendenceHistory");
            this.b(dataSyncInfo, arrayList, AttendenceHistory.REF);
            this.a(n, i);
        }
        this.a(n);
    }

    public void updateStoreLastUpdateTimeProperties() {
        Store store = StoreDAO.getRestaurant();
        GenericDAO genericDAO = GenericDAO.getInstance();
        for (DataSyncInfo dataSyncInfo : this.m) {
            genericDAO.updateLastUpdateTimeProperty(store, dataSyncInfo.getRef(), dataSyncInfo.getLastUpdateTime());
        }
        genericDAO.saveOrUpdate(store);
    }

    private void a(DataSyncInfo dataSyncInfo, List<Integer> list, String string) {
        GenericDAO genericDAO = GenericDAO.getInstance();
        Date date = this.a(dataSyncInfo);
        genericDAO.updateItemsLastSyncTimeByInt(date, list, string);
        dataSyncInfo.setRef(string);
        this.m.add(dataSyncInfo);
        this.a(dataSyncInfo, genericDAO);
    }

    private void b(DataSyncInfo dataSyncInfo, List<String> list, String string) {
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        int n2 = 12000;
        GenericDAO genericDAO = GenericDAO.getInstance();
        if (n > n2) {
            for (int i = 0; n > i; i += n2) {
                List<String> list2 = null;
                list2 = n - i < n2 ? list.subList(i, n) : list.subList(i, i + n2);
                genericDAO.updateItemsLastSyncTime(this.j, list2, string);
            }
        } else {
            genericDAO.updateItemsLastSyncTime(this.j, list, string);
        }
        dataSyncInfo.setRef(string);
        this.m.add(dataSyncInfo);
        this.a(dataSyncInfo, genericDAO);
    }

    private void a(DataSyncInfo dataSyncInfo, List<String> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        int n2 = 12000;
        GenericDAO genericDAO = GenericDAO.getInstance();
        if (n > n2) {
            for (int i = 0; n > i; i += n2) {
                List<String> list2 = null;
                list2 = n - i < n2 ? list.subList(i, n) : list.subList(i, i + n2);
                genericDAO.updateTicketsLastSyncTime(this.j, list2);
            }
        } else {
            genericDAO.updateTicketsLastSyncTime(this.j, list);
        }
        dataSyncInfo.setRef(Ticket.REF);
        this.m.add(dataSyncInfo);
        this.a(dataSyncInfo, genericDAO);
    }

    private void a(DataSyncInfo dataSyncInfo, GenericDAO genericDAO) {
        Store store = StoreDAO.getRestaurant();
        genericDAO.updateLastUpdateTimeProperty(store, dataSyncInfo.getRef(), dataSyncInfo.getLastUpdateTime());
        genericDAO.saveOrUpdate(store);
    }

    private void a(List<?> list, String string) {
        if (list == null || list.size() == 0) {
            return;
        }
        b.debug((Object)("  Uploading " + list.size() + string));
        this.h += list.size();
    }

    private void b(String string) {
        PosLog.info(this.getClass(), string);
        if (this.c == null) {
            return;
        }
        this.c.printInfo("\n" + string);
    }

    private void c(String string) {
        try {
            this.l = this.l + this.k;
            if (this.c == null) {
                return;
            }
            this.c.progress(this.l, string);
            this.c.printInfo("\n" + string);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void a(Integer n, String string) throws Exception {
        this.l = n;
        if (this.c == null) {
            return;
        }
        this.c.progress(n, string);
    }
}

