/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.extension.cronjob.CloudAutoSyncJob;
import com.floreantpos.extension.cronjob.CloudAutoSyncJobPlugin;
import com.floreantpos.extension.cronjob.CronJobPlugin;
import com.floreantpos.extension.cronjob.OroCronJobManager;
import com.floreantpos.main.Application;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.PosWebService;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.sun.jersey.api.client.ClientHandlerException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;

public class CloudLoginPanel
extends JPanel {
    public static final String VIEW_NAME = "login";
    private POSTextField a;
    private POSTextField b;
    private POSPasswordField c;
    private boolean d;
    private JButton e;
    private JCheckBox f;
    private JComboBox<Integer> g;
    private boolean h;
    private PosButton i;
    private CronJob j;

    public CloudLoginPanel() {
        this(false);
    }

    public CloudLoginPanel(boolean bl) {
        this.h = bl;
        this.initComponents();
        this.updateView();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("hidemode 3,fillx,ins 20", "[][fill, grow]", ""));
        this.a = new POSTextField();
        this.b = new POSTextField();
        this.c = new POSPasswordField();
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, 14));
        jLabel.setText("<html>" + Messages.getString("CloudLoginPanel.8") + Messages.getString("CloudLoginPanel.9") + "</html>");
        jPanel.add((Component)jLabel, "gapbottom 10 ,wrap,span 2");
        if (Application.getInstance().isDevelopmentMode()) {
            jPanel.add(new JLabel(Messages.getString("ServerAddress") + ":"));
            jPanel.add((Component)this.a, "grow, wrap");
        }
        jPanel.add(new JLabel(Messages.getString("CloudLoginPanel.2") + ":"));
        jPanel.add((Component)this.b, "grow,wrap");
        jPanel.add(new JLabel(Messages.getString("CloudLoginPanel.10") + ":"));
        jPanel.add((Component)this.c, "grow,wrap");
        this.e = new JButton(Messages.getString("TestConnection"));
        this.e.addActionListener(actionEvent -> this.checkConnection());
        jPanel.add((Component)this.e, "newline,span,split 2,right");
        this.f = new JCheckBox(Messages.getString("CloudSyncDialog.4"));
        this.g = new JComboBox();
        this.g.setEditable(false);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(15);
        arrayList.add(30);
        arrayList.add(60);
        this.g.setModel(new ListComboBoxModel(arrayList));
        jPanel.add((Component)this.f, "newline,split 2");
        JLabel jLabel2 = new JLabel(Messages.getString("CloudSyncDialog.11"));
        JLabel jLabel3 = new JLabel(Messages.getString("CloudSyncDialog.12"));
        jLabel.setVisible(!this.h);
        this.f.setVisible(this.h);
        this.g.setVisible(this.h);
        jLabel2.setVisible(this.h);
        jLabel3.setVisible(this.h);
        jPanel.add((Component)jLabel2, "newline,split");
        jPanel.add(this.g, "");
        jPanel.add((Component)jLabel3, "wrap");
        JSeparator jSeparator = new JSeparator();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        this.i = new PosButton();
        PosButton posButton = new PosButton();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel2.setLayout(new FlowLayout());
        if (this.h) {
            this.i.setText(POSConstants.SAVE_BUTTON_TEXT);
        } else {
            this.i.setFocusable(true);
            this.i.setFocusPainted(true);
            UiUtil.setButtonColorGreen(this.i);
            this.i.setText(Messages.getString("CloudLoginPanel.12"));
        }
        this.i.addActionListener(actionEvent -> this.doLogin());
        jPanel2.add(this.i);
        posButton.setText(POSConstants.CANCEL);
        posButton.addActionListener(actionEvent -> this.a(true));
        jPanel2.add(posButton);
        jPanel3.add((Component)jSeparator, "North");
        jPanel3.add((Component)jPanel2, "Center");
        this.add(jPanel);
        this.add((Component)jPanel3, "South");
    }

    protected void checkConnection() {
        try {
            String string = this.a.getText();
            String string2 = this.b.getText();
            String string3 = new String(this.c.getPassword());
            String string4 = String.valueOf(DataProvider.get().getCurrentTerminal().getId());
            if (StringUtils.isEmpty((String)string)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.0"));
                return;
            }
            if (StringUtils.isEmpty((String)string2)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.1"));
                return;
            }
            if (!EmailValidator.getInstance().isValid(string2)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.3"));
                return;
            }
            if (StringUtils.isEmpty((String)string3)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.4"));
                return;
            }
            PosResponse posResponse = PosWebService.get().checkConnection(string, string2, AESencrp.encrypt(string3), string4);
            if (posResponse != null) {
                if (posResponse.getResponseCode() == 200) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.13"));
                } else {
                    POSMessageDialog.showError(posResponse.getMsg());
                }
            }
        }
        catch (ClientHandlerException clientHandlerException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.5"));
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(bl);
            window.dispose();
        }
    }

    public void updateView() {
        try {
            Store store = StoreDAO.getRestaurant();
            String string = store.getProperty("web.service.url");
            String string2 = store.getProperty("web.service.password");
            String string3 = store.getProperty("web.service.username");
            if (StringUtils.isNotEmpty((String)string2)) {
                string2 = AESencrp.decrypt(string2);
            }
            this.a.setText(StringUtils.isEmpty((String)string) ? "https://menugreat.com/console" : string);
            this.b.setText(string3);
            this.c.setText(string2);
            if (this.h) {
                this.i.setText(POSConstants.SAVE_BUTTON_TEXT);
            } else {
                this.i.setText(Messages.getString("CloudLoginPanel.12"));
            }
            boolean bl = PosWebService.get().isConnected();
            Boolean bl2 = DataProvider.get().getCurrentTerminal().isMasterTerminal() != false && bl;
            this.f.setEnabled(bl2);
            this.g.setEnabled(bl2);
            this.j = CronJobDAO.getInstance().get("cloud_auto_sync");
            if (this.j != null) {
                Boolean bl3 = this.j.isActive();
                this.f.setSelected(bl3);
                String string4 = this.j.getExecutionTime().split(":")[1];
                this.g.setSelectedItem(POSUtil.parseInteger(string4) == 0 ? 60 : POSUtil.parseInteger(string4));
            } else {
                this.g.setSelectedItem(30);
            }
            this.i.requestFocus();
            this.i.revalidate();
            this.i.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLogin() {
        try {
            String string = this.a.getText();
            String string2 = this.b.getText();
            String string3 = AESencrp.encrypt(new String(this.c.getPassword()));
            PosResponse posResponse = this.checkLogin(string, string2, string3);
            if (this.d && !PosWebService.get().isRemoteAccountEmty(string, string2, string3, posResponse.getCustomerId(), posResponse.getStoreId())) {
                throw new PosException(Messages.getString("CloudLoginPanel.6"));
            }
            Store store = StoreDAO.getRestaurant();
            store.addProperty("web.service.url", string);
            store.addProperty("web.service.username", string2);
            store.addProperty("web.service.password", string3);
            if (this.d) {
                StoreDAO.getInstance().removeLastUpdateTime(store);
            }
            store.addProperty("web.service.schema", posResponse.getStoreId());
            store.addProperty("web.service.customer.id", posResponse.getCustomerId());
            store.setUuid(posResponse.getStoreId());
            StoreDAO.getInstance().saveOrUpdate(store);
            Application.getInstance().refreshStore();
            OroMqttClient.getInstance().notifyDataUpdated(Store.class);
            this.a(false);
            this.a();
        }
        catch (ClientHandlerException clientHandlerException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.5"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void a() {
        Boolean bl = DataProvider.get().getCurrentTerminal().isMasterTerminal();
        if (bl.booleanValue()) {
            int n = (Integer)this.g.getSelectedItem();
            if (n == 60) {
                n = 0;
            }
            if (this.f.isSelected() && n > 59) {
                POSMessageDialog.showError(Messages.getString("CloudSyncDialog.14"));
                return;
            }
            String string = "-1:" + n;
            boolean bl2 = Boolean.FALSE;
            if (this.j == null) {
                this.j = new CloudAutoSyncJob();
                bl2 = Boolean.TRUE;
            } else {
                if (this.j.isActive().booleanValue() != this.f.isSelected()) {
                    bl2 = Boolean.TRUE;
                }
                if (!string.equals(this.j.getExecutionTime())) {
                    bl2 = Boolean.TRUE;
                }
            }
            if (bl2) {
                this.j.setExecutionTime(string);
                this.j.setActive(this.f.isSelected());
                CloudAutoSyncJobPlugin cloudAutoSyncJobPlugin = new CloudAutoSyncJobPlugin();
                cloudAutoSyncJobPlugin.setCronJob(this.j);
                OroCronJobManager.getInstance().reScheduleJob(((CronJobPlugin)cloudAutoSyncJobPlugin).convertToActualCronJob());
                PosLog.debug(this.getClass(), "Cron Job saved successfully.");
            }
        }
    }

    public PosResponse checkLogin(String string, String string2, String string3) throws Exception {
        if (StringUtils.isEmpty((String)string)) {
            throw new PosException(Messages.getString("CloudLoginPanel.0"));
        }
        if (StringUtils.isEmpty((String)string2)) {
            throw new PosException(Messages.getString("CloudLoginPanel.1"));
        }
        if (!EmailValidator.getInstance().isValid(string2)) {
            throw new PosException(Messages.getString("CloudLoginPanel.3"));
        }
        if (StringUtils.isEmpty((String)string3)) {
            throw new PosException(Messages.getString("CloudLoginPanel.4"));
        }
        String string4 = String.valueOf(DataProvider.get().getCurrentTerminal().getId());
        PosResponse posResponse = PosWebService.get().login(string, string2, string3, string4);
        if (posResponse != null && posResponse.getResponseCode() == 200) {
            Store store = StoreDAO.getRestaurant();
            String string5 = store.getProperty("web.service.url");
            String string6 = store.getProperty("web.service.username");
            this.d = StringUtils.isNotBlank((String)string5) && StringUtils.isNotBlank((String)string6) && (!string.equalsIgnoreCase(string5) || !string2.equals(string6));
            return posResponse;
        }
        throw new Exception(posResponse.getMsg());
    }
}

