/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.StringRegexDocument;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.CloudSyncListener;
import com.floreantpos.webservice.PosWebService;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CloudRegistrationPanel
extends JPanel {
    private static final String a = "registered";
    public static final String VIEW_NAME = "register";
    private POSTextField b;
    private POSTextField c;
    private JButton d;
    private POSTextField e;
    private POSPasswordField f;
    private POSPasswordField g;
    private JLabel h;
    private JProgressBar i;
    private JPanel j;
    private PosButton k;
    private JButton l;
    private CloudSyncListener m;

    public CloudRegistrationPanel(CloudSyncListener cloudSyncListener) {
        this.m = cloudSyncListener;
        this.initComponents();
        this.b();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.h = new JLabel();
        this.h.setFont(new Font("Arial", 1, 16));
        this.h.setText(Messages.getString("CloudRegistrationPanel.1"));
        this.h.setVisible(false);
        this.i = new JProgressBar();
        this.i.setIndeterminate(true);
        this.i.setStringPainted(false);
        this.i.setPreferredSize(new Dimension(0, 30));
        this.i.setVisible(false);
        this.i.setBorder(BorderFactory.createEmptyBorder(0, -5, 5, -5));
        this.j = new JPanel();
        this.j.setLayout((LayoutManager)new MigLayout("fillx,ins 20 20 20 20", "[][fill, grow]", ""));
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, 14));
        jLabel.setText("<html>" + Messages.getString("CloudRegistrationPanel.2") + "</html>");
        this.b = new POSTextField();
        this.c = new POSTextField();
        this.d = new JButton(Messages.getString("CloudRegistrationPanel.7"));
        this.c.setDocument(new StringRegexDocument());
        this.e = new POSTextField();
        this.f = new POSPasswordField();
        this.g = new POSPasswordField();
        this.j.add((Component)jLabel, "gapbottom 10 ,wrap,span 2");
        if (Application.getInstance().isDevelopmentMode()) {
            this.j.add(new JLabel(Messages.getString("ServerAddress") + ":"));
            this.j.add((Component)this.b, "grow, wrap");
        }
        this.j.add(new JLabel(Messages.getString("CloudRegistrationPanel.8")));
        this.j.add((Component)this.c, "grow");
        this.j.add((Component)this.d, "wrap");
        this.j.add(new JLabel(Messages.getString("CloudLoginPanel.2") + ":"));
        this.j.add((Component)this.e, "grow, wrap");
        this.j.add(new JLabel(Messages.getString("CloudRegistrationPanel.3") + ":"));
        this.j.add((Component)this.f, "grow, wrap");
        this.j.add(new JLabel(Messages.getString("CloudRegistrationPanel.5") + ":"));
        this.j.add((Component)this.g, "grow, wrap");
        this.add(this.j);
        JSeparator jSeparator = new JSeparator();
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout(new FlowLayout());
        this.k = new PosButton();
        this.l = new PosButton();
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel2.setLayout(new BorderLayout());
        transparentPanel.setLayout(new FlowLayout());
        this.k.setText(Messages.getString("CloudRegistrationPanel.15"));
        this.k.addActionListener(actionEvent -> this.doCloudRegistration());
        this.l.setText(POSConstants.CANCEL);
        this.l.addActionListener(actionEvent -> this.a(true));
        transparentPanel.add(this.k);
        transparentPanel.add(this.l);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        jPanel.add((Component)this.h, "split 2");
        jPanel.add((Component)this.i, "gapleft 15,grow,gapafter 20");
        transparentPanel2.add((Component)jPanel, "North");
        transparentPanel2.add((Component)jSeparator, "Center");
        transparentPanel2.add((Component)transparentPanel, "South");
        this.add(this.j);
        this.add((Component)transparentPanel2, "South");
        this.d.addActionListener(actionEvent -> this.a());
    }

    private void a() {
        try {
            String string = this.b.getText();
            String string2 = this.c.getText();
            boolean bl = PosWebService.get().doValidateUrl(string, string2);
            if (bl) {
                POSMessageDialog.showMessage(Messages.getString("CloudRegistrationPanel.10"));
            } else {
                POSMessageDialog.showError(Messages.getString("CloudRegistrationPanel.12"));
            }
        }
        catch (RuntimeException runtimeException) {
            POSMessageDialog.showError(runtimeException.getMessage());
        }
        catch (Exception exception) {
            PosLog.error(PosWebService.class, exception.getMessage());
            POSMessageDialog.showError(Messages.getString("server_is_not_avalable"));
        }
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this.j);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(bl);
            window.dispose();
        }
    }

    private void b() {
        Store store = StoreDAO.getRestaurant();
        String string = store.getProperty("web.service.url");
        this.b.setText(StringUtils.isEmpty((String)string) ? "https://menugreat.com/console" : string);
        this.c.setText(store.getName().replaceAll("[^A-Za-z0-9\\-\\_\\.]+", "").toLowerCase());
    }

    private void c() throws Exception {
        String string;
        String string2;
        String string3 = this.b.getText();
        Store store = StoreDAO.getRestaurant();
        String string4 = store.getName();
        String string5 = this.c.getText();
        String string6 = this.e.getText();
        String string7 = new String(this.f.getPassword());
        String string8 = new String(this.g.getPassword());
        if (StringUtils.isEmpty((String)string7)) {
            throw new PosException(Messages.getString("CloudLoginPanel.4"));
        }
        if (!string7.equals(string8)) {
            throw new PosException(Messages.getString("CloudRegistrationPanel.6"));
        }
        PosWebService.get().doValidateUrl(string3, string5);
        PosResponse posResponse = PosWebService.get().register(string3, string5, string4, string6, string7, store.getDefaultOutletId());
        if (posResponse != null && posResponse.getResponseCode() == 200) {
            store = StoreDAO.getRestaurant();
            string2 = posResponse.getCustomerId();
            store.addProperty("web.service.url", string3);
            String string9 = store.getUuid();
            string = posResponse.getStoreId();
            if (StringUtils.isNotBlank((String)string9) && StringUtils.isNotBlank((String)string) && !string9.equals(string)) {
                StoreDAO.getInstance().removeLastUpdateTime(store);
            }
        } else {
            PosLog.error(PosWebService.class, posResponse.getMsg());
            throw new PosException(Messages.getString("server_is_not_avalable"));
        }
        store.addProperty("web.service.schema", string);
        store.addProperty("web.service.username", string6);
        store.addProperty("web.service.password", AESencrp.encrypt(string7));
        store.addProperty("web.service.customer.id", string2);
        store.setUuid(string);
        StoreDAO.getInstance().saveOrUpdate(store);
        Application.getInstance().refreshStore();
        OroMqttClient.getInstance().notifyDataUpdated(Store.class);
    }

    public void doCloudRegistration() {
        this.h.setVisible(true);
        this.i.setVisible(true);
        this.b(false);
        SwingWorker<String, Object> swingWorker = new SwingWorker<String, Object>(){

            @Override
            protected String doInBackground() throws Exception {
                try {
                    CloudRegistrationPanel.this.c();
                    return CloudRegistrationPanel.a;
                }
                catch (Exception exception) {
                    return exception.getMessage();
                }
            }

            @Override
            protected void done() {
                super.done();
                CloudRegistrationPanel.this.h.setVisible(false);
                CloudRegistrationPanel.this.i.setVisible(false);
                CloudRegistrationPanel.this.b(true);
                try {
                    String string = (String)this.get();
                    if (string != null && string.equals(CloudRegistrationPanel.a)) {
                        CloudRegistrationPanel.this.m.registrationComplete();
                    } else {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CloudRegistrationPanel.20") + string);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
        swingWorker.execute();
    }

    private void b(boolean bl) {
        this.b.setEnabled(bl);
        this.f.setEnabled(bl);
        this.c.setEnabled(bl);
        this.e.setEnabled(bl);
        this.k.setEnabled(bl);
        this.l.setEnabled(bl);
    }
}

