/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.extension.cronjob.CloudAutoSyncJob;
import com.floreantpos.extension.cronjob.CloudAutoSyncJobPlugin;
import com.floreantpos.extension.cronjob.CronJobPlugin;
import com.floreantpos.extension.cronjob.OroCronJobManager;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.floreantpos.webservice.OutletSelectionDialog;
import com.floreantpos.webservice.PosWebService;
import com.floreantpos.webservice.SyncService;
import com.orocube.rest.service.PosResponse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.net.URI;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.DefaultCaret;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.quartz.CronTrigger;

public class CloudSyncDialog
extends POSDialog
implements ProgressObserver {
    private static final Color a = new Color(126, 180, 69);
    private static final String b = "UND";
    private PosSmallButton c;
    private JButton d;
    private JLabel e;
    private JLabel f;
    private JLabel g;
    private JLabel h;
    private JProgressBar i;
    private JLabel j;
    private JProgressBar k;
    private JLabel l;
    private PosSmallButton m;
    private JLabel n;
    private JLabel o;
    private JTextField p;
    private JTextField q;
    private Worker r;
    private JPanel s;
    private JRadioButton t;
    private JRadioButton u;
    private JRadioButton v;
    private JTextArea w;
    private boolean x;
    private CronJob y;
    private JLabel z;
    private JLabel A;
    private JPanel B;
    private JPanel C;
    private JLabel D;

    public CloudSyncDialog() throws HeadlessException {
        super(POSUtil.getFocusedWindow());
        this.setTitle(VersionInfo.getAppName());
        this.f();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.g();
        }
    }

    @Override
    protected void initUI() {
        super.initUI();
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("inset 0 0 10 0,fill,hidemode 3"));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3"));
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3", "", ""));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("CloudSyncDialog.0"));
        this.e = new JLabel();
        this.f = new JLabel();
        this.g = new JLabel();
        this.h = new JLabel();
        this.z = new JLabel();
        this.A = new JLabel();
        this.i = new JProgressBar();
        this.i.setValue(0);
        this.i.setMaximum(100);
        this.i.setStringPainted(true);
        this.i.setPreferredSize(PosUIManager.getSize(0, 30));
        this.j = new JLabel("");
        this.i.setVisible(false);
        this.k = new JProgressBar();
        this.k.setValue(0);
        this.k.setMaximum(100);
        this.k.setStringPainted(true);
        this.k.setPreferredSize(PosUIManager.getSize(0, 30));
        this.l = new JLabel("");
        this.k.setVisible(false);
        this.m = new PosSmallButton(Messages.getString("Cancel"));
        this.m.setVisible(false);
        this.d = new JButton(Messages.getString("Close"));
        this.n = new JLabel(Messages.getString("StoreId"));
        this.n.setVisible(false);
        this.o = new JLabel(Messages.getString("CloudRegistrationPanel.8"));
        this.o.setVisible(false);
        this.p = new JTextField(11);
        this.p.setEditable(false);
        this.p.setBorder(BorderFactory.createEmptyBorder());
        this.q = new JTextField(11);
        this.q.setEditable(false);
        this.q.setBorder(BorderFactory.createEmptyBorder());
        this.c = new PosSmallButton(Messages.getString("Sync"));
        this.c.setEnabled(false);
        this.c.setActionCommand(b);
        jPanel2.add((Component)new JLabel(Messages.getString("CloudSyncDialog.9")), "split 3");
        jPanel2.add((Component)this.e, "grow,wrap");
        this.e.setFocusable(true);
        jPanel2.add((Component)this.n, "split 2");
        jPanel2.add((Component)this.p, "wrap");
        jPanel2.add((Component)this.o, "split 2");
        jPanel2.add((Component)this.q, "wrap");
        JLabel jLabel = new JLabel(Messages.getString("CloudSyncDialog.6"));
        jLabel.setVerticalAlignment(1);
        jPanel2.add((Component)jLabel, "aligny top,split 2");
        jPanel2.add((Component)this.f, "gapx 0,span,push,grow,wrap");
        jPanel2.add((Component)new JLabel(Messages.getString("CloudSyncDialog.7")), "split 2");
        jPanel2.add((Component)this.g, "grow,wrap");
        this.D = new JLabel(Messages.getString("CloudSyncDialog.10"));
        jPanel2.add((Component)this.D, "split 2");
        jPanel2.add((Component)this.h, "grow,wrap");
        jPanel2.add((Component)new JLabel(Messages.getString("CloudSyncDialog.15")), "split 2");
        jPanel2.add((Component)this.z, "grow,wrap");
        jPanel2.add((Component)new JLabel(Messages.getString("CloudSyncDialog.16")), "split 2");
        jPanel2.add((Component)this.A, "grow,wrap");
        JButton jButton = new JButton(Messages.getString("GoToWebConsole"));
        jButton.setFocusable(false);
        jButton.addActionListener(actionEvent -> this.a());
        jButton.setForeground(Color.RED);
        jButton.setFont(new Font(this.getFont().getName(), 1, 11));
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("wrap 1,hidemode 3"));
        jPanel4.add((Component)this.c, "right");
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel2, "top,left,pushx,growx,split 2");
        jPanel.add((Component)jPanel4, "top,wrap,gapafter 5");
        this.s = new JPanel((LayoutManager)new MigLayout("hidemode 3"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.t = new JRadioButton(Messages.getString("Merge"));
        this.u = new JRadioButton(Messages.getString("Ignore"));
        this.v = new JRadioButton(Messages.getString("TerminalConfig.0"));
        this.v.addActionListener(actionEvent -> this.a(Messages.getString("TerminalConfig.0")));
        this.u.addActionListener(actionEvent -> this.a(Messages.getString("Ignore")));
        this.t.addActionListener(actionEvent -> this.a(Messages.getString("Merge")));
        buttonGroup.add(this.v);
        buttonGroup.add(this.t);
        buttonGroup.add(this.u);
        this.s.add(new JLabel(Messages.getString("CloudSyncDialog.2")));
        this.s.add(this.t);
        this.s.add(this.u);
        this.s.add(this.v);
        this.b();
        this.w = new JTextArea(9, 50);
        this.w.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.w.setEditable(false);
        this.w.setWrapStyleWord(true);
        this.w.setLineWrap(true);
        this.w.setAutoscrolls(true);
        this.w.setBackground(Color.white);
        this.B = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3"));
        this.B.setVisible(false);
        this.B.add((Component)this.s, "pushx,growx,gaptop 0,gapbottom 0,wrap");
        this.B.add((Component)this.j, "gapleft 5,right,newline,split 3,gapafter 10");
        this.B.add((Component)this.i, "growx,h " + PosUIManager.getSize(35));
        this.B.add((Component)this.m, "gapafter 10,h " + PosUIManager.getSize(35));
        this.B.add((Component)this.l, "gapleft 5,right,newline,split 3,gapafter 10");
        this.B.add((Component)this.k, "growx,gapafter 10,h " + PosUIManager.getSize(35));
        this.C = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3"));
        this.C.add((Component)new JScrollPane(this.w), "pushx,grow,gapleft 10,gapright 10");
        this.C.setVisible(false);
        jPanel.add((Component)this.B, "growx,wrap");
        jPanel.add((Component)this.C, "push,grow");
        jPanel3.add((Component)new JSeparator(), "growx,gaptop 0,gapbottom 0,wrap");
        jPanel3.add((Component)this.d, "center");
        this.c.addActionListener(actionEvent -> this.a(false));
        this.m.addActionListener(actionEvent -> this.c());
        this.add((Component)titlePanel, "North");
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel3, "South");
    }

    public void startSync() {
        SwingUtilities.invokeLater(() -> {
            try {
                if (PosWebService.get().isConnected()) {
                    this.a(false);
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(exception.getMessage(), exception);
            }
        });
    }

    private void a() {
        try {
            URI uRI = new URI("https://menugreat.com/console");
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(uRI);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void a(String string) {
        try {
            Store store = StoreDAO.getRestaurant();
            String string2 = store.getProperty("sync.conflict_resolve_option");
            if (string2 != null && string.equals(string2)) {
                return;
            }
            if (StringUtils.isBlank((String)string) || string.equalsIgnoreCase(Messages.getString("TerminalConfig.0"))) {
                Map<String, String> map = store.getProperties();
                map.remove("sync.conflict_resolve_option");
            } else {
                store.addProperty("sync.conflict_resolve_option", string);
            }
            StoreDAO.getInstance().update(store);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void b() {
        String string = StoreDAO.getRestaurant().getProperty("sync.conflict_resolve_option");
        boolean bl = StringUtils.isNotBlank((String)string);
        this.s.setVisible(bl);
        this.v.setSelected(StringUtils.isBlank((String)string));
        this.t.setSelected(bl && string.equals(Messages.getString("Merge")));
        this.u.setSelected(bl && string.equals(Messages.getString("Ignore")));
    }

    private void c() {
        this.r.cancel(true);
    }

    public void doVisibleDetailsView(boolean bl) {
        this.B.setVisible(bl);
        this.C.setVisible(bl);
    }

    private void a(boolean bl) {
        try {
            this.doVisibleDetailsView(true);
            this.x = bl;
            this.w.setText("");
            boolean bl2 = this.i();
            this.c.setEnabled(bl2);
            if (!bl2) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.32"));
                return;
            }
            Outlet outlet = this.d();
            if (outlet == null) {
                return;
            }
            this.r = new Worker(this.x, outlet);
            this.r.setActionCommand(b);
            this.c.setEnabled(false);
            this.d.setEnabled(false);
            this.r.execute();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private Outlet d() throws Exception {
        Outlet outlet = DataProvider.get().getOutlet();
        OutletDAO.getInstance().initialize(outlet);
        boolean bl = PosWebService.get().isNewSchema();
        if (!bl) {
            return outlet;
        }
        List<Outlet> list = PosWebService.get().getOutlets();
        if (list == null || list.isEmpty()) {
            this.e();
            return outlet;
        }
        for (Outlet serializable2 : list) {
            if (!serializable2.getId().equals(DataProvider.get().getCurrentOutletId())) continue;
            this.e();
            if (!this.x) {
                OutletDAO.getInstance().saveOrUpdateOutlets(Arrays.asList(serializable2), serializable2.getId(), true, false, true);
            }
            return serializable2;
        }
        String string = POSMessageDialog.showSelectOptionDialog(POSUtil.getFocusedWindow(), Messages.getString("WhatDoYouWant"), POSConstants.CONFIRM, "<html><center>" + Messages.getString("ConnectAs") + "<br><b>" + Messages.getString("NewOutlet") + "</b></center></html>", "<html><center>" + Messages.getString("ConnectTo") + "<br><b>" + Messages.getString("ExistingOutlet") + "</b></center></html>", POSConstants.CANCEL);
        if (string == null || string.equals(POSConstants.CANCEL)) {
            return null;
        }
        if (string.contains(Messages.getString("NewOutlet"))) {
            this.x = true;
            return outlet;
        }
        OutletSelectionDialog outletSelectionDialog = new OutletSelectionDialog(list);
        outletSelectionDialog.open();
        if (outletSelectionDialog.isCanceled()) {
            return null;
        }
        Outlet outlet2 = outletSelectionDialog.getSelectedOutlet();
        this.e();
        if (this.x) {
            this.a(outlet, outlet2);
        }
        return outlet2;
    }

    private void a(Outlet outlet, Outlet outlet2) throws Exception {
        String string = outlet2.getId();
        long l = outlet2.getVersion();
        PropertyUtils.copyProperties((Object)outlet2, (Object)outlet);
        outlet2.setId(string);
        outlet2.setVersion(l);
    }

    private void e() {
        if (this.x) {
            return;
        }
        this.x = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Which settings do you want to keep", Messages.getString("CONFIRM"), Messages.getString("Local"), Messages.getString("Cloud")) == 0;
    }

    private void f() {
        this.d.addActionListener(actionEvent -> this.h());
        this.setDefaultCloseOperation(2);
    }

    private void g() {
        try {
            boolean bl = PosWebService.get().isConnected();
            this.y = CronJobDAO.getInstance().get("cloud_auto_sync");
            if (this.y != null) {
                Boolean bl2 = this.y.isActive();
                if (bl2.booleanValue() && bl) {
                    CronTrigger cronTrigger = OroCronJobManager.getInstance().getCronTriggerFromCronJob(this.y, null);
                    Date date = cronTrigger.getFireTimeAfter(new Date());
                    if (date != null) {
                        this.D.setVisible(true);
                        this.h.setVisible(true);
                        this.h.setText(DateUtil.formatDateWithTime(date));
                    } else {
                        this.D.setVisible(false);
                        this.h.setVisible(false);
                    }
                } else {
                    this.D.setVisible(false);
                    this.h.setVisible(false);
                }
            }
            this.a((Boolean)bl);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void a(Boolean bl) {
        try {
            Date date;
            Date date2;
            Store store = DataProvider.get().getStore();
            StoreDAO.getInstance().refresh(store);
            if (bl != null) {
                if (bl.booleanValue()) {
                    this.e.setText(this.b(Messages.getString("CloudSyncDialog.25")));
                    this.p.setText(store.getUuid());
                    this.q.setText(store.getFriendlyUid());
                } else {
                    this.e.setText("");
                    this.p.setText("");
                    this.q.setText("");
                }
                this.b(bl);
            }
            this.f.setText("<html>" + store.getName() + "</html>");
            String string = store.getProperty("Store.lastUpdateTime");
            Date date3 = DateUtil.parseSyncTime(string);
            if (date3 != null) {
                this.g.setText(DateUtil.formatDateWithTime(date3));
            }
            if ((date2 = GenericDAO.getInstance().getMaxLastUpdateTime()) != null) {
                this.z.setText(DateUtil.formatDateWithTime(date2));
            }
            if ((date = PosWebService.get().getMaxLastUpdateTime()) != null) {
                this.A.setText(DateUtil.formatDateWithTime(date));
            }
        }
        catch (ParseException parseException) {
            PosLog.error(this.getClass(), parseException);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void h() {
        try {
            this.w.setText("");
            Boolean bl = DataProvider.get().getCurrentTerminal().isMasterTerminal();
            if (bl.booleanValue()) {
                boolean bl2 = Boolean.FALSE;
                if (this.y == null) {
                    this.y = new CloudAutoSyncJob();
                    bl2 = Boolean.TRUE;
                }
                if (bl2) {
                    CloudAutoSyncJobPlugin cloudAutoSyncJobPlugin = new CloudAutoSyncJobPlugin();
                    cloudAutoSyncJobPlugin.setCronJob(this.y);
                    OroCronJobManager.getInstance().reScheduleJob(((CronJobPlugin)cloudAutoSyncJobPlugin).convertToActualCronJob());
                    PosLog.debug(this.getClass(), "Cron Job saved successfully.");
                }
            }
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private boolean i() {
        Store store = DataProvider.get().getStore();
        StoreDAO.getInstance().refresh(store);
        String string = store.getProperty("web.service.url");
        if ("https://posdb.net/console".equals(string)) {
            string = "https://menugreat.com/console";
            store.addProperty("web.service.url", string);
            StoreDAO.getInstance().update(store);
            DataProvider.get().refreshStore();
        }
        PosResponse posResponse = null;
        try {
            posResponse = PosWebService.get().checkConnection();
            if (posResponse != null && posResponse.getResponseCode() == 200 && StringUtils.isEmpty((String)store.getProperty("web.service.customer.id"))) {
                String string2 = posResponse.getCustomerId();
                store.addProperty("web.service.customer.id", string2);
                StoreDAO.getInstance().saveOrUpdate(store);
            }
        }
        catch (Exception exception) {
            this.e.setText(this.b(Messages.getString("CloudSyncDialog.23")));
            this.b(false);
        }
        if (posResponse != null) {
            if (posResponse.getResponseCode() == 200) {
                PosLog.info(this.getClass(), "Connected");
                this.e.setText(this.b(Messages.getString("CloudSyncDialog.25")));
                this.b(true);
                this.p.setText(posResponse.getStoreId());
                Application.getInstance().setCloudConnected(true);
                return true;
            }
            this.e.setText(this.b(posResponse.getMsg()));
        }
        return false;
    }

    private void b(boolean bl) {
        this.n.setVisible(bl);
        this.o.setVisible(bl);
        this.c.setEnabled(bl);
    }

    private String b(String string) {
        return "<html><b><center>" + string + "</center></b></html>";
    }

    public static CloudSyncDialog show(Frame frame) {
        CloudSyncDialog cloudSyncDialog = new CloudSyncDialog();
        cloudSyncDialog.setMinimumSize(PosUIManager.getSize(650, 570));
        cloudSyncDialog.open();
        return cloudSyncDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(boolean bl, Outlet outlet) {
        try {
            try {
                this.u.setEnabled(false);
                this.t.setEnabled(false);
                this.v.setEnabled(false);
                this.i.setMaximum(105);
                this.i.setVisible(true);
                this.m.setVisible(true);
                this.i.setValue(0);
                this.j.setForeground(Color.BLUE);
                String string = outlet.getId();
                String string2 = DataProvider.get().getCurrentOutletId();
                SyncService.sync(this, bl, outlet);
                DataProvider.get().initialize();
                if (!string.equals(string2)) {
                    POSMessageDialog.showMessage(Messages.getString("OutletChangeRestartMsg"));
                    Main.restart();
                }
                this.i.setValue(100);
                this.j.setText(Messages.getString("CloudSyncDialog.29"));
                this.j.setForeground(a);
            }
            catch (InterruptedException interruptedException) {
                PosLog.info(this.getClass(), Messages.getString("CloudSyncDialog.1"));
                this.j.setText(Messages.getString("CloudSyncDialog.1"));
                this.j.setForeground(Color.BLACK);
                this.c(true);
                this.r.cancel(true);
            }
            catch (Exception exception) {
                this.printInfo("failed");
                PosLog.error(this.getClass(), exception);
                this.j.setText(Messages.getString("CloudSyncDialog.30"));
                this.j.setForeground(Color.RED);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Messages.getString("CloudSyncDialog.31"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Messages.getString("CloudSyncDialog.31"), exception);
        }
        finally {
            this.u.setEnabled(true);
            this.t.setEnabled(true);
            this.v.setEnabled(true);
            this.b();
            this.hideSubProgressView();
        }
    }

    private void c(boolean bl) {
        this.i.setVisible(!bl);
        this.m.setVisible(!bl);
        this.c.setEnabled(bl);
        this.d.setEnabled(bl);
        this.a((Boolean)null);
    }

    @Override
    public void progress(int n) {
        this.i.setValue(n);
    }

    @Override
    public void progress(String string) {
        this.j.setText(string);
    }

    @Override
    public void progress(int n, String string) throws Exception {
        if (this.r.isCancelled()) {
            throw new InterruptedException(Messages.getString("CloudSyncDialog.1"));
        }
        this.i.setValue(n);
        this.j.setText(string);
    }

    @Override
    public void subProgress(String string) {
        this.l.setText(string);
        this.l.setVisible(true);
        this.k.setVisible(true);
        this.k.setValue(0);
    }

    @Override
    public void subProgress(int n, String string) throws Exception {
        if (this.r.isCancelled()) {
            this.hideSubProgressView();
            throw new InterruptedException(Messages.getString("CloudSyncDialog.1"));
        }
        this.l.setVisible(true);
        this.k.setVisible(true);
        this.k.setValue(n);
        this.l.setText(string);
    }

    @Override
    public void hideSubProgressView() {
        this.k.setVisible(false);
        this.l.setVisible(false);
    }

    @Override
    public void printInfo(String string) {
        this.w.append(string);
        DefaultCaret defaultCaret = (DefaultCaret)this.w.getCaret();
        defaultCaret.setUpdatePolicy(2);
        this.w.setCaretPosition(this.w.getDocument().getLength());
    }

    @Override
    public void printError(String string) {
        this.w.append(string);
    }

    @Override
    public Component getParentComponent() {
        return this;
    }

    class Worker
    extends SwingWorker<Void, Void> {
        String a;
        boolean b;
        Outlet c;

        public Worker(boolean bl, Outlet outlet) {
            this.b = bl;
            this.c = outlet;
        }

        public void setActionCommand(String string) {
            this.a = string;
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (this.a.equals(CloudSyncDialog.b)) {
                CloudSyncDialog.this.a(this.b, this.c);
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            if (CloudSyncDialog.this.r.isCancelled()) {
                CloudSyncDialog.this.i.setVisible(false);
                CloudSyncDialog.this.m.setVisible(false);
                CloudSyncDialog.this.c.setEnabled(true);
                CloudSyncDialog.this.d.setEnabled(true);
                return;
            }
            CloudSyncDialog.this.c(true);
        }
    }
}

